package com.bcxin.ins.aspect;

import com.bcxin.ins.core.entity.SysLog;
import com.bcxin.ins.core.service.SysLogService;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author：huangzp
 * @date：2018/05/02 0002 16:01
 * @description：
 */
@Component
@Lazy(false)
public class LogQuartz {

    @Autowired
    private SysLogService sysLogService;
    @Autowired
    private MyAsyncExecutor myAsyncExecutor;

    @Scheduled(cron = "0 0/1 * * * ? ") // 没5分钟执行一次
    public void job(){
        List<SysLog> items = LogManager.getLogs();
        if(items!=null && items.size()>0){
            myAsyncExecutor.execute(()->{
                sysLogService.insertBatch(items);
            });
        }
    }
}
