package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.ShipDeclareAPIDao;
import com.bcxin.ins.service.order.ShipDeclareAPIService;
import com.bcxin.ins.entity.policy_core.InsShipDeclare;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ShipDeclareMultipleVo;
import com.bcxin.ins.vo.ShipDeclareStepTwoSearchVo;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


/**
 * 出运Service
 * @author liumd
 * @date 2016年12月30日
 */
@Service
@Transactional
public class ShipDeclareAPIServiceImpl extends ServiceImpl<ShipDeclareAPIDao, InsShipDeclare> implements ShipDeclareAPIService {
	
	@Autowired
	private ShipDeclareAPIDao shipDeclareDao;

	@Override
	public InsShipDeclare getShipDeclareById(Long id) {
		List<InsShipDeclare> lis = shipDeclareDao.getShipDeclareById(id);
		if(lis != null){
			return lis.get(0);
		}else{
			return null;
		}
	}

	@Override
	public List<InsShipDeclare> getShipDeclareByInsOrderFormId(Long ins_order_form_id, DwzPage page) {
		List<InsShipDeclare> lis = new ArrayList<InsShipDeclare>();
		if(page != null){

			Page<InsShipDeclare> pageHelper = new Page<>(page.getPageNum(), page.getNumPerPage());
			lis = shipDeclareDao.getShipDeclareByInsOrderFormId(pageHelper,ins_order_form_id);
			page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
		}else{
			lis = shipDeclareDao.getShipDeclareByInsOrderFormId(ins_order_form_id);
		}
		if(lis != null){
			return lis;
		}else{
			return null;
		}
	}

	@Override
	public List<ShipDeclareMultipleVo> getShipDeclareVoByInsOrderFormId(Long ins_order_form_id, DwzPage page) {
		Page<ShipDeclareMultipleVo> pageHelper = new Page<>(page.getPageNum(), page.getNumPerPage());
		List<ShipDeclareMultipleVo> lis = shipDeclareDao.getShipDeclareVoByInsOrderFormId(pageHelper,ins_order_form_id);
		page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
		if(lis != null){
			return lis;
		}else{
			return null;
		}
	}

	@Override
	public List<ShipDeclareMultipleVo> getShipDeclareVoByInsOrderFormIdAndVo(Long ins_order_form_id, ShipDeclareStepTwoSearchVo searchVo, DwzPage page) {
		String insured = null;
		String country = null;
		String buyerName = null;
		String startDate = null;
		String endDate = null;
		String declareType = null;
		if(StringUtils.isNotBlank(searchVo.getInsured())){
			insured = searchVo.getInsured();
		}
		if(StringUtils.isNotBlank(searchVo.getCountry())){
			country = searchVo.getCountry();
		}
		if(StringUtils.isNotBlank(searchVo.getBuyer_name())){
			buyerName = searchVo.getBuyer_name();
		}
		if(StringUtils.isNotBlank(searchVo.getStart_date())){
			startDate = searchVo.getStart_date() + " 00:00:00";
		}
		if(StringUtils.isNotBlank(searchVo.getEnd_date())){
			endDate = searchVo.getEnd_date() + " 23:59:59";
		}
		if(StringUtils.isNotBlank(searchVo.getDeclare_type())){
			declareType = searchVo.getDeclare_type();
		}
		Page<ShipDeclareMultipleVo> pageHelper = new Page<>(page.getPageNum(), page.getNumPerPage());
		List<ShipDeclareMultipleVo> lis = shipDeclareDao.getShipDeclareVoByInsOrderFormIdAndVo(pageHelper,ins_order_form_id, insured, country, buyerName, startDate, endDate, declareType);
		page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
		if(lis != null){
			return lis;
		}else{
			return null;
		}
	}

//	@Override
//	public List<ShipDeclareHtIndexVo> getAllShipDeclare() {
//		List<ShipDeclareHtIndexVo> lis = shipDeclareDao.getAllShipDeclare();
//		return lis.size() > 0 ? lis : null;
//	}

	@Override
	public List<OrderFormVo> getCanShipDeclareList(Long userId, DwzPage page) {
		Page<OrderFormVo> pageHelper = new Page<>(page.getPageNum(), page.getNumPerPage());
		List<OrderFormVo> lis = shipDeclareDao.getCanShipDeclareList(pageHelper,userId);
		page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
		if(lis != null){
			return lis;
		}else{
			return null;
		}
	}

	@Override
	public OrderFormVo getOrderFormVoByOrderFormId(Long orderFormId) {
		List<OrderFormVo> lis = shipDeclareDao.getOrderFormVoByOrderFormId(orderFormId);
		if(lis != null){
			return lis.get(0);
		}else{
			return null;
		}
	}

	@Override
	public List<String> getInsureNameList(Long orderFormId) {
		List<String> lis = shipDeclareDao.getInsureNameList(orderFormId);
		if(lis != null){
			return lis;
		}else{
			return null;
		}
	}
	
	

}
