package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.InsServiceDescriptionAPIDao;
import com.bcxin.ins.service.order.InsServiceDescriptionAPIService;
import com.bcxin.ins.entity.policy_special.StServiceDescription;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.CommonExportVo_1;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


@Service
@Transactional
public class InsServiceDescriptionAPIServiceImpl extends ServiceImpl<InsServiceDescriptionAPIDao, StServiceDescription> implements InsServiceDescriptionAPIService {

	@Autowired
	private InsServiceDescriptionAPIDao dao;

	@Override
	public StServiceDescription initInsServiceDescription() {
		StServiceDescription insServiceDescription = new StServiceDescription();
		dao.insert(insServiceDescription);
		return insServiceDescription;
	}

	/**
	 * <b>根据CommonExportVo_1更新InsServiceDescription数据 </b>
	 * @param vo 企业短期第一页信息
	 * @param service_description_id 业务描述表id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheCommonExportVo_1SetUpInsServiceDescription(CommonExportVo_1 vo, Long service_description_id){
		StServiceDescription insServiceDescription = dao.selectById(service_description_id);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insServiceDescription);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(insServiceDescription);
	}

	/**
	 * <b>根据业务描述表信息转换成 CommonExportVo_1 </b>
	 *
	 * @param insServiceDescription
	 * @param vo
	 * @return
	 * @author ZXF
	 * @date 2017年1月8日 下午3:10:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToInsServiceDescriptionIntoCommonExportVo_1(CommonExportVo_1 vo, StServiceDescription insServiceDescription){
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insServiceDescription), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
