package com.bcxin.ins.dao.preservation;

import com.bcxin.ins.entity.policy_core.InsPreservationDetail;
import com.bcxin.ins.spring.annotation.MyBatisDao;
import com.bcxin.ins.vo.InsPreservationDetailVo;
import com.bcxin.ins.vo.excel.RecordDetailExcelVo;
import com.bcxin.mybatisplus.mapper.BaseMapper;
import com.bcxin.mybatisplus.plugins.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;


/**
 * <b>保全详情 </b>
 *
 */
@MyBatisDao
public interface InsPreservationDetailAPIDao extends BaseMapper<InsPreservationDetail> {

    /**
     * <b>根据保全申请单id及条件查询保全详情记录表并进行分页 </b>
     *
     * @param page 分页
     * @param preservationId 保全申请单id
     * @param keyword 关键字
     * @return
     * @author ZXF
     * @date 2017年8月3日 下午17:19:24
     * @注意事项 </b>
     * <b>
     */
    List<InsPreservationDetail> findInsPreservationDetailByKeyword(Page<InsPreservationDetail> page, @Param("preservationId") Long preservationId, @Param("keyword") String keyword);
    List<InsPreservationDetail> findInsPreservationDetailByKeyword( @Param("preservationId") Long preservationId, @Param("keyword") String keyword);
    List<InsPreservationDetail> findInsPreservationDetail(@Param("policyId") Long policyId, @Param("status") String status, @Param("resType") String resType);
    List<InsPreservationDetail> findDetailByPolicyId(@Param("policyId") Long policyId);

    void batchInsert(@Param("list") List<InsPreservationDetail> list);
    void batchUpdate(@Param("list") List<InsPreservationDetail> list);

    /**
     * <b>根据保全申请单id及条件查询保全详情记录表并进行分页 </b>
     *
     * @param page 分页
     * @param preservationId 保全申请单id
     * @param keyword 关键字
     * @return InsPreservationDetailVo 返回的是辅助类
     * @author ZXF
     * @date 2017年8月3日 下午17:19:24
     * @注意事项 </b>
     * <b>
     */
    public List<InsPreservationDetailVo> findInsPreservationDetailVoByKeyword(Page<InsPreservationDetailVo> page, @Param("preservationId") Long preservationId, @Param("keyword") String keyword);
    public List<InsPreservationDetailVo> findInsPreservationDetailVoByKeyword( @Param("preservationId") Long preservationId, @Param("keyword") String keyword);
    public List<InsPreservationDetailVo> findInsPreservationDetailVoByPreservationId(@Param("sign") String sign, @Param("preservationId") Long preservationId);

    //查询保全申请详情人员数据
    List<Map<Object,Object>> queryDetail(Map<Object, Object> p);

    List<RecordDetailExcelVo> downPreservationList(@Param("userId") String userId, @Param("keyword") String keyword, @Param("name") String name, @Param("start_time") String start_time, @Param("end_time") String end_time);
}
