/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.repkg.org.apache.http.impl.cookie;

import com.pingan.iobs.sdk.repkg.org.apache.http.annotation.Immutable;
import com.pingan.iobs.sdk.repkg.org.apache.http.cookie.Cookie;
import com.pingan.iobs.sdk.repkg.org.apache.http.cookie.CookieOrigin;
import com.pingan.iobs.sdk.repkg.org.apache.http.cookie.CookieRestrictionViolationException;
import com.pingan.iobs.sdk.repkg.org.apache.http.cookie.MalformedCookieException;
import com.pingan.iobs.sdk.repkg.org.apache.http.cookie.SetCookie;
import com.pingan.iobs.sdk.repkg.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.pingan.iobs.sdk.repkg.org.apache.http.util.Args;

@Immutable
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().length() == 0) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }
}

