package com.bcxin.ins.third.gzzrx.changan;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.third.gzzrx.changan.ca_enum.CraftType;
import com.bcxin.ins.third.xyx.yb_enum.YB_City;
import com.bcxin.ins.util.*;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.vo.*;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.report_pac.InsClaimInformationVo;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.ins.vo.report_pac.ReportCodeVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

/**
 * <b> 长安-雇主责任险各接口请求数据组装 </b>
 * @author ZXF
 * @create 2021/02/26 0026 13:59
 * @version
 * @注意事项 </b>
 */
public class GZZRX_PackageMessageChangAn {
	protected Document requestDocument;
	protected Element rootElement;

	void GZZRX_PackageMessageRenBao(){

	}

	private static Logger logger = LoggerFactory.getLogger(GZZRX_PackageMessageChangAn.class);

	/**
	 * <b> 报案 </b>
	 * @param vo 报案信息
	 * @param transType
	 * @author ZXF
	 * @create 2021/03/30 0030 16:02
	 * @version
	 * @注意事项 </b>
	 */
	public static String marshalReport(InsCommonReportVo vo, String transType){
		String result = ConstProp.BLANK_CHAR;
		Document requestDocument = DocumentHelper.createDocument();
		requestDocument.setXMLEncoding("GBK");//设置该XML文件的Encoding = "GBK"
		try {
			IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
			String uid = String.valueOf(idWorker.nextId());
			Element PACKET = requestDocument.addElement("Packet");
			//渠道信息
			Element CHANNEL = PACKET.addElement("channel");
			CHANNEL.addElement("channelCode").setText("BaiChuanXin");
			CHANNEL.addElement("channelTradeSerialNo").setText(uid);
			if(TransTypeEnum.BASL.getValue().equals(transType)) {//报案
				CHANNEL.addElement("channelTradeCode").setText("0102");
				//内容列
				Element RegistInfo = PACKET.addElement("RegistInfo");
				RegistInfo.addElement("BusinessType").setText("BaiChuanXin");
				RegistInfo.addElement("PolicyNo").setText(vo.getPolicy_no());//
				RegistInfo.addElement("ReportName").setText(vo.getReporter_name());//报案人姓名
				RegistInfo.addElement("ReportDate").setText(vo.getReport_date());//报案时间
				RegistInfo.addElement("LinkerName").setText(vo.getReporter_name());//联系人姓名
				RegistInfo.addElement("PhoneNumber").setText(vo.getReporter_tel());//联系人电话
				RegistInfo.addElement("DamageDate").setText(vo.getAccident_date());//出险时间
				ReportCodeVo rcVo = new ReportCodeVo("CA");
				RegistInfo.addElement("DamageCode").setText(vo.getAccident_cause_level_1());//出险原因代码
				RegistInfo.addElement("DamageName").setText(rcVo.getCxyyName(vo.getAccident_cause_level_1()));//出险原因名称
				RegistInfo.addElement("DistrictCode1").setText(vo.getAccident_province_code());//省
				RegistInfo.addElement("DistrictCode2").setText(vo.getAccident_city_code());//市
				RegistInfo.addElement("DistrictCode3").setText(vo.getAccident_county_code());//区代码
				RegistInfo.addElement("DamageAddress").setText(vo.getAccident_place());//详细地址
				RegistInfo.addElement("EstiMateLoss").setText("0");//报损金额
				RegistInfo.addElement("EstiCurrency").setText("CNY");//
				String LossName = "";
				if(StringUtils.isNotEmpty(vo.getOutpatient_list())){
					LossName = "门诊："+vo.getOutpatient_list()+"；";
				}
				if(StringUtils.isNotEmpty(vo.getMaim_list())){
					LossName += "住院："+vo.getMaim_list()+"；";
				}
				if(StringUtils.isNotEmpty(vo.getDemise_list())){
					LossName += "死亡："+vo.getDemise_list();
				}
				RegistInfo.addElement("LossName").setText(LossName);//受损标的
				RegistInfo.addElement("AccidentText").setText(vo.getAccident_process());//事故描述
			}else if(TransTypeEnum.CLSC.getValue().equals(transType)) {//材料上传
				CHANNEL.addElement("channelTradeCode").setText("0104");
				//内容列
				Element RegistInfo = PACKET.addElement("ImageInfo");
				RegistInfo.addElement("BusinessType").setText("BaiChuanXin");
				RegistInfo.addElement("ReportNo").setText(vo.getReport_no());
				Element ImageList = RegistInfo.addElement("ImageList");
				ImageList(ImageList,vo.getClaimInformationVoList());
			}
			result = requestDocument.asXML();
		}catch (Exception e){
			e.printStackTrace();
		}
		return result;
	}

	//上传附件
	private static void ImageList(Element ImageList, List<InsClaimInformationVo> list) {
		for(InsClaimInformationVo vo : list){
			if(ConstProp.DIGIT_ZERO.equals(vo.getStatus())){
				Element ImageData = ImageList.addElement("ImageData");
				int len = vo.getIns_claim_information_id().length();
				String sign = vo.getIns_claim_information_id().substring(len-3,len);
				ImageData.addElement("ImageIndex").setText(vo.getShort_group_code()+sign);//序号
				ImageData.addElement("PicName").setText(vo.getFile_name());//图片名称
				Map<String, String> map = FileHelp.httpFileToBase64(vo.getFile_path());
				ImageData.addElement("PicData").setText(map.get("base64"));//图片转码BASE64后的字符串
				ImageData.addElement("PicSize").setText(map.get("size"));//图片大小
				ImageData.addElement("PicRemark").setText("");//备注
			}
		}
	}

	/**
	 * <b> 理赔查询 </b>
	 * @param policyNo 保单号
	 * @param reportNo 报案号
	 * @author ZXF
	 * @create 2021/03/30 0030 16:02
	 * @version
	 * @注意事项 </b>
	 */
	public static String marshalFindReport(String policyNo, String reportNo,int pageNo){
		String result = ConstProp.BLANK_CHAR;
		Document requestDocument = DocumentHelper.createDocument();
		requestDocument.setXMLEncoding("GBK");//设置该XML文件的Encoding = "GBK"
		try {
			IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
			String uid = String.valueOf(idWorker.nextId());
			Element PACKET = requestDocument.addElement("Packet");
			//渠道信息
			Element CHANNEL = PACKET.addElement("channel");
			CHANNEL.addElement("channelCode").setText("BaiChuanXin");
			CHANNEL.addElement("channelTradeCode").setText("0105");
			CHANNEL.addElement("channelTradeSerialNo").setText(uid);

			//内容列
			Element BODY = PACKET.addElement("Body");
			BODY.addElement("BusinessType").setText("BaiChuanXin");
			BODY.addElement("RegistNo").setText(reportNo);
			BODY.addElement("PolicyNo").setText(policyNo);
			BODY.addElement("PageNo").setText(String.valueOf(pageNo));
			result = requestDocument.asXML();
		}catch (Exception e){
			e.printStackTrace();
		}
		return result;
	}

	public static String mail(SpecialHirelingVo vo, OrderFormVo dto, String transType, String certino, String kpStar, String kpEnd){
		String result = ConstProp.BLANK_CHAR;
		Document requestDocument = DocumentHelper.createDocument();
		requestDocument.setXMLEncoding("GBK");//设置该XML文件的Encoding = "GBK"
		IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
		try {
			if(TransTypeEnum.DZFP.getValue().equals(transType)) {//保单电子发票查询
				//渠道信息
				Element Root = requestDocument.addElement("Root");
				Element CHANNEL = Root.addElement("channel");
				CHANNEL.addElement("channelCode").setText("000160");
				CHANNEL.addElement("channelComCode").setText("430000");
				CHANNEL.addElement("channelProductCode").setText("1516");
				CHANNEL.addElement("channelTradeCode").setText("invoiceQuery");
				CHANNEL.addElement("channelTradeSerialNo").setText(String.valueOf(idWorker.nextId()));
				CHANNEL.addElement("channelAreaCode").setText("430000");
				CHANNEL.addElement("channelTradeDate").setText(DateUtil.getCurrentDateTime());
				Element INFO = Root.addElement("info");
				RoleSubjectVo role = vo.getRoleSubjectList().get(0);
				String TaxNumber = role.getOrganization_code();
				String TaxName = role.getName_cn();
				if(!ConstProp.DIGIT_ZERO.equals(vo.getMailPolicyVo().getNeed_receipt())||!ConstProp.DIGIT_ZERO.equals(vo.getMailPolicyVo().getIs_send_einvoice())){
					TaxNumber = StringUtils.isEmpty(vo.getMailPolicyVo().getTaxpayer_number_invoice())?"":vo.getMailPolicyVo().getTaxpayer_number_invoice();
					TaxName = StringUtils.isEmpty(vo.getMailPolicyVo().getReceipt_head())?"":vo.getMailPolicyVo().getReceipt_head();
				}
				INFO.addElement("buyername").setText(TaxName);//发票抬头
				INFO.addElement("buyerno").setText(TaxNumber);//纳税人识别号
				INFO.addElement("policyno").setText(dto.getExternal_reference());//保单号
			}else if(TransTypeEnum.PDDZFP.getValue().equals(transType)) {//批单电子发票查询
				//渠道信息
				Element Root = requestDocument.addElement("Root");
				Element CHANNEL = Root.addElement("CHANNEL");
				CHANNEL.addElement("ChannelCode").setText("000160");
				CHANNEL.addElement("ChannelComCode").setText("430000");
				CHANNEL.addElement("channelProductCode").setText("1516");
				CHANNEL.addElement("ChannelTradeCode").setText("endorsementInvoiceQuery");
				CHANNEL.addElement("ChannelTradeSerialNo").setText(String.valueOf(idWorker.nextId()));
				CHANNEL.addElement("ChannelAreaCode").setText("430000");
				CHANNEL.addElement("ChannelTradeDate").setText(DateUtil.getCurrentDateTime());
				Element INFO = Root.addElement("INFO");
				INFO.addElement("CertinoList").setText(certino);//批单号 单号之间用逗号隔开
				INFO.addElement("PrintDate1").setText(kpStar);//开票起期 yyyy-MM-dd(包含传入日期)
				INFO.addElement("PrintDate2").setText(kpEnd);//开票止期 yyyy-MM-dd(包含传入日期)
			}
			result = requestDocument.asXML();
		}catch (Exception e){
			e.printStackTrace();
		}
		return result;
	}

	/**
	 * 核保数据组装
	 * @param vo 投保详细信息
	 * @param dto 订单基本信息
	 * @param transType 接口类型
	 * @param iprVo 保全申请单
	 * @param itran 支付号
	 * @return
	 */
	public static String marshal(SpecialHirelingVo vo, OrderFormVo dto, String transType, InsPreservationRecordVo iprVo, InsTransaction itran){
		String result = ConstProp.BLANK_CHAR;
		Document requestDocument = DocumentHelper.createDocument();
		requestDocument.setXMLEncoding("GBK");//设置该XML文件的Encoding = "GBK"
		try {
			if(TransTypeEnum.HB.getValue().equals(transType)){//核保
				Element PACKET = requestDocument.addElement("PACKET");
				//投保对象信息
				Element HEAD = PACKET.addElement("HEAD");
				HEAD(HEAD, dto);
				//渠道信息
				Element CHANNEL = PACKET.addElement("CHANNEL");
				CHANNEL(CHANNEL,dto,"2104");
				//内容列
				Element BODY = PACKET.addElement("BODY");
				//投保基本信息
				Element PrpTmainDto = BODY.addElement("PrpTmainDto");
				PrpTmainDto(PrpTmainDto,dto,vo);
				//投保人信息 PrpTapplicantDto
				Element PrpTapplicantDtoList = BODY.addElement("PrpTapplicantDtoList");
				Element PrpTapplicantDto = PrpTapplicantDtoList.addElement("PrpTapplicantDto");
				PrpTapplicantDto(PrpTapplicantDto,dto,vo);
				//被保险人信息 PrpTinsuredDto
				Element PrpTinsuredDtoList = BODY.addElement("PrpTinsuredDtoList");
				Element PrpTinsuredDto = PrpTinsuredDtoList.addElement("PrpTinsuredDto");
				PrpTinsuredDto(PrpTinsuredDto,dto,vo);

				//险别信息 PrpTitemKindDto
				Element PrpTitemKindList = BODY.addElement("PrpTitemKindList");
				PrpTitemKindList(PrpTitemKindList,vo,dto,String.valueOf(vo.getHirelingVoList().size()));
				//营业处所地址信息 PrpTaddressDto
				Element PrpTaddressDto = BODY.addElement("PrpTaddressDto");
				PrpTaddressDto(PrpTaddressDto,dto,vo);
				//标的信息 PrpTSubjectDto
				Element PrpTSubjectList = BODY.addElement("PrpTSubjectList");
				PrpTSubjectList(PrpTSubjectList,dto,vo);
				//特别约定 PrpTengageDto
				Element PrpTengageList = BODY.addElement("PrpTengageList");
				PrpTengageList(PrpTengageList,dto);
				//限额免赔信息 PrpTlimitDto
				Element PrpTlimitDtoList = BODY.addElement("PrpTlimitDtoList");
				PrpTlimitDtoList(PrpTlimitDtoList,dto,String.valueOf(vo.getHirelingVoList().size()));
				//责任险承保信息
				Element PrpTMainPropDto = BODY.addElement("PrpTMainPropDto");
				PrpTMainPropDto(PrpTMainPropDto,vo);
				result = requestDocument.asXML();
			}else if(TransTypeEnum.PD.getValue().equals(transType)){//批单
				Element PACKET = requestDocument.addElement("PACKET");
				//渠道信息
				Element CHANNEL = PACKET.addElement("CHANNEL");
				PD_CHANNEL(CHANNEL,iprVo,"2401");
				//投保对象信息
				Element HEAD = PACKET.addElement("HEAD");
				PD_HEAD(HEAD, iprVo);
				//内容列
				Element BODY = PACKET.addElement("BODY");
				//批单主信息
				Element PrpTmainDto = BODY.addElement("PrpPHeadDto");
				PrpTmainDto(PrpTmainDto,dto,iprVo);
				//变更信息
				Element PrpCNameList = BODY.addElement("PrpCNameList");
				PrpCNameList(PrpCNameList, dto, iprVo);
				//险别信息
				Element PrpCitemKindList = BODY.addElement("PrpCitemKindList");
				PrpCitemKindList(PrpCitemKindList, dto, iprVo);
				//收款人信息
				Element PrpCRecieverDto = BODY.addElement("PrpCRecieverDto");
				PrpCRecieverDto(PrpCRecieverDto, dto, iprVo, vo);
				//限额免赔
				Element PrpCLimitList = BODY.addElement("PrpClimitList");
				String perNum = ConstProp.DIGIT_ONE.equals(iprVo.getRevise_type())? ""+iprVo.getInsPreservationDetailVoList().size():ConstProp.DIGIT_TWO.equals(iprVo.getRevise_type())? "-"+iprVo.getInsPreservationDetailVoList().size():"0";
				PrpCLimitList(PrpCLimitList, dto, perNum);
				if(!ConstProp.DIGIT_THREE.equals(iprVo.getRevise_type())){
					//缴费计划信息
					Element PrpCplanDto = BODY.addElement("PrpCplanDto");
					PrpCplanDto(PrpCplanDto, dto, iprVo);
				}
				result = requestDocument.asXML();
			}/*else if(TransTypeEnum.PDJG.getValue().equals(transType)){//批单状态查询
				//渠道信息
				Element CHANNEL = requestDocument.addElement("CHANNEL");
				PD_CHANNEL(CHANNEL,iprVo,"2101");
				//投保对象信息
				Element HEAD = requestDocument.addElement("HEAD");
				PDJG_HEAD(HEAD, iprVo);
				result = requestDocument.asXML();
			}*/else if(TransTypeEnum.ZFDZ.getValue().equals(transType)){//获取支付地址
				Element request = requestDocument.addElement("request");
				IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
				String uid = String.valueOf(idWorker.nextId());
				Element requestHead = request.addElement("requestHead");
				requestHead(requestHead, dto, uid);
				Element requestBody = request.addElement("requestBody");
				requestBody(requestBody, dto);
				result = requestDocument.asXML();
			}/*else if(TransTypeEnum.ZFJG.getValue().equals(transType)){//查询支付结果
				Element requestHead = requestDocument.addElement("requestHead");
				requestHead(requestHead, dto);
				Element requestBody = requestDocument.addElement("requestBody");
				//支付号
				requestBody.addElement("payNo").setText(itran.getPay_order_number());
				result = requestDocument.asXML();
			}*/else if(TransTypeEnum.CBQR.getValue().equals(transType)){//承保确认接口
				Element PACKET = requestDocument.addElement("PACKET");
				//渠道信息
				Element CHANNEL = PACKET.addElement("CHANNEL");
				CHANNEL(CHANNEL,dto,"2204");
				//投保对象信息
				Element HEAD = PACKET.addElement("HEAD");
				CB_HEAD(HEAD, dto);
				//内容列
				Element BODY = PACKET.addElement("BODY");
				CB_BODY(BODY, dto, itran);
				result = requestDocument.asXML();
			}/*else if(TransTypeEnum.CBXX.getValue().equals(transType)){//保单查询接口
				//渠道信息
				Element CHANNEL = requestDocument.addElement("CHANNEL");
				CHANNEL(CHANNEL,dto,"2302");
				//投保对象信息
				Element HEAD = requestDocument.addElement("HEAD");
				//密钥ID
				HEAD.addElement("AppId").setText("");
				//业务来源
				HEAD.addElement("SourceType").setText("");
				//内容列
				Element BODY = requestDocument.addElement("BODY");
				//投保单号
				BODY.addElement("ProposalNo").setText(dto.getPolicy_serial_number());
				//保单号
				BODY.addElement("PolicyNo").setText(dto.getExternal_reference());
				//险种代码
				BODY.addElement("RiskCode").setText("");
				result = requestDocument.asXML();
			}*/
//			logger.info("人保接口报文数据组装--getHBOrder："+result);
		}catch (Exception e){
			e.printStackTrace();
		}
		return result;
	}

	//渠道信息
	private static void CHANNEL(Element underwrite, OrderFormVo dto, String ChannelTradeCode) {
		//渠道代码
		underwrite.addElement("ChannelCode").setText("000160");
		//渠道机构代码
		underwrite.addElement("ChannelComCode").setText("430000");
		//渠道产品代码
		underwrite.addElement("ChannelProductCode").setText("1516");
		//渠道交易代码
//		2101(非预缴方式)
//		2102(预缴方式)
//		2103(实时支付出单)
//		2104（确认投保接口）
//		2105(接受投保单信息，返回投保单号，异步落地投保单信息）
		underwrite.addElement("ChannelTradeCode").setText(ChannelTradeCode);
		//渠道交易流水号（一次交易标识）
		underwrite.addElement("ChannelTradeSerialNo").setText(dto.getTrade_serial_number());
		//渠道区域代码
		underwrite.addElement("ChannelAreaCode").setText("430000");
		//渠道交易日期,格式:yyyy-MM-dd HH:mm:ss
		underwrite.addElement("ChannelTradeDate").setText(dto.getStart_time());
	}

	//投保人信息
	private static void PrpTapplicantDto(Element underwrite, OrderFormVo dto, SpecialHirelingVo vo) {
		RoleSubjectVo appli = vo.getRoleSubjectList().get(0);
		underwrite.addElement("InsuredName").setText(appli.getName_cn());//投保人名称
		String appliAddress = RegionUtils.getRegionNameByALLCode(appli.getReg_province(),appli.getReg_city(),appli.getReg_district())+appli.getReg_address();
		underwrite.addElement("Province").setText(appli.getReg_province());
		underwrite.addElement("City").setText(zxCity(appli.getReg_city(),appli.getReg_district()));
		underwrite.addElement("County").setText(zxCounty(appli.getReg_district()));
		underwrite.addElement("InsuredAddress").setText(appliAddress);//投保人地址
		underwrite.addElement("Creditlevel").setText(ConstProp.BLANK_CHAR.equals(appli.getNature_two()) ? natureLinkageSet(appli.getCom_nature()) : natureLinkageSet(appli.getNature_two()));//单位性质
		underwrite.addElement("Language").setText("C");//
		underwrite.addElement("SerialNo").setText("1");//
		underwrite.addElement("InsuredType").setText("2");//关系人类型 1.个人/2.单位和关系人性质随动
		underwrite.addElement("InsuredNature").setText("4");//关系人性质 3.自然人/4.法人和关系人类型随动
		underwrite.addElement("InsuredFlag").setText("2");//关系人标志 2:投保人
		underwrite.addElement("IdentifyType").setText("99");//证件类型
		String organizationCode = appli.getOrganization_code();
		if(StringUtils.isNotEmpty(organizationCode) && ConstProp.DIGIT_ONE.equals(appli.getId_type())){
			organizationCode = organizationCode.split(ConstProp.MINUS)[0]+organizationCode.split(ConstProp.MINUS)[1];
		}
		underwrite.addElement("IdentifyNumber").setText(organizationCode);//证件号码/组织机构代码
		underwrite.addElement("Mobile").setText(appli.getLink_tel());//移动电话
		underwrite.addElement("LinkerName").setText(appli.getLink_name());//联系人姓名
		underwrite.addElement("PhoneNumber").setText("");//联系电话
		underwrite.addElement("Email").setText(appli.getLink_email());//投保人邮箱
		underwrite.addElement("EffectiveStartDate").setText(StringUtils.isEmpty(appli.getId_star_date())?"":appli.getId_star_date());//证件有效期起期
		underwrite.addElement("EffectiveEndDate").setText(StringUtils.isEmpty(appli.getId_star_date())?"":appli.getId_star_date());//证件有效期止期
		String InvoiceType = "";
		if(!ConstProp.DIGIT_ZERO.equals(vo.getMailPolicyVo().getNeed_receipt())||!ConstProp.DIGIT_ZERO.equals(vo.getMailPolicyVo().getIs_send_einvoice())){
			underwrite.addElement("TaxpayerType").setText("1");//纳税人类型 1. 一般纳税人；2. 小规模纳税人；3. 非增值税纳税人；4. 个人
			InvoiceType = "3";
			if(!ConstProp.DIGIT_ONE.equals(vo.getMailPolicyVo().getIs_send_einvoice())){
				InvoiceType = ConstProp.DIGIT_ZERO.equals(vo.getMailPolicyVo().getInvoice_type()) ? "2" : "1";
			}
			String TaxNumber = StringUtils.isEmpty(vo.getMailPolicyVo().getTaxpayer_number_invoice())?"":vo.getMailPolicyVo().getTaxpayer_number_invoice();
			underwrite.addElement("TaxNumber").setText(TaxNumber);//纳税人识别号
			if(ConstProp.DIGIT_ONE.equals(InvoiceType)){//专票
				String TaxRegistAddress = StringUtils.isEmpty(vo.getMailPolicyVo().getRegister_address_invoice())?"":vo.getMailPolicyVo().getRegister_address_invoice();
				underwrite.addElement("TaxRegistAddress").setText(TaxRegistAddress);//税务登记地址
				String Bank = StringUtils.isEmpty(vo.getMailPolicyVo().getBank_invoice())?"":vo.getMailPolicyVo().getBank_invoice();
				underwrite.addElement("Bank").setText(Bank);//开户行
				String Account = StringUtils.isEmpty(vo.getMailPolicyVo().getBank_account_invoice())?"":vo.getMailPolicyVo().getBank_account_invoice();
				underwrite.addElement("Account").setText(Account);//账号
			}
			underwrite.addElement("InvoiceType").setText(InvoiceType);//发票类型 1. 增值税专用发票；2. 增值税普通发票；3. 增值税电子普通发票；4. 其他发票
		}
		String IsAutomatic = StringUtils.isNotEmpty(InvoiceType)? "1" : "0";
		underwrite.addElement("IsAutomatic").setText(IsAutomatic);//自动开具标识(0：否，1：是)
	}

	//责任险承保信息
	private static void PrpTMainPropDto(Element underwrite, SpecialHirelingVo vo) {
		RoleSubjectVo insured = vo.getRoleSubjectList().get(1);
		underwrite.addElement("InsureArea").setText(insured.getIndustry());//营业范围
		String PrpTMainExt1 = natureCov(StringUtils.isNotEmpty(insured.getNature_two())?insured.getNature_two() : insured.getCom_nature());
		underwrite.addElement("PrpTMainExt1").setText(PrpTMainExt1);//企业性质（代码）
		underwrite.addElement("PrpTMainExt2").setText(industryCov(insured.getIndustry()));//营业性质（三级代码）
		underwrite.addElement("PrpTMainExt3").setText(String.valueOf(vo.getHirelingVoList().size()));//员工数
		underwrite.addElement("PrpTMainExt9").setText("0");//投保工伤人数
		underwrite.addElement("PrpTMainExt10").setText(String.valueOf(vo.getHirelingVoList().size()));//雇员总人数
	}
	private static String industryCov(String industry) {
		if("保安服务业".equals(industry)){//
			return "L7493";
		}else if("家政服务业".equals(industry)){//
			return "O8329";
		}else{//其他
			return "";
		}
	}
	private static String natureCov(String natureType) {
		if(NatureLinkage.OFFICE.getValue().equals(natureType)){//机关
			return "100";
		}else if(NatureLinkage.CAUSE.getValue().equals(natureType)){//事业单位
			return "200";
		}else if(NatureLinkage.GROUP.getValue().equals(natureType)){//社会团体
			return "130";
		}else if(NatureLinkage.HOLDING.getValue().equals(natureType)){//国有控股 国有企业
			return "310";
		}else if(NatureLinkage.JOINTOPERATION.getValue().equals(natureType)){//国有联营 国有企业
			return "310";
		}else if(NatureLinkage.RACINGSHOES.getValue().equals(natureType)){//私营企业 民营企业
			return "340";
		}else if(NatureLinkage.RURALTOWNSHIP.getValue().equals(natureType)){//乡镇企业 民营企业
			return "320";
		}else if(NatureLinkage.INDIVIDUAL.getValue().equals(natureType)){//个体企业 民营企业
			return "330";
		}else if(NatureLinkage.FOREIGNMERCHANT.getValue().equals(natureType)){//外商独资 外资企业
			return "350";
		}else if(NatureLinkage.JOINTVENTURE.getValue().equals(natureType)){//中外合资 外资企业
			return "350";
		}else if(NatureLinkage.COLLABORATION.getValue().equals(natureType)){//中外合作 外资企业
			return "350";
		}else{//其他
			return "900";
		}
	}

	//限额免赔信息
	private static void PrpTlimitDtoList(Element PrpTlimitDtoList, OrderFormVo dto, String perNum) {
		if("GZZRX-CA-1".equals(dto.getProduct_code())){
			OnePrpTlimitDtoList(PrpTlimitDtoList,"300000","300000","300000","300000","30000","30000","100000","100000","10000","10000",perNum);
		}else if("GZZRX-CA-2".equals(dto.getProduct_code())){
			OnePrpTlimitDtoList(PrpTlimitDtoList,"400000","400000","400000","400000","40000","40000","120000","120000","12000","12000",perNum);
		}else if("GZZRX-CA-3".equals(dto.getProduct_code())){
			OnePrpTlimitDtoList(PrpTlimitDtoList,"500000","500000","500000","500000","50000","50000","150000","150000","15000","15000",perNum);
		}else if("GZZRX-CA-4".equals(dto.getProduct_code())){
			OnePrpTlimitDtoList(PrpTlimitDtoList,"600000","600000","600000","600000","60000","60000","180000","180000","18000","18000",perNum);
		}else if("GZZRX-CA-5".equals(dto.getProduct_code())){
			OnePrpTlimitDtoList(PrpTlimitDtoList,"700000","700000","700000","700000","70000","70000","210000","210000","21000","21000",perNum);
		}else if("GZZRX-CA-6".equals(dto.getProduct_code())){
			OnePrpTlimitDtoList(PrpTlimitDtoList,"800000","800000","800000","800000","80000","80000","240000","240000","24000","24000",perNum);
		}else if("GZZRX-CA-DQ-1".equals(dto.getProduct_code())){
			OnePrpTlimitDtoList(PrpTlimitDtoList,"300000","300000","300000","300000","30000","30000","100000","100000","10000","10000",perNum);
		}else if("GZZRX-CA-DQ-2".equals(dto.getProduct_code())){
			OnePrpTlimitDtoList(PrpTlimitDtoList,"400000","400000","400000","400000","40000","40000","120000","120000","12000","12000",perNum);
		}else if("GZZRX-CA-DQ-3".equals(dto.getProduct_code())){
			OnePrpTlimitDtoList(PrpTlimitDtoList,"500000","500000","500000","500000","50000","50000","150000","150000","15000","15000",perNum);
		}else if("GZZRX-CA-DQ-4".equals(dto.getProduct_code())){
			OnePrpTlimitDtoList(PrpTlimitDtoList,"600000","600000","600000","600000","60000","60000","180000","180000","18000","18000",perNum);
		}else if("GZZRX-CA-DQ-5".equals(dto.getProduct_code())){
			OnePrpTlimitDtoList(PrpTlimitDtoList,"700000","700000","700000","700000","70000","70000","210000","210000","21000","21000",perNum);
		}else if("GZZRX-CA-DQ-6".equals(dto.getProduct_code())){
			OnePrpTlimitDtoList(PrpTlimitDtoList,"800000","800000","800000","800000","80000","80000","240000","240000","24000","24000",perNum);
		}
	}

	private static void OnePrpTlimitDtoList(Element PrpTlimitDtoList
			,String row_1
			,String row_2
			,String row_4
			,String row_5
			,String row_11
			,String row_12
			,String row_23
			,String row_24
			,String row_30
			,String row_31
			,String perNum) {
		/*---雇主责任险2012版主险-----*/
		String row_1_1 = BigDecimal.valueOf(Double.parseDouble(row_1)).multiply(BigDecimal.valueOf(Double.parseDouble(perNum))).toString();
		PrpTlimitDto(PrpTlimitDtoList,"1","0","32",row_1_1,"0");//*
		PrpTlimitDto(PrpTlimitDtoList,"1","0","33",row_2,"0");
		PrpTlimitDto(PrpTlimitDtoList,"1","0","34",row_2,"0");
		PrpTlimitDto(PrpTlimitDtoList,"1","0","101","100","1");
		/*---雇主责任险2012版主险 死亡伤残限额免赔-----*/
		String row_4_1 = BigDecimal.valueOf(Double.parseDouble(row_4)).multiply(BigDecimal.valueOf(Double.parseDouble(perNum))).toString();
		PrpTlimitDto(PrpTlimitDtoList,"2","1","03",row_4_1,"");//*
		PrpTlimitDto(PrpTlimitDtoList,"2","1","77",row_5,"");
		PrpTlimitDto(PrpTlimitDtoList,"2","1","04","0","");
		PrpTlimitDto(PrpTlimitDtoList,"2","1","78","0","0");
		PrpTlimitDto(PrpTlimitDtoList,"2","1","79","0","");
		PrpTlimitDto(PrpTlimitDtoList,"2","1","80","0","");
		PrpTlimitDto(PrpTlimitDtoList,"2","1","81","0","0");
		/*----雇主责任险2012版主险 医疗费用限额免赔----*/
		String row_11_1 = BigDecimal.valueOf(Double.parseDouble(row_11)).multiply(BigDecimal.valueOf(Double.parseDouble(perNum))).toString();
		PrpTlimitDto(PrpTlimitDtoList,"2","2","03",row_11_1,"");//*
		PrpTlimitDto(PrpTlimitDtoList,"2","2","77",row_12,"");
		PrpTlimitDto(PrpTlimitDtoList,"2","2","04","0","");
		PrpTlimitDto(PrpTlimitDtoList,"2","2","78","0","0");
		PrpTlimitDto(PrpTlimitDtoList,"2","2","79","0","");
		PrpTlimitDto(PrpTlimitDtoList,"2","2","80","0","");
		PrpTlimitDto(PrpTlimitDtoList,"2","2","81","0","0");
		/*----雇主责任险2012版主险 误工费----*/
		String other_1 = BigDecimal.valueOf(Double.parseDouble("18000")).multiply(BigDecimal.valueOf(Double.parseDouble(perNum))).toString();
		PrpTlimitDto(PrpTlimitDtoList,"2","3","03",other_1,"");//*
		PrpTlimitDto(PrpTlimitDtoList,"2","3","77","18000","");
		PrpTlimitDto(PrpTlimitDtoList,"2","3","04","0","");
		PrpTlimitDto(PrpTlimitDtoList,"2","3","78","100","0");
		PrpTlimitDto(PrpTlimitDtoList,"2","3","79","180","");
		PrpTlimitDto(PrpTlimitDtoList,"2","3","80","360","");
		PrpTlimitDto(PrpTlimitDtoList,"2","3","81","18000","0");
		/*----附加24小时意外险特别扩展条款（B）死亡伤残-----*/
		String row_23_1 = BigDecimal.valueOf(Double.parseDouble(row_23)).multiply(BigDecimal.valueOf(Double.parseDouble(perNum))).toString();
		String row_24_1 = BigDecimal.valueOf(Double.parseDouble(row_24)).multiply(BigDecimal.valueOf(Double.parseDouble(perNum))).toString();
		PrpTlimitDto(PrpTlimitDtoList,"2","4","04",row_23_1,"");//*
		PrpTlimitDto(PrpTlimitDtoList,"2","4","78","0","0");
		PrpTlimitDto(PrpTlimitDtoList,"2","4","79","0","");
		PrpTlimitDto(PrpTlimitDtoList,"2","4","80","0","");
		PrpTlimitDto(PrpTlimitDtoList,"2","4","81","0","0");
		PrpTlimitDto(PrpTlimitDtoList,"2","4","77",row_23,"");
		PrpTlimitDto(PrpTlimitDtoList,"2","4","03",row_24_1,"");//*
		/*----附加24小时意外险特别扩展条款（B）医疗费用 -----*/
		String row_30_1 = BigDecimal.valueOf(Double.parseDouble(row_30)).multiply(BigDecimal.valueOf(Double.parseDouble(perNum))).toString();
		String row_31_1 = BigDecimal.valueOf(Double.parseDouble(row_31)).multiply(BigDecimal.valueOf(Double.parseDouble(perNum))).toString();
		PrpTlimitDto(PrpTlimitDtoList,"2","5","04",row_30_1,"");//*
		PrpTlimitDto(PrpTlimitDtoList,"2","5","78","0","0");
		PrpTlimitDto(PrpTlimitDtoList,"2","5","79","0","");
		PrpTlimitDto(PrpTlimitDtoList,"2","5","80","0","");
		PrpTlimitDto(PrpTlimitDtoList,"2","5","81","0","0");
		PrpTlimitDto(PrpTlimitDtoList,"2","5","77",row_30,"");
		PrpTlimitDto(PrpTlimitDtoList,"2","5","03",row_31_1,"");//*
		/*----附加第三者责任保险条款-----*/
		PrpTlimitDto(PrpTlimitDtoList,"2","6","04","0","");
		PrpTlimitDto(PrpTlimitDtoList,"2","6","78","0","0");
		PrpTlimitDto(PrpTlimitDtoList,"2","6","79","0","");
		PrpTlimitDto(PrpTlimitDtoList,"2","6","80","0","");
		PrpTlimitDto(PrpTlimitDtoList,"2","6","81","0","0");
		PrpTlimitDto(PrpTlimitDtoList,"2","6","03","0","");
	}
	private static void PrpTlimitDto(Element PrpTlimitDtoList
			, String LimitGrade
			, String LimitNo
			, String LimitType
			, String LimitFee
			, String LimitFlag) {
		Element underwrite = PrpTlimitDtoList.addElement("PrpTlimitDto");
		underwrite.addElement("RiskCode").setText("1516");//险种代码
		underwrite.addElement("LimitGrade").setText(LimitGrade);//限额/免赔级别
		underwrite.addElement("LimitNo").setText(LimitNo);//限额序号
		underwrite.addElement("LimitType").setText(LimitType);//赔偿限额/免赔额类别
		underwrite.addElement("Currency").setText("CNY");//
		underwrite.addElement("LimitFee").setText(LimitFee);//赔偿限额/免赔额
		underwrite.addElement("CalculateFlag").setText("N");//是否参与保费计算标志
		underwrite.addElement("LimitFlag").setText(LimitFlag);
	}

	//特别约定
	private static void PrpTengageList(Element PrpTengageList, OrderFormVo dto) {
		String Clauses = "";
		if("GZZRX-CA-1".equals(dto.getProduct_code())){
			Clauses = "*本保单的员工投保年龄限为16-65周岁；\n" +
					"*每次事故责任限额为300万，工作期间每人意外身故、伤残限额为30万，工作期间每人意外医疗费用限额为3万，每人生活意外身故、伤残限额为10万，每人生活意外医疗费用限额为1万，法律费用限额为30万；突发急性病身故限额为20万。本保单附加第三者责任险，每年事故累计限额为50万，每次财产损失赔偿限额为25万，每次人身伤亡、医疗、误工赔偿限额为25万，其中每次意外身故、伤残限额为25万，医疗费用限额为2.5万，误工赔偿限额为0.9万元。\n" +
					"*意外医疗每人每次事故绝对免赔额为 100 元，医保范围内损失 100%赔付；\n" +
					"*住院津贴无免赔，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计赔付 180 天；\n" +
					"*误工费免赔 5 天，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计最高赔付 180 天；\n" +
					"*第三者责任险每次事故绝对免赔额：每次事故免赔1000元或损失金额的10%，两者以高者为准。\n" +
					"*被保险人雇员因受伤需要评定伤残的，本保单伤残评定标准同时认可2017年1月1日正式实施的《人体损伤致残程度分级》评定结果，并按照以下比例计算伤残赔偿金：\n" +
					"人体损伤致残程度分级赔偿限额比例：一级（赔偿限额比例100%）、二级（赔偿限额比例80%）、三级（赔偿限额比例70%）、四级（赔偿限额比例60%）、五级（赔偿限额比例50%）、六级（赔偿限额比例40%）、七级（赔偿限额比例30%）、八级（赔偿限额比例20%）、九级（赔偿限额比例10%）、十级（赔偿限额比例5%）。\n" +
					"*附加24小时意外险特别扩展条款(B)，承保时间范围扩展至保险期间内全天 24 小时，而不论是否在工作期间。被保险人之雇员在此期间因意外事故而导致的死亡赔偿金、伤残赔偿金(或自伤残发生之日起在 180 日内发生死亡)以及因此而引起的意外医药费用（含社保范围内用药），保险人承担赔偿责任，但以所列明的限额为限。\n" +
					"*突发急性病身故责任：在本合同保险期间内，被保险人雇员因突发急性病，并自发作之日起 48 小时内因该急性病导致身故的，依法应由被保险人承担的急性病身故责任。\n" +
					"*本保单未尽事宜详见长安责任保险股份有限公司雇主责任保险条款（2012版），附加24小时意外险特别扩展条款（B） 附加第三者责任险条款 。";
		}else if("GZZRX-CA-2".equals(dto.getProduct_code())){
			Clauses = "*本保单的员工投保年龄限为16-65周岁；\n" +
					"*每次事故责任限额为400万，工作期间每人意外身故、伤残限额为40万，工作期间每人意外医疗费用限额为4万，每人生活意外身故、伤残限额为12万，每人生活意外医疗费用限额为1.2万，法律费用限额为40万；突发急性病身故限额为20万。本保单附加第三者责任险，每年事故累计限额为70万，每次财产损失赔偿限额为35万，每次人身伤亡、医疗、误工赔偿限额为35万，其中每次意外身故、伤残限额为35万，医疗费用限额为3.5万，误工赔偿限额为0.9万元。\n" +
					"*意外医疗每人每次事故绝对免赔额为 100 元，医保范围内损失 100%赔付；\n" +
					"*住院津贴无免赔，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计赔付 180 天；\n" +
					"*误工费免赔 5 天，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计最高赔付 180 天；\n" +
					"*第三者责任险每次事故绝对免赔额：每次事故免赔1000元或损失金额的10%，两者以高者为准。\n" +
					"*被保险人雇员因受伤需要评定伤残的，本保单伤残评定标准同时认可2017年1月1日正式实施的《人体损伤致残程度分级》评定结果，并按照以下比例计算伤残赔偿金：\n" +
					"人体损伤致残程度分级赔偿限额比例：一级（赔偿限额比例100%）、二级（赔偿限额比例80%）、三级（赔偿限额比例70%）、四级（赔偿限额比例60%）、五级（赔偿限额比例50%）、六级（赔偿限额比例40%）、七级（赔偿限额比例30%）、八级（赔偿限额比例20%）、九级（赔偿限额比例10%）、十级（赔偿限额比例5%）。\n" +
					"*附加24小时意外险特别扩展条款(B)，承保时间范围扩展至保险期间内全天 24 小时，而不论是否在工作期间。被保险人之雇员在此期间因意外事故而导致的死亡赔偿金、伤残赔偿金(或自伤残发生之日起在 180 日内发生死亡)以及因此而引起的意外医药费用（含社保范围内用药），保险人承担赔偿责任，但以所列明的限额为限。\n" +
					"*突发急性病身故责任：在本合同保险期间内，被保险人雇员因突发急性病，并自发作之日起 48 小时内因该急性病导致身故的，依法应由被保险人承担的急性病身故责任。\t\t\t\t\t\t\n" +
					"*本保单未尽事宜详见长安责任保险股份有限公司雇主责任保险条款（2012版），附加24小时意外险特别扩展条款（B） 附加第三者责任险条款 。";
		}else if("GZZRX-CA-3".equals(dto.getProduct_code())){
			Clauses = "*本保单的员工投保年龄限为16-65周岁；\n" +
					"*每次事故责任限额为500万，工作期间每人意外身故、伤残限额为50万，工作期间每人意外医疗费用限额为5万，每人生活意外身故、伤残限额为15万，每人生活意外医疗费用限额为1.5万，法律费用限额为50万；突发急性病身故限额为20万。本保单附加第三者责任险，每年事故累计限额为80万，每次财产损失赔偿限额为40万，每次人身伤亡、医疗、误工赔偿限额为40万，其中每次意外身故、伤残限额为40万，医疗费用限额为4万，误工赔偿限额为0.9万元。\n" +
					"*意外医疗每人每次事故绝对免赔额为 100 元，医保范围内损失 100%赔付；\n" +
					"*住院津贴无免赔，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计赔付 180 天；\n" +
					"*误工费免赔 5 天，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计最高赔付 180 天；\n" +
					"*第三者责任险每次事故绝对免赔额：每次事故免赔1000元或损失金额的10%，两者以高者为准。\n" +
					"*被保险人雇员因受伤需要评定伤残的，本保单伤残评定标准同时认可2017年1月1日正式实施的《人体损伤致残程度分级》评定结果，并按照以下比例计算伤残赔偿金：\n" +
					"人体损伤致残程度分级赔偿限额比例：一级（赔偿限额比例100%）、二级（赔偿限额比例80%）、三级（赔偿限额比例70%）、四级（赔偿限额比例60%）、五级（赔偿限额比例50%）、六级（赔偿限额比例40%）、七级（赔偿限额比例30%）、八级（赔偿限额比例20%）、九级（赔偿限额比例10%）、十级（赔偿限额比例5%）。\n" +
					"*附加24小时意外险特别扩展条款(B)，承保时间范围扩展至保险期间内全天 24 小时，而不论是否在工作期间。被保险人之雇员在此期间因意外事故而导致的死亡赔偿金、伤残赔偿金(或自伤残发生之日起在 180 日内发生死亡)以及因此而引起的意外医药费用（含社保范围内用药），保险人承担赔偿责任，但以所列明的限额为限。\n" +
					"*突发急性病身故责任：在本合同保险期间内，被保险人雇员因突发急性病，并自发作之日起 48 小时内因该急性病导致身故的，依法应由被保险人承担的急性病身故责任。\t\t\t\t\t\t\n" +
					"*本保单未尽事宜详见长安责任保险股份有限公司雇主责任保险条款（2012版），附加24小时意外险特别扩展条款（B） 附加第三者责任险条款 。";
		}else if("GZZRX-CA-4".equals(dto.getProduct_code())){
			Clauses = "*本保单的员工投保年龄限为16-65周岁；\n" +
					"*每次事故责任限额为600万，工作期间每人意外身故、伤残限额为60万，工作期间每人意外医疗费用限额为6万，每人生活意外身故、伤残限额为18万，每人生活意外医疗费用限额为1.8万，法律费用限额为60万；突发急性病身故限额为20万。本保单附加第三者责任险，每年事故累计限额为100万，每次财产损失赔偿限额为50万，每次人身伤亡、医疗、误工赔偿限额为50万，其中每次意外身故、伤残限额为50万，医疗费用限额为5万，误工赔偿限额为0.9万元。\n" +
					"*意外医疗每人每次事故绝对免赔额为 100 元，医保范围内损失 100%赔付；\n" +
					"*住院津贴无免赔，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计赔付 180 天；\n" +
					"*误工费免赔 5 天，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计最高赔付 180 天；\n" +
					"*第三者责任险每次事故绝对免赔额：每次事故免赔1000元或损失金额的10%，两者以高者为准。\n" +
					"*被保险人雇员因受伤需要评定伤残的，本保单伤残评定标准同时认可2017年1月1日正式实施的《人体损伤致残程度分级》评定结果，并按照以下比例计算伤残赔偿金：\n" +
					"人体损伤致残程度分级赔偿限额比例：一级（赔偿限额比例100%）、二级（赔偿限额比例80%）、三级（赔偿限额比例70%）、四级（赔偿限额比例60%）、五级（赔偿限额比例50%）、六级（赔偿限额比例40%）、七级（赔偿限额比例30%）、八级（赔偿限额比例20%）、九级（赔偿限额比例10%）、十级（赔偿限额比例5%）。\n" +
					"*附加24小时意外险特别扩展条款(B)，承保时间范围扩展至保险期间内全天 24 小时，而不论是否在工作期间。被保险人之雇员在此期间因意外事故而导致的死亡赔偿金、伤残赔偿金(或自伤残发生之日起在 180 日内发生死亡)以及因此而引起的意外医药费用（含社保范围内用药），保险人承担赔偿责任，但以所列明的限额为限。\n" +
					"*突发急性病身故责任：在本合同保险期间内，被保险人雇员因突发急性病，并自发作之日起 48 小时内因该急性病导致身故的，依法应由被保险人承担的急性病身故责任。\n" +
					"*本保单未尽事宜详见长安责任保险股份有限公司雇主责任保险条款（2012版），附加24小时意外险特别扩展条款（B） 附加第三者责任险条款 。";
		}else if("GZZRX-CA-5".equals(dto.getProduct_code())){
			Clauses = "*本保单的员工投保年龄限为16-65周岁；\n" +
					"*每次事故责任限额为700万，工作期间每人意外身故、伤残限额为70万，工作期间每人意外医疗费用限额为7万，每人生活意外身故、伤残限额为21万，每人生活意外医疗费用限额为2.1万，法律费用限额为70万；突发急性病身故限额为20万。本保单附加第三者责任险，每年事故累计限额为200万，每次财产损失赔偿限额为100万，每次人身伤亡、医疗、误工赔偿限额为100万，其中每次意外身故、伤残限额为100万，医疗费用限额为10万，误工赔偿限额为0.9万元。\t\t\t\n" +
					"*意外医疗每人每次事故绝对免赔额为 100 元，医保范围内损失 100%赔付；\n" +
					"*住院津贴无免赔，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计赔付 180 天；\n" +
					"*误工费免赔 5 天，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计最高赔付 180 天；\n" +
					"*第三者责任险每次事故绝对免赔额：每次事故免赔1000元或损失金额的10%，两者以高者为准。\n" +
					"*被保险人雇员因受伤需要评定伤残的，本保单伤残评定标准同时认可2017年1月1日正式实施的《人体损伤致残程度分级》评定结果，并按照以下比例计算伤残赔偿金：\n" +
					"人体损伤致残程度分级赔偿限额比例：一级（赔偿限额比例100%）、二级（赔偿限额比例80%）、三级（赔偿限额比例70%）、四级（赔偿限额比例60%）、五级（赔偿限额比例50%）、六级（赔偿限额比例40%）、七级（赔偿限额比例30%）、八级（赔偿限额比例20%）、九级（赔偿限额比例10%）、十级（赔偿限额比例5%）。\n" +
					"*附加24小时意外险特别扩展条款(B)，承保时间范围扩展至保险期间内全天 24 小时，而不论是否在工作期间。被保险人之雇员在此期间因意外事故而导致的死亡赔偿金、伤残赔偿金(或自伤残发生之日起在 180 日内发生死亡)以及因此而引起的意外医药费用（含社保范围内用药），保险人承担赔偿责任，但以所列明的限额为限。\n" +
					"*突发急性病身故责任：在本合同保险期间内，被保险人雇员因突发急性病，并自发作之日起 48 小时内因该急性病导致身故的，依法应由被保险人承担的急性病身故责任。\t\t\t\t\t\t\n" +
					"*本保单未尽事宜详见长安责任保险股份有限公司雇主责任保险条款（2012版），附加24小时意外险特别扩展条款（B） 附加第三者责任险条款 。";
		}else if("GZZRX-CA-6".equals(dto.getProduct_code())){
			Clauses = "*本保单的员工投保年龄限为16-65周岁；\n" +
					"*每次事故责任限额为800万，工作期间每人意外身故、伤残限额为80万，工作期间每人意外医疗费用限额为8万，每人生活意外身故、伤残限额为24万，每人生活意外医疗费用限额为2.4万，法律费用限额为80万；突发急性病身故限额为20万。本保单附加第三者责任险，每年事故累计限额为300万，每次财产损失赔偿限额为150万，每次人身伤亡、医疗、误工赔偿限额为150万，其中每次意外身故、伤残限额为150万，医疗费用限额为15万，误工赔偿限额为0.9万元。\n" +
					"*意外医疗每人每次事故绝对免赔额为 100 元，医保范围内损失 100%赔付；\n" +
					"*住院津贴无免赔，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计赔付 180 天；\n" +
					"*误工费免赔 5 天，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计最高赔付 180 天；\n" +
					"*第三者责任险每次事故绝对免赔额：每次事故免赔1000元或损失金额的10%，两者以高者为准。\n" +
					"*被保险人雇员因受伤需要评定伤残的，本保单伤残评定标准同时认可2017年1月1日正式实施的《人体损伤致残程度分级》评定结果，并按照以下比例计算伤残赔偿金：\n" +
					"人体损伤致残程度分级赔偿限额比例：一级（赔偿限额比例100%）、二级（赔偿限额比例80%）、三级（赔偿限额比例70%）、四级（赔偿限额比例60%）、五级（赔偿限额比例50%）、六级（赔偿限额比例40%）、七级（赔偿限额比例30%）、八级（赔偿限额比例20%）、九级（赔偿限额比例10%）、十级（赔偿限额比例5%）。\n" +
					"*附加24小时意外险特别扩展条款(B)，承保时间范围扩展至保险期间内全天 24 小时，而不论是否在工作期间。被保险人之雇员在此期间因意外事故而导致的死亡赔偿金、伤残赔偿金(或自伤残发生之日起在 180 日内发生死亡)以及因此而引起的意外医药费用（含社保范围内用药），保险人承担赔偿责任，但以所列明的限额为限。\n" +
					"*突发急性病身故责任：在本合同保险期间内，被保险人雇员因突发急性病，并自发作之日起 48 小时内因该急性病导致身故的，依法应由被保险人承担的急性病身故责任。\t\t\t\t\t\t\n" +
					"*本保单未尽事宜详见长安责任保险股份有限公司雇主责任保险条款（2012版），附加24小时意外险特别扩展条款（B） 附加第三者责任险条款 。";
		}else if("GZZRX-CA-DQ-1".equals(dto.getProduct_code())){
			Clauses = "*本保单的员工投保年龄限为16-65周岁；\n" +
					"*每次事故责任限额为300万，工作期间每人意外身故、伤残限额为30万，工作期间每人意外医疗费用限额为3万，每人生活意外身故、伤残限额为10万，每人生活意外医疗费用限额为1万，法律费用限额为30万；突发急性病身故限额为20万。本保单附加第三者责任险，每年事故累计限额为50万，每次财产损失赔偿限额为25万，每次人身伤亡、医疗、误工赔偿限额为25万，其中每次意外身故、伤残限额为25万，医疗费用限额为2.5万，误工赔偿限额为0.9万元。\n" +
					"*意外医疗每人每次事故绝对免赔额为 100 元，医保范围内损失 100%赔付；\n" +
					"*住院津贴无免赔，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计赔付 180 天；\n" +
					"*误工费免赔 5 天，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计最高赔付 180 天；\n" +
					"*第三者责任险每次事故绝对免赔额：每次事故免赔1000元或损失金额的10%，两者以高者为准。\n" +
					"*被保险人雇员因受伤需要评定伤残的，本保单伤残评定标准同时认可2017年1月1日正式实施的《人体损伤致残程度分级》评定结果，并按照以下比例计算伤残赔偿金：\n" +
					"人体损伤致残程度分级赔偿限额比例：一级（赔偿限额比例100%）、二级（赔偿限额比例80%）、三级（赔偿限额比例70%）、四级（赔偿限额比例60%）、五级（赔偿限额比例50%）、六级（赔偿限额比例40%）、七级（赔偿限额比例30%）、八级（赔偿限额比例20%）、九级（赔偿限额比例10%）、十级（赔偿限额比例5%）。\n" +
					"*附加24小时意外险特别扩展条款(B)，承保时间范围扩展至保险期间内全天 24 小时，而不论是否在工作期间。被保险人之雇员在此期间因意外事故而导致的死亡赔偿金、伤残赔偿金(或自伤残发生之日起在 180 日内发生死亡)以及因此而引起的意外医药费用（含社保范围内用药），保险人承担赔偿责任，但以所列明的限额为限。\n" +
					"*突发急性病身故责任：在本合同保险期间内，被保险人雇员因突发急性病，并自发作之日起 48 小时内因该急性病导致身故的，依法应由被保险人承担的急性病身故责任。\n" +
					"*本保单未尽事宜详见长安责任保险股份有限公司雇主责任保险条款（2012版），附加24小时意外险特别扩展条款（B） 附加第三者责任险条款 。";
		}else if("GZZRX-CA-DQ-2".equals(dto.getProduct_code())){
			Clauses = "*本保单的员工投保年龄限为16-65周岁；\n" +
					"*每次事故责任限额为400万，工作期间每人意外身故、伤残限额为40万，工作期间每人意外医疗费用限额为4万，每人生活意外身故、伤残限额为12万，每人生活意外医疗费用限额为1.2万，法律费用限额为40万；突发急性病身故限额为20万。本保单附加第三者责任险，每年事故累计限额为70万，每次财产损失赔偿限额为35万，每次人身伤亡、医疗、误工赔偿限额为35万，其中每次意外身故、伤残限额为35万，医疗费用限额为3.5万，误工赔偿限额为0.9万元。\n" +
					"*意外医疗每人每次事故绝对免赔额为 100 元，医保范围内损失 100%赔付；\n" +
					"*住院津贴无免赔，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计赔付 180 天；\n" +
					"*误工费免赔 5 天，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计最高赔付 180 天；\n" +
					"*第三者责任险每次事故绝对免赔额：每次事故免赔1000元或损失金额的10%，两者以高者为准。\n" +
					"*被保险人雇员因受伤需要评定伤残的，本保单伤残评定标准同时认可2017年1月1日正式实施的《人体损伤致残程度分级》评定结果，并按照以下比例计算伤残赔偿金：\n" +
					"人体损伤致残程度分级赔偿限额比例：一级（赔偿限额比例100%）、二级（赔偿限额比例80%）、三级（赔偿限额比例70%）、四级（赔偿限额比例60%）、五级（赔偿限额比例50%）、六级（赔偿限额比例40%）、七级（赔偿限额比例30%）、八级（赔偿限额比例20%）、九级（赔偿限额比例10%）、十级（赔偿限额比例5%）。\n" +
					"*附加24小时意外险特别扩展条款(B)，承保时间范围扩展至保险期间内全天 24 小时，而不论是否在工作期间。被保险人之雇员在此期间因意外事故而导致的死亡赔偿金、伤残赔偿金(或自伤残发生之日起在 180 日内发生死亡)以及因此而引起的意外医药费用（含社保范围内用药），保险人承担赔偿责任，但以所列明的限额为限。\n" +
					"*突发急性病身故责任：在本合同保险期间内，被保险人雇员因突发急性病，并自发作之日起 48 小时内因该急性病导致身故的，依法应由被保险人承担的急性病身故责任。\t\t\t\t\t\t\n" +
					"*本保单未尽事宜详见长安责任保险股份有限公司雇主责任保险条款（2012版），附加24小时意外险特别扩展条款（B） 附加第三者责任险条款 。";
		}else if("GZZRX-CA-DQ-3".equals(dto.getProduct_code())){
			Clauses = "*本保单的员工投保年龄限为16-65周岁；\n" +
					"*每次事故责任限额为500万，工作期间每人意外身故、伤残限额为50万，工作期间每人意外医疗费用限额为5万，每人生活意外身故、伤残限额为15万，每人生活意外医疗费用限额为1.5万，法律费用限额为50万；突发急性病身故限额为20万。本保单附加第三者责任险，每年事故累计限额为80万，每次财产损失赔偿限额为40万，每次人身伤亡、医疗、误工赔偿限额为40万，其中每次意外身故、伤残限额为40万，医疗费用限额为4万，误工赔偿限额为0.9万元。\n" +
					"*意外医疗每人每次事故绝对免赔额为 100 元，医保范围内损失 100%赔付；\n" +
					"*住院津贴无免赔，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计赔付 180 天；\n" +
					"*误工费免赔 5 天，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计最高赔付 180 天；\n" +
					"*第三者责任险每次事故绝对免赔额：每次事故免赔1000元或损失金额的10%，两者以高者为准。\n" +
					"*被保险人雇员因受伤需要评定伤残的，本保单伤残评定标准同时认可2017年1月1日正式实施的《人体损伤致残程度分级》评定结果，并按照以下比例计算伤残赔偿金：\n" +
					"人体损伤致残程度分级赔偿限额比例：一级（赔偿限额比例100%）、二级（赔偿限额比例80%）、三级（赔偿限额比例70%）、四级（赔偿限额比例60%）、五级（赔偿限额比例50%）、六级（赔偿限额比例40%）、七级（赔偿限额比例30%）、八级（赔偿限额比例20%）、九级（赔偿限额比例10%）、十级（赔偿限额比例5%）。\n" +
					"*附加24小时意外险特别扩展条款(B)，承保时间范围扩展至保险期间内全天 24 小时，而不论是否在工作期间。被保险人之雇员在此期间因意外事故而导致的死亡赔偿金、伤残赔偿金(或自伤残发生之日起在 180 日内发生死亡)以及因此而引起的意外医药费用（含社保范围内用药），保险人承担赔偿责任，但以所列明的限额为限。\n" +
					"*突发急性病身故责任：在本合同保险期间内，被保险人雇员因突发急性病，并自发作之日起 48 小时内因该急性病导致身故的，依法应由被保险人承担的急性病身故责任。\t\t\t\t\t\t\n" +
					"*本保单未尽事宜详见长安责任保险股份有限公司雇主责任保险条款（2012版），附加24小时意外险特别扩展条款（B） 附加第三者责任险条款 。";
		}else if("GZZRX-CA-DQ-4".equals(dto.getProduct_code())){
			Clauses = "*本保单的员工投保年龄限为16-65周岁；\n" +
					"*每次事故责任限额为600万，工作期间每人意外身故、伤残限额为60万，工作期间每人意外医疗费用限额为6万，每人生活意外身故、伤残限额为18万，每人生活意外医疗费用限额为1.8万，法律费用限额为60万；突发急性病身故限额为20万。本保单附加第三者责任险，每年事故累计限额为100万，每次财产损失赔偿限额为50万，每次人身伤亡、医疗、误工赔偿限额为50万，其中每次意外身故、伤残限额为50万，医疗费用限额为5万，误工赔偿限额为0.9万元。\n" +
					"*意外医疗每人每次事故绝对免赔额为 100 元，医保范围内损失 100%赔付；\n" +
					"*住院津贴无免赔，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计赔付 180 天；\n" +
					"*误工费免赔 5 天，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计最高赔付 180 天；\n" +
					"*第三者责任险每次事故绝对免赔额：每次事故免赔1000元或损失金额的10%，两者以高者为准。\n" +
					"*被保险人雇员因受伤需要评定伤残的，本保单伤残评定标准同时认可2017年1月1日正式实施的《人体损伤致残程度分级》评定结果，并按照以下比例计算伤残赔偿金：\n" +
					"人体损伤致残程度分级赔偿限额比例：一级（赔偿限额比例100%）、二级（赔偿限额比例80%）、三级（赔偿限额比例70%）、四级（赔偿限额比例60%）、五级（赔偿限额比例50%）、六级（赔偿限额比例40%）、七级（赔偿限额比例30%）、八级（赔偿限额比例20%）、九级（赔偿限额比例10%）、十级（赔偿限额比例5%）。\n" +
					"*附加24小时意外险特别扩展条款(B)，承保时间范围扩展至保险期间内全天 24 小时，而不论是否在工作期间。被保险人之雇员在此期间因意外事故而导致的死亡赔偿金、伤残赔偿金(或自伤残发生之日起在 180 日内发生死亡)以及因此而引起的意外医药费用（含社保范围内用药），保险人承担赔偿责任，但以所列明的限额为限。\n" +
					"*突发急性病身故责任：在本合同保险期间内，被保险人雇员因突发急性病，并自发作之日起 48 小时内因该急性病导致身故的，依法应由被保险人承担的急性病身故责任。\n" +
					"*本保单未尽事宜详见长安责任保险股份有限公司雇主责任保险条款（2012版），附加24小时意外险特别扩展条款（B） 附加第三者责任险条款 。";
		}else if("GZZRX-CA-DQ-5".equals(dto.getProduct_code())){
			Clauses = "*本保单的员工投保年龄限为16-65周岁；\n" +
					"*每次事故责任限额为700万，工作期间每人意外身故、伤残限额为70万，工作期间每人意外医疗费用限额为7万，每人生活意外身故、伤残限额为21万，每人生活意外医疗费用限额为2.1万，法律费用限额为70万；突发急性病身故限额为20万。本保单附加第三者责任险，每年事故累计限额为200万，每次财产损失赔偿限额为100万，每次人身伤亡、医疗、误工赔偿限额为100万，其中每次意外身故、伤残限额为100万，医疗费用限额为10万，误工赔偿限额为0.9万元。\t\t\t\n" +
					"*意外医疗每人每次事故绝对免赔额为 100 元，医保范围内损失 100%赔付；\n" +
					"*住院津贴无免赔，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计赔付 180 天；\n" +
					"*误工费免赔 5 天，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计最高赔付 180 天；\n" +
					"*第三者责任险每次事故绝对免赔额：每次事故免赔1000元或损失金额的10%，两者以高者为准。\n" +
					"*被保险人雇员因受伤需要评定伤残的，本保单伤残评定标准同时认可2017年1月1日正式实施的《人体损伤致残程度分级》评定结果，并按照以下比例计算伤残赔偿金：\n" +
					"人体损伤致残程度分级赔偿限额比例：一级（赔偿限额比例100%）、二级（赔偿限额比例80%）、三级（赔偿限额比例70%）、四级（赔偿限额比例60%）、五级（赔偿限额比例50%）、六级（赔偿限额比例40%）、七级（赔偿限额比例30%）、八级（赔偿限额比例20%）、九级（赔偿限额比例10%）、十级（赔偿限额比例5%）。\n" +
					"*附加24小时意外险特别扩展条款(B)，承保时间范围扩展至保险期间内全天 24 小时，而不论是否在工作期间。被保险人之雇员在此期间因意外事故而导致的死亡赔偿金、伤残赔偿金(或自伤残发生之日起在 180 日内发生死亡)以及因此而引起的意外医药费用（含社保范围内用药），保险人承担赔偿责任，但以所列明的限额为限。\n" +
					"*突发急性病身故责任：在本合同保险期间内，被保险人雇员因突发急性病，并自发作之日起 48 小时内因该急性病导致身故的，依法应由被保险人承担的急性病身故责任。\t\t\t\t\t\t\n" +
					"*本保单未尽事宜详见长安责任保险股份有限公司雇主责任保险条款（2012版），附加24小时意外险特别扩展条款（B） 附加第三者责任险条款 。";
		}else if("GZZRX-CA-DQ-6".equals(dto.getProduct_code())){
			Clauses = "*本保单的员工投保年龄限为16-65周岁；\n" +
					"*每次事故责任限额为800万，工作期间每人意外身故、伤残限额为80万，工作期间每人意外医疗费用限额为8万，每人生活意外身故、伤残限额为24万，每人生活意外医疗费用限额为2.4万，法律费用限额为80万；突发急性病身故限额为20万。本保单附加第三者责任险，每年事故累计限额为300万，每次财产损失赔偿限额为150万，每次人身伤亡、医疗、误工赔偿限额为150万，其中每次意外身故、伤残限额为150万，医疗费用限额为15万，误工赔偿限额为0.9万元。\n" +
					"*意外医疗每人每次事故绝对免赔额为 100 元，医保范围内损失 100%赔付；\n" +
					"*住院津贴无免赔，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计赔付 180 天；\n" +
					"*误工费免赔 5 天，赔偿标准为 100 元/天，每次事故最高赔付 90 天，每人累计最高赔付 180 天；\n" +
					"*第三者责任险每次事故绝对免赔额：每次事故免赔1000元或损失金额的10%，两者以高者为准。\n" +
					"*被保险人雇员因受伤需要评定伤残的，本保单伤残评定标准同时认可2017年1月1日正式实施的《人体损伤致残程度分级》评定结果，并按照以下比例计算伤残赔偿金：\n" +
					"人体损伤致残程度分级赔偿限额比例：一级（赔偿限额比例100%）、二级（赔偿限额比例80%）、三级（赔偿限额比例70%）、四级（赔偿限额比例60%）、五级（赔偿限额比例50%）、六级（赔偿限额比例40%）、七级（赔偿限额比例30%）、八级（赔偿限额比例20%）、九级（赔偿限额比例10%）、十级（赔偿限额比例5%）。\n" +
					"*附加24小时意外险特别扩展条款(B)，承保时间范围扩展至保险期间内全天 24 小时，而不论是否在工作期间。被保险人之雇员在此期间因意外事故而导致的死亡赔偿金、伤残赔偿金(或自伤残发生之日起在 180 日内发生死亡)以及因此而引起的意外医药费用（含社保范围内用药），保险人承担赔偿责任，但以所列明的限额为限。\n" +
					"*突发急性病身故责任：在本合同保险期间内，被保险人雇员因突发急性病，并自发作之日起 48 小时内因该急性病导致身故的，依法应由被保险人承担的急性病身故责任。\t\t\t\t\t\t\n" +
					"*本保单未尽事宜详见长安责任保险股份有限公司雇主责任保险条款（2012版），附加24小时意外险特别扩展条款（B） 附加第三者责任险条款 。";
		}
		PrpTengageDto(PrpTengageList,"1","1","T0001","T-通用约定01","0");
		PrpTengageDto(PrpTengageList,"1","1","T0001",Clauses,"1");
	}

	private static void PrpTengageDto(Element PrpTengageList
			, String SerialNo
			, String LineNo
			, String ClauseCode
			, String Clauses
			, String TitleFlag) {
		Element underwrite = PrpTengageList.addElement("PrpTengageDto");
		underwrite.addElement("SerialNo").setText(SerialNo);//
		underwrite.addElement("LineNo").setText(LineNo);//行序号
		underwrite.addElement("ClauseCode").setText(ClauseCode);//条款编码
		underwrite.addElement("Clauses").setText(Clauses);//条款文字描述
		underwrite.addElement("TitleFlag").setText(TitleFlag);//标题标志 0：标题；1：内容
	}

	//标的信息
	private static void PrpTSubjectList(Element PrpTSubjectList, OrderFormVo dto, SpecialHirelingVo gvo) {
		List<HirelingVo> hirelingList = gvo.getHirelingVoList();
		for(HirelingVo vo : hirelingList) {
			Element underwrite = PrpTSubjectList.addElement("PrpTSubjectDto");
			underwrite.addElement("SubjectName").setText(vo.getName());//
			underwrite.addElement("SubjectExt2").setText(vo.getSex());//性别（代码）1:男；2:女；9:未说明
			int age = 0;
			try {
				age = DateUtil.getAge(vo.getBirth_date());
			} catch (Exception e) {
				e.printStackTrace();
			}
			underwrite.addElement("SubjectExt3").setText(String.valueOf(age));//年龄
			underwrite.addElement("SubjectExt4").setText("0");//身体情况（0:好;1:优良;2:一般;3:差）
			CraftType ct = CraftType.getByCareer(vo.getCareer());
			underwrite.addElement("SubjectExt5").setText(ct.getCode4());//工种
			underwrite.addElement("SubjectExt6").setText(vo.getId_card().toUpperCase());//身份证号码
			underwrite.addElement("SubjectExt9").setText("3500");//月工资金额
			underwrite.addElement("SubjectExt10").setText(dto.getPremium());//每人保费
			underwrite.addElement("SubjectExt11").setText("1");//人员类别
			//起止保时间
			underwrite.addElement("SubjectExt12").setText(dto.getInception_date()+" 00:00:00");//
			underwrite.addElement("SubjectExt13").setText(dto.getPlanned_end_date()+" 24:00:00");//
			underwrite.addElement("SubjectExt14").setText(ct.getName());//工种名称
			underwrite.addElement("SubjectExt15").setText("1");//保障组别，对应险别条款里的保障组别
			underwrite.addElement("SubjectExt16").setText(changeCTypePer(vo.getId_type()));//证件类型
			underwrite.addElement("SubjectExt17").setText(vo.getBirth_date());//出生日期
			underwrite.addElement("SubjectExt18").setText("0");//高风险人员标志
			//1-4级工种类别
			underwrite.addElement("Craft1").setText(ct.getCode1());//
			underwrite.addElement("Craft2").setText(ct.getCode2());//
			underwrite.addElement("Craft3").setText(ct.getCode3());//
			underwrite.addElement("Craft4").setText(ct.getCode4());//
			underwrite.addElement("OccupationalClass").setText(ct.getLevel());//职业类别风险等级代码
		}
	}

	//营业处所地址信息
	private static void PrpTaddressDto(Element underwrite, OrderFormVo dto, SpecialHirelingVo vo) {
		RoleSubjectVo appli = vo.getRoleSubjectList().get(1);
		String appliAddress = RegionUtils.getRegionNameByALLCode(appli.getReg_province(),appli.getReg_city(),appli.getReg_district())+appli.getReg_address();
		underwrite.addElement("Province").setText(appli.getReg_province());
		underwrite.addElement("City").setText(zxCity(appli.getReg_city(),appli.getReg_district()));
		underwrite.addElement("County").setText(zxCounty(appli.getReg_district()));
		underwrite.addElement("AddressName").setText(appliAddress);//地址
		underwrite.addElement("AddressCode").setText(getZipCode(appli.getReg_city()));//邮政编码
		underwrite.addElement("AddressNo").setText("1");//地址序号
	}

	//根据城市代码获取邮编
	public static String getZipCode(String cityCode){
		YB_City yc = YB_City.fromYBCity(cityCode);
		String result = "";
		if(yc != null){
			result = String.valueOf(yc).split("_")[1];
		}
		return result;
	}

	//险别信息
	private static void PrpTitemKindList(Element PrpTitemKindList,SpecialHirelingVo vo, OrderFormVo dto, String perNum) {
		if("GZZRX-CA-1".equals(dto.getProduct_code())){
			PrpTitemKindDto(PrpTitemKindList,dto,"1","1516102","雇主责任险2012版主险","0001","死亡/伤残费用","300000","","300000","Y","58.50",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"2","1516102","雇主责任险2012版主险","0002","医疗费用","30000","","30000","N","13.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"3","1516102","雇主责任险2012版主险","0004","误工费","18000","","18000","N","13.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"4","1516402","附加24小时意外险特别扩展条款（B）","","死亡/伤残费用","100000","","100000","N","32.50",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"5","1516402","附加24小时意外险特别扩展条款（B）","","医疗费用","10000","","10000","N","13.00",perNum);
		}else if("GZZRX-CA-2".equals(dto.getProduct_code())){
			PrpTitemKindDto(PrpTitemKindList,dto,"1","1516102","雇主责任险2012版主险","0001","死亡/伤残费用","400000","","400000","Y","72.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"2","1516102","雇主责任险2012版主险","0002","医疗费用","40000","","40000","N","16.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"3","1516102","雇主责任险2012版主险","0004","误工费","18000","","18000","N","16.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"4","1516402","附加24小时意外险特别扩展条款（B）","","死亡/伤残费用","120000","","120000","N","40.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"5","1516402","附加24小时意外险特别扩展条款（B）","","医疗费用","12000","","12000","N","16.00",perNum);
		}else if("GZZRX-CA-3".equals(dto.getProduct_code())){
			PrpTitemKindDto(PrpTitemKindList,dto,"1","1516102","雇主责任险2012版主险","0001","死亡/伤残费用","500000","","500000","Y","90.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"2","1516102","雇主责任险2012版主险","0002","医疗费用","50000","","50000","N","20.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"3","1516102","雇主责任险2012版主险","0004","误工费","18000","","18000","N","20.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"4","1516402","附加24小时意外险特别扩展条款（B）","","死亡/伤残费用","150000","","150000","N","50.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"5","1516402","附加24小时意外险特别扩展条款（B）","","医疗费用","15000","","15000","N","20.00",perNum);
		}else if("GZZRX-CA-4".equals(dto.getProduct_code())){
			PrpTitemKindDto(PrpTitemKindList,dto,"1","1516102","雇主责任险2012版主险","0001","死亡/伤残费用","600000","","600000","Y","103.50",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"2","1516102","雇主责任险2012版主险","0002","医疗费用","60000","","60000","N","23.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"3","1516102","雇主责任险2012版主险","0004","误工费","18000","","18000","N","23.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"4","1516402","附加24小时意外险特别扩展条款（B）","","死亡/伤残费用","180000","","180000","N","57.50",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"5","1516402","附加24小时意外险特别扩展条款（B）","","医疗费用","18000","","18000","N","23.00",perNum);
		}else if("GZZRX-CA-5".equals(dto.getProduct_code())){
			PrpTitemKindDto(PrpTitemKindList,dto,"1","1516102","雇主责任险2012版主险","0001","死亡/伤残费用","700000","","700000","Y","126.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"2","1516102","雇主责任险2012版主险","0002","医疗费用","70000","","70000","N","28.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"3","1516102","雇主责任险2012版主险","0004","误工费","18000","","18000","N","28.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"4","1516402","附加24小时意外险特别扩展条款（B）","","死亡/伤残费用","210000","","210000","N","70.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"5","1516402","附加24小时意外险特别扩展条款（B）","","医疗费用","21000","","21000","N","28.00",perNum);
		}else if("GZZRX-CA-6".equals(dto.getProduct_code())){
			PrpTitemKindDto(PrpTitemKindList,dto,"1","1516102","雇主责任险2012版主险","0001","死亡/伤残费用","800000","","800000","Y","148.50",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"2","1516102","雇主责任险2012版主险","0002","医疗费用","80000","","80000","N","33.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"3","1516102","雇主责任险2012版主险","0004","误工费","18000","","18000","N","33.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"4","1516402","附加24小时意外险特别扩展条款（B）","","死亡/伤残费用","240000","","240000","N","82.50",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"5","1516402","附加24小时意外险特别扩展条款（B）","","医疗费用","24000","","24000","N","33.00",perNum);
		}else if("GZZRX-CA-DQ-1".equals(dto.getProduct_code())){
			PrpTitemKindDto(PrpTitemKindList,dto,"1","1516102","雇主责任险2012版主险","0001","死亡/伤残费用","300000","","300000","Y","2.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"2","1516102","雇主责任险2012版主险","0002","医疗费用","30000","","30000","N","2.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"3","1516102","雇主责任险2012版主险","0004","误工费","18000","","18000","N","2.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"4","1516402","附加24小时意外险特别扩展条款（B）","","死亡/伤残费用","100000","","100000","N","1.50",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"5","1516402","附加24小时意外险特别扩展条款（B）","","医疗费用","10000","","10000","N","2.50",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"6","1505000","附加第三者责任保险条款","","","0","0","0","N","2.00",perNum);
		}else if("GZZRX-CA-DQ-2".equals(dto.getProduct_code())){
			PrpTitemKindDto(PrpTitemKindList,dto,"1","1516102","雇主责任险2012版主险","0001","死亡/伤残费用","400000","","400000","Y","2.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"2","1516102","雇主责任险2012版主险","0002","医疗费用","40000","","40000","N","3.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"3","1516102","雇主责任险2012版主险","0004","误工费","18000","","18000","N","2.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"4","1516402","附加24小时意外险特别扩展条款（B）","","死亡/伤残费用","120000","","120000","N","2.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"5","1516402","附加24小时意外险特别扩展条款（B）","","医疗费用","12000","","12000","N","2.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"6","1505000","附加第三者责任保险条款","","","0","0","0","N","3.00",perNum);
		}else if("GZZRX-CA-DQ-3".equals(dto.getProduct_code())){
			PrpTitemKindDto(PrpTitemKindList,dto,"1","1516102","雇主责任险2012版主险","0001","死亡/伤残费用","500000","","500000","Y","3.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"2","1516102","雇主责任险2012版主险","0002","医疗费用","50000","","50000","N","3.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"3","1516102","雇主责任险2012版主险","0004","误工费","18000","","18000","N","3.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"4","1516402","附加24小时意外险特别扩展条款（B）","","死亡/伤残费用","150000","","150000","N","2.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"5","1516402","附加24小时意外险特别扩展条款（B）","","医疗费用","15000","","15000","N","3.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"6","1505000","附加第三者责任保险条款","","","0","0","0","N","3.00",perNum);
		}else if("GZZRX-CA-DQ-4".equals(dto.getProduct_code())){
			PrpTitemKindDto(PrpTitemKindList,dto,"1","1516102","雇主责任险2012版主险","0001","死亡/伤残费用","600000","","600000","Y","3.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"2","1516102","雇主责任险2012版主险","0002","医疗费用","60000","","60000","N","4.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"3","1516102","雇主责任险2012版主险","0004","误工费","18000","","18000","N","3.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"4","1516402","附加24小时意外险特别扩展条款（B）","","死亡/伤残费用","180000","","180000","N","3.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"5","1516402","附加24小时意外险特别扩展条款（B）","","医疗费用","18000","","18000","N","3.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"6","1505000","附加第三者责任保险条款","","","0","0","0","N","4.00",perNum);
		}else if("GZZRX-CA-DQ-5".equals(dto.getProduct_code())){
			PrpTitemKindDto(PrpTitemKindList,dto,"1","1516102","雇主责任险2012版主险","0001","死亡/伤残费用","700000","","700000","Y","4.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"2","1516102","雇主责任险2012版主险","0002","医疗费用","70000","","70000","N","4.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"3","1516102","雇主责任险2012版主险","0004","误工费","18000","","18000","N","4.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"4","1516402","附加24小时意外险特别扩展条款（B）","","死亡/伤残费用","210000","","210000","N","4.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"5","1516402","附加24小时意外险特别扩展条款（B）","","医疗费用","21000","","21000","N","4.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"6","1505000","附加第三者责任保险条款","","","0","0","0","N","4.00",perNum);
		}else if("GZZRX-CA-DQ-6".equals(dto.getProduct_code())){
			PrpTitemKindDto(PrpTitemKindList,dto,"1","1516102","雇主责任险2012版主险","0001","死亡/伤残费用","800000","","800000","Y","4.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"2","1516102","雇主责任险2012版主险","0002","医疗费用","80000","","80000","N","5.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"3","1516102","雇主责任险2012版主险","0004","误工费","18000","","18000","N","5.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"4","1516402","附加24小时意外险特别扩展条款（B）","","死亡/伤残费用","240000","","240000","N","4.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"5","1516402","附加24小时意外险特别扩展条款（B）","","医疗费用","24000","","24000","N","5.00",perNum);
			PrpTitemKindDto(PrpTitemKindList,dto,"6","1505000","附加第三者责任保险条款","","","0","0","0","N","5.00",perNum);
		}
		if(!dto.getProduct_code().contains("GZZRX-CA-DQ")){
			PrpTitemKindDto(PrpTitemKindList,dto,"6","1505000","附加第三者责任保险条款","","","0","0","0","N","0",perNum);
		}
	}

	private static void PrpTitemKindDto(Element PrpTitemKindList, OrderFormVo dto
			,String ItemKindNo
			,String KindCode
			,String KindName
			,String ItemCode
			,String ItemDetailName
			,String UnitAmount
			,String Value
			,String Amount
			,String CalculateFlag
			,String Premium
			,String perNum) {
		Element underwrite = PrpTitemKindList.addElement("PrpTitemKindDto");
		underwrite.addElement("ItemKindNo").setText(ItemKindNo);//
		underwrite.addElement("KindCode").setText(KindCode);//险别代码
		underwrite.addElement("KindName").setText(KindName);//险别名称
		underwrite.addElement("StartDate").setText(dto.getInception_date());//起保日期
		underwrite.addElement("StartHour").setText("0");//
		underwrite.addElement("EndDate").setText(dto.getPlanned_end_date());//终保日期
		underwrite.addElement("EndHour").setText("24");//
		underwrite.addElement("Currency").setText("CNY");//
		underwrite.addElement("ItemNo").setText("");//标的序号
		underwrite.addElement("ItemCode").setText(ItemCode);//赔偿项目代码
		underwrite.addElement("ItemDetailName").setText(ItemDetailName);//赔偿项目名称
		underwrite.addElement("UnitAmount").setText(UnitAmount);//每人分项责任限额
		underwrite.addElement("Quantity").setText(perNum);//人数
		underwrite.addElement("Value").setText(Value);//保险价值（每次事故赔偿限额）
		Amount = String.valueOf((BigDecimal.valueOf(Double.parseDouble(Amount))).multiply(BigDecimal.valueOf(Double.parseDouble(perNum))));
		underwrite.addElement("Amount").setText(Amount);//每次事故赔偿限额
		underwrite.addElement("CalculateFlag").setText(CalculateFlag);//是否增加险别限额(Y-是 N-否)
		underwrite.addElement("Flag").setText("01");//主附险标志:1.主险;2.附加险
		underwrite.addElement("Discount").setText("1");//行业类型系数
		Premium = String.valueOf((BigDecimal.valueOf(Double.parseDouble(Premium))).multiply(BigDecimal.valueOf(Double.parseDouble(perNum))));
		underwrite.addElement("Premium").setText(Premium);//实交保费
		underwrite.addElement("Rate").setText("0");//费率/年基准保费/年费率
		underwrite.addElement("ShortRateFlag").setText("4");//短期费率方式：1.不计；2.按日;4.按月；默认为不计
		underwrite.addElement("ShortRate").setText("1.00");//短期费率
		underwrite.addElement("Deductible").setText("");//免赔额免赔率
		underwrite.addElement("DeductibleRate").setText("");//免赔率(%)
		underwrite.addElement("AdjustRate").setText("1");//调整系数
		underwrite.addElement("PrpTitemKindExt1").setText("c_1");//保费计算方式c_1:按固定赔偿限额计费;c_2:按工资收入计费
		underwrite.addElement("PrpTitemKindExt2").setText("1");//保障组别（取值范围：1到10之间整数）
	}

	//被保险人信息
	private static void PrpTinsuredDto(Element underwrite, OrderFormVo dto, SpecialHirelingVo vo) {
		RoleSubjectVo insured = vo.getRoleSubjectList().get(1);
		underwrite.addElement("InsuredName").setText(insured.getName_cn());//投保人名称
		String appliAddress = RegionUtils.getRegionNameByALLCode(insured.getReg_province(),insured.getReg_city(),insured.getReg_district())+insured.getReg_address();
		underwrite.addElement("Province").setText(insured.getReg_province());
		underwrite.addElement("City").setText(zxCity(insured.getReg_city(),insured.getReg_district()));
		underwrite.addElement("County").setText(zxCounty(insured.getReg_district()));
		underwrite.addElement("InsuredAddress").setText(appliAddress);//投保人地址
		underwrite.addElement("Creditlevel").setText(ConstProp.BLANK_CHAR.equals(insured.getNature_two()) ? natureLinkageSet(insured.getCom_nature()) : natureLinkageSet(insured.getNature_two()));//单位性质
		underwrite.addElement("Language").setText("C");//
		underwrite.addElement("SerialNo").setText("1");//
		underwrite.addElement("InsuredType").setText("2");//关系人类型 1.个人/2.单位和关系人性质随动
		underwrite.addElement("InsuredNature").setText("4");//关系人性质 3.自然人/4.法人和关系人类型随动
		underwrite.addElement("InsuredFlag").setText("1");//关系人标志 1:被保险人
		underwrite.addElement("AppliIdentity").setText("99");//与投保人关系
		underwrite.addElement("IdentifyType").setText("99");//证件类型
		underwrite.addElement("EffectiveStartDate").setText(StringUtils.isEmpty(insured.getId_star_date())?"":insured.getId_star_date());//证件有效期起期
		underwrite.addElement("EffectiveEndDate").setText(StringUtils.isEmpty(insured.getId_star_date())?"":insured.getId_star_date());//证件有效期止期
		String organizationCode = insured.getOrganization_code();
		if(StringUtils.isNotEmpty(organizationCode) && ConstProp.DIGIT_ONE.equals(insured.getId_type())){
			organizationCode = organizationCode.split(ConstProp.MINUS)[0]+organizationCode.split(ConstProp.MINUS)[1];
		}
		underwrite.addElement("IdentifyNumber").setText(organizationCode);//证件号码/组织机构代码
		underwrite.addElement("Mobile").setText(insured.getLink_tel());//移动电话
		underwrite.addElement("LinkerName").setText(insured.getLink_name());//联系人姓名
		underwrite.addElement("PhoneNumber").setText(insured.getLink_tel());//联系电话
		underwrite.addElement("Email").setText(insured.getLink_email());//投保人邮箱
	}

	private static String zxCity(String value,String county) {//直辖市代码转换
		if("110100,120100,310100,500100,500200,500300".contains(value)){
			return value.substring(0,2)+"0000";
		}
		if("429005,650522,469005,469007,469022,469024,469027,469030,429006,429004,429021,659001,659002,659003,659005,659006,659007,659009,469021,650502,650521,469002,469006,469023,469029,469001,469026,469028,469025,659004,659008,659010,419001".contains(county)){
			return county;
		}
		return value;
	}

	private static String zxCounty(String value) {//直辖市代码转换
		if("4419,4420,4603,6202,4604,6505".contains(value.substring(0,4))){
			return value.substring(0,4)+"00";
		}
		return value;
	}

	private static String natureLinkageSet(String value){//单位性质
		if ( "0".equals(value) ) {
			return "100";
		} else if ("1".equals(value)) {
			return "200";
		}else if ("2".equals(value)) {
			return "130";
		}else if ("3".equals(value)) {
			return "310";
		}else if ("4".equals(value)) {
			return "300";
		}else if ("5".equals(value)) {
			return "350";
		}else if ("310".equals(value)) {
			return "310";
		}else if ("7".equals(value)) {
			return "310";
		}else if ("8".equals(value)) {
			return "310";
		}else if ("9".equals(value)) {
			return "340";
		}else if ("10".equals(value)) {
			return "320";
		}else if ("11".equals(value)) {
			return "330";
		}else if ("12".equals(value)) {
			return "350";
		}else if ("13".equals(value)) {
			return "300";
		}else if ("14".equals(value)) {
			return "300";
		}
		return "900";
	}

	//投保基本信息
	private static void PrpTmainDto(Element underwrite, OrderFormVo dto, SpecialHirelingVo vo) {
		RoleSubjectVo appli = vo.getRoleSubjectList().get(0);
		RoleSubjectVo insured = vo.getRoleSubjectList().get(1);
		underwrite.addElement("PolicySort").setText("0");//保单种类代码
		underwrite.addElement("RiskCode").setText("1516");//险种代码
		underwrite.addElement("Language").setText("C");//语种标志
		underwrite.addElement("AppliName").setText(appli.getName_cn());//投保人名称
		String appliAddress = RegionUtils.getRegionNameByALLCode(appli.getReg_province(),appli.getReg_city(),appli.getReg_district())+appli.getReg_address();
		underwrite.addElement("AppliAddress").setText(appliAddress);//投保人地址
		underwrite.addElement("InsuredName").setText(insured.getName_cn());//被保险人名称
		String insuredAddress = RegionUtils.getRegionNameByALLCode(insured.getReg_province(),insured.getReg_city(),insured.getReg_district())+insured.getReg_address();
		underwrite.addElement("InsuredAddress").setText(insuredAddress);//被保险人地址
		String od = "";
		if(StringUtils.isNotEmpty(dto.getStart_time())){
			od = dto.getStart_time().split(" ")[0];
		}
		underwrite.addElement("OperateDate").setText(od);//操作日期(YYYY-MM-DD)
		underwrite.addElement("InputDate").setText(od);//输入日期(YYYY-MM-DD)
		underwrite.addElement("SignDate").setText(od);//制单日期(YYYY-MM-DD)
		underwrite.addElement("StartDate").setText(dto.getInception_date());//起保日期
		underwrite.addElement("EndDate").setText(dto.getPlanned_end_date());//终保日期
		underwrite.addElement("StartHour").setText("0");//起保小时
		underwrite.addElement("EndHour").setText("24");//终保小时
//		String SumAmount = String.valueOf(BigDecimal.valueOf(Double.parseDouble(dto.getInsured_amount())).divide(BigDecimal.valueOf(vo.getHirelingVoList().size())).setScale(2,BigDecimal.ROUND_HALF_UP));
//		String SumPremium = String.valueOf(BigDecimal.valueOf(Double.parseDouble(dto.getGross_premium())).divide(BigDecimal.valueOf(vo.getHirelingVoList().size())).setScale(2,BigDecimal.ROUND_HALF_UP));
		underwrite.addElement("SumAmount").setText(dto.getInsured_amount());//保单总保险金额
		underwrite.addElement("SumPremium").setText(dto.getGross_premium());//保单总保险费
		underwrite.addElement("PureRate").setText("1");//净费率
		underwrite.addElement("DisRate").setText("1");//手续费比例
		underwrite.addElement("Discount").setText("0");//总折扣率
		underwrite.addElement("Currency").setText("CNY");//币别代码
		underwrite.addElement("ArgueSolution").setText("1");//争议解决方式 1-诉讼（默认）;2-仲裁
		underwrite.addElement("PayTimes").setText("1");//约定分期交费次数
		underwrite.addElement("CoinsFlag").setText("0");//联共保标志
		underwrite.addElement("PolicySortNew").setText("0");//保单类型
		underwrite.addElement("ReinsFlag").setText("0");//
		underwrite.addElement("ProgrammeCode").setText("1");//方案代码/见费标识
		underwrite.addElement("AgentCode").setText("");//代理人代码
		underwrite.addElement("AgreementNo").setText("");//代理协议代码
		underwrite.addElement("MakeCom").setText("");//出单机构
		underwrite.addElement("ComCode").setText("");//业务归属机构代码
		underwrite.addElement("OperatorCode").setText("");//操作员代码
		underwrite.addElement("HandlerCode").setText("");//经办人代码
		underwrite.addElement("HandlerName").setText("");//经办人姓名
		underwrite.addElement("Handler1Code").setText("");//归属业务员代码
		underwrite.addElement("Handler1Name").setText("");//归属业务员姓名
		underwrite.addElement("BusinessNature").setText("");//业务来源代码
		underwrite.addElement("InquiryNo").setText("1");//1516新旧页面标志
	}

	//投保对象信息
	private static void HEAD(Element underwrite, OrderFormVo dto) {
		//出单来源
		underwrite.addElement("SourceType").setText("61");
		//请求类型（康存必传）投保：T1001；变更关系人：P1001
//		underwrite.addElement("RequestType").setText("T1001");
	}

	//投保对象信息
	private static void CB_HEAD(Element underwrite, OrderFormVo dto) {
		//投单号
		underwrite.addElement("ProposalNo").setText(dto.getPolicy_serial_number());
		underwrite.addElement("SourceType").setText("61");
	}

	//
	private static void CB_BODY(Element underwrite, OrderFormVo dto, InsTransaction itran) {
		//支付流水号
		underwrite.addElement("BusinessNo").setText(itran.getPay_order_number());
		underwrite.addElement("BusinessId").setText("");
		//刷卡卡号
		underwrite.addElement("CarNo").setText("");
		//刷卡终端号
		underwrite.addElement("TerminalNo").setText("");
		//刷卡流水号
		underwrite.addElement("CardSerialNo").setText("");
		underwrite.addElement("Currency").setText("CNY");
		underwrite.addElement("CardPayFee").setText(dto.getGross_premium());
		underwrite.addElement("OperateDate").setText(DateUtil.convertDateToString(itran.getStart_time(),DateUtil.FORMAT2));
		underwrite.addElement("OperateTime").setText(DateUtil.convertDateToString(itran.getStart_time(),DateUtil.FORMAT5));
		underwrite.addElement("BusinessCount").setText("1");
		underwrite.addElement("LastOperateDate").setText(DateUtil.convertDateToString(itran.getStart_time(),DateUtil.FORMAT1));
		underwrite.addElement("RiskCode").setText("1516");
		//请求类型 01（交易包） 02（结算包）03（补登包）
		underwrite.addElement("QueryType").setText("01");
	}

	//渠道信息
	private static void PD_CHANNEL(Element underwrite, InsPreservationRecordVo vo, String ChannelTradeCode) {
		//渠道代码
		underwrite.addElement("ChannelCode").setText("000160");
		//渠道机构代码
		underwrite.addElement("ChannelComCode").setText("430000");
		//渠道产品代码
		underwrite.addElement("ChannelProductCode").setText("1516");
		//渠道交易代码
//		2101(非预缴方式)
//		2102(预缴方式)
//		2103(实时支付出单)
//		2104（确认投保接口）
//		2105(接受投保单信息，返回投保单号，异步落地投保单信息）
		underwrite.addElement("ChannelTradeCode").setText(ChannelTradeCode);
		//渠道交易流水号（一次交易标识）
		underwrite.addElement("ChannelTradeSerialNo").setText(vo.getRevise_serial_number());
		//渠道区域代码
		underwrite.addElement("ChannelAreaCode").setText("430000");
		//渠道交易日期,格式:yyyy-MM-dd HH:mm:ss
		underwrite.addElement("ChannelTradeDate").setText(vo.getStart_time());
	}

	//投保对象信息
	private static void PD_HEAD(Element underwrite, InsPreservationRecordVo vo) {
		//保单号
		underwrite.addElement("PolicyNo").setText(vo.getExternal_reference());
		//出单来源
		underwrite.addElement("SourceType").setText("61");
		//请求类型（E01：替换雇员信息；E02：修改雇员信息）
//		underwrite.addElement("RequestType").setText("3".equals(vo.getRevise_type())?"E01":"E02");
	}

	//投保对象信息
	private static void PDJG_HEAD(Element underwrite, InsPreservationRecordVo vo) {
		//批单号
		underwrite.addElement("EndorseNo").setText(vo.getRevise_serial_num_ins());
		//险种代码
		underwrite.addElement("RiskCode").setText("");
	}

	//缴费计划信息
	private static void PrpCplanDto(Element underwrite, OrderFormVo dto, InsPreservationRecordVo vo) {
		underwrite.addElement("SerialNo").setText(String.valueOf(vo.getSerialNo()+1));//批改次数+1
		underwrite.addElement("PayNo").setText("1");//交费期次
		underwrite.addElement("PayReason").setText("R30");//交费原因
		underwrite.addElement("PlanDate").setText(vo.getInception_date());//计划交费截止日期 批单生效日期
		underwrite.addElement("Currency").setText("CNY");//币别
		underwrite.addElement("PlanFee").setText(vo.getTotal_premium());//应交费金额
		underwrite.addElement("DelinquentFee").setText(vo.getTotal_premium());//拖欠金额
		underwrite.addElement("PlanStartDate").setText(vo.getInception_date());//计划开始日期(YYYY-MM-DD) 批单生效日期
	}
	//收款人信息
	private static void PrpCRecieverDto(Element underwrite, OrderFormVo dto, InsPreservationRecordVo vo, SpecialHirelingVo svo) {
		RoleSubjectVo appli = svo.getRoleSubjectList().get(0);
		underwrite.addElement("RecieverID").setText("");//收款人基础ID
		underwrite.addElement("CustomerName").setText(appli.getName_cn());//收款人名称
		underwrite.addElement("IdentifyType").setText("99");//证件类型
		underwrite.addElement("IdentifyNumber").setText(appli.getOrganization_code());//证件号码
		underwrite.addElement("CustomerNature").setText("");//收款人类型
		underwrite.addElement("BankCName").setText(appli.getBank_name());//开户行名称
		underwrite.addElement("CustomerType").setText("");//客户类型
		underwrite.addElement("BankCode").setText("");//开户行联行号
		underwrite.addElement("BankArea").setText("");//开户行地区
		underwrite.addElement("AccountName").setText(appli.getAccount_name());//账户名称
		underwrite.addElement("Account").setText(appli.getBank_account());//银行账号
		underwrite.addElement("BankType").setText("");//银行类别
		underwrite.addElement("CardType").setText("");//卡折类型
		underwrite.addElement("SelectMode").setText("");//结算方式
		underwrite.addElement("EnturstFlag").setText("");//委托收款标志
		underwrite.addElement("OperatorCode").setText("");//操作人
		underwrite.addElement("ModifierCode").setText("");//修改人
		underwrite.addElement("CreateDate").setText(vo.getStart_time());//创建时间
		underwrite.addElement("LastModifyDate").setText(vo.getStart_time());//最后修改时间
		underwrite.addElement("ValidStatus").setText("");//有效标志；0为有效，1为无效
		underwrite.addElement("Tcol3").setText(appli.getLink_tel());//电话
		underwrite.addElement("Remark").setText("");//备注
		underwrite.addElement("BankAreaName").setText("");//开户行地区名称
		underwrite.addElement("BankTypeName").setText("");//银行类别名称
		underwrite.addElement("Currency").setText("CNY");//币种

	}

	//限额免赔信息
	private static void PrpCLimitList(Element PrpCLimitList, OrderFormVo dto, String perNum) {
		if("GZZRX-CA-1".equals(dto.getProduct_code())){
			String amo_1="300000",amo_2="300000",amo_3="30000",amo_4="18000",amo_5="100000",amo_6="100000",amo_7="10000",amo_8="10000";
			setLimit(PrpCLimitList, perNum, amo_1, amo_2, amo_3, amo_4, amo_5, amo_6, amo_7, amo_8);
		}else if("GZZRX-CA-2".equals(dto.getProduct_code())){
			String   amo_1="400000",amo_2="400000",amo_3="40000",amo_4="18000",amo_5="120000",amo_6="120000",amo_7="12000",amo_8="12000";
			setLimit(PrpCLimitList, perNum, amo_1, amo_2, amo_3, amo_4, amo_5, amo_6, amo_7, amo_8);
		}else if("GZZRX-CA-3".equals(dto.getProduct_code())){
			String   amo_1="500000",amo_2="500000",amo_3="50000",amo_4="18000",amo_5="150000",amo_6="150000",amo_7="15000",amo_8="15000";
			setLimit(PrpCLimitList, perNum, amo_1, amo_2, amo_3, amo_4, amo_5, amo_6, amo_7, amo_8);
		}else if("GZZRX-CA-4".equals(dto.getProduct_code())){
			String   amo_1="600000",amo_2="600000",amo_3="60000",amo_4="18000",amo_5="180000",amo_6="180000",amo_7="18000",amo_8="18000";
			setLimit(PrpCLimitList, perNum, amo_1, amo_2, amo_3, amo_4, amo_5, amo_6, amo_7, amo_8);
		}else if("GZZRX-CA-5".equals(dto.getProduct_code())){
			String   amo_1="700000",amo_2="700000",amo_3="70000",amo_4="18000",amo_5="210000",amo_6="210000",amo_7="21000",amo_8="21000";
			setLimit(PrpCLimitList, perNum, amo_1, amo_2, amo_3, amo_4, amo_5, amo_6, amo_7, amo_8);
		}else if("GZZRX-CA-6".equals(dto.getProduct_code())){
			String   amo_1="800000",amo_2="800000",amo_3="80000",amo_4="18000",amo_5="240000",amo_6="240000",amo_7="24000",amo_8="24000";
			setLimit(PrpCLimitList, perNum, amo_1, amo_2, amo_3, amo_4, amo_5, amo_6, amo_7, amo_8);
		}else if("GZZRX-CA-DQ-1".equals(dto.getProduct_code())){
			String amo_1="300000",amo_2="300000",amo_3="30000",amo_4="18000",amo_5="100000",amo_6="100000",amo_7="10000",amo_8="10000";
			setLimit(PrpCLimitList, perNum, amo_1, amo_2, amo_3, amo_4, amo_5, amo_6, amo_7, amo_8);
		}else if("GZZRX-CA-DQ-2".equals(dto.getProduct_code())){
			String   amo_1="400000",amo_2="400000",amo_3="40000",amo_4="18000",amo_5="120000",amo_6="120000",amo_7="12000",amo_8="12000";
			setLimit(PrpCLimitList, perNum, amo_1, amo_2, amo_3, amo_4, amo_5, amo_6, amo_7, amo_8);
		}else if("GZZRX-CA-DQ-3".equals(dto.getProduct_code())){
			String   amo_1="500000",amo_2="500000",amo_3="50000",amo_4="18000",amo_5="150000",amo_6="150000",amo_7="15000",amo_8="15000";
			setLimit(PrpCLimitList, perNum, amo_1, amo_2, amo_3, amo_4, amo_5, amo_6, amo_7, amo_8);
		}else if("GZZRX-CA-DQ-4".equals(dto.getProduct_code())){
			String   amo_1="600000",amo_2="600000",amo_3="60000",amo_4="18000",amo_5="180000",amo_6="180000",amo_7="18000",amo_8="18000";
			setLimit(PrpCLimitList, perNum, amo_1, amo_2, amo_3, amo_4, amo_5, amo_6, amo_7, amo_8);
		}else if("GZZRX-CA-DQ-5".equals(dto.getProduct_code())){
			String   amo_1="700000",amo_2="700000",amo_3="70000",amo_4="18000",amo_5="210000",amo_6="210000",amo_7="21000",amo_8="21000";
			setLimit(PrpCLimitList, perNum, amo_1, amo_2, amo_3, amo_4, amo_5, amo_6, amo_7, amo_8);
		}else if("GZZRX-CA-DQ-6".equals(dto.getProduct_code())){
			String   amo_1="800000",amo_2="800000",amo_3="80000",amo_4="18000",amo_5="240000",amo_6="240000",amo_7="24000",amo_8="24000";
			setLimit(PrpCLimitList, perNum, amo_1, amo_2, amo_3, amo_4, amo_5, amo_6, amo_7, amo_8);
		}
	}

	private static void setLimit(Element prpCLimitList, String perNum, String amo_1, String amo_2, String amo_3, String amo_4, String amo_5, String amo_6, String amo_7, String amo_8) {
		String _32 = BigDecimal.valueOf(Double.parseDouble(amo_1)).multiply(BigDecimal.valueOf(Double.parseDouble(perNum))).toString();
		String _03_1 = BigDecimal.valueOf(Double.parseDouble(amo_2)).multiply(BigDecimal.valueOf(Double.parseDouble(perNum))).toString();
		String _03_2 = BigDecimal.valueOf(Double.parseDouble(amo_3)).multiply(BigDecimal.valueOf(Double.parseDouble(perNum))).toString();
		String _03_3 = BigDecimal.valueOf(Double.parseDouble(amo_4)).multiply(BigDecimal.valueOf(Double.parseDouble(perNum))).toString();
		String _03_4 = BigDecimal.valueOf(Double.parseDouble(amo_5)).multiply(BigDecimal.valueOf(Double.parseDouble(perNum))).toString();
		String _04_4 = BigDecimal.valueOf(Double.parseDouble(amo_6)).multiply(BigDecimal.valueOf(Double.parseDouble(perNum))).toString();
		String _03_5 = BigDecimal.valueOf(Double.parseDouble(amo_7)).multiply(BigDecimal.valueOf(Double.parseDouble(perNum))).toString();
		String _04_5 = BigDecimal.valueOf(Double.parseDouble(amo_8)).multiply(BigDecimal.valueOf(Double.parseDouble(perNum))).toString();
		PrpCLimitDto(prpCLimitList, "0", "32", _32, "", "U");
		PrpCLimitDto(prpCLimitList, "1", "03", _03_1, "", "U");
		PrpCLimitDto(prpCLimitList, "1", "04", "0", "", "U");
		PrpCLimitDto(prpCLimitList, "2", "03", _03_2, "", "U");
		PrpCLimitDto(prpCLimitList, "2", "04", "0", "", "U");
		PrpCLimitDto(prpCLimitList, "3", "03", _03_3, "", "U");
		PrpCLimitDto(prpCLimitList, "3", "04", "0", "", "U");
		PrpCLimitDto(prpCLimitList, "4", "03", _03_4, "", "U");
		PrpCLimitDto(prpCLimitList, "4", "04", _04_4, "", "U");
		PrpCLimitDto(prpCLimitList, "5", "03", _03_5, "", "U");
		PrpCLimitDto(prpCLimitList, "5", "04", _04_5, "", "U");
		PrpCLimitDto(prpCLimitList, "6", "03", "0", "", "U");
		PrpCLimitDto(prpCLimitList, "6", "04", "0", "", "U");
	}

	//限额信息
	private static void PrpCLimitDto(Element PrpCLimitList, String LimitNo, String LimitType, String LimitFee, String LimitFlag, String Flag) {
		Element underwrite = PrpCLimitList.addElement("PrpClimitDto");
		underwrite.addElement("LimitNo").setText(LimitNo);
		underwrite.addElement("LimitType").setText(LimitType);
		underwrite.addElement("Currency").setText("CNY");
		underwrite.addElement("LimitFee").setText(LimitFee);
		underwrite.addElement("LimitFlag").setText(LimitFlag);
		underwrite.addElement("Flag").setText(Flag);
	}
	//险别信息
	private static void PrpCitemKindList(Element PrpCitemKindList, OrderFormVo dto, InsPreservationRecordVo vo) {
		String Quantity = String.valueOf(vo.getInsPreservationDetailVoList().size());
		String[] arr;
		if("GZZRX-CA-1".equals(dto.getProduct_code())){
			arr = scanBigDecimal(dto.getPremium(),vo.getTotal_premium(), new String[]{"58.50","13.00","32.50","13.00","13.00"});
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"1",Quantity,"1516102","雇主责任险2012版主险",arr[0],"300000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"2",Quantity,"1516102","雇主责任险2012版主险",arr[1],"30000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"3",Quantity,"1516102","雇主责任险2012版主险",arr[2],"18000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"4",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[3],"100000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"5",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[4],"10000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"6",Quantity,"1505000","附加第三者责任保险条款","0","0");
		}else if("GZZRX-CA-2".equals(dto.getProduct_code())){
			arr = scanBigDecimal(dto.getPremium(),vo.getTotal_premium(), new String[]{"72.00","16.00","40.00","16.00","16.00"});
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"1",Quantity,"1516102","雇主责任险2012版主险",arr[0],"400000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"2",Quantity,"1516102","雇主责任险2012版主险",arr[1],"40000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"3",Quantity,"1516102","雇主责任险2012版主险",arr[2],"18000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"4",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[3],"120000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"5",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[4],"12000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"6",Quantity,"1505000","附加第三者责任保险条款","0","0");
		}else if("GZZRX-CA-3".equals(dto.getProduct_code())){
			arr = scanBigDecimal(dto.getPremium(),vo.getTotal_premium(), new String[]{"90.00","20.00","50.00","20.00","20.00"});
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"1",Quantity,"1516102","雇主责任险2012版主险",arr[0],"500000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"2",Quantity,"1516102","雇主责任险2012版主险",arr[1],"50000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"3",Quantity,"1516102","雇主责任险2012版主险",arr[2],"18000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"4",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[3],"150000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"5",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[4],"15000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"6",Quantity,"1505000","附加第三者责任保险条款","0","0");
		}else if("GZZRX-CA-4".equals(dto.getProduct_code())){
			arr = scanBigDecimal(dto.getPremium(),vo.getTotal_premium(), new String[]{"103.50","23.00","57.50","23.00","23.00"});
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"1",Quantity,"1516102","雇主责任险2012版主险",arr[0],"600000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"2",Quantity,"1516102","雇主责任险2012版主险",arr[1],"60000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"3",Quantity,"1516102","雇主责任险2012版主险",arr[2],"18000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"4",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[3],"180000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"5",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[4],"18000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"6",Quantity,"1505000","附加第三者责任保险条款","0","0");
		}else if("GZZRX-CA-5".equals(dto.getProduct_code())){
			arr = scanBigDecimal(dto.getPremium(),vo.getTotal_premium(), new String[]{"126.00","28.00","70.00","28.00","28.00"});
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"1",Quantity,"1516102","雇主责任险2012版主险",arr[0],"700000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"2",Quantity,"1516102","雇主责任险2012版主险",arr[1],"70000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"3",Quantity,"1516102","雇主责任险2012版主险",arr[2],"18000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"4",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[3],"210000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"5",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[4],"21000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"6",Quantity,"1505000","附加第三者责任保险条款","0","0");
		}else if("GZZRX-CA-6".equals(dto.getProduct_code())){
			arr = scanBigDecimal(dto.getPremium(),vo.getTotal_premium(), new String[]{"148.50","33.00","82.50","33.00","33.00"});
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"1",Quantity,"1516102","雇主责任险2012版主险",arr[0],"800000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"2",Quantity,"1516102","雇主责任险2012版主险",arr[1],"80000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"3",Quantity,"1516102","雇主责任险2012版主险",arr[2],"18000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"4",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[3],"240000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"5",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[4],"24000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"6",Quantity,"1505000","附加第三者责任保险条款","0","0");
		}else if("GZZRX-CA-DQ-1".equals(dto.getProduct_code())){
			arr = scanBigDecimal2(dto.getPremium(),vo.getTotal_premium(), new String[]{"2.00","2.00","2.00","1.50","2.50","2.00"});
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"1",Quantity,"1516102","雇主责任险2012版主险",arr[0],"300000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"2",Quantity,"1516102","雇主责任险2012版主险",arr[1],"30000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"3",Quantity,"1516102","雇主责任险2012版主险",arr[2],"18000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"4",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[3],"100000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"5",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[4],"10000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"6",Quantity,"1505000","附加第三者责任保险条款",arr[5],"0");
		}else if("GZZRX-CA-DQ-2".equals(dto.getProduct_code())){
			arr = scanBigDecimal2(dto.getPremium(),vo.getTotal_premium(), new String[]{"2.00","3.00","2.00","2.00","2.00","3.00"});
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"1",Quantity,"1516102","雇主责任险2012版主险",arr[0],"400000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"2",Quantity,"1516102","雇主责任险2012版主险",arr[1],"40000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"3",Quantity,"1516102","雇主责任险2012版主险",arr[2],"18000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"4",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[3],"120000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"5",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[4],"12000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"6",Quantity,"1505000","附加第三者责任保险条款",arr[5],"0");
		}else if("GZZRX-CA-DQ-3".equals(dto.getProduct_code())){
			arr = scanBigDecimal2(dto.getPremium(),vo.getTotal_premium(), new String[]{"3.00","3.00","3.00","2.00","3.00","3.00"});
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"1",Quantity,"1516102","雇主责任险2012版主险",arr[0],"500000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"2",Quantity,"1516102","雇主责任险2012版主险",arr[1],"50000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"3",Quantity,"1516102","雇主责任险2012版主险",arr[2],"18000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"4",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[3],"150000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"5",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[4],"15000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"6",Quantity,"1505000","附加第三者责任保险条款",arr[5],"0");
		}else if("GZZRX-CA-DQ-4".equals(dto.getProduct_code())){
			arr = scanBigDecimal2(dto.getPremium(),vo.getTotal_premium(), new String[]{"3.00","4.00","3.00","3.00","3.00","4.00"});
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"1",Quantity,"1516102","雇主责任险2012版主险",arr[0],"600000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"2",Quantity,"1516102","雇主责任险2012版主险",arr[1],"60000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"3",Quantity,"1516102","雇主责任险2012版主险",arr[2],"18000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"4",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[3],"180000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"5",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[4],"18000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"6",Quantity,"1505000","附加第三者责任保险条款",arr[5],"0");
		}else if("GZZRX-CA-DQ-5".equals(dto.getProduct_code())){
			arr = scanBigDecimal2(dto.getPremium(),vo.getTotal_premium(), new String[]{"4.00","4.00","4.00","4.00","4.00"});
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"1",Quantity,"1516102","雇主责任险2012版主险",arr[0],"700000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"2",Quantity,"1516102","雇主责任险2012版主险",arr[1],"70000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"3",Quantity,"1516102","雇主责任险2012版主险",arr[2],"18000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"4",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[3],"210000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"5",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[4],"21000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"6",Quantity,"1505000","附加第三者责任保险条款",arr[5],"0");
		}else if("GZZRX-CA-DQ-6".equals(dto.getProduct_code())){
			arr = scanBigDecimal2(dto.getPremium(),vo.getTotal_premium(), new String[]{"4.00","5.00","5.00","4.00","5.00","5.00"});
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"1",Quantity,"1516102","雇主责任险2012版主险",arr[0],"800000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"2",Quantity,"1516102","雇主责任险2012版主险",arr[1],"80000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"3",Quantity,"1516102","雇主责任险2012版主险",arr[2],"18000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"4",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[3],"240000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"5",Quantity,"1516402","附加24小时意外险特别扩展条款（B）",arr[4],"24000");
			PrpCitemKindDto(PrpCitemKindList,vo.getRevise_type(),"6",Quantity,"1505000","附加第三者责任保险条款",arr[5],"0");
		}
	}

	/**
	 * <b> 保费变化量 </b>
	 * @param premium 每人保费
	 * @param totalPremium 批单保费
	 * @param premiumArr 保单险别保费
	 * @author ZXF
	 * @create 2021/06/15 0015 14:40
	 * @version
	 * @注意事项 </b>
	 */
	private static String[] scanBigDecimal(String premium, String totalPremium, String[] premiumArr){
		BigDecimal t1, t2, t3, t4, t5;
		t1 = (BigDecimal.valueOf(Double.parseDouble(premiumArr[0])).divide(BigDecimal.valueOf(Double.parseDouble(premium)),9,BigDecimal.ROUND_DOWN)).multiply(BigDecimal.valueOf(Double.parseDouble(String.valueOf(totalPremium)))).setScale(2, BigDecimal.ROUND_HALF_UP);
		t2 = (BigDecimal.valueOf(Double.parseDouble(premiumArr[1])).divide(BigDecimal.valueOf(Double.parseDouble(premium)),9,BigDecimal.ROUND_DOWN)).multiply(BigDecimal.valueOf(Double.parseDouble(String.valueOf(totalPremium)))).setScale(2, BigDecimal.ROUND_HALF_UP);
		t3 = (BigDecimal.valueOf(Double.parseDouble(premiumArr[2])).divide(BigDecimal.valueOf(Double.parseDouble(premium)),9,BigDecimal.ROUND_DOWN)).multiply(BigDecimal.valueOf(Double.parseDouble(String.valueOf(totalPremium)))).setScale(2, BigDecimal.ROUND_HALF_UP);
		t4 = (BigDecimal.valueOf(Double.parseDouble(premiumArr[3])).divide(BigDecimal.valueOf(Double.parseDouble(premium)),9,BigDecimal.ROUND_DOWN)).multiply(BigDecimal.valueOf(Double.parseDouble(String.valueOf(totalPremium)))).setScale(2, BigDecimal.ROUND_HALF_UP);
		t5 = BigDecimal.valueOf(Double.parseDouble(String.valueOf(totalPremium))).subtract(t1).subtract(t2).subtract(t3).subtract(t4);
		return new String[]{t1+"", t2+"", t3+"", t4+"", t5+""};
	}

	/**
	 * <b> 保费变化量2 </b>
	 * @param premium 每人保费
	 * @param totalPremium 批单保费
	 * @param premiumArr 保单险别保费
	 * @author ZXF
	 * @create 2021/06/15 0015 14:40
	 * @version
	 * @注意事项 </b>
	 */
	private static String[] scanBigDecimal2(String premium, String totalPremium, String[] premiumArr){
		BigDecimal t1, t2, t3, t4, t5, t6;
		t1 = (BigDecimal.valueOf(Double.parseDouble(premiumArr[0])).divide(BigDecimal.valueOf(Double.parseDouble(premium)),9,BigDecimal.ROUND_DOWN)).multiply(BigDecimal.valueOf(Double.parseDouble(String.valueOf(totalPremium)))).setScale(2, BigDecimal.ROUND_HALF_UP);
		t2 = (BigDecimal.valueOf(Double.parseDouble(premiumArr[1])).divide(BigDecimal.valueOf(Double.parseDouble(premium)),9,BigDecimal.ROUND_DOWN)).multiply(BigDecimal.valueOf(Double.parseDouble(String.valueOf(totalPremium)))).setScale(2, BigDecimal.ROUND_HALF_UP);
		t3 = (BigDecimal.valueOf(Double.parseDouble(premiumArr[2])).divide(BigDecimal.valueOf(Double.parseDouble(premium)),9,BigDecimal.ROUND_DOWN)).multiply(BigDecimal.valueOf(Double.parseDouble(String.valueOf(totalPremium)))).setScale(2, BigDecimal.ROUND_HALF_UP);
		t4 = (BigDecimal.valueOf(Double.parseDouble(premiumArr[3])).divide(BigDecimal.valueOf(Double.parseDouble(premium)),9,BigDecimal.ROUND_DOWN)).multiply(BigDecimal.valueOf(Double.parseDouble(String.valueOf(totalPremium)))).setScale(2, BigDecimal.ROUND_HALF_UP);
		t5 = (BigDecimal.valueOf(Double.parseDouble(premiumArr[4])).divide(BigDecimal.valueOf(Double.parseDouble(premium)),9,BigDecimal.ROUND_DOWN)).multiply(BigDecimal.valueOf(Double.parseDouble(String.valueOf(totalPremium)))).setScale(2, BigDecimal.ROUND_HALF_UP);
		t6 = BigDecimal.valueOf(Double.parseDouble(String.valueOf(totalPremium))).subtract(t1).subtract(t2).subtract(t3).subtract(t4).subtract(t5);
		return new String[]{t1+"", t2+"", t3+"", t4+"", t5+"", t6+""};
	}

	private static void PrpCitemKindDto(Element PrpCitemKindList, String revise_type, String ItemKindNo, String Quantity, String KindCode, String KindName, String Premium, String Amount) {
		String sign = "";
		if(ConstProp.DIGIT_THREE.equals(revise_type)){
			Premium = "0";
			Amount = "0";
			Quantity = "0";
		}else{
			sign = ConstProp.DIGIT_TWO.equals(revise_type)? "-":"";
			Amount = String.valueOf((BigDecimal.valueOf(Double.parseDouble(Amount))).multiply(BigDecimal.valueOf(Double.parseDouble(sign+Quantity))));
		}
		Element underwrite = PrpCitemKindList.addElement("PrpCitemKindDto");
		underwrite.addElement("Quantity").setText(sign + Quantity);//人数
		underwrite.addElement("ItemKindNo").setText(ItemKindNo);//险别序号
		underwrite.addElement("KindCode").setText(KindCode);//险别代码
		underwrite.addElement("KindName").setText(KindName);//险别名称
		underwrite.addElement("Premium").setText(Premium);//最新保费
		underwrite.addElement("Amount").setText(Amount);//最新保额
		underwrite.addElement("Flag").setText("U");//批改标志(U-修改)
	}

	//变更信息
	private static void PrpCNameList(Element PrpCNameList, OrderFormVo dto, InsPreservationRecordVo vo) {
		String type;
		String total_premium = vo.getTotal_premium().replace("-","");
		int len = vo.getInsPreservationDetailVoList().size();
		String premium = BigDecimal.valueOf(Double.parseDouble(total_premium)).divide(BigDecimal.valueOf(len),2, RoundingMode.HALF_UP).toString();
		InsPreservationDetailVo resVo;
		for(InsPreservationDetailVo ipdVo : vo.getInsPreservationDetailVoList()) {
			type = conventPType(vo.getRevise_type());
			Element underwrite = PrpCNameList.addElement("PrpCNameDto");
			CraftType ct = CraftType.getByCareer(ipdVo.getCareer());
			underwrite.addElement("id").setText("");//
			underwrite.addElement("EmployeeName").setText(ipdVo.getName());//
			underwrite.addElement("Sex").setText(ipdVo.getSex());//
			int age = 0;
			try {
				age = DateUtil.getAge(ipdVo.getBirthday());
			} catch (Exception e) {
				e.printStackTrace();
			}
			underwrite.addElement("Age").setText(String.valueOf(age));//
			underwrite.addElement("Health").setText("1");//
			underwrite.addElement("JobCode").setText(ct.getCode4());//
			underwrite.addElement("CertificateId").setText(changeCTypePer(ipdVo.getId_type()));//
			underwrite.addElement("IdentifyNumber").setText(ipdVo.getId_card().toUpperCase());//
			underwrite.addElement("BirthDate").setText(ipdVo.getBirthday());//
			underwrite.addElement("Currency").setText("CNY");//
			underwrite.addElement("HighRiskId").setText("0");//
			underwrite.addElement("JobUnit").setText(dto.getApplicant_name());//工作单位
			underwrite.addElement("MonthwAge").setText("3500");//月薪资
			underwrite.addElement("PersonTypeId").setText("1516");//人员类别
			underwrite.addElement("ChgUnitPremium").setText(premium);//每人保费
			underwrite.addElement("StartDate").setText(vo.getInception_date());//起止保时间
			underwrite.addElement("EndDate").setText(dto.getPlanned_end_date());//
			underwrite.addElement("JobName").setText(ct.getName());//雇员工种名称
			underwrite.addElement("Remark1").setText(ct.getCode1());//
			underwrite.addElement("Remark2").setText(ct.getCode2());//
			underwrite.addElement("Remark3").setText(ct.getCode3());//
			underwrite.addElement("Remark4").setText(ct.getCode4());//
			underwrite.addElement("Remark5").setText("1");//
			if("1".equals(type)){
				resVo = ipdVo.getBusiness_vo();
				underwrite.addElement("OldEmployeeName").setText(resVo.getName());//修改雇员姓名
				underwrite.addElement("OldCertificateId").setText(changeCTypePer(resVo.getId_type()));//历史证件类型（代码）
				underwrite.addElement("OldIdentifyNumber").setText(resVo.getId_card().toUpperCase());//历史身份证号码
			}
			underwrite.addElement("OccupationalClass").setText(ct.getLevel());//职业类别风险等级代码
			underwrite.addElement("ReplaceFlag").setText("1".equals(type)?"1":"0");//替换标志（0-非替换；1-替换）
			underwrite.addElement("Flag").setText(type);//批改类型（1-修改,2-删除,3-增加）
		}
	}

	private static String conventPType(String revise_type){
		String rt = ConstProp.BLANK_CHAR;
		if(ConstProp.DIGIT_ONE.equals(revise_type)){//增员
			rt = "3";
		}else if(ConstProp.DIGIT_TWO.equals(revise_type)){//减员
			rt = "2";
		}else if(ConstProp.DIGIT_THREE.equals(revise_type)){//替换
			rt = "1";
		}
		return rt;
	}

	//批单主信息
	private static void PrpTmainDto(Element underwrite, OrderFormVo dto, InsPreservationRecordVo vo) {
		underwrite.addElement("PolicyNo").setText(dto.getExternal_reference());//
		underwrite.addElement("ClassCode").setText("15");//险类代码
		underwrite.addElement("RiskCode").setText("1516");//险种代码
		underwrite.addElement("MakeCom").setText("11000013");//出单机构
		underwrite.addElement("InsuredCode").setText("");//
		underwrite.addElement("InsuredName").setText("");//
		underwrite.addElement("Language").setText("C");//
		underwrite.addElement("PolicyType").setText("02");//01个单/02团单
		underwrite.addElement("EndorType").setText("60");//批改类型 60变更雇员清单
		underwrite.addElement("EndorDate").setText(vo.getStart_time());//批改日期
		underwrite.addElement("ValidDate").setText(vo.getInception_date());//批单生效日期(YYYY-MM-DD)
		underwrite.addElement("ValidHour").setText("0");//批单生效小时
		underwrite.addElement("HandlerCode").setText("");//经办人代码
		underwrite.addElement("Handler1Code").setText("");//归属业务员代码
		String ApproverCode = "4351000148";//生产用
		if(GlobalResources.IS_TEST_ENVI) {//是测试环境
			ApproverCode = "1100001329";
		}
		underwrite.addElement("ApproverCode").setText(ApproverCode);//复核人代码
		underwrite.addElement("OperatorCode").setText("");//操作员代码
		underwrite.addElement("InputDate").setText(DateUtil.dateFormat(vo.getStart_time(),DateUtil.FORMAT2));//录入日期
		underwrite.addElement("InputHour").setText(DateUtil.dateFormat(vo.getStart_time(),DateUtil.FORMAT7));//录入小时
		underwrite.addElement("ComCode").setText("");//业务归属机构代码
		underwrite.addElement("AgentCode").setText("");//代理人代码
		underwrite.addElement("ProvisonalNo").setText(vo.getRevise_serial_number());//暂批单号
		String cHttp = GlobalResources.WEB_URL.replace("https","http");
		underwrite.addElement("UnderwriteBackURL").setText(cHttp+"CA-API/GZZRX/Endorsement-Opinion");//核批回调通知地址
		underwrite.addElement("Flag").setText("");//标志字段
	}

	//个人证件类型编码转换
	private static String changeCTypePer(String c_t){
		if("0".equals(c_t)){//身份证
			return "01";
		}else if("3".equals(c_t)){//护照
			return "03";
		}else if("5".equals(c_t)){//返乡证
			return "06";
		}else{//其它
			return "99";
		}
	}

	//获取支付地址
	private static void requestHead(Element underwrite, OrderFormVo dto, String consumerSeqNo) {
		//交易流水号（服务消费方）
		underwrite.addElement("consumerSeqNo").setText(consumerSeqNo);
		//第三方渠道编码，由服务方提供
		underwrite.addElement("consumerID").setText("000160");
		//服务请求类型
		underwrite.addElement("requestType").setText("QueryPayUrl");
		//交易密码，MD5加密，根据约定是否必传
		underwrite.addElement("passWord").setText("");
		//产品代码
		underwrite.addElement("productCode").setText("1516");
		//地区
		underwrite.addElement("regionCode").setText("430000");
	}

	//获取支付地址
	private static void requestBody(Element underwrite, OrderFormVo dto) {
		//请求方
		underwrite.addElement("parterId").setText("baichuanxin");
		//地区
		underwrite.addElement("regionCode").setText("430000");
		//订单类型 01-车险，02-非车人身险，03-非车核心
		underwrite.addElement("orderType").setText("02");
		//投保单号
		underwrite.addElement("orderNo").setText(dto.getPolicy_serial_number());
		//订单金额
		underwrite.addElement("orderFee").setText(dto.getGross_premium().replace(".00","")+"00");
		//请求来源 01 代表app/ 02代表pc端
		underwrite.addElement("orderSource").setText("02");
		String timeExpire = DateUtil.getTomorrow()+" 23:59:00";
		try {
			timeExpire = DateUtil.dateAdd(7, DateUtil.getCurrentDateTime(), 1);
		} catch (Exception e) {
			e.printStackTrace();
		}
		//支付有效期止期
		underwrite.addElement("timeExpire").setText(timeExpire);
		String cHttp = GlobalResources.WEB_URL.replace("https","http");
		//回调地址
//		支付成功后渠道平台会使用http + post方式调用该链接，并且支付相关信息通过URL参数形式返回
//		订单号：orderNo
//		支付方式：payType
//		刷卡流水号：cardSerialNo
//		支付时间：payTime
//		请求方：parterId
//		订单类型：orderType
//		校验码：passWord
		underwrite.addElement("callBack").setText(cHttp+"CA-API/GZZRX/Policy-Opinion");
		//支付二维码请求 None,Wechat,Alipay(如果获取支付URL可不传，如果获取二维码必传）
		underwrite.addElement("qrType").setText("None");
		underwrite.addElement("payNo").setText("");//支付号
		underwrite.addElement("proposalNoBI").setText("");//商业险投保单号
		underwrite.addElement("proposalNoCI").setText("");//交强险投保单号
	}

	/**
	 * <b> 报案解析 </b>
	 * @author ZXF
	 * @create 2021/03/01 0001 16:12
	 * @version
	 * @注意事项 </b>
	 */
	private String getCABASLResult(String originalXML) {
		String ReportNo = ConstProp.BLANK_CHAR;
		String Msg = ConstProp.BLANK_CHAR;
		String ReportStatus = ConstProp.BLANK_CHAR;
		try {
			requestDocument = DocumentHelper.parseText(originalXML);//解析XML文件
			rootElement = requestDocument.getRootElement();//获取节点
			for(Iterator u = rootElement.elementIterator(); u.hasNext();){
				Element node_u = (Element) u.next();
				if("ReportStatus".equals(node_u.getName())){
					ReportStatus = node_u.getText();
				}
				if("ReportNo".equals(node_u.getName())){
					ReportNo = node_u.getText();
				}
				if("Msg".equals(node_u.getName())){
					Msg = node_u.getText();
				}
			}
			if(!"1".equals(ReportStatus)){
				if(StringUtils.isEmpty(Msg)){
					Msg = "业务处理失败！";
				}
				return "300#"+Msg;
			}
			return "200#"+ ReportNo;
		}catch (Exception e){
			logger.info("getCAAJCXResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * <b> 上传文件解析 </b>
	 * @author ZXF
	 * @create 2021/03/01 0001 16:12
	 * @version
	 * @注意事项 </b>
	 */
	private String getCACLSCResult(String originalXML) {
		String Msg = ConstProp.BLANK_CHAR;
		String UpLoadStatus = ConstProp.BLANK_CHAR;
		String ImageIndex = ConstProp.BLANK_CHAR;
		try {
			requestDocument = DocumentHelper.parseText(originalXML);//解析XML文件
			rootElement = requestDocument.getRootElement();//获取节点
			for(Iterator r = rootElement.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				if("UpLoadStatus".equals(node_r.getName())){
					UpLoadStatus = node_r.getText();
				}
				if("ErrorList".equals(node_r.getName())){
					for(Iterator m = node_r.elementIterator(); m.hasNext();){
						Element node_m = (Element) m.next();
						if("ErrorData".equals(node_m.getName())){
							for(Iterator n = node_m.elementIterator(); n.hasNext();){
								Element node_n = (Element) n.next();
								if("UpLoadFlag".equals(node_n.getName())&&!"0".equals(node_n.getText())){
									continue;
								}
								if("ImageIndex".equals(node_n.getName())){
									ImageIndex = ImageIndex+node_n.getText()+",";
								}
								if(StringUtils.isEmpty(Msg)&&"ErrorMsg".equals(node_n.getName())){
									Msg = node_n.getText();
								}
							}
						}
					}
				}
			}
			if(!"1".equals(UpLoadStatus)){
				if(StringUtils.isEmpty(Msg)){
					Msg = "业务处理失败！";
				}
				return "300#"+ImageIndex+"#"+Msg;
			}
			return "200#";
		}catch (Exception e){
			logger.info("getCAAJCXResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * <b> 案件查询解析 </b>
	 * @author ZXF
	 * @create 2021/03/01 0001 16:12
	 * @version
	 * @注意事项 </b>
	 */
	private String getCAAJCXResult(String originalXML) {
		String ResponseCode = ConstProp.BLANK_CHAR;
		String ErrorMessage = ConstProp.BLANK_CHAR;
		String TotalCount = ConstProp.BLANK_CHAR;
		String TotalPage = ConstProp.BLANK_CHAR;
		String ThisPageNo = ConstProp.BLANK_CHAR;
		List<Map<String,String>> list = Lists.newArrayList();
		Map<String,String> map = null;
		try {
			requestDocument = DocumentHelper.parseText(originalXML);//解析XML文件
			rootElement = requestDocument.getRootElement();//获取节点
			for(Iterator u = rootElement.elementIterator(); u.hasNext();){
				Element node_u = (Element) u.next();
				if("Head".equals(node_u.getName())){
					for(Iterator r = node_u.elementIterator(); r.hasNext();){
						Element node_r = (Element) r.next();
						if("ResponseCode".equals(node_r.getName())){
							ResponseCode = node_r.getText();
						}
						if("Message".equals(node_r.getName())){
							ErrorMessage = node_r.getText();
						}
					}
					if(!"1".equals(ResponseCode)){
						if(StringUtils.isEmpty(ErrorMessage)){
							ErrorMessage = "业务处理失败！";
						}
						return "300#"+ErrorMessage;
					}
				}
				if("Body".equals(node_u.getName())){
					for(Iterator r = node_u.elementIterator(); r.hasNext();){
						Element node_r = (Element) r.next();
						if("TotalCount".equals(node_r.getName())){
							TotalCount = node_r.getText();
						}
						if("TotalPage".equals(node_r.getName())){
							TotalPage = node_r.getText();
						}
						if("ThisPageNo".equals(node_r.getName())){
							ThisPageNo = node_r.getText();
						}
						if("RegistInfoList".equals(node_r.getName())){
							for(Iterator e = node_r.elementIterator(); e.hasNext();){
								Element node_e = (Element) e.next();
								if("RegistInfo".equals(node_e.getName())){
									map = Maps.newHashMap();
									for(Iterator m = node_e.elementIterator(); m.hasNext();){
										Element node_m = (Element) m.next();
										if("RegistNo".equals(node_m.getName())){
											map.put("RegistNo",node_m.getText());
										}
										if("PolicyNo".equals(node_m.getName())){
											map.put("PolicyNo",node_m.getText());
										}
										if("DamageTime".equals(node_m.getName())){
											//出险时间（yyyy-MM-dd HH:mm:ss）
											map.put("DamageTime",node_m.getText());
										}
										if("ReportTime".equals(node_m.getName())){
											//报案时间（yyyy-MM-dd HH:mm:ss）
											map.put("ReportTime",node_m.getText());
										}
										if("RiskName".equals(node_m.getName())){
											//险种名称
											map.put("RiskName",node_m.getText());
										}
										if("ReportName".equals(node_m.getName())){
											//报案人名称
											map.put("ReportName",node_m.getText());
										}
										if("PhoneNumber".equals(node_m.getName())){
											//报案人电话
											map.put("PhoneNumber",node_m.getText());
										}
										if("DistrictCode1".equals(node_m.getName())){
											//事故地点省编码
											map.put("DistrictCode1",node_m.getText());
										}
										if("DistrictCode2".equals(node_m.getName())){
											//事故地点市编码
											map.put("DistrictCode2",node_m.getText());
										}
										if("DistrictCode3".equals(node_m.getName())){
											//事故地点县编码
											map.put("DistrictCode3",node_m.getText());
										}
										if("DamageAddress".equals(node_m.getName())){
											//事故地点详细地址
											map.put("DamageAddress",node_m.getText());
										}
										if("DamageCode".equals(node_m.getName())){
											//出险原因代码
											map.put("DamageCode",node_m.getText());
										}
										if("context".equals(node_m.getName())){
											//
											map.put("context",node_m.getText());
										}
										if("AccidentText".equals(node_m.getName())){
											//事故经过
											map.put("AccidentText",node_m.getText());
										}
										if("CaseStatusCode".equals(node_m.getName())){
											//案件状态编码
											map.put("CaseStatusCode",node_m.getText());
										}
										if("CaseStatusName".equals(node_m.getName())){
											//案件状态名称
											map.put("CaseStatusName",node_m.getText());
										}
										if("RecireverList".equals(node_m.getName())) {
											String rs = "";
											String pm = "";
											for (Iterator s = node_m.elementIterator(); s.hasNext(); ) {
												Element node_s = (Element) s.next();
												if("RecireverInfo".equals(node_s.getName())) {
													String AcciPerson = "";
													String AcciIdentifyNumber = "";
													String PersonLossType = "";
													String AccountType = "";
													String AccountName = "";
													String IdentifyNumber = "";
													String BankName = "";
													String BankAreaProvince = "";
													String BankArea = "";
													String Account = "";
													for (Iterator d = node_s.elementIterator(); d.hasNext(); ) {
														Element node_d = (Element) d.next();
														if("AcciPerson".equals(node_d.getName())){
															AcciPerson = node_d.getText();
														}
														if("AcciIdentifyNumber".equals(node_d.getName())){
															AcciIdentifyNumber = node_d.getText();
														}
														if("PersonLossType".equals(node_d.getName())){
															PersonLossType = node_d.getText();
														}
														if("AccountType".equals(node_d.getName())){
															AccountType = node_d.getText();
														}
														if("AccountName".equals(node_d.getName())){
															AccountName = node_d.getText();
														}
														if("IdentifyNumber".equals(node_d.getName())){
															IdentifyNumber = node_d.getText();
														}
														if("BankName".equals(node_d.getName())){
															BankName = node_d.getText();
														}
														if("BankAreaProvince".equals(node_d.getName())){
															BankAreaProvince = node_d.getText();
														}
														if("BankArea".equals(node_d.getName())){
															BankArea = node_d.getText();
														}
														if("Account".equals(node_d.getName())){
															Account = node_d.getText();
														}
													}
													rs =rs + AcciPerson+"("+AcciIdentifyNumber+")|"+PersonLossType+";";
													pm =pm + AccountName+"|"+IdentifyNumber+"|"+BankName+"|"+Account+"|"+BankAreaProvince+"|"+BankArea+"|"+AccountType+";";
												}
											}
											//出险人信息
											map.put("rs",rs);
											map.put("pm",pm);
										}
									}
									list.add(map);
								}
							}

						}
						map = Maps.newHashMap();
						map.put("TotalCount",TotalCount);
						map.put("TotalPage",TotalPage);
						map.put("ThisPageNo",ThisPageNo);
						map.put("ReportInfo",JSON.toJSONString(list));
					}
				}
			}
			return "200#"+ JSON.toJSONString(map);
		}catch (Exception e){
			logger.info("getCAAJCXResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * <b> 核保确认解析 </b>
	 * @author ZXF
	 * @create 2021/03/01 0001 16:12
	 * @version
	 * @注意事项 </b>
	 */
	private String getCAHBResult(String originalXML) {
		String ResponseCode = ConstProp.BLANK_CHAR;
		String ErrorMessage = ConstProp.BLANK_CHAR;
		String CertiNo = ConstProp.BLANK_CHAR;//投保单号
		String SumAmount = ConstProp.BLANK_CHAR;//保额
		String SumPremium = ConstProp.BLANK_CHAR;//保费
		String Epolicy = ConstProp.BLANK_CHAR;//电子保单（未见费流程）
		try {
			requestDocument = DocumentHelper.parseText(originalXML);//解析XML文件
			rootElement = requestDocument.getRootElement();//获取节点
			Element HEAD = rootElement.element("HEAD");
			Element AffirmPropsalResultDto = HEAD.element("AffirmPropsalResultDto");
			for(Iterator r = AffirmPropsalResultDto.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				if("CertiNo".equals(node_r.getName())){
					CertiNo = node_r.getText();
				}
				if("SumAmount".equals(node_r.getName())){
					SumAmount = node_r.getText();
				}
				if("SumPremium".equals(node_r.getName())){
					SumPremium = node_r.getText();
				}
				if("Epolicy".equals(node_r.getName())){
					Epolicy = node_r.getText();
				}
				if("ReturnMessageDto".equals(node_r.getName())){
					for(Iterator m = node_r.elementIterator(); m.hasNext();){
						Element node_m = (Element) m.next();
						if("ResponseCode".equals(node_m.getName())){
							ResponseCode = node_m.getText();
						}
						if("ErrorMessage".equals(node_m.getName())){
							ErrorMessage = node_m.getText();
						}
					}
					if(!"1".equals(ResponseCode)){
						if(StringUtils.isEmpty(ErrorMessage)){
							ErrorMessage = "业务处理失败！";
						}
						return "300#"+ErrorMessage;
					}
				}
			}
			return "200#"+CertiNo+"#"+SumAmount+"#"+SumPremium+"#"+Epolicy;
		}catch (Exception e){
			logger.info("getCAHBResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * <b> 投保单状态解析 </b>
	 * @author ZXF
	 * @create 2021/03/01 0001 16:12
	 * @version
	 * @注意事项 </b>
	 */
	private String getCAHBJGResult(String originalXML) {
		String ResponseCode = ConstProp.BLANK_CHAR;
		String ErrorMessage = ConstProp.BLANK_CHAR;
		String flag = ConstProp.BLANK_CHAR;//投保单状态（0-初始值;1-通过;2-不通过;3-无需核保;9-待核保;5-人工预核保;6-自动预核保）
		String ProposalNo = ConstProp.BLANK_CHAR;//投保单号
		try {
			requestDocument = DocumentHelper.parseText(originalXML);//解析XML文件
			rootElement = requestDocument.getRootElement();//获取节点
			Element HEAD = rootElement.element("HEAD");
			for(Iterator r = HEAD.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				if("flag".equals(node_r.getName())){
					flag = node_r.getText();
				}
				if("ProposalNo".equals(node_r.getName())){
					ProposalNo = node_r.getText();
				}
				if("ResponseCode".equals(node_r.getName())){
					ResponseCode = node_r.getText();
				}
				if("ErrorMessage".equals(node_r.getName())){
					ErrorMessage = node_r.getText();
				}
			}
			if(!"1".equals(ResponseCode)){
				if(StringUtils.isEmpty(ErrorMessage)){
					ErrorMessage = "业务处理失败！";
				}
				return "300#"+ErrorMessage;
			}
			return "200#"+flag+"#"+ProposalNo;
		}catch (Exception e){
			logger.info("getCACBQRResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * <b> 承保确认解析 </b>
	 * @author ZXF
	 * @create 2021/03/01 0001 16:12
	 * @version
	 * @注意事项 </b>
	 */
	private String getCACBQRResult(String originalXML) {
		String ResponseCode = ConstProp.BLANK_CHAR;
		String ErrorMessage = ConstProp.BLANK_CHAR;
		String CertiNo = ConstProp.BLANK_CHAR;//保单号
		String EndorseNo = ConstProp.BLANK_CHAR;//批单号
		String ProposalNo = ConstProp.BLANK_CHAR;//投单号
		String Epolicy = ConstProp.BLANK_CHAR;//电子保单下载地址
		try {
			requestDocument = DocumentHelper.parseText(originalXML);//解析XML文件
			rootElement = requestDocument.getRootElement();//获取节点
			Element HEAD = rootElement.element("HEAD");
			Element AffirmPropsalResultDto = HEAD.element("AffirmPropsalResultDto");
			for(Iterator r = AffirmPropsalResultDto.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				if("CertiNo".equals(node_r.getName())){
					CertiNo = node_r.getText();
				}
				if("ProposalNo".equals(node_r.getName())){
					ProposalNo = node_r.getText();
				}
				if("EndorseNo".equals(node_r.getName())){
					EndorseNo = node_r.getText();
				}

				if("ReturnMessageDto".equals(node_r.getName())){
					for(Iterator m = node_r.elementIterator(); m.hasNext();){
						Element node_m = (Element) m.next();
						if("ResponseCode".equals(node_m.getName())){
							ResponseCode = node_m.getText();
						}
						if("ErrorMessage".equals(node_m.getName())){
							ErrorMessage = node_m.getText();
						}
						if("Epolicy".equals(node_m.getName())){
							Epolicy = node_m.getText();
						}
					}
					if(!"1".equals(ResponseCode)){
						if(StringUtils.isEmpty(ErrorMessage)){
							ErrorMessage = "业务处理失败！";
						}
						return "300#"+ErrorMessage;
					}
				}
			}
//			if(StringUtils.isNotEmpty(Epolicy)){
//				System.out.println("========>电子保单："+Epolicy);
//				Epolicy = unloading_bd(CertiNo,Epolicy);
//			}
			return "200#"+CertiNo+"#"+ProposalNo+"#"+EndorseNo+"#"+Epolicy;
		}catch (Exception e){
			logger.info("getCACBQRResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * <b> 保单电子发票解析 </b>
	 * @author ZXF
	 * @create 2021/03/01 0001 16:12
	 * @version
	 * @注意事项 </b>
	 */
	private String getBDDZFPResult(String originalXML) {
		String ResponseCode = ConstProp.BLANK_CHAR;
		String ErrorMessage;
		String CertiNo = ConstProp.BLANK_CHAR;//保单号
		String eshortlink = ConstProp.BLANK_CHAR;//电子发票下载地址
		try {
			originalXML = originalXML.replace("&","&amp;");
			requestDocument = DocumentHelper.parseText(originalXML);//解析XML文件
			rootElement = requestDocument.getRootElement();//获取节点
//			Element IfResponse = rootElement.element("IfResponse");
			Element IfResult = rootElement.element("IfResult");
//			Element IfWarning = IfResponse.element("IfWarning");
			Element IfError = rootElement.element("IfError");
//			Element IfErrorStack = IfResponse.element("IfErrorStack");
			ErrorMessage = IfError.getText();
			if(!"0".equals(IfResult.getText())){
				if(StringUtils.isEmpty(ErrorMessage)){
					ErrorMessage = "业务处理失败！";
				}
				return "300#"+ErrorMessage;
			}
			Element IfResultInfo = rootElement.element("IfResultInfo");
			Element request = IfResultInfo.element("request");
			Element main = request.element("main");
			for(Iterator r = main.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				if("status".equals(node_r.getName())){
					ResponseCode = node_r.getText();
				}
				if("msg".equals(node_r.getName())){
					ErrorMessage = node_r.getText();
				}
				if("policyno".equals(node_r.getName())){
					CertiNo = node_r.getText();
				}
				if("eshortlink".equals(node_r.getName())){
					eshortlink = node_r.getText();
				}

			}
			if(!"01".equals(ResponseCode)){
				if(StringUtils.isEmpty(ErrorMessage)){
					ErrorMessage = "业务处理失败！";
				}
				return "300#"+ErrorMessage;
			}
			eshortlink = eshortlink.replace("&amp;","&");
			return "200#"+unloading_fp(eshortlink);
		}catch (Exception e){
			logger.info("getBDDZFPResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * <b>
	 *     根据保险公司电子发票下载地址转存成自己平台的下载地址
	 * </b>
	 * @param rb_url 电子保单下载地址
	 * @author ZXF
	 * @create 2018/06/07 0007 11:01
	 * @version
	 * @注意事项 </b>
	 */
	public static String unloading_fp(String rb_url){
		String result = rb_url;
		if (StringUtils.isEmpty(rb_url)) {
			return result;
		}
		String pno = "CAFP"+DateUtil.generatorRadomNumber();
		InputStream inStream = null;
		try {
			URL url = new URL(rb_url);
			HttpURLConnection conn = (HttpURLConnection)url.openConnection();
			conn.setRequestMethod("GET");
			conn.setConnectTimeout(5 * 1000);
			inStream = conn.getInputStream();//通过输入流获取图片数据
			String savePath = "/policy/";
			String files = pno + ".pdf";
			result = savePath + files;
			String path = GlobalResources.COM_IMG_RE+savePath;
			FileHelp.isFile(inStream, path, files);
			result = GlobalResources.WEB_URL+"/getResource?path="+result;
		} catch (Exception e) {
//			e.printStackTrace();
			logger.error(e.getMessage());
			return rb_url;
		} finally {
			if (inStream != null) {
				try {
					inStream.close();
				} catch (IOException e1) {
					e1.printStackTrace();
				}
			}
		}
		return result;
	}

	/**
	 * <b> 批单电子发票解析 </b>
	 * @author ZXF
	 * @create 2021/03/01 0001 16:12
	 * @version
	 * @注意事项 </b>
	 */
	private String getPDDZFPResult(String originalXML) {
		String ResultCode = ConstProp.BLANK_CHAR;
		String ResultFlag = ConstProp.BLANK_CHAR;
		String ResultMessage = ConstProp.BLANK_CHAR;
		String InvoiceUrl = ConstProp.BLANK_CHAR;//批单电子发票下载地址
		try {
			originalXML = originalXML.replace("&","&amp;");
			requestDocument = DocumentHelper.parseText(originalXML);//解析XML文件
			rootElement = requestDocument.getRootElement();//获取节点
//			Element ResponseBody = rootElement.element("ResponseBody");
			for(Iterator r = rootElement.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				if("ResultCode".equals(node_r.getName())){
					ResultCode = node_r.getText();
				}
				if("ResultFlag".equals(node_r.getName())){
					ResultFlag = node_r.getText();
				}
				if("ResultMessage".equals(node_r.getName())){
					ResultMessage = node_r.getText();
				}
				if("InvoiceUrlList".equals(node_r.getName())){
					for(Iterator m = node_r.elementIterator(); m.hasNext();) {
						Element node_m = (Element) m.next();
						if("InvoiceUrl".equals(node_m.getName())){
							InvoiceUrl = node_m.getText();
							break;
						}
					}
				}
			}
			if(!"0000".equals(ResultCode)){
				if(StringUtils.isEmpty(ResultMessage)){
					ResultMessage = "业务处理失败！";
				}
				return "300#"+ResultMessage;
			}
			if(StringUtils.isEmpty(InvoiceUrl)){
				return "300#未查询到有效发票";
			}
			InvoiceUrl = InvoiceUrl.replace("&amp;","&");
			return "200#"+unloading_fp(InvoiceUrl);
		}catch (Exception e){
			logger.info("getPDDZFPResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * <b> 承保信息解析 </b>
	 * @author ZXF
	 * @create 2021/03/01 0001 16:12
	 * @version
	 * @注意事项 </b>
	 */
	private String getCACBXXResult(String originalXML) {
		String ResponseCode = ConstProp.BLANK_CHAR;
		String ErrorMessage = ConstProp.BLANK_CHAR;
		String CertiNo = ConstProp.BLANK_CHAR;//保单号
		String SumAmount = ConstProp.BLANK_CHAR;//批单号
		String ProposalNo = ConstProp.BLANK_CHAR;//投单号
		String Epolicy = ConstProp.BLANK_CHAR;//电子保单下载地址
		try {
			requestDocument = DocumentHelper.parseText(originalXML);//解析XML文件
			rootElement = requestDocument.getRootElement();//获取节点
			Element HEAD = rootElement.element("HEAD");
			for(Iterator r = HEAD.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				if("ResponseCode".equals(node_r.getName())){
					ResponseCode = node_r.getText();
				}
				if("ErrorMessage".equals(node_r.getName())){
					ErrorMessage = node_r.getText();
				}
			}
			if(!"1".equals(ResponseCode)){
				if(StringUtils.isEmpty(ErrorMessage)){
					ErrorMessage = "业务处理失败！";
				}
				return "300#"+ErrorMessage;
			}
			Element BODY = rootElement.element("BODY");
			Element PrpCmainDto = BODY.element("PrpCmainDto");
			for(Iterator r = PrpCmainDto.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				if("CertiNo".equals(node_r.getName())){
					CertiNo = node_r.getText();
				}
				if("ProposalNo".equals(node_r.getName())){
					ProposalNo = node_r.getText();
				}
				if("SumAmount".equals(node_r.getName())){
					SumAmount = node_r.getText();
				}
				if("Epolicy".equals(node_r.getName())){
					Epolicy = node_r.getText();
				}
			}
			return "200#"+CertiNo+"#"+ProposalNo+"#"+SumAmount+"#"+Epolicy;
		}catch (Exception e){
			logger.info("getCACBXXResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * <b> 批单生成接口解析 </b>
	 * @author ZXF
	 * @create 2021/03/01 0001 16:12
	 * @version
	 * @注意事项 </b>
	 */
	private String getCAPDResult_1(String originalXML) {
		String ResponseCode = ConstProp.BLANK_CHAR;
		String ErrorMessage = ConstProp.BLANK_CHAR;
		String CertiNo = ConstProp.BLANK_CHAR;//暂存单号
		String UnderWriteFlag = ConstProp.BLANK_CHAR;//核保状态 0-初始化；1-核保通过；3-自核通过；5-人工预核保；6-自动预核保
		try {
			requestDocument = DocumentHelper.parseText(originalXML);//解析XML文件
			rootElement = requestDocument.getRootElement();//获取节点
			Element HEAD = rootElement.element("HEAD");
			Element AffirmPropsalResultDto = HEAD.element("AffirmEndorseResultDto");
			for(Iterator r = AffirmPropsalResultDto.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				if("CertiNo".equals(node_r.getName())){
					CertiNo = node_r.getText();
				}
				if("UnderWriteFlag".equals(node_r.getName())){
					UnderWriteFlag = node_r.getText();
				}
				if("ReturnMessageDto".equals(node_r.getName())){
					for(Iterator m = node_r.elementIterator(); m.hasNext();){
						Element node_m = (Element) m.next();
						if("ResponseCode".equals(node_m.getName())){
							ResponseCode = node_m.getText();
						}
						if("ErrorMessage".equals(node_m.getName())){
							ErrorMessage = node_m.getText();
						}
					}
					if(!"1".equals(ResponseCode)){
						if(StringUtils.isEmpty(ErrorMessage)){
							ErrorMessage = "业务处理失败！";
						}
						return "300#"+ErrorMessage;
					}
				}
			}
			return "200#"+CertiNo+"#"+UnderWriteFlag;
		}catch (Exception e){
			logger.info("getCAHBResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * <b> 批单生成实时接口解析 </b>
	 * @author ZXF
	 * @create 2021/03/01 0001 16:12
	 * @version
	 * @注意事项 </b>
	 */
	private String getCAPDResult(String originalXML) {
		String ResponseCode = ConstProp.BLANK_CHAR;
		String ErrorMessage = ConstProp.BLANK_CHAR;
		String CertiNo = ConstProp.BLANK_CHAR;//批单号
		String UnderWriteFlag = ConstProp.BLANK_CHAR;//核保状态 0-初始化；1-核保通过；3-自核通过；5-人工预核保；6-自动预核保
		try {
			requestDocument = DocumentHelper.parseText(originalXML);//解析XML文件
			rootElement = requestDocument.getRootElement();//获取节点
			Element HEAD = rootElement.element("HEAD");
			Element AffirmPropsalResultDto = HEAD.element("AffirmEndorseResultDto");
			for(Iterator r = AffirmPropsalResultDto.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				if("CertiNo".equals(node_r.getName())){
					CertiNo = node_r.getText();
				}
				if("UnderWriteFlag".equals(node_r.getName())){
					UnderWriteFlag = node_r.getText();
				}
			}
			Element ReturnMessageDto = HEAD.element("ReturnMessageDto");
			for(Iterator r = ReturnMessageDto.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				if("ResponseCode".equals(node_r.getName())){
					ResponseCode = node_r.getText();
				}
				if("ErrorMessage".equals(node_r.getName())){
					ErrorMessage = node_r.getText();
				}
			}
			if(!"1".equals(ResponseCode)){
				if(StringUtils.isEmpty(ErrorMessage)){
					ErrorMessage = "业务处理失败！";
				}
				return "300#"+ErrorMessage;
			}
			return "200#"+CertiNo/*+"#"+UnderWriteFlag*/;
		}catch (Exception e){
			logger.info("getCAHBResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * <b> 批单确认报文解析 </b>
	 * @author ZXF
	 * @create 2021/03/01 0001 16:12
	 * @version
	 * @注意事项 </b>
	 */
	private String getCAPDQRResult(String originalXML) {
		String underwriteFlag = ConstProp.BLANK_CHAR;
		String underwriteOpinion = ConstProp.BLANK_CHAR;
		String endorNo = ConstProp.BLANK_CHAR;//批单号
		String timestamp = ConstProp.BLANK_CHAR;
		try {
			requestDocument = DocumentHelper.parseText(originalXML);//解析XML文件
			rootElement = requestDocument.getRootElement();//获取节点
			Element HEAD = rootElement.element("requestHead");
			for(Iterator r = HEAD.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				if("endorNo".equals(node_r.getName())){
					endorNo = node_r.getText();
				}
				if("timestamp".equals(node_r.getName())){
					timestamp = node_r.getText();
				}
				if("underwriteFlag".equals(node_r.getName())){
					underwriteFlag = node_r.getText();
				}
				if("underwriteOpinion".equals(node_r.getName())){
					underwriteOpinion = node_r.getText();
				}
			}

			if(!"1".equals(underwriteFlag)){
				if(StringUtils.isEmpty(underwriteOpinion)){
					underwriteOpinion = "业务处理失败！";
				}
				return "300#"+endorNo+"#"+timestamp+"#"+underwriteOpinion;
			}
			return "200#"+endorNo+"#"+timestamp;
		}catch (Exception e){
			logger.info("getCAHBResult:"+e.getMessage());
		}
		return "301#数据解析失败";
	}

	/**
	 * <b> 批单状态查询结果解析 </b>
	 * @author ZXF
	 * @create 2021/03/01 0001 16:12
	 * @version
	 * @注意事项 </b>
	 */
	private String getCAPDJGResult(String originalXML) {
		String ResponseCode = ConstProp.BLANK_CHAR;
		String ErrorMessage = ConstProp.BLANK_CHAR;
		String EndorseNo = ConstProp.BLANK_CHAR;//批单号/保单号
		String Flag = ConstProp.BLANK_CHAR;//批单状态（0-初始值;1-通过;2-不通过;3-无需核保;9-待核保;5-人工预核保;6-自动预核保）
		try {
			requestDocument = DocumentHelper.parseText(originalXML);//解析XML文件
			rootElement = requestDocument.getRootElement();//获取节点
			Element HEAD = rootElement.element("HEAD");
			for(Iterator r = HEAD.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				if("ResponseCode".equals(node_r.getName())){
					ResponseCode = node_r.getText();
				}
				if("ErrorMessage".equals(node_r.getName())){
					ErrorMessage = node_r.getText();
				}
			}
			if(!"1".equals(ResponseCode)){
				if(StringUtils.isEmpty(ErrorMessage)){
					ErrorMessage = "业务处理失败！";
				}
				return "300#"+ErrorMessage;
			}
			Element BODY = rootElement.element("BODY");
			for(Iterator r = BODY.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				for(Iterator m = node_r.elementIterator(); r.hasNext();){
					Element node_m = (Element) m.next();
					if("EndorseNo".equals(node_m.getName())){
						EndorseNo = node_m.getText();
					}
					if("Flag".equals(node_m.getName())){
						Flag = node_m.getText();
					}
				}

			}
			return "200#"+EndorseNo+"#"+Flag;
		}catch (Exception e){
			logger.info("getCACBXXResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * <b> 线下承保结果回调 </b>
	 * @author ZXF
	 * @create 2021/03/01 0001 16:12
	 * @version
	 * @注意事项 </b>
	 */
	private String getCAXXCBResult(String originalXML) {
		String ResponseCode = ConstProp.BLANK_CHAR;
		String ErrorMessage = ConstProp.BLANK_CHAR;
		String PolicyNo = ConstProp.BLANK_CHAR;//保单号
		String ProposalNo = ConstProp.BLANK_CHAR;//投保单号
		String Epolicy = ConstProp.BLANK_CHAR;//电子保单链接
		try {
			requestDocument = DocumentHelper.parseText(originalXML);//解析XML文件
			rootElement = requestDocument.getRootElement();//获取节点
			Element RequestBody = rootElement.element("RequestBody");
			for(Iterator r = RequestBody.elementIterator(); r.hasNext();){
				Element node_n = (Element) r.next();
				if("PayState".equals(node_n.getName())){
					ResponseCode = node_n.getText();
				}
				if("Message".equals(node_n.getName())){
					ErrorMessage = node_n.getText();
				}
				if("ProposalNo".equals(node_n.getName())){
					ProposalNo = node_n.getText();
				}
				if("Epolicy".equals(node_n.getName())){
					Epolicy = node_n.getText();
				}
				if("PolicyNo".equals(node_n.getName())){
					PolicyNo = node_n.getText();
				}
			}
			if(!"true".equals(ResponseCode)){
				if(StringUtils.isEmpty(ErrorMessage)){
					ErrorMessage = "业务处理失败！";
				}
				return "300#"+ErrorMessage;
			}

			return "200#"+ProposalNo+"#"+PolicyNo+"#"+Epolicy;
		}catch (Exception e){
			logger.info("getCAXXCBResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * <b> 支付地址解析 </b>
	 * @author ZXF
	 * @create 2021/03/01 0001 16:12
	 * @version
	 * @注意事项 </b>
	 */
	private String getCAZFDZResult(String originalXML) {
		String status = ConstProp.BLANK_CHAR;
		String appMessage = ConstProp.BLANK_CHAR;
		String ResponseCode = ConstProp.BLANK_CHAR;
		String ErrorMessage = ConstProp.BLANK_CHAR;
		String payNo = ConstProp.BLANK_CHAR;
		String payUrl = ConstProp.BLANK_CHAR;
		try {
			requestDocument = DocumentHelper.parseText(originalXML);//解析XML文件
			rootElement = requestDocument.getRootElement();//获取节点
			Element responseHead = rootElement.element("responseHead");
			for(Iterator r = responseHead.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				if("status".equals(node_r.getName())){
					status = node_r.getText();
				}
				if("esbCode".equals(node_r.getName())){
					ResponseCode = node_r.getText();
				}
				if("esbMessage".equals(node_r.getName())){
					ErrorMessage = node_r.getText();
				}
				if("appMessage".equals(node_r.getName())){
					appMessage = node_r.getText();
				}
			}
			if(!"00".equals(ResponseCode)||!"0".equals(status)){
				if(StringUtils.isEmpty(ErrorMessage)){
					ErrorMessage = "业务处理失败！";
					if(StringUtils.isNotEmpty(appMessage)){
						ErrorMessage = appMessage;
					}
				}
				return "300#"+ErrorMessage;
			}
			Element responseBody = rootElement.element("responseBody");
			for(Iterator r = responseBody.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				if("payNo".equals(node_r.getName())){
					payNo = node_r.getText();
				}
				if("payUrl".equals(node_r.getName())){
					payUrl = node_r.getText();
				}
			}
			return "200#"+payNo+"#"+payUrl;
		}catch (Exception e){
			logger.info("getCAZFDZResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * <b> 支付结果解析 </b>
	 * @author ZXF
	 * @create 2021/03/01 0001 16:12
	 * @version
	 * @注意事项 </b>
	 */
	private String getCAZFJGResult(String originalXML) {
		String ResponseCode = ConstProp.BLANK_CHAR;
		String ErrorMessage = ConstProp.BLANK_CHAR;
		String payNo = ConstProp.BLANK_CHAR;
		String payResult = ConstProp.BLANK_CHAR;//0未支付，1支付成功，2，无效
		String payType = ConstProp.BLANK_CHAR;//wechat微信支付,Alipay支付宝支付,yeepay易宝支付,unionPay银联支付
		try {
			requestDocument = DocumentHelper.parseText(originalXML);//解析XML文件
			rootElement = requestDocument.getRootElement();//获取节点
			Element responseHead = rootElement.element("responseHead");
			for(Iterator r = responseHead.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				if("esbCode".equals(node_r.getName())){
					ResponseCode = node_r.getText();
				}
				if("esbMessage".equals(node_r.getName())){
					ErrorMessage = node_r.getText();
				}
			}
			if(!"00".equals(ResponseCode)){
				if(StringUtils.isEmpty(ErrorMessage)){
					ErrorMessage = "业务处理失败！";
				}
				return "300#"+ErrorMessage;
			}
			Element responseBody = rootElement.element("responseBody");
			for(Iterator r = responseBody.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				if("payNo".equals(node_r.getName())){
					payNo = node_r.getText();
				}
				if("payResult".equals(node_r.getName())){
					payResult = node_r.getText();
				}
				if("payType".equals(node_r.getName())){
					payType = node_r.getText();
				}
			}
			return "200#"+payNo+"#"+payResult+"#"+payType;
		}catch (Exception e){
			logger.info("getCAZFJGResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * <b> 保单落地反向通知报文解析 </b>
	 * @author ZXF
	 * @create 2021/03/01 0001 16:12
	 * @version
	 * @注意事项 </b>
	 */
	public String getHDBDResult(String originalXML) {
		String proposalNo = ConstProp.BLANK_CHAR;//投保单号
		String policyNo = ConstProp.BLANK_CHAR;//保单号
		String ePolicy = ConstProp.BLANK_CHAR;//电子保单下载地址
		String eGpolicy = ConstProp.BLANK_CHAR;//保函链接地址
		try {
			requestDocument = DocumentHelper.parseText(originalXML);//解析XML文件
			rootElement = requestDocument.getRootElement();//获取节点
			Element UNDWRTRESULTNOTICE = rootElement.element("UNDWRTRESULTNOTICE");
			for(Iterator r = UNDWRTRESULTNOTICE.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				if("proposalNo".equals(node_r.getName())){
					proposalNo = node_r.getText();
				}
				if("policyNo".equals(node_r.getName())){
					policyNo = node_r.getText();
				}
				if("ePolicy".equals(node_r.getName())){
					ePolicy = node_r.getText();
				}
				if("eGpolicy".equals(node_r.getName())){
					eGpolicy = node_r.getText();
				}
			}
			return "200#"+proposalNo+"#"+policyNo+"#"+ePolicy+"#"+eGpolicy;
		}catch (Exception e){
			logger.info("getHDBDResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 * <b> 批单落地反向通知报文解析 </b>
	 * @author ZXF
	 * @create 2021/03/01 0001 16:12
	 * @version
	 * @注意事项 </b>
	 */
	public String getHDPDResult(String originalXML) {
		String CertiNo = ConstProp.BLANK_CHAR;//暂存单号
		String EndorNo = ConstProp.BLANK_CHAR;//批单号
		String UnderwriteFlag = ConstProp.BLANK_CHAR;//核保标识 0-初始值;1-通过;2-不通过;3-无需核保;9-待核保;5-人工预核保;6-自动预核保
		String UnderwriteOpinion = ConstProp.BLANK_CHAR;//核保结果
		try {
			requestDocument = DocumentHelper.parseText(originalXML);//解析XML文件
			rootElement = requestDocument.getRootElement();//获取节点
			Element UNDWRTRESULTNOTICE = rootElement.element("UNDWRTRESULTNOTICE");
			for(Iterator r = UNDWRTRESULTNOTICE.elementIterator(); r.hasNext();){
				Element node_r = (Element) r.next();
				if("CertiNo".equals(node_r.getName())){
					CertiNo = node_r.getText();
				}
				if("EndorNo".equals(node_r.getName())){
					EndorNo = node_r.getText();
				}
				if("UnderwriteFlag".equals(node_r.getName())){
					UnderwriteFlag = node_r.getText();
				}
				if("UnderwriteOpinion".equals(node_r.getName())){
					UnderwriteOpinion = node_r.getText();
				}
			}
			return "200#"+CertiNo+"#"+EndorNo+"#"+UnderwriteFlag+"#"+UnderwriteOpinion;
		}catch (Exception e){
			logger.info("getHDBDResult:"+e.getMessage());
		}
		return "300#数据解析失败";
	}

	/**
	 *	核保接口返回字符串解析
	 * @return
	 */
	public String returnAnalysisXML(String xml, String transType){
		if(TransTypeEnum.HB.getValue().equals(transType)) {
			//核保
			return getCAHBResult(xml);
		}else if(TransTypeEnum.PD.getValue().equals(transType)) {
			//批单
			return getCAPDResult(xml);
		}else if(TransTypeEnum.PDQR.getValue().equals(transType)) {
			//批单
			return getCAPDQRResult(xml);
		}else if(TransTypeEnum.CBQR.getValue().equals(transType)) {
			return getCACBQRResult(xml);
			//承保回调
//			return getRBHDCBResult(xml);
		}else if(TransTypeEnum.HDZF.getValue().equals(transType)) {
			//批单支付回调
//			return getRBHDZFResult(xml);
		}else if(TransTypeEnum.ZFDZ.getValue().equals(transType)) {
			//获取支付地址
			return getCAZFDZResult(xml);
		}else if(TransTypeEnum.BASL.getValue().equals(transType)) {
			//报案
			return getCABASLResult(xml);
		}else if(TransTypeEnum.CLSC.getValue().equals(transType)) {
			//上传文件
			return getCACLSCResult(xml);
		}else if(TransTypeEnum.AJCX.getValue().equals(transType)) {
			//案件查询
			return getCAAJCXResult(xml);
		}else if(TransTypeEnum.XXCB.getValue().equals(transType)) {
			//线下承保回调
			return getCAXXCBResult(xml);
		}else if(TransTypeEnum.DZFP.getValue().equals(transType)) {
			//线下承保回调
			return getBDDZFPResult(xml);
		}else if(TransTypeEnum.PDDZFP.getValue().equals(transType)) {
			//线下承保回调
			return getPDDZFPResult(xml);
		}
		return ConstProp.BLANK_CHAR;
	}

	/**
	 * <b>
	 *     根据保险公司电子保单下载地址转存成自己平台的下载地址（该方法暂未用）
	 * </b>
	 * @param pno 保单号
	 * @param rb_url 电子保单下载地址
	 * @author ZXF
	 * @create 2018/06/07 0007 11:01
	 * @version
	 * @注意事项 </b>
	 */
	private static String unloading_bd(String pno, String rb_url){
		String result = rb_url;
		if (StringUtils.isEmpty(rb_url)) {
			return result;
		}
		if(StringUtils.isEmpty(pno)){
			pno = "CAGZ"+System.currentTimeMillis();
		}
		InputStream inStream = null;
		try {
			URL url = new URL(rb_url);
			HttpURLConnection conn = (HttpURLConnection)url.openConnection();
			conn.setRequestMethod("GET");
			conn.setConnectTimeout(5 * 1000);
			inStream = conn.getInputStream();
			String savePath = "/policy/";
			String files = pno + ".pdf";
			result = savePath + files;
			String path = GlobalResources.COM_IMG_RE+savePath;
			FileHelp.isFile(inStream, path, files);
			result = "/getResource?path="+result;
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (inStream != null) {
				try {
					inStream.close();
				} catch (IOException e1) {
					e1.printStackTrace();
				}
			}
		}
		return result;
	}
}
