package com.bcxin.ins.third.build.dubang;

import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.MD5Util;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Iterator;

/**
 * <b>都邦941.942接口报文信息辅助表 </b>
 * 
 * @author zxf
 * @date 2017年1月19日 下午2:47:14
 * @注意事项 </b>
 * <b>
 */
public class DBSendInfoVo {

	private static Logger logger = LoggerFactory.getLogger(DBSendInfoVo.class);

	protected Document requestDocument;
	protected Element rootElement;

	private String sign;//签名密文
	private String requestType;//请求类型
	/*941*/
	private String outOrderNo;//第三方订单号
	private String amount;//应支付金额
	private String payStatus;//支付状态（2-支付成功）
	private String payTime;//支付时间
	private String orderSource;//订单来源

	/*942*/
	private String policyNo;//保单号
	private String proposalNo;//投保单号
	private String certiType;//核保通过U/保单生效V/全单退保W
	private String operateTime;//操作时间
	private String inputSysCode;//对接渠道代码

	public String getRequestType() {
		return requestType;
	}

	public void setRequestType(String requestType) {
		this.requestType = requestType;
	}

	public String getSign() {
		return sign;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	public String getOutOrderNo() {
		return outOrderNo;
	}

	public void setOutOrderNo(String outOrderNo) {
		this.outOrderNo = outOrderNo;
	}

	public String getAmount() {
		return amount;
	}

	public void setAmount(String amount) {
		this.amount = amount;
	}

	public String getPayStatus() {
		return payStatus;
	}

	public void setPayStatus(String payStatus) {
		this.payStatus = payStatus;
	}

	public String getPayTime() {
		return payTime;
	}

	public void setPayTime(String payTime) {
		this.payTime = payTime;
	}

	public String getOrderSource() {
		return orderSource;
	}

	public void setOrderSource(String orderSource) {
		this.orderSource = orderSource;
	}

	public String getPolicyNo() {
		return policyNo;
	}

	public void setPolicyNo(String policyNo) {
		this.policyNo = policyNo;
	}

	public String getProposalNo() {
		return proposalNo;
	}

	public void setProposalNo(String proposalNo) {
		this.proposalNo = proposalNo;
	}

	public String getCertiType() {
		return certiType;
	}

	public void setCertiType(String certiType) {
		this.certiType = certiType;
	}

	public String getOperateTime() {
		return operateTime;
	}

	public void setOperateTime(String operateTime) {
		this.operateTime = operateTime;
	}

	public String getInputSysCode() {
		return inputSysCode;
	}

	public void setInputSysCode(String inputSysCode) {
		this.inputSysCode = inputSysCode;
	}

	/**
	 * 对941,942请求的报文解析
	 * @param originalXML
	 */
	public void analysisXML(String originalXML) {
		try {
			requestDocument = DocumentHelper.parseText(originalXML);
			rootElement = requestDocument.getRootElement();
			for(Iterator i = rootElement.elementIterator(); i.hasNext();){
				Element node = (Element) i.next();
				if(!"BODY".equals(node.getName())){
					continue;
				}
				for(Iterator n = node.elementIterator(); n.hasNext();){
					Element node_n = (Element) n.next();
					if("REQUEST_TYPE".equals(node_n.getName())){
						String name = node_n.getName();
						String value = node_n.getText();
						if(StringUtils.isNotEmpty(value)){
							value = value.replace("<![CDATA[",ConstProp.BLANK_CHAR).replace("]]>",ConstProp.BLANK_CHAR);
						}
						this.setRequestType(value);
					}
					if("SENDINFO".equals(node_n.getName())){
						for(Iterator o = node_n.elementIterator(); o.hasNext();){
							Element node_o = (Element) o.next();
							String name = node_o.getName();
							String value = node_o.getText();
							if(StringUtils.isNotEmpty(value)){
								value = value.replace("<![CDATA[",ConstProp.BLANK_CHAR).replace("]]>",ConstProp.BLANK_CHAR);
							}
							if("OUTORDERNO".equals(name)){
								this.setOutOrderNo(value);
							}
							if("AMOUNT".equals(name)){
								this.setAmount(value);
							}
							if("PAYSTATUS".equals(name)){
								this.setPayStatus(value);
							}
							if("PAYTIME".equals(name)){
								this.setPayTime(value);
							}
							if("ORDERSOURCE".equals(name)){
								this.setOrderSource(value);
							}
							if("POLICYNO".equals(name)){
								this.setPolicyNo(value);
							}
							if("PROPOSALNO".equals(name)){
								this.setProposalNo(value);
							}
							if("CERTITYPE".equals(name)){
								this.setCertiType(value);
							}
							if("OPERATETIME".equals(name)){
								this.setOperateTime(value);
							}
							if("INPUTSYSCODE".equals(name)){
								this.setInputSysCode(value);
							}
						}
					}
					if("SIGNINFO".equals(node_n.getName())){
						for(Iterator o = node_n.elementIterator(); o.hasNext();){
							Element node_o = (Element) o.next();
							String name = node_o.getName();
							String value = node_o.getText();
							if(StringUtils.isNotEmpty(value)){
								value = value.replace("<![CDATA[",ConstProp.BLANK_CHAR).replace("]]>",ConstProp.BLANK_CHAR);
							}
							if("SIGN".equals(name)){
								this.setSign(value);
							}
						}
					}
				}
			}
		}catch (Exception e){
			logger.info("analysisXML:"+e.getMessage());
		}
	}

	/**
	 * 数据加完密后是否匹配
	 * @return
	 */
	public boolean isSign(){
		String result = ConstProp.BLANK_CHAR;
		if(DBProp.PORT_941.equals(this.getRequestType())){
			result = "REQUEST_TYPE="+this.getRequestType()+"&OUTORDERNO="+this.getOutOrderNo()+"&AMOUNT="+this.getAmount()+"&PAYSTATUS="+this.getPayStatus()+"&PAYTIME="+this.getPayTime()+"&ORDERSOURCE="+this.getOrderSource()+"&KEY="+ GlobalResources.DB_INS_KEY;
		}else if(DBProp.PORT_942.equals(this.getRequestType())){
			result = "REQUEST_TYPE="+this.getRequestType()+"&POLICYNO="+this.getPolicyNo()+"&PROPOSALNO="+this.getProposalNo()+"&CERTITYPE="+this.getCertiType()+"&OPERATETIME="+this.getOperateTime()+"&INPUTSYSCODE="+this.getInputSysCode()+"&KEY="+GlobalResources.DB_INS_KEY;
		}
		if(StringUtils.isNotEmpty(result)){
			logger.info("result:"+result);
			String sign= MD5Util.md5(DBProp.gbToUnicodeEncoding(result.trim())).toUpperCase();//加密
			logger.info("sign(N):"+sign);
			logger.info("sign(W):"+this.getSign());
			if(sign.equals(this.getSign())){
				return true;
			}
		}
		return false;
	}

	public static void main(String[] args){
		String a = "REQUEST_TYPE=941&OUTORDERNO=943422401327263744&AMOUNT=0.01&PAYSTATUS=2&PAYTIME=2017-12-20 18:09:47&ORDERSOURCE=00003&KEY=czVsBSUNe7gQK19n6diLiqgrTm4=";
		String b = "REQUEST_TYPE=941&OUTORDERNO=943422401327263744&AMOUNT=0.01&PAYSTATUS=2&PAYTIME=2017-12-20 18:09:47&ORDERSOURCE=00003&KEY=czVsBSUNe7gQK19n6diLiqgrTm4=";
		String sign1 = MD5Util.md5(DBProp.gbToUnicodeEncoding(a)).toUpperCase();//加密
		String sign2 = MD5Util.md5(DBProp.gbToUnicodeEncoding(b)).toUpperCase();//加密
		System.out.println(sign1.equals(sign2));
	}
}
