package com.bcxin.ins.service.product.impl;

import com.bcxin.ins.dao.product.InsProductRuleXWCKAPIDao;
import com.bcxin.ins.service.product.InsProductRuleXWCKAPIService;
import com.bcxin.ins.entity.product_core.ProPrimaryRuleXWCK;
import com.bcxin.ins.vo.RuleXWCKVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
* 类名称：
* 类描述：
* 创建人：zxf
* @version
 */
@Service
public class InsProductRuleXWCKAPIServiceImpl extends ServiceImpl<InsProductRuleXWCKAPIDao, ProPrimaryRuleXWCK> implements InsProductRuleXWCKAPIService {
    private static Logger log = LoggerFactory.getLogger(InsProductRuleXWCKAPIServiceImpl.class);

    @Autowired
    private InsProductRuleXWCKAPIDao dao;
    /**
     * 根据产品id和城市代码查询产品的区域规则
     * @param product_id
     * @return
     */
    @Override
    public RuleXWCKVo getRuleXWCKVoByProductIDAndCity(String product_id, String city_code){
        if(StringUtils.isEmpty(product_id)||StringUtils.isEmpty(city_code)){
            return null;
        }
        return dao.getRuleXWCKVoByProductIDAndCity(Long.parseLong(product_id),city_code);
    }
}