package com.bcxin.ins.service.order.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.dao.order.InsInsuranceSlipAPIDao;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.entity.policy_core.*;
import com.bcxin.ins.entity.policy_special.*;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.service.order.*;
import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.service.product.InsProductResponsibilityAPIService;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.DateUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;


/**
 * <b>投保单主表业务处理 </b>
 *
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsInsuranceSlipAPIServiceImpl extends ServiceImpl<InsInsuranceSlipAPIDao, InsInsuranceSlip> implements InsInsuranceSlipAPIService {

	@Autowired
	private InsCommonExportAPIService insCommonExportService;

	@Autowired
	private InsMicroExportAPIService insMicroExportService;

	@Autowired
	private InsRoleInpolicyAPIService insRoleInpolicyService;

	@Autowired
	private InsProductAPIService insProductService;

	@Autowired
	private InsUnderwriteAPIService insUnderwriteService;

	@Autowired
	private InsMailPolicyAPIService insMailPolicyService;

	@Autowired
	private InsInsuranceSlipAPIDao dao;

	@Autowired
	private InsTransactionAPIService insTransactionService;

	@Autowired
	private InsAgreementAPIService insAgreementService;

	@Autowired
	private InsRiskDutyAPIService insRiskDutyService;

	@Autowired
	private InsProductResponsibilityAPIService insProductResponsibilityService;

	@Autowired
	private SpecialLitigationAPIService specialLitigationService;
	@Autowired
	private SpecialBidAPIService specialBidService;
	@Autowired
	private SpecialPerformanceAPIService specialPerformanceService;
	@Autowired
	private SpecialPublicDutyAPIService specialPublicDutyService;
	@Autowired
	private SpecialExhibitionAPIService specialExhibitionAPIService;
	@Autowired
	private ComTaskResidualAPIService comTaskResidualAPIService;


	/**
	 * <b>投保单子表绑定主表，如果主表为空那么方法强制返回null </b>
	 * getInsInsuranceSlipgExtendsParent
	 * @param oid 投保单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月5日 下午3:54:36
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public InsInsuranceSlip selectById(Long oid){
		InsInsuranceSlip insInsuranceSlip = dao.selectById(oid);
		if(insInsuranceSlip != null){
			insMailPolicyService.throughTheInsInsuranceSlipForInsMailPolicySetUpInsInsuranceSlip(insInsuranceSlip);
			insUnderwriteService.throughTheInsInsuranceSlipForInsUnderwriteSetUpInsInsuranceSlip(insInsuranceSlip);
			insInsuranceSlip.setInsTransaction(insTransactionService.selectInsTransactionByInsOrderForm(oid));
		}
		return insInsuranceSlip;
	}

	/**
	 * <b>根据投保单id查询投保单信息，然后根据类型判断查询特殊字段相关信息封装到投保单中 </b>
	 *
	 * @param oid 投保单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月5日 下午3:54:36
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public InsInsuranceSlip packagingInsInsuranceSlip(Long oid){
		InsInsuranceSlip insInsuranceSlip = selectById(oid);
		if(insInsuranceSlip == null){
			return insInsuranceSlip;
		}
		insInsuranceSlip.setRoles(insRoleInpolicyService.selectInsRoleInpolicyByInsInsuranceSlip(insInsuranceSlip.getIns_insurance_slip_id()));
		ProPrimary insProduct = insProductService.selectById(insInsuranceSlip.getPro_primary().getPro_primary_id());
		insInsuranceSlip.setPro_primary(insProduct);
		if(StringUtils.isEmpty(insProduct.getProduct_code())){
			return insInsuranceSlip;
		}
		if(ConstProp.XYX_XWCK.equals(insProduct.getProduct_code())){
			SpecialCreditMicro insMicroExport = insMicroExportService.selectById(insInsuranceSlip.getSpecial_id());
			if (insMicroExport != null && insMicroExport.getSpecial_credit_micro_id() != null) {
				insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()),insMicroExport);
				insInsuranceSlip.setSpecial_id(insMicroExport.getSpecial_credit_micro_id());
			}
		}else if(ConstProp.XYX_DQCK.equals(insProduct.getProduct_code())){
			SpecialCreditSt insCommonExport = insCommonExportService.getInsCommonExportBusiness(insInsuranceSlip.getSpecial_id());
			if (insCommonExport != null && insCommonExport.getSpecial_credit_st_id() != null) {
				insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), insCommonExport);
				insInsuranceSlip.setSpecial_id(insCommonExport.getSpecial_credit_st_id());
			}
		}else if((ConstProp.BZX_TB_GCTB.equals(insProduct.getProduct_code()))
				||(ConstProp.BZX_YG_GCTB.equals(insProduct.getProduct_code()))
				||(ConstProp.BZX_DB_GCTB.equals(insProduct.getProduct_code()))){

			SpecialBid specialBid = specialBidService.selectById(insInsuranceSlip.getSpecial_id());
			if (specialBid != null && specialBid.getSpecial_bid_id() != null) {
				insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialBid);
				insInsuranceSlip.setSpecial_id(specialBid.getSpecial_bid_id());
			}
		}else if(ConstProp.BZX_GCLY.equals(insProduct.getProduct_code())){
			SpecialPerformance specialPerformance = specialPerformanceService.selectById(insInsuranceSlip.getSpecial_id());
			if (specialPerformance != null && specialPerformance.getSpecial_performance_id() != null) {
				insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialPerformance);
				insInsuranceSlip.setSpecial_id(specialPerformance.getSpecial_performance_id());
			}
		}else if(ConstProp.BZX_SSBQ.equals(insProduct.getProduct_code())){
			SpecialLitigation specialLitigation = specialLitigationService.getSpecialLitigationBusiness(insInsuranceSlip.getSpecial_id());
			if (specialLitigation != null && specialLitigation.getSpecial_litigation_id() != null) {
				insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialLitigation);
				insInsuranceSlip.setSpecial_id(specialLitigation.getSpecial_litigation_id());
			}
		}else if(ConstProp.GZX.equals(insProduct.getProduct_code().split(ConstProp.MINUS)[0])){
			SpecialPublicDuty specialPublicDuty = specialPublicDutyService.selectById(insInsuranceSlip.getSpecial_id());
			if (specialPublicDuty != null && specialPublicDuty.getSpecial_public_duty_id() != null) {
				insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialPublicDuty);
				insInsuranceSlip.setSpecial_id(specialPublicDuty.getSpecial_public_duty_id());
			}
		}else if(ConstProp.ZZX.equals(insProduct.getProduct_code().split(ConstProp.MINUS)[0])){
			SpecialExhibition specialExhibition = specialExhibitionAPIService.selectById(insInsuranceSlip.getSpecial_id());
			if (specialExhibition != null && specialExhibition.getSpecial_exhibition_id() != null) {
				insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialExhibition);
				insInsuranceSlip.setSpecial_id(specialExhibition.getSpecial_exhibition_id());
			}
		}

		return insInsuranceSlip;
	}

	/**
	 * <b>投保单初始化，联级表初始化创建new InsInsuranceSlipg() </b>
	 *
	 * @param poductID 产品id
	 * @param user_id 用户id
	 * @return
	 * @author ZXF
	 * @date 2017年1月5日 下午3:54:36
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public InsInsuranceSlip initOrderForm(Long poductID,Long user_id, String recommendCode,String trade_serial_number){
		InsInsuranceSlip insInsuranceSlip = new InsInsuranceSlip();
		IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
		if(StringUtils.isEmpty(trade_serial_number)){
			trade_serial_number = String.valueOf(idWorker.nextId());
		}
		insInsuranceSlip.setTrade_serial_number(trade_serial_number);
		insInsuranceSlip.setStart_time(DateUtil.getTimestamp());
		insInsuranceSlip.setSigned_date(DateUtil.getTimestamp());
		insInsuranceSlip.setRegister_user_id(user_id);
		insInsuranceSlip.setRecommend_code(recommendCode);
		insInsuranceSlip.setUnderwrite(insUnderwriteService.initInsUnderwrite());
		insInsuranceSlip.setMailPolicy(insMailPolicyService.initInsMailPolicy());
        insInsuranceSlip.setOrder_status(DictConst.ORDER_STATUS_TBZ);

        ProPrimary insProduct = insProductService.selectById(poductID);
		insInsuranceSlip.setPro_primary(insProduct);
		if(StringUtils.isEmpty(insProduct.getProduct_code())){
			dao.insert(insInsuranceSlip);
			return insInsuranceSlip;
		}
		if(ConstProp.XYX_XWCK.equals(insProduct.getProduct_code())){
			SpecialCreditMicro insMicroExport = insMicroExportService.initInsMicroExport();
			insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()),insMicroExport);
			insInsuranceSlip.setSpecial_id(insMicroExport.getSpecial_credit_micro_id());
		}else if(ConstProp.XYX_DQCK.equals(insProduct.getProduct_code())){
			SpecialCreditSt insCommonExport = insCommonExportService.initInsCommonExport();
			insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()),insCommonExport);
			insInsuranceSlip.setSpecial_id(insCommonExport.getSpecial_credit_st_id());
		}else if((ConstProp.BZX_TB_GCTB.equals(insProduct.getProduct_code()))
				||(ConstProp.BZX_YG_GCTB.equals(insProduct.getProduct_code()))
				||(ConstProp.BZX_DB_GCTB.equals(insProduct.getProduct_code()))){
			SpecialBid specialBid = specialBidService.initInsSpecialBid();
			insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()),specialBid);
			insInsuranceSlip.setSpecial_id(specialBid.getSpecial_bid_id());
		}else if(ConstProp.BZX_GCLY.equals(insProduct.getProduct_code())){
			SpecialPerformance specialPerformance = specialPerformanceService.initInsSpecialPerformance();
			insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()),specialPerformance);
			insInsuranceSlip.setSpecial_id(specialPerformance.getSpecial_performance_id());
		}else if(ConstProp.BZX_SSBQ.equals(insProduct.getProduct_code())){
			SpecialLitigation specialLitigation = specialLitigationService.initSpecialLitigation();
			insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()),specialLitigation);
			insInsuranceSlip.setSpecial_id(specialLitigation.getSpecial_litigation_id());
		}else if(ConstProp.GZX.equals(insProduct.getProduct_code().split(ConstProp.MINUS)[0])){
			SpecialPublicDuty specialPublicDuty = specialPublicDutyService.initSpecialPublicDuty();
			insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()),specialPublicDuty);
			insInsuranceSlip.setSpecial_id(specialPublicDuty.getSpecial_public_duty_id());
		}else if(ConstProp.ZZX.equals(insProduct.getProduct_code().split(ConstProp.MINUS)[0])){
			SpecialExhibition specialExhibition = specialExhibitionAPIService.initSpecialExhibition();
			insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()),specialExhibition);
			insInsuranceSlip.setSpecial_id(specialExhibition.getSpecial_exhibition_id());
		}else if(ConstProp.TYX.equals(insProduct.getProduct_code().split(ConstProp.MINUS)[0])){
			SpecialExhibition specialExhibition = specialExhibitionAPIService.initSpecialExhibition();
			insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()),specialExhibition);
			insInsuranceSlip.setSpecial_id(specialExhibition.getSpecial_exhibition_id());
		}
		dao.insert(insInsuranceSlip);
		return insInsuranceSlip;
	}


	/**
	 * <b>将投保单转换成 InsurePolicyVo</b>
	 *
	 * @param insInsuranceSlip_id
	 * @return
	 * @author ZXF
	 * @date 2017年1月14日 上午11:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public InsurePolicyVo willInsInsuranceSlipChangeIntoInsurePolicyVo(Long insInsuranceSlip_id){
		InsurePolicyVo vo = new InsurePolicyVo();
		InsInsuranceSlip insInsuranceSlip = packagingInsInsuranceSlip(insInsuranceSlip_id);
		if(insInsuranceSlip != null){
			try {
				MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
			} catch (Exception e) {
				e.printStackTrace();
			}
			vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
			vo.setMailPolicy_id(String.valueOf(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id()));
			if(insInsuranceSlip.getUnderwrite() != null){
				vo.setUnderwrite_id(String.valueOf(insInsuranceSlip.getUnderwrite().getUnderwrite_id()));
			}
			vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
		}
		return vo;
	}

	/**
	 * <b>设置保险金额度到投保单父表 </b>
	 *
	 * @param insuredAmount
	 * @param iis
	 * @author ZXF
	 * @date 2017年1月18日 下午5:37:43
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void getInsuredAmountSetToInsInsuranceSlip(BigDecimal insuredAmount, InsInsuranceSlip iis){
		iis.setInsured_amount(insuredAmount);
		dao.updateById(iis);
	}

	/**
	 * <b>生成投保单 </b>
	 *
	 * @param insInsuranceSlip
	 * @author ZXF
	 * @date 2017年1月19日 下午10:10:01
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToOrderIDCreatePolicySerialNumber(InsInsuranceSlip insInsuranceSlip){
		IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
		insInsuranceSlip.setPolicy_serial_number("BCX-"+String.valueOf(idWorker.nextId())+"A");
		dao.updateById(insInsuranceSlip);
	}








	/**
	 * <b>根据订单id查询订单信息及交易详情 </b>
	 *
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 下午1:41:34
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public InsInsuranceSlip getInsOrderForm(Long oid){
		InsInsuranceSlip insOrderForm = dao.selectById(oid);
		if(insOrderForm != null){
			insOrderForm.setInsTransaction(insTransactionService.selectInsTransactionByInsOrderForm(insOrderForm.getIns_insurance_slip_id()));
		}
		return insOrderForm;
	}

	/**
	 * <b>根据订单交易流水号查询订单信息及交易详情 </b>
	 *
	 * @param tradeSerialNumber
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 下午1:41:34
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public InsInsuranceSlip getInsOrderForm(String tradeSerialNumber){
		InsInsuranceSlip insOrderForm = dao.selectByTradeSerialNumber(tradeSerialNumber);
		if(insOrderForm != null){
			insOrderForm.setInsTransaction(insTransactionService.selectInsTransactionByInsOrderForm(insOrderForm.getIns_insurance_slip_id()));
		}
		return insOrderForm;
	}

	/**
	 * <b>根据订单id查询并封装交易详情及投保单信息 </b>
	 *
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 下午1:42:10
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public InsInsuranceSlip packagingInsOrderForm(Long oid){
		return packagingInsInsuranceSlip(oid);
	}


	/**
	 * <b>根据前台用户id跟订单状态查询订单并进行分页 </b>
	 *
	 * @param user_id
	 * @param status
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午8:21:24
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<InsInsuranceSlip> selectInsOrderFormByUserIDAndStatus(Long user_id, String status, DwzPage page){
		Page<InsInsuranceSlip> pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
		List<InsInsuranceSlip> list = new ArrayList<InsInsuranceSlip>();
		List<InsInsuranceSlip> insOrderFormList = dao.selectInsOrderFormByUserIDAndStatus(pageHelper,user_id, status);
		for(InsInsuranceSlip order : insOrderFormList){
			list.add(packagingInsOrderForm(order.getIns_insurance_slip_id()));
		}
		page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
		return list;
	}

	/**
	 * <b>根据前台用户id跟订单状态查询订单并进行分页封装到OrderFormVo </b>
	 *
	 * @param user_id
	 * @param status
	 * @param page
	 * @param keyword 关键字
	 * @param starDate 创建时间区间
	 * @param endDate 创建时间区间
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午8:21:24
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<OrderFormVo> selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(InsOrderSearchVo search){
		List<OrderFormVo> voList = null;
		if(search.getPage() != null){
			Page<OrderFormVo> pageHelper = new Page(search.getPage().getPageNum(), search.getPage().getNumPerPage());
			voList = dao.findOrderFormVoByID(pageHelper,null, search.getUserId(), null, search.getPType(), search.getPolicyStatus(), search.getKeyword(), search.getStarDate(), search.getEndDate(),search.getBusinessType());
			search.getPage().setTotalCount(new Long(pageHelper.getTotal()).intValue());
			for(OrderFormVo vo : voList){
				replenishOrderFormVo(vo);
			}
		}else{
			voList = dao.findOrderFormVoByID(null, search.getUserId(), null, search.getPType(), search.getPolicyStatus(), search.getKeyword(), search.getStarDate(), search.getEndDate(),search.getBusinessType());
			for(OrderFormVo vo : voList){
				replenishOrderFormVo(vo);
			}
		}
		/*List<OrderFormVo> voList = new ArrayList<OrderFormVo>();
		List<InsOrderForm> orderList = selectInsOrderFormByUserIDAndStatus(user_id, status, page);
		for(InsOrderForm order : orderList){
			voList.add(willInsOrderFormSetUpOrderFormVo(order));
		}*/
		return voList;
	}

	/**
	 * <b> 根据产品标识查询已承保但是电子保单地址不存在的订单列表 </b>
	 * @param productCode 产品标识
	 * @author ZXF
	 * @create 2018/04/17 0017 16:10
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public List<OrderFormVo> listOrderFormVoByDzbdIsNot(String productCode){
		List<OrderFormVo> voList = dao.listOrderFormVoByDzbdIsNot(productCode);
		for(OrderFormVo vo : voList){
			replenishOrderFormVo(vo);
		}
		return voList;
	}


	@Override
	public List<OrderFormVo> selectInsOrderFormByStatusAndProductCode( String status, String productCode){
		List<OrderFormVo> voList = dao.selectInsOrderFormByStatusAndProductCode(status, productCode);
		for(OrderFormVo vo : voList){
			replenishOrderFormVo(vo);
		}
		return voList;
	}

	/**
	 * <b>根据前台用户id跟订单状态列表查询订单并进行分页 </b>
	 *
	 * @param user_id
	 * @param statusList
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午8:21:24
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<InsInsuranceSlip> selectInsOrderFormByUserIDAndStatusList(Long user_id, List<String> statusList, DwzPage page){
		Page<InsInsuranceSlip> pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
		List<InsInsuranceSlip> list = new ArrayList<InsInsuranceSlip>();
		List<InsInsuranceSlip> insOrderFormList = dao.selectInsOrderFormByUserIDAndStatusList(pageHelper,user_id, statusList);
		for(InsInsuranceSlip order : insOrderFormList){
			list.add(packagingInsOrderForm(order.getIns_insurance_slip_id()));
		}
		page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
		return list;
	}

	/**
	 * <b>根据前台用户id跟订单状态查询订单并进行分页封装到OrderFormVo </b>
	 *
	 * @param user_id
	 * @param status
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午8:21:24
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<OrderFormVo> selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(Long user_id, String status, DwzPage page){
		List<OrderFormVo> voList = new ArrayList<OrderFormVo>();
		List<InsInsuranceSlip> orderList = selectInsOrderFormByUserIDAndStatus(user_id, status, page);
		for(InsInsuranceSlip order : orderList){
			voList.add(willInsOrderFormSetUpOrderFormVo(order));
		}
		return voList;
	}

	@Override
	public List<OrderFormVo> selectInsOrderFormByUserIDAndStatusListSetUpOrderFormVo(Long user_id, List<String> statusList, String productType, String keyword, String starDate, String endDate, DwzPage page) {
		List<OrderFormVo> voList = null;
		if(page != null){
			Page<OrderFormVo> pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
			voList = dao.findOrderFormVoByID(pageHelper,null, user_id, statusList, productType, null, keyword, starDate, endDate,"");
			page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
			for(OrderFormVo vo : voList){
				replenishOrderFormVo(vo);
			}
		}else{
			voList = dao.findOrderFormVoByID(null, user_id, statusList, productType, null, keyword, starDate, endDate,"");
			for(OrderFormVo vo : voList){
				replenishOrderFormVo(vo);
			}
		}
		/*List<OrderFormVo> voList = new ArrayList<OrderFormVo>();
		List<InsOrderForm> orderList = selectInsOrderFormByUserIDAndStatusList(user_id, statusList, page);
		for(InsOrderForm order : orderList){
			voList.add(willInsOrderFormSetUpOrderFormVo(order));
		}*/
		return voList;
	}


	/**
	 * <b>根据订单状态跟产品标识查询对应的订单信息，用OrderFormVo接收</b>
	 *
	 * @param status
	 * @param productCode
	 * @return
	 * @author ZXF
	 * @date 2017年8月17日 下午9:42:22
	 * @注意事项 </b>
	 * <b>
	 */
//	public List<OrderFormVo> selectInsOrderFormByStatusAndProductCode( String status, String productCode){
//		List<OrderFormVo> voList = dao.selectInsOrderFormByStatusAndProductCode(status, productCode);
//		for(OrderFormVo vo : voList){
//			replenishOrderFormVo(vo);
//		}
//		return voList;
//	}

	/**
	 * <b>将 InsOrderForm 封装到 OrderFormVo</b>
	 *
	 * @param insInsuranceSlip
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午8:42:22
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public OrderFormVo willInsOrderFormSetUpOrderFormVo(InsInsuranceSlip insInsuranceSlip){
		OrderFormVo vo = new OrderFormVo();
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
		ClientUserVo  user = UserSupportUtil.getSessionUser();
		if(user != null){
			vo.setLogin_name(user.getLogin_name());

		}
		if(insInsuranceSlip.getStart_time() != null){
			vo.setStart_time(DateUtil.formatDate(insInsuranceSlip.getStart_time()));
		}
		if(!DictConst.ORDER_STATUS_TBZ.equals(insInsuranceSlip.getOrder_status()) && !DictConst.ORDER_STATUS_DSH.equals(insInsuranceSlip.getOrder_status()) && !DictConst.ORDER_STATUS_YSH.equals(insInsuranceSlip.getOrder_status())){
			InsAgreement insAgreement = insAgreementService.selectInsAgreementByInsInsuranceSlip(insInsuranceSlip.getIns_insurance_slip_id());
			vo.setExternal_reference(insAgreement != null?insAgreement.getExternal_reference():ConstProp.BLANK_CHAR);
		}
		if(insInsuranceSlip.getPremium() != null){
			vo.setGross_premium(String.valueOf(insInsuranceSlip.getPremium()));
			vo.setInsured_amount(String.valueOf(insInsuranceSlip.getInsured_amount()));
		}
		if(insInsuranceSlip.getPro_primary() != null){
			vo.setProduct_oid(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
		}
		if(insInsuranceSlip.getInception_date() != null){
			vo.setInception_date(DateUtil.formatDate(insInsuranceSlip.getInception_date()));
		}
		if(insInsuranceSlip.getPlanned_end_date() != null){
			vo.setPlanned_end_date(DateUtil.formatDate(insInsuranceSlip.getPlanned_end_date()));
		}
		if(StrUtil.isNotBlank(insInsuranceSlip.getPolicy_serial_number())){
			vo.setPolicy_serial_number(insInsuranceSlip.getPolicy_serial_number());
		}
		if(StrUtil.isNotBlank(insInsuranceSlip.getOrder_status())){
			vo.setPolicy_status(insInsuranceSlip.getOrder_status());
		}
		insProductService.accordingToProductIDToGetInsProductSetUpOrderFormVo(vo, insInsuranceSlip.getPro_primary().getPro_primary_id());

		insTransactionService.setOrderFormVoOfShowUrlByOrderID(vo, insInsuranceSlip.getIns_insurance_slip_id());
		if(insInsuranceSlip.getStart_time() != null){
			vo.setStart_time(DateUtil.formatDateTime(insInsuranceSlip.getStart_time()));
		}
		List<InsRoleInpolicy> applicantRoles = insInsuranceSlip.getRolesOfKind(ConstProp.DIGIT_ONE);
		if(applicantRoles != null){
			vo.setApplicant_name(applicantRoles.get(0).getName_cn());
		}
		List<InsRoleInpolicy> insurenceRoles = insInsuranceSlip.getRolesOfKind(ConstProp.DIGIT_TWO);
		if(insurenceRoles != null){
			vo.setInsured_role(insurenceRoles.get(0).getName_cn());
			vo.setBusiness_scope(insurenceRoles.get(0).getBusiness_nature());
			vo.setPolicy_currency(SysDictUtils.getDictLabel(insurenceRoles.get(0).getCurrency_required(), "currencyRequired", ConstProp.BLANK_CHAR));
		}
		ProPrimary insProduct = insProductService.selectById(insInsuranceSlip.getPro_primary().getPro_primary_id());
		if(insProduct != null && ConstProp.XYX_XWCK.equals(insProduct.getProduct_code())){
			SpecialCreditMicro micro = (SpecialCreditMicro) insInsuranceSlip.getMapSpecial().get(String.valueOf(insProduct.getPro_primary_id()));
			vo.setPolicy_currency(SysDictUtils.getDictLabel(micro.getAnnual_currency(), "annualCurrency", ConstProp.BLANK_CHAR));
		}
		return vo;
	}

	/**
	 * <b>将 InsOrderForm 封装到 AdviceNoteVo</b>
	 *
	 * @param insInsuranceSlip
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午8:42:22
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public AdviceNoteVo willInsOrderFormSetUpAdviceNoteVo(InsInsuranceSlip insInsuranceSlip){
		AdviceNoteVo vo = new AdviceNoteVo();
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		InsUnderwrite underwrite =insUnderwriteService.selectById(insInsuranceSlip.getUnderwrite().getUnderwrite_id());

		if(underwrite != null){
			vo.setTotal_rate(String.valueOf(underwrite.getTotal_rate()));
			vo.setYear_premium(String.valueOf(underwrite.getYear_premium()));
			vo.setInitial_premium(String.valueOf(underwrite.getInitial_premium()));
			vo.setPay_methods(underwrite.getPayment_way());
		}
		if(insInsuranceSlip.getPremium() != null){
			vo.setGross_premium(String.valueOf(insInsuranceSlip.getPremium()));
		}
		insProductService.accordingToProductIDToGetInsProductSetUpAdviceNoteVo(vo, insInsuranceSlip.getPro_primary().getPro_primary_id());
		return vo;
	}

	/**
	 * <b>根据前台用户id查找对应订单所有状态的总条目 </b>
	 *
	 * @param user_id
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午9:59:47
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public OrderStatusCountVo selectOrderStatusCountVoByUserID(InsOrderSearchVo searchVo) {
		return dao.selectOrderStatusCountVoByUserID(searchVo);
	}

	/**
	 * <b> 根据保单号和被保险人姓名查询订单 </b>
	 * @author ZXF
	 * @create 2019/09/05 0005 17:53
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Map selectOrderByExAndName(String external_reference, String name) {
		return dao.selectOrderByExAndName(external_reference, name);
	}

	/**
	 * <b>修改订单状态 </b>
	 *
	 * @param vo
	 * @return
	 * @author ZXF
	 * @date 2017年1月12日 上午9:43:07
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public String updateOrderFormStatus(OrderFormVo vo){
		InsInsuranceSlip insInsuranceSlip = dao.selectById(Long.parseLong(vo.getOid()));
		insInsuranceSlip.setOrder_status(vo.getPolicy_status());
		dao.updateById(insInsuranceSlip);
		return insInsuranceSlip.getIns_insurance_slip_id().toString();
	}

	@Override
	public List<InsInsuranceSlip> findAllInsOrderList(String sql) {

		return dao.findAllInsOrderList(sql);
	}

	/**
	 * <b>根据前台获取的买家列表查询相应安全等级再获取产品配的安全等级进行筛选只要跟产品存在的安全等级匹配就创建一条InsRiskDuty数据 </b>
	 *
	 * @param order_id
	 * @author ZXF
	 * @date 2017年1月19日 上午11:03:47
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToInsTopBuyersListGainInsRiskDuty(Long order_id){
		InsInsuranceSlip insInsuranceSlip = packagingInsOrderForm(order_id);
		Long pid = insInsuranceSlip.getPro_primary().getPro_primary_id();
		ProPrimary product = insProductService.getProduct(pid);
		if(product == null ? false : ConstProp.XYX_DQCK.equals(product.getProduct_code())){
			SpecialCreditSt insCommonExport = (SpecialCreditSt) insInsuranceSlip.getMapSpecial().get(String.valueOf(pid));
			List<StTopBuyers> tbList = insCommonExport.getTopBuyers();
			Long underwrite_id = insInsuranceSlip.getUnderwrite().getUnderwrite_id();
			insRiskDutyService.accordingToInsTopBuyersListGainInsRiskDuty(tbList, underwrite_id, pid);
		}
	}

	/**
	 * <b>承保数据更新</b>
	 *
	 * @param vo
	 * @return
	 * @author ZXF
	 * @date 2017年1月12日 上午9:43:07
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void updateOrderUnderwriting(OrderFormVo vo){
		InsInsuranceSlip insInsuranceSlip = packagingInsOrderForm(Long.parseLong(vo.getOid()));
		SimpleDateFormat DATE_FORMAT_6 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
		try {
			insInsuranceSlip.setInception_date(DATE_FORMAT_6.parse(vo.getInception_date()+ConstProp.DAY_00));
			insInsuranceSlip.setPlanned_end_date(DATE_FORMAT_6.parse(vo.getPlanned_end_date()+ConstProp.DAY_23));
		} catch (Exception e) {
			e.printStackTrace();
		}
		insInsuranceSlip.setPremium(new BigDecimal(vo.getGross_premium()));
		dao.updateById(insInsuranceSlip);
		insAgreementService.willInsurePolicyVoChangeIntoInsAgreement(insInsuranceSlip.getIns_insurance_slip_id(), vo.getExternal_reference());
	}

	/**
	 * <b>根据订单id查找对应OrderFormVo信息 </b>
	 *
	 * @param orderId
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午9:59:47
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public OrderFormVo findOrderFormVoByID(Long orderId){
		OrderFormVo vo = null;
		String key = ConstProp.REDIS_HEAD_POLICY_ID+String.valueOf(orderId);
		if(JedisUtils.exists(key)){
			vo = JSON.parseObject(JedisUtils.get(key),OrderFormVo.class);
		}else{
			OrderFormVo orderFormVo = dao.getOrderFormVoByID(orderId);
			if(orderFormVo != null){
				vo = orderFormVo;
				replenishOrderFormVo(vo);
				if(ConstProp.DIGIT_SIX.equals(vo.getPolicy_status())&&StringUtils.isNotEmpty(vo.getExternal_reference())&&StringUtils.isNotEmpty(vo.getInsure_path())){
					//设置3小时过期
					JedisUtils.set(key,JSON.toJSONString(vo), ConstProp.THREE_HOURS_TIMEOUT_SECONDS);
				}
			}
		}
		return vo;
	}

	/**
	 * 根据特殊字段表id查询是否存在有效的订单（排查过期，废弃单）
	 * @param special_id
	 * @return
	 */
	@Override
	public boolean getInsInsuranceSlipBySpecialId(Long special_id){
		boolean flag = false;
		Map<String,Object> m = Maps.newHashMap();
		m.put("special_id",special_id);
		List<InsInsuranceSlip> list = dao.selectByMap(m);
		if(list.size()>0){
			for(InsInsuranceSlip iis : list){
				if(!DictConst.ORDER_STATUS_YGQ.equals(iis.getOrder_status())&&!DictConst.ORDER_STATUS_YFQ.equals(iis.getOrder_status())){
					flag = true;
					break;
				}
			}
		}
		return flag;
	}

	/**
	 * 根据投保单号查询订单OrderFormVo
	 * @param rcptNo
	 * @return
	 */
	@Override
	public OrderFormVo getOrderFormVoByRcptNo( String rcptNo){
		return dao.getOrderFormVoByRcptNo( rcptNo);
	}

	/**
	 * 根据订单编号查询订单OrderFormVo
	 * @param tsNumber
	 * @return
	 */
	@Override
	public OrderFormVo getOrderFormVoByTradeSerialNumber( String tsNumber){
		return dao.getOrderFormVoByTradeSerialNumber( tsNumber);
	}

	/**
	 * 根据保险公司核保时返回的编号查询订单OrderFormVo
	 * @param noticeNo
	 * @return
	 */
	@Override
	public OrderFormVo getOrderFormVoByNoticeNo( String noticeNo){
		return dao.getOrderFormVoByNoticeNo( noticeNo);
	}

	/**
	 * <b>补充 OrderFormVo 数据</b>
	 *
	 * @param vo
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午8:42:22
	 * <b>
	 */
	@Override
	public void replenishOrderFormVo(OrderFormVo vo){

		insTransactionService.setOrderFormVoOfShowUrlByOrderID(vo, Long.parseLong(vo.getOid()));
		if(StringUtils.isEmpty(vo.getProduct_code()) ? false : ConstProp.XYX_XWCK.equals(vo.getProduct_code())){
			String ac = insMicroExportService.getAnnualCurrency(Long.parseLong(vo.getOid()));
			vo.setPolicy_currency(SysDictUtils.getDictLabel(ac, "annualCurrency", ConstProp.BLANK_CHAR));
		}
		if(StringUtils.isNotEmpty(vo.getProduct_oid())){
			vo.setResponsibilityVoList(insProductResponsibilityService.findResponsibilityVoList(vo.getProduct_oid()));
		}
	}


	/**
	 * 查询订单，通过保单号跟被保险人名称
	 * @param externalRefernce 保单号
	 * @param roleName 被保险人名称
	 */
	@Override
	public OrderFormVo findPolicyByExternalAndRoleName(String externalRefernce, String roleName){
		OrderFormVo vo = dao.findPolicyByExternalAndRoleName( externalRefernce);
		if(vo != null){
			if(StringUtils.isNotEmpty(roleName)){
				if(!roleName.equals(vo.getInsured_role())){
					vo = null;
				}
			}
		}
		return vo;
	}


	/**
	 * <b>通过订单id查询产品最低保费及被保险人数量计算保单保费相应设置保费及保额 </b>
	 *
	 * @param insInsuranceSlip
	 * @author ZXF
	 * @date 2017年1月19日 下午10:10:01
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void setPremiumAndCoverageByOrderID(InsInsuranceSlip insInsuranceSlip){
		if(insInsuranceSlip == null){
			return;
		}
		int insuredCount = insRoleInpolicyService.countInsurancedByID(insInsuranceSlip.getIns_insurance_slip_id());
		if(insuredCount<=0){
			return;
		}
		if(insInsuranceSlip.getInception_date() == null){
			return;
		}
		String insTime = DateUtil.formatDate(insInsuranceSlip.getInception_date())+ConstProp.DAY_00;
		if(insInsuranceSlip.getPlanned_end_date() == null){
			//计算终保日期,起保日期加一年
			Calendar c = Calendar.getInstance();
			c.setTime(insInsuranceSlip.getInception_date());
			c.add(Calendar.YEAR, 1);
			c.set(Calendar.DATE, c.get(Calendar.DATE) - 1);
			String plaTime = DateUtil.formatDate(c.getTime())+ConstProp.DAY_23;
			insInsuranceSlip.setPlanned_end_date(DateUtil.parseDateTime(plaTime));
		}
		insInsuranceSlip.setInception_date(DateUtil.parseDateTime(insTime));
		int day = com.bcxin.ins.util.DateUtil.getDistDates(insInsuranceSlip.getInception_date(),insInsuranceSlip.getPlanned_end_date())+1;
		//设置保费
		ProPrimary product = insProductService.getProduct(insInsuranceSlip.getPro_primary().getPro_primary_id());
		if(StringUtils.isEmpty(product.getProduct_code()) || !ConstProp.TYX.equals(product.getProduct_code().split(ConstProp.MINUS)[0])){
			dao.updateById(insInsuranceSlip);
		}
		if(product.getPremium_min() == null){
			dao.updateById(insInsuranceSlip);
		}
		List<ResponsibilityVo> irpVoList = insProductResponsibilityService.findResponsibilityVoList(String.valueOf(product.getPro_primary_id()));
		if(irpVoList.size()<=0){
			insInsuranceSlip.setPremium(getPremium(product.getPremium_min()
					,product.getProduct_code()
					,insInsuranceSlip.getIs_contain_repo(),day).multiply(new BigDecimal(insuredCount+"")));
			//TODO 待设置保额，如果保额从产品获取的话
			dao.updateById(insInsuranceSlip);
		}
		BigDecimal allAm = BigDecimal.ZERO;
		for(ResponsibilityVo vo : irpVoList){
			if(StringUtils.isEmpty(vo.getFcy())){
				continue;
			}
			if(StringUtils.isNotEmpty(vo.getCompensation_days())){
				allAm = allAm.add((BigDecimal.valueOf(Double.parseDouble(vo.getFcy()))).multiply(BigDecimal.valueOf(Double.parseDouble(vo.getCompensation_days()))));
			}else{
				allAm = allAm.add(BigDecimal.valueOf(Double.parseDouble(vo.getFcy())));
			}
		}
		if(!(allAm.compareTo(BigDecimal.ZERO) < 0)){
			insInsuranceSlip.setInsured_amount(allAm.multiply(BigDecimal.valueOf(Double.parseDouble(insuredCount+""))));
		}
		insInsuranceSlip.setPremium(getPremium(product.getPremium_min()
				,product.getProduct_code()
				,insInsuranceSlip.getIs_contain_repo(),day).multiply(BigDecimal.valueOf(Double.parseDouble(insuredCount+""))));
		//TODO 待设置保额，如果保额从产品获取的话
		dao.updateById(insInsuranceSlip);
	}

	/**
	 * <b> 团意险计算保费 </b>
	 * 根据产品初始保费（一个人）、产品类型、是否包含可选保障 来计算保费价格，主要针对人保产品
	 * @param pm 初始保费
	 * @param pCode 产品类型
	 * @param _t 保障类型（0不包含可选，1包含可选一，2包含可选二、3包含可选一二）人保团意险投保页才有这些选项
	 * @author ZXF
	 * @create 2018/09/03 0003 16:22
	 * @version
	 * @注意事项 </b>
	 */
	private BigDecimal getPremium(BigDecimal pm, String pCode, String _t, int sDay){
		if(pCode.contains(ConstProp.TYX_QH)){
			int allPr = 0;
			String _code = pCode;
			if(_code.equals("TYX-QH-DQ-1")){
				if(sDay<2){
					allPr = 8;
				}else if(sDay>1&&sDay<4){
					allPr = 10;
				}else if(sDay>3&&sDay<8){
					allPr = 13;
				}else if(sDay>7&&sDay<16){
					allPr = 18;
				}else if(sDay>15&&sDay<31){
					allPr = 25;
				}
			}else if(_code.equals("TYX-QH-DQ-2")){
				if(sDay<2){
					allPr = 10;
				}else if(sDay>1&&sDay<4){
					allPr = 12;
				}else if(sDay>3&&sDay<8){
					allPr = 15;
				}else if(sDay>7&&sDay<16){
					allPr = 20;
				}else if(sDay>15&&sDay<31){
					allPr = 28;
				}
			}else if(_code.equals("TYX-QH-DQ-3")){
				if(sDay<2){
					allPr = 12;
				}else if(sDay>1&&sDay<4){
					allPr = 14;
				}else if(sDay>3&&sDay<8){
					allPr = 17;
				}else if(sDay>7&&sDay<16){
					allPr = 23;
				}else if(sDay>15&&sDay<31){
					allPr = 30;
				}
			}else if(_code.equals("TYX-QH-DQ-4")){
				if(sDay<2){
					allPr = 14;
				}else if(sDay>1&&sDay<4){
					allPr = 16;
				}else if(sDay>3&&sDay<8){
					allPr = 20;
				}else if(sDay>7&&sDay<16){
					allPr = 28;
				}else if(sDay>15&&sDay<31){
					allPr = 40;
				}
			}else if(_code.equals("TYX-QH-DQ-5")){
				if(sDay<2){
					allPr = 15;
				}else if(sDay>1&&sDay<4){
					allPr = 18;
				}else if(sDay>3&&sDay<8){
					allPr = 23;
				}else if(sDay>7&&sDay<16){
					allPr = 35;
				}else if(sDay>15&&sDay<31){
					allPr = 50;
				}
			}
			return new BigDecimal(allPr+"");
		}else if(pCode.contains(ConstProp.TYX_HT)){
			int allPr = 0;
			String _code = pCode;
			if(_code.equals("TYX-HT-DQ-1")){
				if(sDay<2){
					allPr = 4;
				}else if(sDay>1&&sDay<4){
					allPr = 9;
				}else if(sDay>3&&sDay<8){
					allPr = 11;
				}else if(sDay>7&&sDay<16){
					allPr = 15;
				}else if(sDay>15&&sDay<31){
					allPr = 24;
				}
			}else if(_code.equals("TYX-HT-DQ-2")){
				if(sDay<2){
					allPr = 6;
				}else if(sDay>1&&sDay<4){
					allPr = 11;
				}else if(sDay>3&&sDay<8){
					allPr = 13;
				}else if(sDay>7&&sDay<16){
					allPr = 20;
				}else if(sDay>15&&sDay<31){
					allPr = 28;
				}
			}else if(_code.equals("TYX-HT-DQ-3")){
				if(sDay<2){
					allPr = 8;
				}else if(sDay>1&&sDay<4){
					allPr = 12;
				}else if(sDay>3&&sDay<8){
					allPr = 14;
				}else if(sDay>7&&sDay<16){
					allPr = 23;
				}else if(sDay>15&&sDay<31){
					allPr = 35;
				}
			}else if(_code.equals("TYX-HT-DQ-4")){
				if(sDay<2){
					allPr = 9;
				}else if(sDay>1&&sDay<4){
					allPr = 14;
				}else if(sDay>3&&sDay<8){
					allPr = 16;
				}else if(sDay>7&&sDay<16){
					allPr = 28;
				}else if(sDay>15&&sDay<31){
					allPr = 45;
				}
			}else if(_code.equals("TYX-HT-DQ-5")){
				if(sDay<2){
					allPr = 11;
				}else if(sDay>1&&sDay<4){
					allPr = 16;
				}else if(sDay>3&&sDay<8){
					allPr = 18;
				}else if(sDay>7&&sDay<16){
					allPr = 35;
				}else if(sDay>15&&sDay<31){
					allPr = 55;
				}
			}
			return new BigDecimal(allPr+"");
		}else{
			int p1 = "TYX-RB-3".equals(pCode) ? 30
					: "TYX-RB-4".equals(pCode) ? 40
					: "TYX-RB-5".equals(pCode) ? 50
					: "TYX-RB-6".equals(pCode) ? 60
					: 0 ;
			int p2 = "TYX-RB-3".equals(pCode) ? 260
					: "TYX-RB-4".equals(pCode) ? 350
					: "TYX-RB-5".equals(pCode) ? 430
					: "TYX-RB-6".equals(pCode) ? 530
					: 0 ;
			int plusP = 0;
			if("1".equals(_t)){
				plusP = p1;
			}else if("2".equals(_t)){
				plusP = p2;
			}else if("3".equals(_t)){
				plusP = p1+p2;
			}
			return pm.add(BigDecimal.valueOf(Double.parseDouble(plusP+"")));
		}
	}

	/**
	 * <b> 变更是否成功发送影像字段值，默认变更为1 </b>
	 * @author ZXF
	 * @create 2018/04/28 0028 14:04
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public boolean updateIsSendYX(Long order_id){
		int count = dao.updateIsSendYX(1, order_id);
		return true;
	}

	/**
	 * <b> 设置是否见费 </b>
	 * @author ZXF
	 * @create 2020/04/10 0010 10:55
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public boolean updateIsPolicyBeforePayFee(int isPayFee, Long order_id){
		dao.updateIsPolicyBeforePayFee(isPayFee, order_id);
		return true;
	}

	/**
	 * <b> 设置订单的备注 </b>
	 * @author ZXF
	 * @create 2020/07/02 0002 13:32
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public boolean addRemarksByOrder(String remarks, Long order_id){
		dao.addRemarksByOrder(remarks,order_id);
		return true;
	}

	/**
	 * <b> 根据订单id获取产品编码 </b>
	 * @author ZXF
	 * @create 2020/04/02 0002 14:41
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public String getProductCode(Long order_id){
		return dao.getProductCode(order_id);
	}

	/**
	 * <b> 根据产品标识查询已承保但未有保全结果集记录的订单id(目前产品标识仅限团意险和雇主责任险需要做保全) </b>
	 * @param product_code TYX,GZZRX
	 * @author ZXF
	 * @create 2018/06/05 0005 13:25
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public List<String> selectOrderIdByProductCode(String product_code){
		if(StringUtils.isEmpty(product_code)){
			return null;
		}
		return dao.selectOrderIdByProductCode(product_code);
	}

	/**
	 * <b> 查询将到期保单，第一个日期参数必传 </b>
	 * @author ZXF
	 * @create 2019/04/01 0001 13:51
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public List<Map<String,Object>> findMaturingPolicy(String aDay, String bDay, String cDay){
		if(StringUtils.isEmpty(aDay)){
			return null;
		}
		return dao.findMaturingPolicy(aDay,bDay,cDay);
	}

	/**
	 * <b> 根据保单号列查询保单对应的在保人数 </b>
	 * @author ZXF
	 * @create 2020/04/17 0017 17:30
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public List<Map<String,String>> findZBNumByPolicyNos(String policyNos){
		if(StringUtils.isEmpty(policyNos)){
			return null;
		}
		return dao.findZBNumByPolicyNos(policyNos.split(ConstProp.COMMA));
	}

	/**
	 * <b> 查询平安财雇主的保单号列 </b>
	 * @author ZXF
	 * @create 2020/04/27 0027 11:21
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public List<String> findPolicyNosByPACGZZRX(Long userId){
		return dao.findPolicyNosByPACGZZRX(userId);
	}

	@Override
	public List<String> findPolicyNosByCAGZZRX(Long userId){
		return dao.findPolicyNosByCAGZZRX(userId);
	}

	/**
	 * <b> 根据保单号查询订单id </b>
	 * @author ZXF
	 * @create 2020/04/27 0027 15:16
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public Long getIdByPolicyNo(String policyNo){
		return dao.getIdByPolicyNo(policyNo);
	}

	/**
	 * <b> 通过人员身份证查询保单记录 </b>
	 * @author ZXF
	 * @create 2020/06/24 0024 16:11
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public List<Map<String,Object>> orderList(String idCardNo){
		List<Map<String,Object>> mapList = dao.findPolicyByIdCard(idCardNo);
		String productId;
		for(Map map : mapList){
			productId = map.get("productId") != null ? String.valueOf(map.get("productId")) : "";
			if(StringUtils.isNotEmpty(productId)){
				String bz = dao.getBZContentJsonByProductId(productId);
				if(StringUtils.isNotEmpty(bz)){
					map.put("zrJsonArr",bz);
				}
				String proClauses = dao.getClausesJsonByProductId(productId);
				if(StringUtils.isNotEmpty(proClauses)){
					map.put("proClauses",proClauses);
				}
			}
		}
		return mapList;
	}

	/**
	 * <b> 做批单时，检索生效时间是否是到期时间当天 </b>
	 * @author ZXF
	 * @create 2020/09/07 0007 9:50
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public int isDueToByPolicy(Long orderId,String inception_date){
		return dao.isDueToByPolicy(orderId,inception_date);
	}

	/**
	 * <b> 根据保单号获取回溯记录 </b>
	 * @author ZXF
	 * @create 2024/03/04 0004 10:01
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public List<Map<String,String>> findOperationRecordByExNo(String exNo){
		/*List<Map<String,String>> list = Lists.newArrayList();
		Map<String,String> map = Maps.newHashMap();
		map.put("create_time","2024-02-22 15:14:33");
		map.put("operation_type","投保确认页");
		map.put("path","https://bcxin-blb-test.obs.cn-north-1.myhuaweicloud.com:443/upload%2FinsOperation%2F2024-03-01%2F1709287258356396106.txt");
		list.add(map);
		Map<String,String> map1 = Maps.newHashMap();
		map1.put("create_time","2024-02-23 15:14:33");
		map1.put("operation_type","投保确认页投保页");
		map1.put("path","https://bcxin-blb-test.obs.cn-north-1.myhuaweicloud.com:443/upload%2FinsOperation%2F2024-03-01%2F1709287258356396106.txt");
		list.add(map1);
		return list;*/
		return dao.findOperationRecordByExNo(exNo);
	}

	/**
	 * <b> 投保操作记录保存 </b>
	 * @author ZXF
	 * @create 2021/06/16 0016 17:03
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public int saveInsOperationRecord(String order_id, String sig_id, String operation_type, String path){
		return dao.saveInsOperationRecord(IdWorker.getId(), order_id, sig_id,  operation_type,  path);
	}

	/**
	 * <b> 操作记录更新订单id </b>
	 * @author ZXF
	 * @create 2021/06/16 0016 17:03
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public int updateOrderIdBySigId(String order_id, String sig_id){
		return dao.updateOrderIdBySigId(order_id, sig_id);
	}

	/**
	 * <b> 已承保订单设置来源标识（其它第三方平台录入线下保单并标识来源为百联保的才触发这个更新） </b>
	 * @author ZXF
	 * @create 2021/06/16 0016 17:03
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public int updateWebTypeByEx(String policyNo, String webType){
		Long orderId = dao.getIdByPolicyNo(policyNo);
		comTaskResidualAPIService.saveComTaskResidual("pushOfflineOrderPerson","团意险/雇主责任险在保人员推给PASP平台(线下单关联)","com.bcxin.ins.service.order.PolicyService",1,"String",String.valueOf(orderId));
		return dao.updateWebTypeByEx(policyNo, webType);
	}
}
