package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.common.http.MessageUtils;
import com.bcxin.ins.dao.order.InsBuyersAPIDao;
import com.bcxin.ins.service.order.InsBuyersAPIService;
import com.bcxin.ins.service.order.InsTopBuyersAPIService;
import com.bcxin.ins.entity.common.ComBuyers;
import com.bcxin.ins.entity.policy_special.StTopBuyers;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.TopBuyersVo;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * <b>全球买家业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsBuyersAPIServiceImpl extends ServiceImpl<InsBuyersAPIDao, ComBuyers> implements InsBuyersAPIService {

	@Autowired
	private InsTopBuyersAPIService insTopBuyersService;
	@Autowired
	private InsBuyersAPIDao dao;

	
	
	/**
	 * <b>通过3字段查询是否存在买家，如果没有新建 </b> 
	 * 
	 * @param name
	 * @param address
	 * @param country
	 * @return
	 * @author ZXF 
	 * @date 2017年1月7日 下午5:53:09
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public ComBuyers selectInsBuyersBySomeField(String name, String address, String country){
		ComBuyers insBuyers = dao.selectInsBuyersBySomeField(name, address, country);
		if(insBuyers == null){
			insBuyers = new ComBuyers();
			dao.insert(insBuyers);
		}
		return insBuyers;
	}
	

	/**
	 * 根据 code查找 InsBuyers
	 */
	@Override
	public ComBuyers selectInsBuyersByCode(String code) {
		ComBuyers insBuyers=dao.selectInsBuyersByCode(code);
		return insBuyers;
	}



	/*--------------------------------API 接口业务操作方法-------------------------------------*/

	/**
	 * <b>填充 保单列表选择数据 </b> 
	 */
	@Override
	public Map<String,String> buildDataPolicyChange(String data, DwzPage page) {
		Map<String,String>  map=null;
		map = new HashMap<String, String>();
		if (data == null) {
			return map;
		}
		// JSONObject result=MessageUtils.unPackageMessage(data);
		Long userId = MessageUtils.getLongValueByKey(data, "userId");
		// int pageSize=MessageUtils.getIntegerValueByKey(data,"pageSize");
		int pageNo = MessageUtils.getIntegerValueByKey(data, "pageNo");
		page.setNumPerPage(pageNo);
		map.put("userId", String.valueOf(userId));
		return map;
	}


	/**
	 * <b>填充 买家列表选择数据 </b> 
	 */
	@Override
	public Map<String,String> buildDataBuyerList(String data, DwzPage page) {
		Map<String,String>  map=null;
		map = new HashMap<String, String>();
		Long oid = MessageUtils.getObject(data, Long.class, "oid");
		// int pageSize=MessageUtils.getObject(data,Integer.class,"pageSize");
		int pageNo = MessageUtils.getObject(data, Integer.class, "pageNo");
		page.setNumPerPage(pageNo);
		map.put("oid", String.valueOf(oid));
		return map;
	}

	/**
	 * <b>填充 买家插入数据填充到实体vo </b>
	 */
	@Override
	public Map<String,Object> buildDataTopBuyer(String data) {
		Map<String,Object> map=null;
		map = new HashMap<String, Object>();
		Long oid = MessageUtils.getLongValueByKey(data, "special_id");
		TopBuyersVo vo = MessageUtils.getObject(data, TopBuyersVo.class, "tvo");
		map.put("oid", oid);
		map.put("TopBuyersVo", vo);
		return map;
	}


	@Override
	public Map<String,String> buildDataBuyList(String data, DwzPage page) {
		Map<String,String>  map=null;
		map = new HashMap<String, String>();
		Long special_id = MessageUtils.getLongValueByKey(data, "special_id");
		int pageSize = MessageUtils.getIntegerValueByKey(data, "pageSize");
		int pageNo = MessageUtils.getIntegerValueByKey(data, "pageNo");
		page.setNumPerPage(pageSize);
		page.setPageNum(pageNo);
		map.put("special_id", String.valueOf(special_id));
		return map;
	}


	@Override
	public List<TopBuyersVo> findListNotOid(TopBuyersVo topBuyersVo, DwzPage page) {
		Page<StTopBuyers> pageHelper = new Page<StTopBuyers>(page.getPageNum(), page.getNumPerPage());
		List<StTopBuyers> list=insTopBuyersService.findTopBuyers(pageHelper,page, topBuyersVo);
		page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
		List<TopBuyersVo>  tList= new ArrayList<TopBuyersVo>();
		for (StTopBuyers insTopBuyers : list) {
			TopBuyersVo vo	=insTopBuyersService.accordingToInsTopBuyersIntoTopBuyersVo(insTopBuyers);
			if(vo.getCode()!=null){
				tList.add(vo);
			}
		}
		return tList;
	}



	

	
	


}
