package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.ComPartnersAPIDao;
import com.bcxin.ins.service.order.ComPartnersAPIService;
import com.bcxin.ins.entity.common.ComPartners;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;


@Service
@Transactional(readOnly = true)
public class ComPartnersAPIServiceImpl extends ServiceImpl<ComPartnersAPIDao, ComPartners> implements ComPartnersAPIService {


	@Autowired
	private ComPartnersAPIDao dao;

	@Override
	public List<ComPartners> findComPartnersList(ComPartners comPartners, DwzPage page){
		String ae = "";
		if(comPartners != null){
			if("Y".equals(comPartners.getActive())){
				ae = "Y";
			}
		}
		Page<ComPartners> pageHelper = new Page<ComPartners>(page.getPageNum(), page.getNumPerPage());
		List<ComPartners> list = dao.findComPartnersList(pageHelper,comPartners.getName(),ae);
		page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
		return list;
	}

	@Override
	public boolean uploadFile(MultipartFile file, ComPartners comPartners, String basePath) {
		boolean flag = true;
		try {
			if(file == null || StringUtils.isEmpty(file.getOriginalFilename())) {
				return flag;
			}

			String originalName = file.getOriginalFilename();
			String fileType = originalName.split("\\.").length > 1 ? originalName.split("\\.")[1] : ConstProp.BLANK_CHAR;
			String parentPath = "/policy/partners/" + comPartners.getExternal() + ConstProp.SLASH;
			File baseFile = new File(basePath + parentPath);
			if(!baseFile.exists()){
				baseFile.mkdirs();
			}

			String targetFilePath =  DateUtil.generatorRadomNumber() + (ConstProp.BLANK_CHAR.equals(fileType) ? ConstProp.BLANK_CHAR : (ConstProp.DOT + fileType));

			File targetFile = new File(baseFile, targetFilePath);
			file.transferTo(targetFile);

			comPartners.setDraw_logo_path(parentPath + targetFilePath);
		} catch (Exception e) {
			e.printStackTrace();
			flag = false;
		}

		return flag;
	}

	@Override
	public boolean deleteLogoFile(String path, ComPartners comPartners) {
		boolean flag = true;

		if (path != null) {
			File file = new File(path);
			try {
				Files.delete(file.toPath());
			} catch (IOException e) {
				e.printStackTrace();
			}
		}

		comPartners.setDraw_logo_path(null);

		return flag;
	}

	@Override
	public boolean deleteConfirmationFile(String path, ComPartners comPartners) {
		boolean flag = true;

		if (path != null) {
			File file = new File(path);
			try {
				Files.delete(file.toPath());
			} catch (IOException e) {
				e.printStackTrace();
			}
		}

		comPartners.setDraw_cooperation_path(null);

		return flag;
	}

	@Override
	public boolean upConfirmationFile(MultipartFile confirmationFile, ComPartners comPartners, String path) {
		boolean flag = true;
		try {
			if(confirmationFile == null || StringUtils.isEmpty(confirmationFile.getOriginalFilename())) {
				return flag;
			}

			String originalName = confirmationFile.getOriginalFilename();
			String fileType = originalName.split("\\.").length > 1 ? originalName.split("\\.")[1] : ConstProp.BLANK_CHAR;
			String parentPath = "/policy/partners/" + comPartners.getExternal() + ConstProp.SLASH;
			File baseFile = new File(path + parentPath);
			if(!baseFile.exists()){
				baseFile.mkdirs();
			}

			String targetFilePath =  DateUtil.generatorRadomNumber() + ("".equals(fileType) ? ConstProp.BLANK_CHAR : (ConstProp.DOT + fileType));

			File targetFile = new File(baseFile, targetFilePath);
			confirmationFile.transferTo(targetFile);

			comPartners.setDraw_cooperation_path(parentPath + targetFilePath);
		} catch (Exception e) {
			e.printStackTrace();
			flag = false;
		}

		return flag;
	}
}
