package com.bcxin.ins.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.util.HttpUtil;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.util.Constant;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.OrderFormVo;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class OrderSupportUtil1 {


//    private final static String  URL ="http://192.168.30.147:8080/";
    private final static String  URL ="http://120.76.218.179:9113/"; //测试环境

    //1.3.1.订单推送给支撑接口地址
    private  final  static  String  ORDER_SYNCHRONIZATION="/api/webOrderForm/receiveOrderFormData";

    //1.3.1.交易推送给支撑接口地址
    private  final  static  String  TRAN_SYNCHRONIZATION="/api/webOrderForm/receiveOrderPaymentData";

    //1.3.3.订单撤单
    private  final  static  String  ORDER_CANCELLATIONS="/api/webOrderForm/cancellationOrder";

    public static  String  receiveOrderFormData(OrderFormVo orderVo,InsInsuranceSlip policy, InsTransaction itn){//有效订单推送
        //需要记录请求记录信息
        String  url =URL+ORDER_SYNCHRONIZATION;
        Map<String,Object> orderMap = new HashMap<String,Object>();
        orderMap.put("sign",Constant.WEB_TYPE_COINS);//订单编号
        orderMap.put("orderNumber",policy.getTrade_serial_number());//订单编号
        orderMap.put("sign",Constant.WEB_TYPE_COINS);//平台标识(来源)
        orderMap.put("orderDate", policy.getSigned_date() == null ? ConstProp.BLANK_CHAR : DateUtil.convertDateToString(policy.getSigned_date(),DateUtil.FORMAT1));//购买时间
        String paymentMethod = ConstProp.BLANK_CHAR;
        String stagesNumber = ConstProp.BLANK_CHAR;
        if(policy.getUnderwrite() != null){
            paymentMethod = policy.getUnderwrite().getPayment_way();
            stagesNumber = ConstProp.DIGIT_ONE.equals(paymentMethod) ? ConstProp.DIGIT_ONE
                    : ConstProp.DIGIT_TWO.equals(paymentMethod) ? ConstProp.DIGIT_FOUR
                    : null;
        }else{
            if(itn != null){
                paymentMethod = itn.getPayment_method();
                stagesNumber = ConstProp.DIGIT_ONE.equals(itn.getPayment_method()) ? ConstProp.DIGIT_ONE
                        : ConstProp.DIGIT_TWO.equals(itn.getPayment_method()) ? ConstProp.DIGIT_FOUR
                        : null;
            }
        }
        orderMap.put("paymentMethod",paymentMethod);//缴费方式
        orderMap.put("stagesNumber", stagesNumber);//分期期数
        orderMap.put("currency","CNY");//币种
        orderMap.put("startDate",DateUtil.convertDateToString(policy.getInception_date(),DateUtil.FORMAT1));//订单有效期
        orderMap.put("endDate",DateUtil.convertDateToString(policy.getPlanned_end_date(),DateUtil.FORMAT1));//订单失效期
        orderMap.put("invoiceType",policy.getMailPolicy().getInvoice_type());//发票类型
        orderMap.put("productId",String.valueOf(policy.getPro_primary().getPro_primary_id()));//产品ID
        orderMap.put("webUserId",String.valueOf(policy.getRegister_user_id()));//购买用户id
        orderMap.put("province",policy.getProvince());//省
        orderMap.put("city",policy.getCity());//市
        orderMap.put("district",policy.getArea_code());//区/县
        orderMap.put("address","");//详细地址
        orderMap.put("distributorId",policy.getRecommend_code());//所属分销商
        orderMap.put("fcy",policy.getPremium());//订单金额
        orderMap.put("webOrderFormId",orderVo.getOid());//订单id
        if(itn != null){
            orderMap.put("orderPayment.paymentPeriod","");//付款期限
            orderMap.put("orderPayment.payDate",DateUtil.convertDateToString(itn.getStart_time(),DateUtil.FORMAT1));//支付日期
            orderMap.put("orderPayment.payCode",itn.getPay_order_number());//支付编号
            orderMap.put("orderPayment.paySerialNumber",itn.getTrade_serial_number());//支付流水号
            orderMap.put("orderPayment.paymentMethod",itn.getPayment_method());//支付方式
            orderMap.put("orderPayment.remainingNumber",String.valueOf(policy.getInsTransaction().size()));//支付期数
            orderMap.put("orderPayment.currentPayable",itn.getPay_amount());//本期应付
            orderMap.put("orderPayment.actualPayment",itn.getPay_amount());//实际支付
        }else{
            orderMap.put("orderPayment.paymentPeriod","");//付款期限
            orderMap.put("orderPayment.payDate",DateUtil.getCurrentDate());//支付日期
            orderMap.put("orderPayment.payCode","0");//支付编号
            orderMap.put("orderPayment.paySerialNumber","0");//支付流水号
            orderMap.put("orderPayment.paymentMethod","");//支付方式
            orderMap.put("orderPayment.remainingNumber",null);//支付期数
            orderMap.put("orderPayment.currentPayable",String.valueOf(policy.getPremium().divide(new BigDecimal(stagesNumber))));//本期应付
            orderMap.put("orderPayment.actualPayment","0");//实际支付
        }
        try {
            String result= HttpUtil.doPost(url, orderMap);
            JSONObject  json = JSON.parseObject(result);
            if(json!=null&&json.get("success").toString().equals("true")){
                return json.get("data").toString();
            }
        }catch (Exception ex){
            ex.printStackTrace();
        }
        return "";
    }

    public static  boolean  receiveTrancetionData(InsInsuranceSlip policy, InsTransaction itn){//有效订单推送
        //需要记录请求记录信息
        String  url =URL+TRAN_SYNCHRONIZATION;
        Map<String,Object> tranMap = new HashMap<String,Object>();
        tranMap.put("paymentPeriod","");//付款期限
        tranMap.put("payDate",DateUtil.convertDateToString(itn.getStart_time(),DateUtil.FORMAT1));//支付日期
        tranMap.put("payCode",itn.getPay_order_number());//支付编号
        tranMap.put("paySerialNumber",itn.getTrade_serial_number());//支付流水号
        tranMap.put("paymentMethod",itn.getPayment_method());//支付方式
        tranMap.put("remainingNumber",String.valueOf(policy.getInsTransaction().size()));//支付期数
        tranMap.put("currentPayable",itn.getPay_amount());//本期应付
        tranMap.put("actualPayment",itn.getPay_amount());//实际支付
        tranMap.put("orderFormId",policy.getOrder_zc_id());//实际支付
        try {
            String result= HttpUtil.doPost(url, tranMap);
            JSONObject  json = JSON.parseObject(result);
            if(json!=null&&json.get("success").toString().equals("true")){
                return true;
            }
        }catch (Exception ex){
            ex.printStackTrace();
        }
        return   false;
    }

    public static  boolean  cancellationOrder(String tradeSerialNumber){//撤单
        //需要记录请求记录信息
        String  url =URL+ORDER_CANCELLATIONS;
        StringBuffer params =new StringBuffer("sign="+ Constant.WEB_TYPE_COINS+"&webType="+Constant.WEB_TYPE_COINS);

        if(StringUtils.isNotEmpty(tradeSerialNumber)){
            params.append("&data="+tradeSerialNumber);
        }
        try {
            String s= RequestUtil.sendPost(url, params.toString());
            JSONObject  json = JSON.parseObject(s);
            if(json!=null&&json.get("success").toString().equals("true")){
                return true;
            }
        }catch (Exception ex){
            ex.printStackTrace();
        }
        return   false;
    }

    public static HttpServletRequest getRequest(){
        if(RequestContextHolder.getRequestAttributes() != null){
            return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        }else{
            return null;
        }
    }

    public static void main(String[] args) {
//        getUserSynchronization();
    }
}