package com.bcxin.ins.dao.order;

import com.bcxin.ins.entity.policy_report.InsCommonReport;
import com.bcxin.ins.entity.policy_special.Hireling;
import com.bcxin.ins.spring.annotation.MyBatisDao;
import com.bcxin.ins.vo.HirelingVo;
import com.bcxin.ins.vo.excel.ResultSetExcelVo;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.mybatisplus.mapper.BaseMapper;
import com.bcxin.mybatisplus.plugins.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;


/**
 * <b> 保险理赔 </b>
 * @author ZXF
 * @create 2019/11/19 0019 15:05
 * @version
 * @注意事项 </b>
 */
@MyBatisDao
public interface InsCommonReportAPIDao extends BaseMapper<InsCommonReport> {

    InsCommonReportVo getInsCommonReportVoById(@Param("oid") Long oid);

    /**
     * <b> 保存报案号 </b>
     * @author ZXF
     * @create 2019/11/27 0027 10:44
     * @version
     * @注意事项 </b>
     */
    void updateReportNo(InsCommonReportVo vo);

    void updateStatusById(@Param("report_id") Long report_id);

    /**
     * <b> 修改报案状态 </b>
     * @author ZXF
     * @create 2019/11/28 0028 16:55
     * @version
     * @注意事项 </b>
     */
    void updateStatus(@Param("status") String status, @Param("end_case_date") String end_case_date, @Param("report_id") Long report_id);

    /**
     * <b> 保存理赔信息 </b>
     * @author ZXF
     * @create 2019/11/27 0027 10:44
     * @version
     * @注意事项 </b>
     */
    void updateResult(InsCommonReportVo vo);

    /**
     * <b> 根据用户Id查询报案列表 </b>
     * @author ZXF
     * @create 2019/11/19 0019 17:51
     * @version
     * @注意事项 </b>
     */
    List<InsCommonReportVo> selectInsCommonReportVoListByOrderID(Page<InsCommonReportVo> page, @Param("keyword") String keyword
            , @Param("status") String status
            , @Param("startDate") String startDate
            , @Param("endDate") String endDate
            , @Param("user_id") Long user_id);

    List<Map<String,String>> selectReportListByIdCardNo(@Param("status") String status, @Param("saasIdCardNo") String saasIdCardNo);

    /**
     * <b> 查询订单的在保人员拼装数据，例：张*(4406**********4213),张三(440612345678904213);李*(4406**********4213),张四(440612345678904213); </b>
     * @author ZXF
     * @create 2020/06/03 0003 17:20
     * @version
     * @注意事项 </b>
     */
    List<String> getZBRYByOrderId(@Param("oid") Long oid);

    String getProductCodeByReportId(@Param("reportId") Long reportId);
}
