/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.storage;

import com.pingan.iobs.core.exception.IobsCoreException;
import com.pingan.iobs.core.model.Context;
import com.pingan.iobs.core.model.PutResult;
import com.pingan.iobs.core.service.FileService;
import com.pingan.iobs.sdk.common.Config;
import com.pingan.iobs.sdk.common.IOBSException;
import com.pingan.iobs.sdk.http.HttpClientFactory;
import com.pingan.iobs.sdk.repkg.com.google.gson.Gson;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpResponse;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.HttpClient;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.methods.HttpPost;
import com.pingan.iobs.sdk.repkg.org.apache.http.util.EntityUtils;
import com.pingan.iobs.sdk.storage.Persistent.FileRecorder;
import com.pingan.iobs.sdk.storage.UploadBlock;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResumeUploader {
    private final String upToken;
    private final String bucket;
    private final String key;
    private final File file;
    private final FileRecorder recorder;
    private List<Context> contextList;
    private RandomAccessFile randomAccessFile;
    private FileService fileService;
    private static final String MKFILE_SERVICE = "/mkfile";

    public ResumeUploader(String upToken, String bucket, String key, File file) throws IOBSException {
        try {
            this.upToken = upToken;
            this.bucket = bucket;
            this.key = key;
            this.file = file;
            this.recorder = new FileRecorder(System.getProperty("java.io.tmpdir") + File.separator + "iobs");
            this.randomAccessFile = new RandomAccessFile(file, "r");
            this.fileService = new FileService();
        }
        catch (IOException e) {
            throw new IOBSException(e);
        }
    }

    public PutResult execute() throws IOBSException {
        try {
            this.contextList = this.getContextList();
            this.sliceAndUpload();
            PutResult putResult = this.mkFile();
            this.recorder.del(this.bucket, this.key);
            PutResult putResult2 = putResult;
            return putResult2;
        }
        catch (Exception e) {
            throw new IOBSException(e);
        }
        finally {
            try {
                this.randomAccessFile.close();
            }
            catch (IOException e) {
                throw new IOBSException(e);
            }
        }
    }

    private void sliceAndUpload() throws IOException, InterruptedException, IOBSException {
        for (Context ctx : this.contextList) {
            if (ctx.isUploadOver()) continue;
            this.uploadBlock(ctx);
            this.recordContextList();
        }
    }

    private PutResult mkFile() throws IOException, IobsCoreException, NoSuchAlgorithmException, InterruptedException {
        String respMsg = null;
        HttpPost httpPost = null;
        try {
            Map<String, String> paramMap = this.getParamMap();
            String mkFileUrl = this.getMkFileUrl();
            String mkFileUrlWithParams = this.createUrlWithParams(paramMap, mkFileUrl);
            HttpClient httpClient = HttpClientFactory.createHttpClient();
            httpPost = new HttpPost(mkFileUrlWithParams);
            HttpResponse resp = httpClient.execute(httpPost);
            respMsg = EntityUtils.toString(resp.getEntity(), "UTF-8");
            PutResult putResult = new Gson().fromJson(respMsg, PutResult.class);
            this.releaseConnection(httpPost);
            return putResult;
        }
        catch (Exception e) {
            try {
                throw new IobsCoreException(respMsg);
            }
            catch (Throwable throwable) {
                this.releaseConnection(httpPost);
                throw throwable;
            }
        }
    }

    private void releaseConnection(HttpPost post) {
        if (post != null) {
            post.releaseConnection();
        }
    }

    public String getMkFileUrl() {
        StringBuffer sb = new StringBuffer();
        return sb.append(Config.HOST).append(MKFILE_SERVICE).append("/").append(this.bucket).append("/").append(this.key).toString();
    }

    private String createUrlWithParams(Map<String, String> paramMap, String basicUrl) {
        StringBuffer sb = new StringBuffer();
        sb.append(basicUrl).append("?");
        for (String key : paramMap.keySet()) {
            sb.append(key).append("=").append(paramMap.get(key)).append("&");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private Map<String, String> getParamMap() throws IOException, NoSuchAlgorithmException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String md5 = this.bigFileMD5(this.file);
        paramMap.put("token", this.upToken);
        paramMap.put("fileSize", String.valueOf(this.file.length()));
        paramMap.put("fileName", this.file.getName());
        paramMap.put("md5", md5);
        return paramMap;
    }

    private String bigFileMD5(File bigFile) throws NoSuchAlgorithmException, IOException {
        StringBuilder sb = new StringBuilder();
        FileInputStream fis = new FileInputStream(bigFile);
        byte[] bytes = new byte[Config.BLOCK_SIZE];
        int len = 0;
        while ((len = fis.read(bytes)) != -1) {
            if (len != Config.BLOCK_SIZE) {
                int remainLen = (int)(bigFile.length() % (long)Config.BLOCK_SIZE);
                sb.append(this.fileService.MD5(Arrays.copyOf(bytes, remainLen)));
                continue;
            }
            sb.append(this.fileService.MD5(bytes));
        }
        fis.close();
        return this.fileService.MD5(sb.toString().getBytes());
    }

    private void uploadBlock(Context context) throws IOException, InterruptedException, IOBSException {
        long start = (context.getBlockId() - 1) * Config.BLOCK_SIZE;
        int len = (int)Math.min((long)Config.BLOCK_SIZE, this.file.length() - start);
        UploadBlock uploadBlock = new UploadBlock(this, context, start, len, this.randomAccessFile);
        uploadBlock.execute();
    }

    private List<Context> getContextList() throws IOException {
        byte[] bytes = this.recorder.get(this.bucket, this.key);
        if (bytes == null) {
            return this.recorder.initRecorder(this.file, this.bucket, this.key);
        }
        return this.recorder.getRecordCtxList(this.bucket, this.key);
    }

    public void recordContextList() {
        String contextListJson = new Gson().toJson(this.contextList);
        this.recorder.set(this.bucket, this.key, contextListJson.getBytes());
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getUpToken() {
        return this.upToken;
    }

    public String getKey() {
        return this.key;
    }

    public File getFile() {
        return this.file;
    }
}

