/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.repkg.org.apache.http.client.protocol;

import com.pingan.iobs.sdk.repkg.org.apache.http.Header;
import com.pingan.iobs.sdk.repkg.org.apache.http.HeaderElement;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpEntity;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpException;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpResponse;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpResponseInterceptor;
import com.pingan.iobs.sdk.repkg.org.apache.http.annotation.Immutable;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.entity.DeflateDecompressingEntity;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.entity.GzipDecompressingEntity;
import com.pingan.iobs.sdk.repkg.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.util.Locale;

@Immutable
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public static final String UNCOMPRESSED = "http.client.response.uncompressed";

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Header ceheader;
        HttpEntity entity = response.getEntity();
        if (entity != null && entity.getContentLength() != 0L && (ceheader = entity.getContentEncoding()) != null) {
            HeaderElement[] codecs = ceheader.getElements();
            boolean uncompressed = false;
            int i$ = 0;
            HeaderElement[] arr$ = codecs;
            int len$ = arr$.length;
            if (i$ < len$) {
                HeaderElement codec = arr$[i$];
                String codecname = codec.getName().toLowerCase(Locale.ENGLISH);
                if ("gzip".equals(codecname) || "x-gzip".equals(codecname)) {
                    response.setEntity(new GzipDecompressingEntity(response.getEntity()));
                    uncompressed = true;
                } else if ("deflate".equals(codecname)) {
                    response.setEntity(new DeflateDecompressingEntity(response.getEntity()));
                    uncompressed = true;
                } else {
                    if ("identity".equals(codecname)) {
                        return;
                    }
                    throw new HttpException("Unsupported Content-Coding: " + codec.getName());
                }
            }
            if (uncompressed) {
                response.removeHeaders("Content-Length");
                response.removeHeaders("Content-Encoding");
                response.removeHeaders("Content-MD5");
            }
        }
    }
}

