package com.bcxin.ins.third.gzx.pingancai;

import com.bcxin.ins.entity.common.LogBusinessrequest;
import com.bcxin.ins.service.order.LogBusinessrequestService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.SpecialPublicDutyVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.Map;


/**
 *
 * <b>平安财-公责险http接口请求业务</b>
 *
 * @author zxf
 * @date 2017年10月11日 上午10:29:46
 * @注意事项 </b>
 * <b>
 */
@Service("gZX_PACRequestService")
@Transactional
public class GZX_PACRequestService {

	private Logger communicatorLog =  LoggerFactory.getLogger(GZX_PACRequestService.class);

	@Autowired
	private PolicyService policyService;
	@Autowired
	private LogBusinessrequestService logBusinessrequestService;


	/**
	 * 平安请求方法
	 * 
	 * @return
	 */
	public String requestPAC(Long order_id, String transType, Map<String,String> map) throws Exception {
		communicatorLog.info("requestPAC-GZX：star-----------------------");
		communicatorLog.info("requestPAC-GZX：接口编码-"+transType+",订单id-"+order_id+",MAP-"+(map != null ? map.toString() : "null"));
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(order_id);
		SpecialPublicDutyVo vo = policyService.accordingToOrderIDToGetSpecialPublicDutyVo(Long.parseLong(dto.getOid()));
		String result = "300#（APP-PAC-GZX-001）网络不稳定，请重新请求！";
		LogBusinessrequest lb = null;
		try {
			String json = GZX_PackageMessagePingAnCai.marshal(vo, dto, transType, map);
			communicatorLog.info("请求报文："+json);
			String url = GlobalResources.PN_INS_URL + "/open/"+getUrlByTransType(transType)+"?access_token="+policyService.pnc_access_token();
			communicatorLog.info("请求地址："+url);
			Date bTime = new Date();
			String ret = RequestUtil.initHttp().doPostByAccept(url, json, "application/json", "UTF-8");
			lb = logBusinessrequestService.initLogBusinessrequest(String.valueOf(order_id),transType,url,json,ret,bTime,new Date(), TransTypeEnum.getAlias(transType));
			communicatorLog.info("返回报文："+ret);
			result = GZX_PackageMessagePingAnCai.returnAnalysisJson(ret,transType);
			communicatorLog.info("返回报文处理："+result);
			logBusinessrequestService.supplementDecAndSave(lb,result.startsWith(ConstProp.CODE_FAILURE)?1:0,ConstProp.BLANK_CHAR);
		}catch (Exception ex){
			logBusinessrequestService.supplementDecAndSave(lb,2,ex.getMessage());
			ex.printStackTrace();
		}
		communicatorLog.info("requestPAC-GZX：end-----------------------");
		return result;
	}

	private static String getUrlByTransType(String type){
		if("1".equals(type)){//核保
			return "/appsvr/property/standardGroupPropertyFeeApply";
		}else if("2".equals(type)){//承保
			return "/appsvr/property/standardGroupPropertyFeeAccept";
		}else if("3".equals(type)){//电子保单打印
			return "/appsvr/property/ePasElectronicPolicy";
		}
		return "";
	}
}
