package com.bcxin.ins.service.user;

import com.bcxin.ins.entity.user.SysClientUser;
import com.bcxin.ins.util.email.EmailMsgType;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.mybatisplus.service.IService;

import java.util.Map;

public interface ClientUserService extends IService<SysClientUser> {


    boolean saveClientUserVo(ClientUserVo vo);

    boolean getUserMobileForRegister(String mobile, String webType);

    boolean getUserEmailForRegister(String email, String webType);

    boolean sendEmailToUser(String email, String emailTitle, String emailContent);

    public boolean sendEmailToService( String emailTitle, String emailContent);

    boolean checkUserExist(String email, boolean isUserName);

    String sendUserCode(String email, EmailMsgType authcode);

    ClientUserVo getClientUserVo(String email, String type);

    public ClientUserVo getClientUserVoForThir(String webId, String webType);

    boolean updClientUserVoPwd(ClientUserVo vo, String password);

    ClientUserVo initNewUser(Map<String, Object> map);

//    Map<String,Object> loginStatus(String userName, String password);

    boolean updClientUserVoInfo(ClientUserVo vo, String realName, String realCard);

    boolean updClientUserVoEmail(ClientUserVo vo, String email);

    boolean updClientUserVoPhone(ClientUserVo vo, String phone);

    boolean  saveClientUserVo(String webType, String webUserName, String userWebId);

    /**
     * <b> 第三方请求过来触发的注册用户状态 </b>
     * @author ZXF
     * @create 2020/08/14 0014 14:20
     * @version
     * @注意事项 </b>
     */
    boolean saveClientUserVoForTHR(String webType, String webUserName,String userWebId, String token);

    /**
     * <b> 第三方绑定已有账号 </b>
     * @author ZXF
     * @create 2024/04/07 0007 14:55
     * @version
     * @注意事项 </b>
     */
    boolean bindClientUser(String webType, String mobile, String webUserName, String userWebId);

    void setLastTime(ClientUserVo userVo);

    SysClientUser getClientUser(String userName, String type);

    boolean getUserPassword(String login_name, String newPwd);

    /**
     * <b> 百联保用户信息绑定第三方平台标识 </b>
     * @author ZXF
     * @create 2024/01/29 0029 10:05
     * @version
     * @注意事项 </b>
     */
    boolean bindThrUser(String webId, String webUsername, String phone, String userId, String webType);
}