package com.bcxin.ins.service.order.impl;


import com.bcxin.ins.dao.order.InsMicroExportAPIDao;
import com.bcxin.ins.service.order.InsMicroExportAPIService;
import com.bcxin.ins.entity.policy_special.SpecialCreditMicro;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.MicroExportVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


/**
 * <b>小微企业特殊字段业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsMicroExportAPIServiceImpl extends ServiceImpl<InsMicroExportAPIDao, SpecialCreditMicro> implements InsMicroExportAPIService {

	@Autowired
	private InsMicroExportAPIDao dao;


	@Override
	public SpecialCreditMicro initInsMicroExport(){
		SpecialCreditMicro insMicroExport = new SpecialCreditMicro();//
		dao.insert(insMicroExport);
		return insMicroExport;
	}

	/**
	 * <b>根据Vo及小微出口ID更新InsMicroExport数据 </b>
	 *
	 * @param vo
	 * @param microID 小微出口id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheMicroExportVoSetUpInsMicroExport(MicroExportVo vo, Long microID){
		SpecialCreditMicro insMicroExport = dao.selectById(microID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insMicroExport);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(insMicroExport);
	}

	/**
	 * <b>获取MicroExportVo根据小微出口id查询小微出口信息插入到MicroExportVo </b>
	 *
	 * @param vo 小微出口辅助表
	 * @param microID 小微出口id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void getMicroExportVoByPolicyID(MicroExportVo vo, Long microID){
		SpecialCreditMicro insMicroExport = dao.selectById(microID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insMicroExport), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * <b> 根据订单id获取币种 </b>
	 * @author ZXF
	 * @create 2018/08/21 0021 16:32
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public String getAnnualCurrency(Long orderID) {
		return dao.getAnnualCurrency(orderID);
	}
}
