/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.tyx.taikang;

import com.bcxin.ins.entity.common.LogBusinessrequest;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.order.LogBusinessrequestService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.third.tyx.taikang.PackageMessageTK;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.vo.GMRPolicyVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tKRequestService")
@Transactional
public class TKRequestService {
    private Logger communicatorLog = LoggerFactory.getLogger((String)"commuLog");
    @Autowired
    private PolicyService policyService;
    @Autowired
    private LogBusinessrequestService logBusinessrequestService;

    public String requestTK(Long order_id, String transType) {
        String url = GlobalResources.TK_INS_URL;
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        GMRPolicyVo vo = null;
        if (!StringUtils.isNotEmpty((CharSequence)transType)) {
            return "300#\uff08APP-TK-001\uff09\u6570\u636e\u4e22\u5931\uff01";
        }
        vo = this.policyService.accordingToOrderIDToGetGMRPolicyVo(Long.parseLong(dto.getOid()));
        String result = "300#\uff08APP-TK-TYX-001\uff09\u7f51\u7edc\u4e0d\u7a33\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8bf7\u6c42\uff01";
        LogBusinessrequest lb = null;
        try {
            String data = PackageMessageTK.marshal(vo, dto, transType);
            this.communicatorLog.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + data);
            this.communicatorLog.info("request url:" + url);
            Date bTime = new Date();
            String ret = RequestUtil.initHttp().doPost(url, data, "application/json", "UTF-8");
            lb = this.logBusinessrequestService.initLogBusinessrequest(String.valueOf(order_id), transType, url, data, ret, bTime, new Date(), TransTypeEnum.getAlias((String)transType));
            this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587\uff1a" + ret);
            result = PackageMessageTK.returnAnalysisJson(ret);
            this.logBusinessrequestService.supplementDecAndSave(lb, result.startsWith("300") ? 1 : 0, "");
        }
        catch (Exception ex) {
            this.logBusinessrequestService.supplementDecAndSave(lb, 2, ex.getMessage());
            ex.printStackTrace();
        }
        return result;
    }
}

