/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.tyx.pingan.util;

import com.bcxin.ins.third.tyx.pingan.util.Base64Utils;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public class PaRsaUtils {
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA512withRSA";
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";
    private static final int MAX_ENCRYPT_BLOCK = 245;
    private static final int MAX_DECRYPT_BLOCK = 256;

    public static void main(String[] args) throws Exception {
        Map<String, Object> keyMap = PaRsaUtils.genKeyPair();
        String privateKey = PaRsaUtils.getPrivateKey(keyMap);
        String publicKey = PaRsaUtils.getPublicKey(keyMap);
        System.out.println("\u79c1\u94a5\uff1a" + privateKey);
        System.out.println("\u516c\u94a5\uff1a" + PaRsaUtils.getPublicKey(keyMap));
        String content = "RSA\u52a0\u5bc6\u3001\u89e3\u5bc6\u6d4b\u8bd5\u9a8c\u8bc1{\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1\u3001\u957f\u6587\u672c\u6570\u636e\u9a8c\u8bc1}";
        System.out.println("\u660e\u6587\u6570\u636e\uff1a");
        System.out.println(content);
        System.out.println("==================Start \u516c\u94a5\u52a0\u5bc6\uff0c\u79c1\u94a5\u89e3\u5bc6\u9a8c\u8bc1==================");
        byte[] encryptByPublicKey = PaRsaUtils.encryptByPublicKey(content.getBytes(), publicKey);
        System.out.println("\u516c\u94a5\u52a0\u5bc6\u5bc6\u6587\uff1a");
        System.out.println(Base64Utils.encode(encryptByPublicKey));
        byte[] decryptByPrivateKey = PaRsaUtils.decryptByPrivateKey(encryptByPublicKey, privateKey);
        System.out.println("\u79c1\u94a5\u89e3\u5bc6\u7ed3\u679c\uff1a");
        System.out.println(new String(decryptByPrivateKey));
        System.out.println("==================End \u516c\u94a5\u52a0\u5bc6\uff0c\u79c1\u94a5\u89e3\u5bc6\u9a8c\u8bc1==================");
        System.out.println("==================Start \u79c1\u94a5\u7b7e\u540d\uff0c\u516c\u94a5\u9a8c\u8bc1\u7b7e\u540d==================");
        String sign = PaRsaUtils.sign(content.getBytes(), privateKey);
        System.out.println("\u79c1\u94a5\u7b7e\u540d\uff1a");
        System.out.println(sign);
        System.out.println("\u516c\u94a5\u9a8c\u8bc1\u7b7e\u540d\uff1a");
        System.out.println(PaRsaUtils.verify(content.getBytes(), publicKey, sign));
        System.out.println("==================End \u79c1\u94a5\u7b7e\u540d\uff0c\u516c\u94a5\u9a8c\u8bc1\u7b7e\u540d==================");
        System.out.println("==================Start \u79c1\u94a5\u52a0\u5bc6\uff0c\u516c\u94a5\u89e3\u5bc6\u9a8c\u8bc1==================");
        byte[] encryptByPrivateKey = PaRsaUtils.encryptByPrivateKey(content.getBytes(), privateKey);
        System.out.println("\u79c1\u94a5\u52a0\u5bc6\u5bc6\u6587\uff1a");
        System.out.println(Base64Utils.encode(encryptByPrivateKey));
        byte[] decryptByPublicKey = PaRsaUtils.decryptByPublicKey(encryptByPrivateKey, publicKey);
        System.out.println("\u516c\u94a5\u89e3\u5bc6\u7ed3\u679c\uff1a");
        System.out.println(new String(decryptByPublicKey));
        System.out.println("==================End \u79c1\u94a5\u52a0\u5bc6\uff0c\u516c\u94a5\u89e3\u5bc6\u9a8c\u8bc1==================");
    }

    public static Map<String, Object> genKeyPair() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(2048);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, Object> keyMap = new HashMap<String, Object>(2);
        keyMap.put(PUBLIC_KEY, publicKey);
        keyMap.put(PRIVATE_KEY, privateKey);
        return keyMap;
    }

    public static String sign(byte[] data, String privateKey) throws Exception {
        byte[] keyBytes = Base64Utils.decode(privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(privateK);
        signature.update(data);
        return Base64Utils.encode(signature.sign());
    }

    public static boolean verify(byte[] data, String publicKey, String sign) throws Exception {
        byte[] keyBytes = Base64Utils.decode(publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicK = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(publicK);
        signature.update(data);
        return signature.verify(Base64Utils.decode(sign));
    }

    public static byte[] decryptByPrivateKey(byte[] encryptedData, String privateKey) throws Exception {
        byte[] keyBytes = Base64Utils.decode(privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(2, privateK);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 256 ? cipher.doFinal(encryptedData, offSet, 256) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 256;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }

    public static byte[] decryptByPublicKey(byte[] encryptedData, String publicKey) throws Exception {
        byte[] keyBytes = Base64Utils.decode(publicKey);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicK = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(2, publicK);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 256 ? cipher.doFinal(encryptedData, offSet, 256) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 256;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }

    public static byte[] encryptByPublicKey(byte[] data, String publicKey) throws Exception {
        byte[] keyBytes = Base64Utils.decode(publicKey);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicK = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(1, publicK);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 245 ? cipher.doFinal(data, offSet, 245) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 245;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    public static byte[] encryptByPrivateKey(byte[] data, String privateKey) throws Exception {
        byte[] keyBytes = Base64Utils.decode(privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(1, privateK);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 245 ? cipher.doFinal(data, offSet, 245) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 245;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    public static String getPrivateKey(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PRIVATE_KEY);
        return Base64Utils.encode(key.getEncoded());
    }

    public static String getPublicKey(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PUBLIC_KEY);
        return Base64Utils.encode(key.getEncoded());
    }
}

