/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.gyx.changan.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class CAHttpUtils {
    public static CloseableHttpResponse doGet(String host, String path, String method, Map<String, String> headers, Map<String, String> querys, Map<String, String> sslConfig) throws Exception {
        CloseableHttpClient httpClient = CAHttpUtils.wrapClient(host, sslConfig);
        HttpGet request = new HttpGet(CAHttpUtils.buildUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static CloseableHttpResponse doPost(String host, String path, String method, Map<String, String> headers, Map<String, String> querys, Map<String, String> bodys, Map<String, String> sslConfig) throws Exception {
        CloseableHttpClient httpClient = CAHttpUtils.wrapClient(host, sslConfig);
        HttpPost request = new HttpPost(CAHttpUtils.buildUrl(host, path, querys));
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            request.addHeader(entry.getKey(), entry.getValue());
        }
        if (bodys != null) {
            ArrayList<BasicNameValuePair> nameValuePairList = new ArrayList<BasicNameValuePair>();
            for (String key : bodys.keySet()) {
                nameValuePairList.add(new BasicNameValuePair(key, bodys.get(key)));
            }
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(nameValuePairList, "utf-8");
            urlEncodedFormEntity.setContentType("application/x-www-form-urlencoded; charset=UTF-8");
            request.setEntity((HttpEntity)urlEncodedFormEntity);
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static CloseableHttpResponse doPost(String host, String path, String method, Map<String, String> headers, Map<String, String> querys, String body, Map<String, String> sslConfig) throws Exception {
        CloseableHttpClient httpClient = CAHttpUtils.wrapClient(host, sslConfig);
        HttpPost request = new HttpPost(CAHttpUtils.buildUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        if (StringUtils.isNotBlank((String)body)) {
            request.setEntity((HttpEntity)new StringEntity(body, "gbk"));
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static CloseableHttpResponse doPost(String host, String path, String method, Map<String, String> headers, Map<String, String> querys, byte[] body, Map<String, String> sslConfig) throws Exception {
        CloseableHttpClient httpClient = CAHttpUtils.wrapClient(host, sslConfig);
        HttpPost request = new HttpPost(CAHttpUtils.buildUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        if (body != null) {
            request.setEntity((HttpEntity)new ByteArrayEntity(body));
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    private static String buildUrl(String host, String path, Map<String, String> querys) throws UnsupportedEncodingException {
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(host);
        if (!StringUtils.isBlank((String)path)) {
            sbUrl.append(path);
        }
        if (null != querys) {
            StringBuilder sbQuery = new StringBuilder();
            for (Map.Entry<String, String> query : querys.entrySet()) {
                if (0 < sbQuery.length()) {
                    sbQuery.append("&");
                }
                if (StringUtils.isBlank((String)query.getKey()) && !StringUtils.isBlank((String)query.getValue())) {
                    sbQuery.append(query.getValue());
                }
                if (StringUtils.isBlank((String)query.getKey())) continue;
                sbQuery.append(query.getKey());
                if (StringUtils.isBlank((String)query.getValue())) continue;
                sbQuery.append("=");
                sbQuery.append(URLEncoder.encode(query.getValue(), "utf-8"));
            }
            if (0 < sbQuery.length()) {
                sbUrl.append("?").append((CharSequence)sbQuery);
            }
        }
        return sbUrl.toString();
    }

    private static CloseableHttpClient wrapClient(String host, Map<String, String> sslConfig) throws Exception {
        String ignoreVerifySSL;
        CloseableHttpClient httpClient = null;
        SSLContext sslcontext = null;
        String string = ignoreVerifySSL = sslConfig != null ? sslConfig.get("IgnoreVerifySSL") : "";
        if (StringUtils.equals((String)"true", (String)ignoreVerifySSL)) {
            sslcontext = CAHttpUtils.createIgnoreVerifySSL();
        } else {
            String keyStorePath = sslConfig.get("keyStorePath");
            String keyStorepass = sslConfig.get("keyStorepass");
            String trustStorePath = sslConfig.get("trustStorePath");
            String trustStorepass = sslConfig.get("trustStorepass");
            sslcontext = CAHttpUtils.createCustomSSL(keyStorePath, keyStorepass, trustStorePath, trustStorepass);
        }
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
        return httpClient;
    }

    public static SSLContext createIgnoreVerifySSL() throws Exception {
        SSLContext sc = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        return sc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLContext createCustomSSL(String keyStorePath, String keyStorepass, String trustStorePath, String trustStorePass) {
        SSLContext sc = null;
        FileInputStream trustInstream = null;
        KeyStore trustStore = null;
        FileInputStream keyInstream = null;
        KeyStore keyStore = null;
        try {
            boolean unilateralFlag;
            trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustInstream = new FileInputStream(new File(trustStorePath));
            trustStore.load(trustInstream, trustStorePass.toCharArray());
            boolean bl = unilateralFlag = StringUtils.isBlank((String)keyStorePath);
            if (unilateralFlag) {
                sc = SSLContexts.custom().loadTrustMaterial(trustStore, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            } else {
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyInstream = new FileInputStream(new File(keyStorePath));
                keyStore.load(keyInstream, keyStorepass.toCharArray());
                sc = SSLContexts.custom().loadKeyMaterial(keyStore, keyStorepass.toCharArray()).loadTrustMaterial(trustStore, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (trustInstream != null) {
                    trustInstream.close();
                }
                if (keyInstream != null) {
                    keyInstream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return sc;
    }

    public static void main(String[] args) throws Exception {
        String keyStorePath = "C:/Users/l/Desktop/fsdownload/demo/testjks/test_keystore.jks";
        String keyStorepass = "ecaictest";
        String trustStorePath = "C:/Users/l/Desktop/fsdownload/demo/testjks/test_truststore.jks";
        String trustStorepass = "ecaictest";
        HashMap<String, String> sslConfig = new HashMap<String, String>();
        sslConfig.put("IgnoreVerifySSL", "false");
        sslConfig.put("keyStorePath", keyStorePath);
        sslConfig.put("keyStorepass", keyStorepass);
        sslConfig.put("trustStorePath", trustStorePath);
        sslConfig.put("trustStorepass", trustStorepass);
        String reqxml = "<?xml version=\"1.0\" encoding=\"GBK\" standalone=\"yes\"?><root><applicant><age>33</age><appliName>\u9093\u5a77</appliName><appliType>1</appliType><birthDay>1987-06-18</birthDay><identifyNumber>440281198706186626</identifyNumber><identifyType>01</identifyType><insuredIdentity>50</insuredIdentity><sex>2</sex><taxInfo><invoiceType>3</invoiceType><taxpayerType>4</taxpayerType></taxInfo><taxInfoFlag>1</taxInfoFlag></applicant><channel><channelAreaCode>M33000000030</channelAreaCode><channelCode>330020</channelCode><channelComCode>33000000</channelComCode><channelName>\u4fdd\u9669\u5e08</channelName><channelProductCode>27080210001</channelProductCode><channelTradeCode>0001</channelTradeCode><channelTradeDate>2021-02-23</channelTradeDate><channelTradeSerialNo>e0bbb14b83984e179abdc125b966ed10-005</channelTradeSerialNo><sourceType>0</sourceType></channel><main><endDate>2022-02-26 23:59:59</endDate><endHour>24</endHour><insuredCount>1</insuredCount><proposalNo>2021022315111173010863665250</proposalNo><startDate>2021-02-27 00:00:00</startDate><startHour>00</startHour><sumAmount>343000.0</sumAmount><sumPremium>350.0</sumPremium><sumQuantity>1</sumQuantity></main><insureds><insured><age>5</age><appliIdentity>50</appliIdentity><birthDay>2015-04-22</birthDay><identifyNumber>341203201504220315</identifyNumber><identifyType>01</identifyType><insuredCName>\u674e\u6cfd\u542b</insuredCName><sex>1</sex></insured></insureds></root>";
        String host = "http://test.channelplat.capli.com.cn:7000/17104/commlife1";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "text/xml;charset=gbk");
        System.out.println("\u8bf7\u6c42\u5730\u5740:" + host);
        System.out.println("\u8bf7\u6c42\u62a5\u6587:" + reqxml);
        CloseableHttpResponse httpResponse = CAHttpUtils.doPost(host, null, null, headers, null, reqxml, sslConfig);
        String body = "";
        System.out.println("\u8fd4\u56de\u54cd\u5e94\u72b6\u6001\u4fe1\u606f:" + httpResponse.getStatusLine());
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            body = EntityUtils.toString((HttpEntity)entity, (String)"GBK");
        }
        EntityUtils.consume((HttpEntity)entity);
        httpResponse.close();
        System.out.println("\u8fd4\u56de\u54cd\u5e94\u4fe1\u606f\u4f53:" + StringUtils.replaceEach((String)body, (String[])new String[]{"\n", "\t", "\r"}, (String[])new String[]{"", "", ""}));
    }
}

