/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.user.impl;

import com.bcxin.ins.core.service.ComDeployConfigService;
import com.bcxin.ins.dao.user.ClientUserDao;
import com.bcxin.ins.entity.user.SysClientCompany;
import com.bcxin.ins.entity.user.SysClientUser;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.oauth.OAuthService;
import com.bcxin.ins.service.order.InsCommonReportAPIService;
import com.bcxin.ins.service.user.ClientCompanyService;
import com.bcxin.ins.service.user.ClientUserService;
import com.bcxin.ins.spring.cache.CacheUtils;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.MathUtil;
import com.bcxin.ins.util.Sha1Util;
import com.bcxin.ins.util.email.EmailModel;
import com.bcxin.ins.util.email.EmailMsgType;
import com.bcxin.ins.util.email.MessageModel;
import com.bcxin.ins.util.email.SendEmailAndMsgUtil;
import com.bcxin.ins.util.idcard.IdNumberValidator;
import com.bcxin.ins.util.toolbox.DateUtil;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
@Transactional
public class ClientUserServiceImpl
extends ServiceImpl<ClientUserDao, SysClientUser>
implements ClientUserService {
    private static Logger logger = LoggerFactory.getLogger(ClientUserServiceImpl.class);
    @Autowired
    private ClientUserDao clientUserDao;
    @Autowired
    private OAuthService oAuthService;
    @Autowired
    private ClientCompanyService clientCompanyService;
    @Autowired
    private ComDeployConfigService comDeployConfigService;
    @Autowired
    private InsCommonReportAPIService insCommonReportAPIService;

    @Override
    public boolean saveClientUserVo(ClientUserVo vo) {
        try {
            boolean flag;
            Map<String, Object> map;
            SysClientUser user = null;
            SysClientCompany company = null;
            if (vo.getLogin_name() != null) {
                if (StringUtils.isNotEmpty((String)vo.getOid())) {
                    user = (SysClientUser)this.selectById((Serializable)((Object)vo.getOid()));
                } else {
                    user = new SysClientUser();
                    user.setSys_client_user_id(Long.valueOf(IdWorker.getId()));
                    user.setLogin_name(vo.getLogin_name());
                }
            } else {
                user = this.setUserNameData(vo);
                user.setSys_client_user_id(Long.valueOf(IdWorker.getId()));
            }
            if ("2".equals(vo.getTerminal_type())) {
                if (vo.getCid() != null) {
                    company = (SysClientCompany)this.clientCompanyService.selectById((Serializable)((Object)vo.getCid()));
                } else {
                    company = new SysClientCompany();
                    company.setSys_client_company_id(Long.valueOf(IdWorker.getId()));
                    company.setCompany_name("");
                }
                map = UserSupportUtil.getCompany(company);
                flag = (Boolean)map.get("status");
                if (flag) {
                    company.setWeb_id(map.get("webID").toString());
                    this.clientCompanyService.insertOrUpdate(company);
                    user.setCompany_id(company.getSys_client_company_id());
                } else {
                    return false;
                }
            }
            user.setPassword(vo.getPassword());
            user.setTerminal_type(vo.getTerminal_type());
            user.setPassword(vo.getPassword());
            user.setEmail(vo.getEmail());
            user.setTelephone(vo.getTelephone());
            user.setUser_name(vo.getUser_name());
            user.setRole_name(vo.getRole_name());
            user.setRole_id(Long.valueOf(Long.parseLong(vo.getRole_id())));
            user.setBusiness_support_id(vo.getBusiness_support_id());
            user.setWeb_user_name(vo.getWeb_user_name());
            if (StringUtils.isNotEmpty((String)vo.getWeb_type())) {
                user.setWeb_type(vo.getWeb_type());
                user.setWeb_id(vo.getWeb_id());
            } else {
                user.setWeb_type("BLB");
                user.setWeb_id(user.getSys_client_user_id() + "");
            }
            if ("1".equals(vo.getIs_new_data())) {
                this.insertOrUpdate(user);
                return true;
            }
            if (company != null && StringUtils.isNotEmpty((String)company.getWeb_id())) {
                map = UserSupportUtil.getUserSynchronization(user, company.getWeb_id());
                flag = (Boolean)map.get("status");
                if (flag) {
                    user.setBusiness_support_id(map.get("webID").toString());
                    this.insertOrUpdate(user);
                    return true;
                }
            } else {
                map = UserSupportUtil.getUserSynchronization(user, null);
                flag = (Boolean)map.get("status");
                if (flag) {
                    user.setBusiness_support_id(map.get("webID").toString());
                    this.insertOrUpdate(user);
                    return true;
                }
            }
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return false;
    }

    private SysClientUser setUserNameData(ClientUserVo vo) {
        SysClientUser user = new SysClientUser();
        boolean flag = false;
        do {
            StringBuffer userName = new StringBuffer("");
            if ("2".equals(vo.getTerminal_type())) {
                userName.append("p" + MathUtil.getUserNum((int)9));
                user.setLogin_name(userName.toString());
            } else {
                userName.append("c" + MathUtil.getUserNum((int)9));
                user.setLogin_name(userName.toString());
            }
            int userNameNum = this.clientUserDao.getUserNameByExist(userName.toString());
            if (userNameNum <= 0) continue;
            flag = true;
        } while (flag);
        return user;
    }

    @Override
    public boolean getUserMobileForRegister(String mobile, String webType) {
        int num = this.clientUserDao.getUserMobileForRegister(mobile, webType);
        return num <= 0;
    }

    @Override
    public boolean getUserEmailForRegister(String email, String webType) {
        int num = this.clientUserDao.getUserEmailForRegister(email, webType);
        return num <= 0;
    }

    @Override
    public boolean sendEmailToUser(String email, String emailTitle, String emailContent) {
        try {
            if (!(StringUtils.isBlank((String)emailTitle) || StringUtils.isBlank((String)emailContent) || StringUtils.isBlank((String)email))) {
                EmailModel emailModel = new EmailModel(emailTitle, emailContent);
                ArrayList<String> list = new ArrayList<String>();
                list.add(email);
                emailModel.setTo(list);
                SendEmailAndMsgUtil.sendEmail((EmailModel)emailModel);
                return true;
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u90ae\u4ef6\u9519\u8bef", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean sendEmailToService(String emailTitle, String emailContent) {
        try {
            if (StringUtils.isBlank((String)emailTitle) || StringUtils.isBlank((String)emailContent)) {
                return false;
            }
            String[] arrs = this.comDeployConfigService.getValueByKey("exmail").split(";");
            EmailModel emailModel = new EmailModel(emailTitle, emailContent);
            logger.info("\u90ae\u4ef6\u53d1\u9001\uff08sendEmailToService \u5185\u5bb9htmlContent\uff09:" + emailModel.getContent());
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < arrs.length; ++i) {
                if (!StringUtils.isNotBlank((String)arrs[i]) || arrs[i].contains(":")) continue;
                list.add(arrs[i].trim());
                logger.info("\u90ae\u4ef6\u53d1\u9001\uff08sendEmailToService \u6536\u4ef6\u4ebaEmail-" + (i + 1) + "\uff09:" + arrs[i]);
            }
            if (list.size() > 0) {
                emailModel.setTo(list);
                SendEmailAndMsgUtil.sendEmail((EmailModel)emailModel);
                logger.info("\u90ae\u4ef6\u53d1\u9001\uff08sendEmailToService\uff09:SUCCESS!");
                return true;
            }
            logger.info("\u90ae\u4ef6\u53d1\u9001\uff08sendEmailToService\uff09:FAIL!");
            return false;
        }
        catch (Exception e) {
            logger.error("\u90ae\u4ef6\u53d1\u9001\uff08sendEmailToService \u53d1\u751f\u5f02\u5e38\uff09", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean checkUserExist(String email, boolean isUserName) {
        if (StringUtils.isBlank((String)email)) {
            return false;
        }
        if (MathUtil.checkEmail((String)email)) {
            int num = this.clientUserDao.getUserEmailForRegister(email, "BLB");
            if (num > 0) {
                return true;
            }
        } else if (MathUtil.isMobileNO((String)email)) {
            int num = this.clientUserDao.getUserMobileForRegister(email, "BLB");
            if (num > 0) {
                return true;
            }
        } else {
            if (!isUserName) {
                return false;
            }
            int num = this.clientUserDao.getUserNameByExist(email);
            if (num > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String sendUserCode(String email, EmailMsgType type) {
        if ("1".equals(MathUtil.getType((String)email))) {
            if (EmailMsgType.AUTHCODE == type) {
                String code = MathUtil.getRandomCode();
                code = GlobalResources.IS_TEST_ENVI != false ? "123456" : code;
                logger.info("\u5b9e\u540d\u8ba4\u8bc1-\u9a8c\u8bc1\u7801\uff1a" + code);
                MessageModel mm = new MessageModel(code, EmailMsgType.AUTHCODE);
                logger.info("\u5b9e\u540d\u8ba4\u8bc1-\u624b\u673a\u9a8c\u8bc1\u7801\u5185\u5bb9\uff1a" + mm.getContent());
                logger.info("\u5b9e\u540d\u8ba4\u8bc1-\u624b\u673a\u53f7\u7801" + email);
                return code;
            }
        } else if ("2".equals(MathUtil.getType((String)email)) && EmailMsgType.AUTHCODE == type) {
            String code = MathUtil.getRandomCode();
            code = GlobalResources.IS_TEST_ENVI != false ? "123456" : code;
            EmailModel em = new EmailModel(code, EmailMsgType.TYYZM);
            em.addTo(email);
            try {
                SendEmailAndMsgUtil.sendEmail((EmailModel)em);
                return code;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public ClientUserVo getClientUserVo(String email, String type) {
        ClientUserVo vo = null;
        if ("2".equals(type)) {
            vo = new ClientUserVo();
            vo.setEmail(email);
            vo = this.clientUserDao.getClientUserVo(vo);
        } else if ("1".equals(type)) {
            vo = new ClientUserVo();
            vo.setTelephone(email);
            vo = this.clientUserDao.getClientUserVo(vo);
        } else if ("3".equals(type)) {
            vo = new ClientUserVo();
            vo.setLogin_name(email);
            vo = this.clientUserDao.getClientUserVo(vo);
        }
        if (vo != null && StringUtils.isNotEmpty((String)vo.getOid())) {
            if ("1".equals(vo.getTerminal_type())) {
                vo.setCompany_name(null);
            } else if ("2".equals(vo.getTerminal_type())) {
                vo.setReal_name(null);
            }
            return vo;
        }
        return null;
    }

    @Override
    public ClientUserVo getClientUserVoForThir(String webId, String webType) {
        ClientUserVo vo = new ClientUserVo();
        vo.setWeb_id(webId);
        vo.setWeb_type(webType);
        return this.clientUserDao.getClientUserVoForThir(vo);
    }

    @Override
    public boolean updClientUserVoPwd(ClientUserVo vo, String password) {
        return StringUtils.isNotEmpty((String)password) && vo.getOid() != null && this.getUserPassword(vo.getLogin_name(), password);
    }

    @Override
    public boolean getUserPassword(String login_name, String password) {
        SysClientUser user = new SysClientUser();
        user.setUser_name(login_name);
        user = (SysClientUser)this.selectOne(new EntityWrapper().addFilter("login_name={0}", new Object[]{login_name}));
        if (user == null) {
            return false;
        }
        user.setPassword(Sha1Util.entryptPassword((String)password));
        this.clientUserDao.updateById(user);
        return true;
    }

    @Override
    public ClientUserVo initNewUser(Map<String, Object> map) {
        ClientUserVo vo = new ClientUserVo();
        vo.setTerminal_type("1");
        vo.setRole_id("3");
        vo.setRole_name("COMMON-ZERO-HEAD");
        SysClientUser user = (SysClientUser)map.get("clientUser");
        if (user.getLogin_name() != null) {
            vo.setLogin_name(user.getLogin_name());
        }
        if (user.getEmail() != null) {
            vo.setEmail(user.getEmail());
        }
        if (user.getTelephone() != null) {
            vo.setTelephone(user.getTelephone());
        }
        if (user.getBusiness_support_id() != null) {
            vo.setBusiness_support_id(user.getBusiness_support_id());
        }
        vo.setIs_new_data("1");
        boolean flag = this.saveClientUserVo(vo);
        if (flag) {
            return vo;
        }
        return null;
    }

    @Override
    public boolean bindThrUser(String webId, String webUsername, String phone, String userId, String webType) {
        SysClientUser user = (SysClientUser)this.selectById(Long.valueOf(Long.parseLong(userId)));
        if (user != null) {
            user.setWeb_type(webType);
            user.setWeb_id(webId);
            user.setWeb_user_name(webUsername);
            user.setUpdate_time(new Date());
            return this.updateById(user);
        }
        return false;
    }

    @Override
    public boolean updClientUserVoInfo(ClientUserVo vo, String realName, String realCard) {
        SysClientUser sysClientUser = (SysClientUser)this.clientUserDao.selectById((Serializable)((Object)vo.getOid()));
        sysClientUser.setReal_name(realName);
        sysClientUser.setBirthday(DateUtil.format((Date)IdNumberValidator.idNumber2BirthDate((String)realCard), (String)"yyyy-MM-dd"));
        String value = IdNumberValidator.getSexFromCard((String)realCard).code();
        sysClientUser.setSex(Integer.valueOf(Integer.parseInt(value)));
        sysClientUser.setId_card(realCard);
        sysClientUser.setId_type("0");
        sysClientUser.setIs_certification("1");
        sysClientUser.setPassword(vo.getPassword());
        this.clientUserDao.updateById(sysClientUser);
        UserSupportUtil.getUserSynchronization(sysClientUser, null);
        vo.setBirthday(sysClientUser.getBirthday());
        vo.setSex(value);
        vo.setReal_name(sysClientUser.getReal_name());
        vo.setIs_certification("1");
        HttpServletRequest request = null;
        if (RequestContextHolder.getRequestAttributes() != null) {
            request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HttpSession session = request.getSession();
            session.setAttribute("userdetail", (Object)vo);
        }
        return true;
    }

    @Override
    public boolean updClientUserVoEmail(ClientUserVo vo, String email) {
        SysClientUser sysClientUser = (SysClientUser)this.clientUserDao.selectById((Serializable)((Object)vo.getOid()));
        sysClientUser.setEmail(email);
        sysClientUser.setPassword(vo.getPassword());
        Map<String, Object> map = UserSupportUtil.getUserSynchronization(sysClientUser, null);
        boolean flag = (Boolean)map.get("status");
        if (flag) {
            vo.setEmail(email);
            this.clientUserDao.updateById(sysClientUser);
            HttpServletRequest request = null;
            if (RequestContextHolder.getRequestAttributes() != null) {
                request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                HttpSession session = request.getSession();
                session.setAttribute("userdetail", (Object)vo);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean updClientUserVoPhone(ClientUserVo vo, String phone) {
        SysClientUser sysClientUser = (SysClientUser)this.clientUserDao.selectById((Serializable)((Object)vo.getOid()));
        sysClientUser.setTelephone(phone);
        sysClientUser.setPassword(vo.getPassword());
        Map<String, Object> map = UserSupportUtil.getUserSynchronization(sysClientUser, null);
        if (map.size() == 0) {
            return false;
        }
        boolean flag = (Boolean)map.get("status");
        if (flag) {
            vo.setTelephone(phone);
            this.clientUserDao.updateById(sysClientUser);
            HttpServletRequest request = null;
            if (RequestContextHolder.getRequestAttributes() != null) {
                request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                HttpSession session = request.getSession();
                session.setAttribute("userdetail", (Object)vo);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean saveClientUserVo(String webType, String webUserName, String userWebId) {
        int num = this.clientUserDao.getUserWebIdByExist(userWebId, webType);
        if (num > 0) {
            ClientUserVo vo = new ClientUserVo();
            vo.setWeb_id(userWebId);
            vo.setWeb_type(webType);
            ClientUserVo userVo = this.clientUserDao.getClientUserVo(vo);
            if (userVo == null) {
                return false;
            }
            this.setUserVoSession(userVo, webType);
            this.insCommonReportAPIService.findXXReportDetails();
            return true;
        }
        ClientUserVo userVo = this.setUserVoData(webType, webUserName, userWebId);
        if (userVo == null) {
            return false;
        }
        this.setUserVoSession(userVo, webType);
        return true;
    }

    @Override
    public boolean saveClientUserVoForTHR(String webType, String webUserName, String userWebId, String token) {
        int num = this.clientUserDao.getUserWebIdByExist(userWebId, webType);
        ClientUserVo userVo = null;
        if (num > 0) {
            ClientUserVo vo = new ClientUserVo();
            vo.setWeb_id(userWebId);
            vo.setWeb_type(webType);
            userVo = this.clientUserDao.getClientUserVo(vo);
            if (userVo == null) {
                return false;
            }
            JedisUtils.del((String)("BLB:CACHE:UIP-" + userVo.getOid()));
            this.setUserVoSessionForTHR(userVo, webType, token);
            this.insCommonReportAPIService.findXXReportDetails();
        } else {
            userVo = this.setUserVoData(webType, webUserName, userWebId);
            if (userVo == null) {
                return false;
            }
            this.setUserVoSessionForTHR(userVo, webType, token);
        }
        return true;
    }

    @Override
    public boolean bindClientUser(String webType, String mobile, String webUserName, String userWebId) {
        SysClientUser user = this.getClientUser(mobile, "1");
        if (user == null) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)user.getWeb_type()) && !"BLB".equals(user.getWeb_type())) {
            return false;
        }
        user.setWeb_type(webType);
        user.setWeb_user_name(webUserName);
        user.setWeb_id(userWebId);
        return this.clientUserDao.updateById(user) > 0;
    }

    @Override
    public void setLastTime(ClientUserVo userVo) {
        SysClientUser sysClientUser = (SysClientUser)this.selectById((Serializable)((Object)userVo.getOid()));
        sysClientUser.setLast_login_time(new Date());
        sysClientUser.setBusiness_support_id(userVo.getBusiness_support_id());
        this.updateById(sysClientUser);
    }

    @Override
    public SysClientUser getClientUser(String userName, String type) {
        if ("1".equals(type)) {
            return (SysClientUser)this.selectOne(new EntityWrapper().addFilter("telephone={0}", new Object[]{userName}));
        }
        if ("2".equals(type)) {
            return (SysClientUser)this.selectOne(new EntityWrapper().addFilter("email={0}", new Object[]{userName}));
        }
        if ("3".equals(type)) {
            return (SysClientUser)this.selectOne(new EntityWrapper().addFilter("login_name={0}", new Object[]{userName}));
        }
        return null;
    }

    private ClientUserVo setUserVoData(String webType, String webUserName, String userWebId) {
        ClientUserVo userVo = new ClientUserVo();
        SysClientUser sysClientUser = this.setUserNameData(userVo);
        sysClientUser.setWeb_type(webType);
        sysClientUser.setWeb_user_name(webUserName);
        if (StringUtils.isNotEmpty((String)userWebId)) {
            sysClientUser.setWeb_id(userWebId);
        }
        sysClientUser.setSys_client_user_id(Long.valueOf(IdWorker.getId()));
        Map<String, Object> map = UserSupportUtil.getUserSynchronization(sysClientUser, null);
        boolean flag = (Boolean)map.get("status");
        if (!flag) {
            return null;
        }
        sysClientUser.setBusiness_support_id(map.get("webID").toString());
        this.insert(sysClientUser);
        userVo.setWeb_id(userWebId);
        userVo.setWeb_user_name(webUserName);
        userVo.setWeb_type(webType);
        userVo.setBusiness_support_id(sysClientUser.getBusiness_support_id());
        userVo.setOid(sysClientUser.getSys_client_user_id() + "");
        this.setUserVoSession(userVo, webType);
        return userVo;
    }

    private void setUserVoSession(ClientUserVo userVo, String webType) {
        HttpServletRequest request = null;
        if (RequestContextHolder.getRequestAttributes() != null) {
            request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HttpSession session = request.getSession();
            session.setMaxInactiveInterval(3600);
            session.setAttribute("userdetail", (Object)userVo);
            CacheUtils.put((String)"thirdPlatformFlagCache", (String)session.getId(), (Object)webType);
        } else {
            logger.info("session\u521b\u5efa\u4e0d\u6210\u529f");
        }
    }

    private void setUserVoSessionForTHR(ClientUserVo userVo, String webType, String token) {
        try {
            this.oAuthService.getAccessToken("web", userVo, token);
        }
        catch (OAuthSystemException e) {
            e.printStackTrace();
        }
        JedisUtils.set((String)("thirdPlatformFlagCache" + token), (String)webType, (int)86400);
    }
}

