/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.SpecialExhibitionAPIDao;
import com.bcxin.ins.entity.policy_special.SpecialExhibition;
import com.bcxin.ins.service.order.SpecialExhibitionAPIService;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.SpecialExhibitionVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SpecialExhibitionAPIServiceImpl
extends ServiceImpl<SpecialExhibitionAPIDao, SpecialExhibition>
implements SpecialExhibitionAPIService {
    @Autowired
    private SpecialExhibitionAPIDao dao;

    @Override
    public SpecialExhibition initSpecialExhibition() {
        SpecialExhibition specialExhibition = new SpecialExhibition();
        this.dao.insert(specialExhibition);
        return specialExhibition;
    }

    @Override
    public void accordingToTheSpecialExhibitionVoSetUpSpecialExhibition(SpecialExhibitionVo vo, Long seID) {
        SpecialExhibition specialExhibition = (SpecialExhibition)this.dao.selectById(seID);
        try {
            if (StringUtils.isEmpty((String)vo.getBuild_com_name())) {
                vo.setBuild_com_name(" ");
            }
            if (StringUtils.isEmpty((String)vo.getSubcontracting_units())) {
                vo.setSubcontracting_units(" ");
            }
            if (StringUtils.isEmpty((String)vo.getExhibitor_name())) {
                vo.setExhibitor_name(" ");
            }
            if (StringUtils.isEmpty((String)vo.getExhibitor_type())) {
                vo.setExhibitor_type(" ");
            }
            if (StringUtils.isEmpty((String)vo.getExhibitor_code())) {
                vo.setExhibitor_code(" ");
            }
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)specialExhibition);
            specialExhibition.setEnd_time(DateUtil.convertStringToDate((String)vo.getEnd_time()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dao.updateById(specialExhibition);
    }

    @Override
    public void getSpecialExhibitionVoByPolicyID(SpecialExhibitionVo vo, Long seID) {
        SpecialExhibition specialExhibition = (SpecialExhibition)this.dao.selectById(seID);
        if (specialExhibition == null) {
            return;
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)specialExhibition), (Object)vo);
            if (specialExhibition.getStar_time() != null) {
                vo.setStar_time(DateUtil.convertDateToString((Date)specialExhibition.getStar_time(), (String)"yyyy-MM-dd"));
            }
            if (specialExhibition.getEnd_time() != null) {
                vo.setEnd_time(DateUtil.convertDateToString((Date)specialExhibition.getEnd_time(), (String)"yyyy-MM-dd"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void getSpecialExhibitionVoByPolicyID2(SpecialExhibitionVo vo, Long seID) {
        SpecialExhibition specialExhibition = (SpecialExhibition)this.dao.selectById(seID);
        if (specialExhibition == null) {
            return;
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)specialExhibition), (Object)vo);
            if (specialExhibition.getStar_time() != null) {
                vo.setStar_time(DateUtil.convertDateToString((Date)specialExhibition.getStar_time(), (String)"yyyy-MM-dd"));
            }
            if (specialExhibition.getEnd_time() != null) {
                vo.setEnd_time(DateUtil.convertDateToString((Date)specialExhibition.getEnd_time(), (String)"yyyy-MM-dd"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

