/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.core.service.ComDeployConfigService;
import com.bcxin.ins.core.util.TokenUtils;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.entity.common.ComAreaCode;
import com.bcxin.ins.entity.common.ComRegion;
import com.bcxin.ins.entity.policy_core.InsAgreement;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsMailPolicy;
import com.bcxin.ins.entity.policy_core.InsPreservationResultSet;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.entity.policy_special.Hireling;
import com.bcxin.ins.entity.policy_special.LnAccused;
import com.bcxin.ins.entity.policy_special.SpecialBid;
import com.bcxin.ins.entity.policy_special.SpecialCreditMicro;
import com.bcxin.ins.entity.policy_special.SpecialExhibition;
import com.bcxin.ins.entity.policy_special.SpecialLitigation;
import com.bcxin.ins.entity.policy_special.SpecialPerformance;
import com.bcxin.ins.entity.policy_special.SpecialPublicDuty;
import com.bcxin.ins.entity.user.SysClientUser;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.common.ComAreaCodeAPIService;
import com.bcxin.ins.service.order.ComTaskResidualAPIService;
import com.bcxin.ins.service.order.HirelingAPIService;
import com.bcxin.ins.service.order.InsAgreementAPIService;
import com.bcxin.ins.service.order.InsCommonExportAPIService;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsMailPolicyAPIService;
import com.bcxin.ins.service.order.InsMicroExportAPIService;
import com.bcxin.ins.service.order.InsRoleInpolicyAPIService;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.InsUnderwriteAPIService;
import com.bcxin.ins.service.order.LnAccusedAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.order.SpecialBidAPIService;
import com.bcxin.ins.service.order.SpecialExhibitionAPIService;
import com.bcxin.ins.service.order.SpecialLitigationAPIService;
import com.bcxin.ins.service.order.SpecialPerformanceAPIService;
import com.bcxin.ins.service.order.SpecialPublicDutyAPIService;
import com.bcxin.ins.service.preservation.InsPreservationPayAPIService;
import com.bcxin.ins.service.preservation.InsPreservationRecordAPIService;
import com.bcxin.ins.service.preservation.InsPreservationResultSetAPIService;
import com.bcxin.ins.service.product.InsProductResponsibilityAPIService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.service.user.ClientUserService;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.third.build.dubang.Build_DBRequestService;
import com.bcxin.ins.third.build.taibao.CommunicateType;
import com.bcxin.ins.third.build.taibao.Communicator;
import com.bcxin.ins.third.build.taibao.TransType;
import com.bcxin.ins.third.build.yangguang.YGGCService;
import com.bcxin.ins.third.build.yangguang.yggc.BDYGGC;
import com.bcxin.ins.third.gyx.changan.GYX_CARequestService;
import com.bcxin.ins.third.gzx.changan.GZX_CARequestService;
import com.bcxin.ins.third.gzx.huatai.HtPolicyService;
import com.bcxin.ins.third.gzx.pingancai.GZX_PACRequestService;
import com.bcxin.ins.third.gzzrx.changan.GZZRX_CARequestService;
import com.bcxin.ins.third.gzzrx.pingancai.GZZRX_PACRequestService;
import com.bcxin.ins.third.gzzrx.renbao.GZZRX_RBRequestService;
import com.bcxin.ins.third.tyx.changan.TYX_CARequestService;
import com.bcxin.ins.third.tyx.pingan.PARequestService;
import com.bcxin.ins.third.tyx.pingancai.PACRequestService;
import com.bcxin.ins.third.tyx.taikang.TKRequestService;
import com.bcxin.ins.third.xyx.taibao.XYX_TBRequestService;
import com.bcxin.ins.third.zzx.changan.ZZX_CARequestService;
import com.bcxin.ins.third.zzx.pingancai.ZZX_PACRequestService;
import com.bcxin.ins.third.zzx.zhongan.ZARequestService;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.IdNumberValidator;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.OrderSupportUtil;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.RestUtil;
import com.bcxin.ins.util.email.EmailModel;
import com.bcxin.ins.util.email.EmailMsgType;
import com.bcxin.ins.util.email.SendEmailAndMsgUtil;
import com.bcxin.ins.util.excel.ExcelUtil;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.AdviceNoteVo;
import com.bcxin.ins.vo.BLBCommunicationDto;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.CommonExportVo_1;
import com.bcxin.ins.vo.CommonExportVo_2;
import com.bcxin.ins.vo.CommonExportVo_3;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.GMRPolicyVo;
import com.bcxin.ins.vo.GYXPolicyVo;
import com.bcxin.ins.vo.HirelingVo;
import com.bcxin.ins.vo.InsOrderSearchVo;
import com.bcxin.ins.vo.InsPreservationDetailVo;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.InsPreservationResultSetVo;
import com.bcxin.ins.vo.LOTEPolicyVo;
import com.bcxin.ins.vo.MailPolicyVo;
import com.bcxin.ins.vo.MicroExportVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.OrderStatusCountVo;
import com.bcxin.ins.vo.PingAnPayVo;
import com.bcxin.ins.vo.PolicyTransactionVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResponsibilityVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialBidVo;
import com.bcxin.ins.vo.SpecialExhibitionVo;
import com.bcxin.ins.vo.SpecialHirelingVo;
import com.bcxin.ins.vo.SpecialLitigationVo_1;
import com.bcxin.ins.vo.SpecialLitigationVo_2;
import com.bcxin.ins.vo.SpecialLitigationVo_3;
import com.bcxin.ins.vo.SpecialPerformanceVo_1;
import com.bcxin.ins.vo.SpecialPerformanceVo_2;
import com.bcxin.ins.vo.SpecialPerformanceVo_3;
import com.bcxin.ins.vo.SpecialPublicDutyVo;
import com.bcxin.ins.vo.UnderwriteVo;
import com.bcxin.ins.vo.excel.ResultSetExcelVo;
import com.bcxin.ins.vo.shop.ImportInsuranceOrderRequest;
import com.bcxin.ins.vo.shop.ShopResult;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xiaoleilu.hutool.http.HttpUtil;
import com.xiaoleilu.hutool.thread.ThreadUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
@Transactional
public class PolicyServiceImpl
implements PolicyService {
    private Logger log = LoggerFactory.getLogger(PolicyServiceImpl.class);
    @Autowired
    private HtPolicyService htPolicyService;
    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipService;
    @Autowired
    private InsAgreementAPIService insAgreementAPIService;
    @Autowired
    private InsTransactionAPIService insTransactionService;
    @Autowired
    private ClientUserService clientUserService;
    @Autowired
    private TKRequestService tKRequestService;
    @Autowired
    private PARequestService pARequestService;
    @Autowired
    private ZARequestService zARequestService;
    @Autowired
    private ZZX_PACRequestService zZX_PACRequestService;
    @Autowired
    private GZX_PACRequestService gZX_PACRequestService;
    @Autowired
    private GZX_CARequestService gZX_CARequestService;
    @Autowired
    private ZZX_CARequestService zZX_CARequestService;
    @Autowired
    private ComAreaCodeAPIService comAreaCodeAPIService;
    @Autowired
    private InsPreservationRecordAPIService insPreservationRecordAPIService;
    @Autowired
    private InsPreservationPayAPIService insPreservationPayAPIService;
    @Autowired
    private ProductService productService;
    @Autowired
    private SpecialPublicDutyAPIService specialPublicDutyAPIService;
    @Autowired
    private Build_DBRequestService build_DBRequestService;
    @Autowired
    private ComDeployConfigService comDeployConfigService;
    @Autowired
    private InsMicroExportAPIService insMicroExportService;
    @Autowired
    private InsRoleInpolicyAPIService insRoleInpolicyService;
    @Autowired
    private InsCommonExportAPIService insCommonExportService;
    @Autowired
    private SpecialBidAPIService insSpecialBidService;
    @Autowired
    private SpecialExhibitionAPIService specialExhibitionAPIService;
    @Autowired
    private SpecialPerformanceAPIService insSpecialPerformanceService;
    @Autowired
    private InsMailPolicyAPIService insMailPolicyService;
    @Autowired
    private InsUnderwriteAPIService insUnderwriteAPIService;
    @Autowired
    private SpecialLitigationAPIService specialLitigationService;
    @Autowired
    private SpecialPublicDutyAPIService specialPublicDutyService;
    @Autowired
    private LnAccusedAPIService lnAccusedAPIService;
    @Autowired
    private InsProductResponsibilityAPIService insProductResponsibilityAPIService;
    @Autowired
    private ComTaskResidualAPIService comTaskResidualAPIService;
    @Autowired
    private XYX_TBRequestService xYX_TBRequestService;
    @Autowired
    private PACRequestService pACRequestService;
    @Autowired
    private HirelingAPIService hirelingAPIService;
    @Autowired
    private YGGCService yGGCService;
    @Autowired
    private GZZRX_RBRequestService gZZRX_RBRequestService;
    @Autowired
    private GZZRX_PACRequestService gZZRX_PACRequestService;
    @Autowired
    private GZZRX_CARequestService gZZRX_CARequestService;
    @Autowired
    private TYX_CARequestService tYX_CARequestService;
    @Autowired
    private GYX_CARequestService gYX_CARequestService;
    @Autowired
    private InsPreservationResultSetAPIService insPreservationResultSetAPIService;

    @Override
    public String getRecommendCodeByCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        String result = "";
        if (cookies.length <= ConstProp.INT_NUMBER_ZERO) {
            return result;
        }
        for (Cookie cookie : cookies) {
            if (!"recommendCode".equals(cookie.getName())) continue;
            result = cookie.getValue();
            break;
        }
        return result;
    }

    @Override
    public Map<String, Object> createOrderFormByProductOid(Long product_id, Long user_id, String recommendCode, String trade_serial_number) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isNotBlank((CharSequence)String.valueOf(product_id)) && StrUtil.isNotBlank((CharSequence)String.valueOf(user_id))) {
            InsInsuranceSlip order = this.insInsuranceSlipService.initOrderForm(product_id, user_id, recommendCode, trade_serial_number);
            map.put("order_id", String.valueOf(order.getIns_insurance_slip_id()));
        } else {
            map = null;
        }
        return map;
    }

    @Override
    public OrderFormVo accordingToOrderIDToGetPolicyDto(Long order_id) {
        OrderFormVo vo = null;
        if (StrUtil.isNotBlank((CharSequence)String.valueOf(order_id))) {
            vo = this.insInsuranceSlipService.findOrderFormVoByID(order_id);
        }
        return vo;
    }

    @Override
    public String getTPUserIDByOrderID(Long order_id) {
        SysClientUser user;
        Object vo = null;
        String result = "";
        if (StrUtil.isBlank((String)String.valueOf(order_id))) {
            return result;
        }
        InsInsuranceSlip order = this.insInsuranceSlipService.selectById(order_id);
        if (order != null && (user = (SysClientUser)this.clientUserService.selectById(order.getRegister_user_id())) != null) {
            result = user.getWeb_id() + ";" + user.getWeb_type();
        }
        return result;
    }

    @Override
    public AdviceNoteVo accordingToOrderIDToGetAdviceNoteVo(Long order_id) {
        AdviceNoteVo vo = null;
        if (StrUtil.isNotBlank((CharSequence)String.valueOf(order_id))) {
            InsInsuranceSlip order = this.insInsuranceSlipService.selectById(order_id);
            vo = this.insInsuranceSlipService.willInsOrderFormSetUpAdviceNoteVo(order);
        }
        return vo;
    }

    @Override
    public Map<String, Object> obtainMicroExportVoSetUp(MicroExportVo vo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isBlank((String)vo.getOid())) {
            return null;
        }
        try {
            InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
            if (StringUtils.isNotEmpty((CharSequence)vo.getRecommend_code())) {
                insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
            }
            insInsuranceSlip.setPremium(new BigDecimal(vo.getGross_premium()));
            insInsuranceSlip.setInsured_amount(new BigDecimal(vo.getInsured_amount()));
            if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
                insInsuranceSlip.setInception_date(DateUtil.convertStringToDate((String)(vo.getInception_date() + " 00:00:00")));
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date())) {
                insInsuranceSlip.setPlanned_end_date(DateUtil.convertStringToDate((String)(vo.getPlanned_end_date() + " 23:59:59")));
            }
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
            vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
            vo.setOrder_status(insInsuranceSlip.getOrder_status());
            this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
            this.insMicroExportService.accordingToTheMicroExportVoSetUpInsMicroExport(vo, insInsuranceSlip.getSpecial_id());
            this.insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        map.put("order_id", String.valueOf(vo.getOid()));
        return map;
    }

    @Override
    public ResultDto pendingMicroExportPolicy(MicroExportVo vo, String recommendCode) {
        try {
            Map<String, Object> map;
            ClientUserVo userdetail = UserSupportUtil.getSessionUser();
            if (userdetail == null) {
                return new ResultDto("\u8d26\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c", "/");
            }
            if (StringUtils.isEmpty((CharSequence)vo.getOid())) {
                String orderId = this.getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode, vo.getSigId());
                if (StringUtils.isNotEmpty((CharSequence)orderId)) {
                    vo.setOid(orderId);
                    if (StringUtils.isNotEmpty((CharSequence)vo.getSigId())) {
                        this.insInsuranceSlipService.updateOrderIdBySigId(orderId, vo.getSigId());
                    }
                } else {
                    return new ResultDto("\u8ba2\u5355\u521d\u59cb\u5316\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
                }
            }
            if ((map = this.obtainMicroExportVoSetUp(vo)) != null) {
                return new ResultDto("\u5f53\u524d\u586b\u5199\u5185\u5bb9\u5df2\u7ecf\u6682\u5b58\uff0c\u7a0d\u540e\u60a8\u53ef\u5728\u3010\u6211\u7684\u8d26\u6237-\u6211\u7684\u8ba2\u5355-\u6295\u4fdd\u4e2d\u3011 \u7ee7\u7eed\u5b8c\u6210\u586b\u5199\u5185\u5bb9\u3002", "200", String.valueOf(map.get("order_id")), "", "");
            }
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResultDto("\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff01", "300", "", "", "");
        }
    }

    private String getOidByCreatePolicy(String product_id, String user_id, String recommendCode, String trade_serial_number) {
        String result = "";
        if (StringUtils.isNotEmpty((CharSequence)product_id)) {
            result = this.createOrderAndGetOrderIDByProductID(Long.parseLong(product_id), Long.parseLong(user_id), recommendCode, trade_serial_number);
        }
        return result;
    }

    @Override
    public MicroExportVo accordingToOrderIDToGetMicroExportVo(Long order_id) {
        MicroExportVo vo = null;
        if (StrUtil.isBlank((String)String.valueOf(order_id))) {
            return vo;
        }
        vo = new MicroExportVo();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(order_id);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
        if (insInsuranceSlip.getPremium() != null) {
            vo.setGross_premium(String.valueOf(insInsuranceSlip.getPremium()));
        }
        if (insInsuranceSlip.getInsured_amount() != null) {
            vo.setInsured_amount(String.valueOf(insInsuranceSlip.getInsured_amount()));
        }
        if (insInsuranceSlip.getInception_date() != null) {
            vo.setInception_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getInception_date(), (String)"yyyy-MM-dd"));
        }
        if (insInsuranceSlip.getPlanned_end_date() != null) {
            vo.setPlanned_end_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getPlanned_end_date(), (String)"yyyy-MM-dd"));
        }
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        this.insMicroExportService.getMicroExportVoByPolicyID(vo, insInsuranceSlip.getSpecial_id());
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        return vo;
    }

    @Override
    public Map<String, String> findTotalPolicyNum(InsOrderSearchVo searchVo) {
        OrderStatusCountVo vo = null;
        Map<String, String> mapSum = null;
        if (searchVo.getUserId() == null) {
            return mapSum;
        }
        mapSum = new HashMap<String, String>();
        vo = this.insInsuranceSlipService.selectOrderStatusCountVoByUserID(searchVo);
        if (vo != null) {
            try {
                mapSum = MyConverUtil.PO2Map((Object)vo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mapSum;
    }

    @Override
    public List<OrderFormVo> findPolicyForPage(InsOrderSearchVo search) {
        List<OrderFormVo> pdList = null;
        if (StrUtil.isBlank((String)search.getPolicyStatus()) || search.getUserId() == null) {
            return pdList;
        }
        pdList = this.insInsuranceSlipService.selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(search);
        return pdList;
    }

    @Override
    public OrderFormVo findPolicyByExternalAndRoleName(String externalRefernce, String roleName) {
        OrderFormVo dto = null;
        if (StrUtil.isNotBlank((CharSequence)externalRefernce) && StrUtil.isNotBlank((CharSequence)roleName)) {
            dto = this.insInsuranceSlipService.findPolicyByExternalAndRoleName(externalRefernce, roleName);
        }
        return dto;
    }

    @Override
    public String updateOrderFormStatus(OrderFormVo vo) {
        String order_id = "";
        try {
            if (vo == null || StrUtil.isBlank((String)vo.getOid())) {
                return order_id;
            }
            this.insInsuranceSlipService.updateOrderFormStatus(vo);
            if ("2".equals(vo.getPolicy_status())) {
                InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
                this.insInsuranceSlipService.accordingToOrderIDCreatePolicySerialNumber(insInsuranceSlip);
                this.insInsuranceSlipService.accordingToInsTopBuyersListGainInsRiskDuty(Long.parseLong(vo.getOid()));
            }
            if ("6".equals(vo.getPolicy_status())) {
                new Thread(() -> {
                    if ("1".equals(GlobalResources.map.get("IS_SEND_SHOP"))) {
                        this.comTaskResidualAPIService.saveComTaskResidual("createSendOrderTask", "\u4fdd\u9669\u8ba2\u5355\u63a8\u9001\u5546\u57ce\u521d\u59cb\u5316", "com.bcxin.ins.service.order.PolicyService", 3, "Long,int,String", vo.getOid() + ",2,");
                    }
                }).start();
                this.orderSyncZC(vo.getOid());
                ThreadUtil.excAsync(() -> this.sendZZPolicyEmail(vo.getOid()), (boolean)false);
            }
            if ("3".equals(vo.getPolicy_status()) || "4".equals(vo.getPolicy_status()) || "16".equals(vo.getPolicy_status())) {
                ThreadUtil.excAsync(() -> this.sendInsureEmail(vo.getOid()), (boolean)false);
            }
            order_id = vo.getOid();
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u72b6\u6001\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return order_id;
    }

    @Override
    public ResultDto updateOrderFormStatusByRequest(HttpServletRequest request) {
        String order_id = request.getParameter("order_id");
        String status = request.getParameter("status");
        if (StringUtils.isEmpty((CharSequence)order_id) || StringUtils.isEmpty((CharSequence)status)) {
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        OrderFormVo vo = new OrderFormVo();
        vo.setOid(String.valueOf(order_id));
        vo.setPolicy_status(status);
        try {
            this.insInsuranceSlipService.updateOrderFormStatus(vo);
            if ("2".equals(vo.getPolicy_status())) {
                InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
                this.insInsuranceSlipService.accordingToOrderIDCreatePolicySerialNumber(insInsuranceSlip);
                this.insInsuranceSlipService.accordingToInsTopBuyersListGainInsRiskDuty(Long.parseLong(vo.getOid()));
            }
            if ("6".equals(vo.getPolicy_status())) {
                this.orderSyncZC(vo.getOid());
            }
            return new ResultDto("\u8ba2\u5355\u5f55\u5165\u6210\u529f\u3002", "200", order_id, "300", "");
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u72b6\u6001\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResultDto("\u9519\u8bef\u5f02\u5e38\uff1a" + e.getMessage(), "300", "", "", "");
        }
    }

    @Override
    public void sendZZPolicyEmail(String order_id) {
        ThreadUtil.sleep((Number)120000);
        InsMailPolicy insMailPolicy = this.insMailPolicyService.getInsMailPolicyByOrderId(Long.parseLong(order_id));
        if (insMailPolicy == null) {
            return;
        }
        OrderFormVo vo = this.accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
        String content = this.htmlContentByZZPolicyEmail(vo, insMailPolicy);
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            String pcode = StringUtils.isNotEmpty((CharSequence)vo.getProduct_code()) && vo.getProduct_code().contains("PAC") ? vo.getProduct_code() : "";
            this.sendMsgEmail("TBFP_EMAIL", pcode, content, "\u4fdd\u5355\u3001\u53d1\u7968\u5bc4\u9001\u901a\u77e5");
        }
    }

    @Override
    public void sendInsureEmail(String order_id) {
        OrderFormVo vo = this.accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
        if (vo == null) {
            return;
        }
        String content = this.htmlContentByInsureEmail(vo);
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            this.sendMsgEmail("exmail", "", content, "\u5ba2\u6237\u4e0b\u5355\u901a\u77e5");
        }
    }

    public void sendMsgEmail(String emailType, String product_code, String htmlContent, String title) {
        this.log.info("\u90ae\u4ef6\u53d1\u9001\uff08\u5185\u5bb9htmlContent\uff09:" + htmlContent);
        String[] arrs = this.comDeployConfigService.getValueByKey(emailType).split(";");
        EmailModel emailModel = new EmailModel(title, htmlContent);
        ArrayList<String> emailList = new ArrayList<String>();
        for (int i = 0; i < arrs.length; ++i) {
            if (StringUtils.isEmpty((CharSequence)arrs[i])) continue;
            String em = "";
            if (arrs[i].contains(":")) {
                String[] sigs = arrs[i].split(":");
                if (StringUtils.isNotEmpty((CharSequence)product_code) && product_code.contains(sigs[1])) {
                    em = sigs[0].trim();
                }
            } else {
                em = arrs[i].trim();
            }
            if (!StringUtils.isNotEmpty((CharSequence)em)) continue;
            emailList.add(em);
            this.log.info("\u90ae\u4ef6\u53d1\u9001\uff08\u6536\u4ef6\u4ebaEmail-" + (i + 1) + "\uff09:" + em);
        }
        if (emailList.size() > 0) {
            emailModel.setTo(emailList);
            SendEmailAndMsgUtil.sendEmail((EmailModel)emailModel);
        }
    }

    private String htmlContentByZZPolicyEmail(OrderFormVo orderVo, InsMailPolicy insMailPolicy) {
        StringBuffer htmlContent = new StringBuffer();
        try {
            if (orderVo == null) {
                return "";
            }
            if (insMailPolicy.getNeed_insur_bill() == 0 && insMailPolicy.getNeed_receipt() == 0) {
                return "";
            }
            htmlContent.append("<!DOCTYPE html><html lang=\"en\"><head><meta charset=\"UTF-8\"><title>\u7eb8\u8d28\u4fdd\u5355\u3001\u53d1\u7968\u5bc4\u9001\u4fe1\u606f</title><style type=\"text/css\">.wrap{width:500px;margin:30px auto}.wrap h1{text-align:center}.shenqing-con p strong,.shenqing-con p span{display:block;font-size:14px;line-height:24px}.shenqing-con p strong{float:left;margin-right:8px}.shenqing-con div{float:left}.shenqing-con p.mg-r{width:200px;margin-left:78px}table{width:680px}table th,table td{padding:5px}</style></head><body><div class=\"wrap\"><h1>\u7eb8\u8d28\u4fdd\u5355\u3001\u53d1\u7968\u5bc4\u9001\u4fe1\u606f</h1><div class=\"shenqing-con\">");
            htmlContent.append("<p><strong>\u8ba2\u5355\u53f7\uff1a</strong><span>" + orderVo.getTrade_serial_number() + "</span></p>");
            htmlContent.append("<p><strong>\u4fdd\u9669\u516c\u53f8\uff1a</strong><span>" + orderVo.getInsurance_name() + "</span></p><p><strong>\u4fdd\u5355\u53f7\uff1a</strong><span>" + orderVo.getExternal_reference() + "</span></p><p><strong>\u6295\u4fdd\u65f6\u95f4\uff1a</strong><span>" + orderVo.getStart_time() + "</span></p><p><strong>\u6295\u4fdd\u4eba\uff1a</strong><span>" + orderVo.getApplicant_name() + "</span></p><p><strong>\u4fdd\u9669\u4ea7\u54c1\uff1a</strong><span>[\u4ea7\u54c1\u540d\u79f0\uff1a" + orderVo.getProduct_name() + "]</span></p>");
            if (insMailPolicy.getNeed_insur_bill() == 1) {
                htmlContent.append("<h2>\u7eb8\u8d28\u4fdd\u5355\u5bc4\u9001\u4fe1\u606f\uff1a</h2>");
                htmlContent.append("<p><strong>\u6536\u4ef6\u4eba\u540d\u79f0\uff1a</strong><span>" + insMailPolicy.getReceiver_name() + "</span></p>");
                htmlContent.append("<p><strong>\u6536\u4ef6\u4eba\u624b\u673a\uff1a</strong><span>" + insMailPolicy.getReceiver_mobile() + "</span></p>");
                htmlContent.append("<p><strong>\u6536\u4ef6\u4eba\u5730\u5740\uff1a</strong><span>" + insMailPolicy.getReceiver_address_detail() + "</span></p>");
            }
            if (insMailPolicy.getNeed_receipt() == 1) {
                boolean isInv = "1".equals(insMailPolicy.getInvoice_type());
                String inv = isInv ? "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968" : "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968";
                htmlContent.append("<h2>\u7eb8\u8d28" + inv + "\u5bc4\u9001\u4fe1\u606f\uff1a</h2>");
                htmlContent.append("<p><strong>\u5355\u4f4d\u540d\u79f0\uff1a</strong><span>" + insMailPolicy.getReceipt_head() + "</span></p>");
                htmlContent.append("<p><strong>\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a</strong><span>" + insMailPolicy.getTaxpayer_number_invoice() + "</span></p>");
                htmlContent.append("<p><strong>\u6536\u7968\u4eba\u59d3\u540d\uff1a</strong><span>" + insMailPolicy.getTaker_name() + "</span></p>");
                htmlContent.append("<p><strong>\u6536\u7968\u4eba\u624b\u673a\uff1a</strong><span>" + insMailPolicy.getTaker_mobile() + "</span></p>");
                htmlContent.append("<p><strong>\u6536\u7968\u4eba\u5730\u5740\uff1a</strong><span>" + insMailPolicy.getTaker_address_detail() + "</span></p>");
                if (isInv) {
                    htmlContent.append("<p><strong>\u5f00\u6237\u94f6\u884c\uff1a</strong><span>" + insMailPolicy.getBank_invoice() + "</span></p>");
                    htmlContent.append("<p><strong>\u94f6\u884c\u8d26\u53f7\uff1a</strong><span>" + insMailPolicy.getBank_account_invoice() + "</span></p>");
                    htmlContent.append("<p><strong>\u5f00\u6237\u5730\u5740\uff1a</strong><span>" + RegionUtils.getRegionNameByALLCode((String)insMailPolicy.getBank_province(), (String)insMailPolicy.getBank_city(), (String)"") + "</span></p>");
                }
            }
            htmlContent.append("</div></div></body></html>");
        }
        catch (Exception e) {
            this.log.error("\u7eb8\u8d28\u4fdd\u5355\u3001\u53d1\u7968\u5f85\u5bc4\u9001\u901a\u77e5\u5185\u5bb9\u7ec4\u88c5\u5f02\u5e38\uff1a", (Throwable)e);
            e.printStackTrace();
        }
        return htmlContent.toString();
    }

    private String htmlContentByInsureEmail(OrderFormVo orderVo) {
        StringBuffer htmlContent = new StringBuffer();
        try {
            htmlContent.append("<!DOCTYPE html><html lang=\"en\"><head><meta charset=\"UTF-8\"><style type=\"text/css\">.wrap{width:500px;margin:30px auto}.wrap h1{text-align:center}.shenqing-con p strong,.shenqing-con p span{display:block;font-size:14px;line-height:24px}.shenqing-con p strong{float:left;margin-right:8px}.shenqing-con div{float:left}.shenqing-con p.mg-r{width:200px;margin-left:78px}table{width:680px}table th,table td{padding:5px}</style></head><body><div class=\"wrap\"><h1>\u5ba2\u6237\u4e0b\u5355\u901a\u77e5</h1><div class=\"shenqing-con\">");
            htmlContent.append("<p><strong>\u6709\u65b0\u7684\u8ba2\u5355\u4ea7\u751f\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a</strong><span></span></p></br>");
            htmlContent.append("<p><strong>\u8ba2\u5355\u53f7\uff1a</strong><span>" + orderVo.getTrade_serial_number() + "</span></p>");
            htmlContent.append("<p><strong>\u4fdd\u9669\u4ea7\u54c1\uff1a</strong><span>[\u4ea7\u54c1\u540d\u79f0\uff1a" + orderVo.getProduct_name() + "]</span></p><p><strong>\u6295\u4fdd\u4eba\uff1a</strong><span>" + orderVo.getApplicant_name() + "</span></p><p><strong>\u91d1\u989d\uff1a</strong><span>" + orderVo.getGross_premium() + "</span></p><p><strong>\u4e0b\u5355\u65f6\u95f4\uff1a</strong><span>" + orderVo.getStart_time() + "</span></p><p><strong>\u751f\u6548\u65e5\u671f\uff1a</strong><span>" + orderVo.getInception_date() + "</span></p>");
            htmlContent.append("</div></div></body></html>");
        }
        catch (Exception e) {
            this.log.error("\u65b0\u8ba2\u5355\u4ea7\u751f\u901a\u77e5\u5185\u5bb9\u7ec4\u88c5\u5f02\u5e38\uff1a", (Throwable)e);
            e.printStackTrace();
        }
        return htmlContent.toString();
    }

    private void orderSyncZC(String oid) {
        String sup_order_id;
        SpecialPublicDutyVo vo;
        InsInsuranceSlip policy = this.insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(oid));
        OrderFormVo orderVo = this.accordingToOrderIDToGetPolicyDto(policy.getIns_insurance_slip_id());
        InsTransaction it = null;
        if (policy.getInsTransaction() != null && !policy.getInsTransaction().isEmpty()) {
            it = (InsTransaction)policy.getInsTransaction().get(0);
        }
        SysClientUser user = (SysClientUser)this.clientUserService.selectById(policy.getRegister_user_id());
        String insName = "";
        if ("GZX".equals(orderVo.getProduct_code().split("-")[0])) {
            vo = this.accordingToOrderIDToGetSpecialPublicDutyVo(Long.parseLong(orderVo.getOid()));
            insName = vo.getReport_name();
        }
        if ("ZZX".equals(orderVo.getProduct_code().split("-")[0])) {
            vo = this.accordingToOrderIDToGetLOTEPolicyVo(Long.parseLong(orderVo.getOid()));
            insName = vo.getSpecialExhibitionVo().getName();
        }
        if (StringUtils.isNotEmpty((CharSequence)(sup_order_id = OrderSupportUtil.receiveOrderFormData((String)String.valueOf(user.getBusiness_support_id()), (OrderFormVo)orderVo, (InsInsuranceSlip)policy, (InsTransaction)it, (String)insName)))) {
            policy.setOrder_zc_id(Long.valueOf(Long.parseLong(sup_order_id)));
            this.insInsuranceSlipService.updateById(policy);
        }
        if (it != null) {
            OrderSupportUtil.receiveTrancetionData((InsInsuranceSlip)policy, (InsTransaction)it);
        }
    }

    @Override
    public boolean recordSyncZC(String record_id) {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        InsPreservationRecordVo record = this.insPreservationRecordAPIService.findInsPreservationRecordVoById(Long.parseLong(record_id));
        InsInsuranceSlip policy = this.insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(record.getIns_insurance_slip_id()));
        SysClientUser user = (SysClientUser)this.clientUserService.selectById(policy.getRegister_user_id());
        String record_zc_id = OrderSupportUtil.receivePreservationData((String)String.valueOf(user.getBusiness_support_id()), (InsInsuranceSlip)policy, (InsPreservationRecordVo)record);
        if (StringUtils.isNotEmpty((CharSequence)record_zc_id)) {
            this.insPreservationRecordAPIService.saveYWZCId(record_id, record_zc_id);
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> obtainCommonExportVo_1VoSetUp(CommonExportVo_1 vo) {
        HashMap<String, Object> map1 = null;
        if (StrUtil.isBlank((String)vo.getOid())) {
            return map1;
        }
        map1 = new HashMap<String, Object>();
        try {
            InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
            if (StringUtils.isNotEmpty((CharSequence)vo.getRecommend_code())) {
                insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
                this.insInsuranceSlipService.updateById(insInsuranceSlip);
            }
            this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
            this.insCommonExportService.accordingToTheCommonExportVo_1SetUpInsCommonExport(vo, insInsuranceSlip.getSpecial_id());
            if (vo.getRoleSubjectList().size() > 0 && StrUtil.isNotBlank((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getTurnover_export())) {
                this.insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(new BigDecimal(((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getTurnover_export()), insInsuranceSlip);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        map1.put("order_id", String.valueOf(vo.getOid()));
        return map1;
    }

    @Override
    public ResultDto pendingCommonExportVo_1Policy(CommonExportVo_1 vo, String recommendCode) {
        try {
            Map<String, Object> map;
            ClientUserVo userdetail = UserSupportUtil.getSessionUser();
            if (userdetail == null) {
                return new ResultDto("\u8d26\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c", "/");
            }
            if (StringUtils.isEmpty((CharSequence)vo.getOid())) {
                String orderId = this.getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode, vo.getSigId());
                if (StringUtils.isNotEmpty((CharSequence)orderId)) {
                    vo.setOid(orderId);
                    if (StringUtils.isNotEmpty((CharSequence)vo.getSigId())) {
                        this.insInsuranceSlipService.updateOrderIdBySigId(orderId, vo.getSigId());
                    }
                } else {
                    return new ResultDto("\u8ba2\u5355\u521d\u59cb\u5316\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
                }
            }
            if ((map = this.obtainCommonExportVo_1VoSetUp(vo)) != null) {
                return new ResultDto("\u5f53\u524d\u586b\u5199\u5185\u5bb9\u5df2\u7ecf\u6682\u5b58\uff0c\u7a0d\u540e\u60a8\u53ef\u5728\u3010\u6211\u7684\u8d26\u6237-\u6211\u7684\u8ba2\u5355-\u6295\u4fdd\u4e2d\u3011 \u7ee7\u7eed\u5b8c\u6210\u586b\u5199\u5185\u5bb9\u3002", "200", String.valueOf(map.get("order_id")), "", "");
            }
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        catch (Exception e) {
            this.log.error("\u77ed\u671f\u51fa\u53e3\u9875\u4e00\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResultDto("\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff01", "300", "", "", "");
        }
    }

    @Override
    public Map<String, Object> obtainCommonExportVo_2VoSetUp(CommonExportVo_2 vo) {
        HashMap<String, String> map = null;
        if (StrUtil.isNotBlank((CharSequence)vo.getOid())) {
            map = new HashMap<String, String>();
            InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
            this.insCommonExportService.accordingToTheCommonExportVo_2SetUpInsCommonExport(vo, insInsuranceSlip.getSpecial_id());
            map.put("order_id", String.valueOf(vo.getOid()));
        }
        return map;
    }

    @Override
    public ResultDto pendingCommonExportVo_2Policy(CommonExportVo_2 vo) {
        try {
            ClientUserVo userdetail = UserSupportUtil.getSessionUser();
            if (userdetail == null) {
                return new ResultDto("\u8d26\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c", "/");
            }
            Map<String, Object> map = this.obtainCommonExportVo_2VoSetUp(vo);
            if (map != null) {
                return new ResultDto("\u5f53\u524d\u586b\u5199\u5185\u5bb9\u5df2\u7ecf\u6682\u5b58\uff0c\u7a0d\u540e\u60a8\u53ef\u5728\u3010\u6211\u7684\u8d26\u6237-\u6211\u7684\u8ba2\u5355-\u6295\u4fdd\u4e2d\u3011 \u7ee7\u7eed\u5b8c\u6210\u586b\u5199\u5185\u5bb9\u3002", "200", String.valueOf(map.get("order_id")), "", "");
            }
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        catch (Exception e) {
            this.log.error("\u77ed\u671f\u51fa\u53e3\u9875\u4e8c\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResultDto("\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff01", "300", "", "", "");
        }
    }

    @Override
    public Map<String, Object> obtainCommonExportVo_3VoSetUp(CommonExportVo_3 vo) {
        HashMap<String, String> map = null;
        if (StrUtil.isNotBlank((CharSequence)vo.getOid())) {
            map = new HashMap<String, String>();
            InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
            this.insCommonExportService.accordingToTheCommonExportVo_3SetUpInsCommonExport(vo, insInsuranceSlip.getSpecial_id());
            this.insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
            map.put("order_id", String.valueOf(vo.getOid()));
        }
        return map;
    }

    @Override
    public ResultDto pendingCommonExportVo_3Policy(CommonExportVo_3 vo) {
        try {
            ClientUserVo userdetail = UserSupportUtil.getSessionUser();
            if (userdetail == null) {
                return new ResultDto("\u8d26\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c", "/");
            }
            Map<String, Object> map = this.obtainCommonExportVo_3VoSetUp(vo);
            if (map != null) {
                return new ResultDto("\u5f53\u524d\u586b\u5199\u5185\u5bb9\u5df2\u7ecf\u6682\u5b58\uff0c\u7a0d\u540e\u60a8\u53ef\u5728\u3010\u6211\u7684\u8d26\u6237-\u6211\u7684\u8ba2\u5355-\u6295\u4fdd\u4e2d\u3011 \u7ee7\u7eed\u5b8c\u6210\u586b\u5199\u5185\u5bb9\u3002", "200", String.valueOf(map.get("order_id")), "", "");
            }
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        catch (Exception e) {
            this.log.error("\u77ed\u671f\u51fa\u53e3\u9875\u4e09\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResultDto("\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff01", "300", "", "", "");
        }
    }

    @Override
    public CommonExportVo_1 accordingToOrderIDToGetCommonExportVo_1(Long order_id) {
        CommonExportVo_1 vo = null;
        if (StrUtil.isNotBlank((CharSequence)String.valueOf(order_id))) {
            vo = new CommonExportVo_1();
            InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(order_id);
            vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
            vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
            vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
            vo.setResponsibilityVoList(this.findResponsibilityVoList(vo.getProduct_id(), order_id));
            vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
            this.insCommonExportService.getCommonExportVo_1BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        }
        return vo;
    }

    @Override
    public CommonExportVo_2 accordingToOrderIDToGetCommonExportVo_2(Long order_id) {
        CommonExportVo_2 vo = null;
        if (StrUtil.isNotBlank((CharSequence)String.valueOf(order_id))) {
            vo = new CommonExportVo_2();
            InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(order_id);
            vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
            this.insCommonExportService.getCommonExportVo_2BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        }
        return vo;
    }

    @Override
    public CommonExportVo_3 accordingToOrderIDToGetCommonExportVo_3(Long order_id) {
        CommonExportVo_3 vo = null;
        if (StrUtil.isNotBlank((CharSequence)String.valueOf(order_id))) {
            vo = new CommonExportVo_3();
            MailPolicyVo voMP = new MailPolicyVo();
            InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(order_id);
            vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
            this.insCommonExportService.getCommonExportVo_3BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
            InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
            this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
            vo.setMailPolicyVo(voMP);
        }
        return vo;
    }

    @Override
    public String uploadPayMentFileToTranction(String path_url, String order_id, String path_sign, String payAmount) {
        String orderID = "";
        try {
            if (StrUtil.isBlank((String)order_id) || StrUtil.isBlank((String)path_url) || StrUtil.isBlank((String)payAmount) || StrUtil.isBlank((String)path_sign)) {
                return orderID;
            }
            InsInsuranceSlip order = this.insInsuranceSlipService.selectById(Long.parseLong(order_id));
            if (order != null) {
                this.insTransactionService.uploadPayMentFileToTranction(path_url, order, path_sign, payAmount, "6");
                orderID = String.valueOf(order.getIns_insurance_slip_id());
            }
        }
        catch (Exception e) {
            this.log.error("\u4e0a\u4f20\u652f\u4ed8\u51ed\u8bc1\u66f4\u65b0\u6570\u636e\u5e93\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return orderID;
    }

    @Override
    public UnderwriteVo accordingToOrderIDGainInsUnderwrite(Long order_id) {
        UnderwriteVo vo = null;
        if (StrUtil.isNotBlank((CharSequence)String.valueOf(order_id))) {
            InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.packagingInsOrderForm(order_id);
            vo = this.insUnderwriteAPIService.accordingToInsUnderwriteIntoUnderwriteVo(insInsuranceSlip.getUnderwrite());
        }
        return vo;
    }

    @Override
    public String accordingToOrderIDGainPathSign(Long order_id) {
        String path_sign = "";
        if (StrUtil.isNotBlank((CharSequence)String.valueOf(order_id))) {
            path_sign = this.insTransactionService.accordingToOrderIDGainPathSign(String.valueOf(order_id));
        }
        return path_sign;
    }

    @Override
    public List<RoleSubjectVo> getComAndEmpByUserID_BBDAPI(String user_id, String sign) {
        this.log.info("(findCompnayAndPersonByUserid)\u767e\u4fdd\u76fe\u4eba\u5458\u6570\u636e\uff0cStar!");
        HashMap<String, String> data = new HashMap<String, String>();
        ArrayList<RoleSubjectVo> voList = null;
        ArrayList list = new ArrayList();
        List lists = null;
        data.put("user_id", user_id);
        this.log.info("(findCompnayAndPersonByUserid)\u767e\u4fdd\u76fe\u4eba\u5458\u6570\u636e\uff0cuser_id\uff1a" + user_id);
        String url = this.getArsPath(sign) + "/company/findCompnayAndPersonByUserid.json";
        this.log.info("(findCompnayAndPersonByUserid)\u767e\u4fdd\u76fe\u4eba\u5458\u6570\u636e\uff0curl\uff1a" + url);
        String result = "";
        try {
            result = RestUtil.restful((String)url, data);
            this.log.info("(findCompnayAndPersonByUserid)\u767e\u4fdd\u76fe\u4eba\u5458\u6570\u636e\uff0cresult\uff1a" + result);
        }
        catch (IOException e) {
            this.log.error("(findCompnayAndPersonByUserid)\u767e\u4fdd\u76fe\u4eba\u5458\u6570\u636e\uff0c\u8bf7\u6c42\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            return new ArrayList<RoleSubjectVo>();
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            return voList;
        }
        AjaxResult r = null;
        try {
            r = (AjaxResult)JSON.parseObject((String)result, AjaxResult.class);
        }
        catch (Exception e) {
            this.log.error("(findCompnayAndPersonByUserid)\u767e\u4fdd\u76fe\u4eba\u5458\u6570\u636e\uff0c\u89e3\u6790\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            return new ArrayList<RoleSubjectVo>();
        }
        this.log.info("(findCompnayAndPersonByUserid)\u767e\u4fdd\u76fe\u4eba\u5458\u6570\u636e\uff0c\u89e3\u6790\uff1a" + JSONObject.toJSONString((Object)r));
        if (!r.isSuccessful()) {
            return voList;
        }
        lists = (List)r.getData();
        if (lists == null) {
            return voList;
        }
        RoleSubjectVo initVo = null;
        Map map = null;
        voList = new ArrayList<RoleSubjectVo>();
        for (Object obj : lists) {
            map = (Map)obj;
            if (map == null) continue;
            initVo = new RoleSubjectVo();
            HashMap mapn = Maps.newHashMap();
            for (String key : map.keySet()) {
                if ("null".equals(map.get(key)) || map.get(key) == null) continue;
                mapn.put(key, map.get(key));
            }
            try {
                MyConverUtil.map2PO((Map)mapn, (Object)initVo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            voList.add(initVo);
            initVo = null;
            map = null;
        }
        if (voList.size() > 0) {
            if ("1".equals(((RoleSubjectVo)voList.get(0)).getKind())) {
                return voList;
            }
            RoleSubjectVo ro = null;
            for (RoleSubjectVo vo : voList) {
                if (!"1".equals(((RoleSubjectVo)voList.get(0)).getKind())) continue;
                ro = vo;
                voList.remove(vo);
            }
            voList.set(0, ro);
        } else {
            RoleSubjectVo nullVo = null;
            for (int i = 0; i < 4; ++i) {
                nullVo = new RoleSubjectVo();
                if (i == 0) {
                    nullVo.setKind("1");
                } else {
                    nullVo.setKind("2");
                }
                voList.add(nullVo);
                nullVo = null;
            }
        }
        this.log.info("(findCompnayAndPersonByUserid)\u767e\u4fdd\u76fe\u4eba\u5458\u6570\u636e\uff0cRoleSubjectVo List\uff1a" + voList);
        this.log.info("(findCompnayAndPersonByUserid)\u767e\u4fdd\u76fe\u4eba\u5458\u6570\u636e\uff1aEnd!");
        return voList;
    }

    @Override
    public List<RoleSubjectVo> getComAndEmpByUserID_API(String user_id, String sign) {
        this.log.info("(getComAndEmpByUserID_API)\u5e73\u53f0\u4eba\u5458\u6570\u636e\uff1aStar!");
        HashMap<String, String> data = new HashMap<String, String>();
        ArrayList<Object> voList = new ArrayList<RoleSubjectVo>();
        List lists = null;
        data.put("comId", user_id);
        this.log.info("(getComAndEmpByUserID_API)\u5e73\u53f0\u4eba\u5458\u6570\u636e\uff0cuser_id\uff1a" + user_id);
        String url = "";
        if (sign.contains("SAAS")) {
            url = this.getArsPath(sign) + "/enterprise/blb-api-controller/find-compnay-person-by-user-id";
        } else if (sign.contains("PASP")) {
            url = this.getArsPath(sign) + "/enterprise/blb-api-controller/find-compnay-person-by-user-id";
        }
        this.log.info("(getComAndEmpByUserID_API)\u5e73\u53f0\u4eba\u5458\u6570\u636e\uff0curl\uff1a" + url);
        String result = "";
        try {
            result = RequestUtil.sendGet((String)url, (String)("comId=" + user_id));
            this.log.info("(getComAndEmpByUserID_API)\u5e73\u53f0\u4eba\u5458\u6570\u636e\uff0cresult\uff1a" + result);
        }
        catch (Exception e) {
            this.log.error("(getComAndEmpByUserID_API)\u5e73\u53f0\u4eba\u5458\u6570\u636e\uff0c\u8bf7\u6c42\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            return new ArrayList<RoleSubjectVo>();
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            return voList;
        }
        Result r = null;
        try {
            r = (Result)JSON.parseObject((String)result, Result.class);
        }
        catch (Exception e) {
            this.log.error("(getComAndEmpByUserID_API)\u5e73\u53f0\u4eba\u5458\u6570\u636e\uff0c\u89e3\u6790\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            return new ArrayList<RoleSubjectVo>();
        }
        this.log.info("(getComAndEmpByUserID_API)\u5e73\u53f0\u4eba\u5458\u6570\u636e\uff0c\u89e3\u6790\uff1a" + JSONObject.toJSONString((Object)r));
        if (!"0".equals(r.getRetType())) {
            return voList;
        }
        lists = (List)r.getData();
        if (lists == null) {
            return voList;
        }
        RoleSubjectVo initVo = null;
        Map map = null;
        voList = new ArrayList();
        for (Object obj : lists) {
            map = (Map)obj;
            if (map == null) continue;
            initVo = new RoleSubjectVo();
            HashMap hashMap = Maps.newHashMap();
            for (String key : map.keySet()) {
                if ("null".equals(map.get(key)) || map.get(key) == null) continue;
                hashMap.put(key, map.get(key));
            }
            try {
                MyConverUtil.map2PO((Map)hashMap, (Object)initVo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if ("0".equals(initVo.getId_type()) && StringUtils.isNotEmpty((CharSequence)initVo.getOrganization_code()) && initVo.getOrganization_code().length() == 18) {
                if (StringUtils.isEmpty((CharSequence)initVo.getSex())) {
                    initVo.setSex(IdNumberValidator.getSexFromCard((String)initVo.getOrganization_code()));
                }
                if (StringUtils.isEmpty((CharSequence)initVo.getBirth_date())) {
                    initVo.setBirth_date(DateUtil.convertDateToString((Date)IdNumberValidator.idNumber2BirthDate((String)initVo.getOrganization_code()), (String)"yyyy-MM-dd"));
                }
            }
            voList.add(initVo);
            initVo = null;
            map = null;
        }
        if (voList.size() <= 0) {
            return voList;
        }
        if ("1".equals(((RoleSubjectVo)voList.get(0)).getKind())) {
            return voList;
        }
        RoleSubjectVo ro = null;
        for (RoleSubjectVo roleSubjectVo : voList) {
            if (!"1".equals(((RoleSubjectVo)voList.get(0)).getKind())) continue;
            ro = roleSubjectVo;
            voList.remove(roleSubjectVo);
        }
        voList.set(0, ro);
        this.log.info("(getComAndEmpByUserID_API)\u5e73\u53f0\u4eba\u5458\u6570\u636e\uff0cRoleSubjectVo List\uff1a" + voList);
        this.log.info("(getComAndEmpByUserID_API)\u5e73\u53f0\u4eba\u5458\u6570\u636e\uff1aEnd!");
        return voList;
    }

    @Override
    public List<RoleSubjectVo> getComAndEmpByCacheId_API(String cacheId, String sign) {
        this.log.info("(getComAndEmpByCacheId_API)\u5e73\u53f0\u4eba\u5458\u6570\u636e\uff1aStar!");
        ArrayList<Object> voList = new ArrayList<RoleSubjectVo>();
        List lists = null;
        this.log.info("(getComAndEmpByCacheId_API)\u5e73\u53f0\u4eba\u5458\u6570\u636e\uff0ccacheId\uff1a" + cacheId);
        String url = "";
        if (sign.contains("SAAS")) {
            url = this.getArsPath(sign) + "/enterprise/blb-api-controller/find-compnay-person-by-cache-id";
        } else if (sign.contains("PASP")) {
            url = this.getArsPath(sign) + "/enterprise/blb-api-controller/find-compnay-person-by-cache-id";
        }
        this.log.info("(getComAndEmpByCacheId_API)\u5e73\u53f0\u4eba\u5458\u6570\u636e\uff0curl\uff1a" + url);
        String result = "";
        try {
            result = RequestUtil.sendGet((String)url, (String)("cacheId=" + cacheId));
            this.log.info("(getComAndEmpByCacheId_API)\u5e73\u53f0\u4eba\u5458\u6570\u636e\uff0cresult\uff1a" + result);
        }
        catch (Exception e) {
            this.log.error("(getComAndEmpByCacheId_API)\u5e73\u53f0\u4eba\u5458\u6570\u636e\uff0c\u8bf7\u6c42\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            return new ArrayList<RoleSubjectVo>();
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            return voList;
        }
        Result r = null;
        try {
            r = (Result)JSON.parseObject((String)result, Result.class);
        }
        catch (Exception e) {
            this.log.error("(getComAndEmpByCacheId_API)\u5e73\u53f0\u4eba\u5458\u6570\u636e\uff0c\u89e3\u6790\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            return new ArrayList<RoleSubjectVo>();
        }
        this.log.info("(getComAndEmpByCacheId_API)\u5e73\u53f0\u4eba\u5458\u6570\u636e\uff0c\u89e3\u6790\uff1a" + JSONObject.toJSONString((Object)r));
        if (!"0".equals(r.getRetType())) {
            return voList;
        }
        lists = (List)r.getData();
        if (lists == null) {
            return voList;
        }
        RoleSubjectVo initVo = null;
        Map map = null;
        voList = new ArrayList();
        for (Object obj : lists) {
            map = (Map)obj;
            if (map == null) continue;
            initVo = new RoleSubjectVo();
            HashMap hashMap = Maps.newHashMap();
            for (String key : map.keySet()) {
                if ("null".equals(map.get(key)) || map.get(key) == null) continue;
                hashMap.put(key, map.get(key));
            }
            try {
                MyConverUtil.map2PO((Map)hashMap, (Object)initVo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if ("0".equals(initVo.getId_type()) && StringUtils.isNotEmpty((CharSequence)initVo.getOrganization_code()) && initVo.getOrganization_code().length() == 18) {
                if (StringUtils.isEmpty((CharSequence)initVo.getSex())) {
                    initVo.setSex(IdNumberValidator.getSexFromCard((String)initVo.getOrganization_code()));
                }
                if (StringUtils.isEmpty((CharSequence)initVo.getBirth_date())) {
                    initVo.setBirth_date(DateUtil.convertDateToString((Date)IdNumberValidator.idNumber2BirthDate((String)initVo.getOrganization_code()), (String)"yyyy-MM-dd"));
                }
            }
            voList.add(initVo);
            initVo = null;
            map = null;
        }
        if (voList.size() <= 0) {
            return voList;
        }
        if ("1".equals(((RoleSubjectVo)voList.get(0)).getKind())) {
            return voList;
        }
        RoleSubjectVo ro = null;
        for (RoleSubjectVo roleSubjectVo : voList) {
            if (!"1".equals(((RoleSubjectVo)voList.get(0)).getKind())) continue;
            ro = roleSubjectVo;
            voList.remove(roleSubjectVo);
        }
        voList.set(0, ro);
        this.log.info("(getComAndEmpByCacheId_API)\u5e73\u53f0\u4eba\u5458\u6570\u636e\uff0cRoleSubjectVo List\uff1a" + voList);
        this.log.info("(getComAndEmpByCacheId_API)\u5e73\u53f0\u4eba\u5458\u6570\u636e\uff1aEnd!");
        return voList;
    }

    @Override
    public List<InsPreservationResultSetVo> getPersonByUserID_BBDAPI(String user_id, String webType, String sign) {
        String result;
        HashMap<String, String> data = new HashMap<String, String>();
        List<InsPreservationResultSetVo> iprsVoList = new ArrayList<InsPreservationResultSetVo>();
        this.log.info("(requestBBD)\u83b7\u53d6\u767e\u4fdd\u76fe\u4eba\u5458\u5217\u8868\uff0c" + ("1".equals(sign) ? "\u589e\u5458" : "\u51cf\u5458") + "\uff1astar-----------------------");
        data.put("user_id", user_id);
        data.put("work_status", sign);
        String url = this.getArsPath(webType) + "/company/findPersonByUseridAndStatus.json";
        this.log.info("(requestBBD)\u83b7\u53d6\u767e\u4fdd\u76fe\u4eba\u5458\u5217\u8868\uff0cURL\uff1a" + url);
        this.log.info("(requestBBD)\u83b7\u53d6\u767e\u4fdd\u76fe\u4eba\u5458\u5217\u8868\uff0cDATA\uff1a" + ((Object)data).toString());
        try {
            result = RestUtil.restful((String)url, data);
            this.log.info("(requestBBD)\u83b7\u53d6\u767e\u4fdd\u76fe\u4eba\u5458\u5217\u8868\uff0cRETURE\uff1a" + result.toString());
            this.log.info("(requestBBD)\u83b7\u53d6\u767e\u4fdd\u76fe\u4eba\u5458\u5217\u8868\uff0cRETURE-SUCCESS\uff1a" + result.toString());
        }
        catch (IOException e) {
            this.log.info("(requestBBD)\u83b7\u53d6\u767e\u4fdd\u76fe\u4eba\u5458\u5217\u8868\uff0cRETURE-FAIL\uff1a" + e.getMessage());
            return new ArrayList<InsPreservationResultSetVo>();
        }
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            iprsVoList = this.getInsPreservationResultSetVos(iprsVoList, result);
        }
        if (iprsVoList == null) {
            this.log.info("requestBBD(\u83b7\u53d6\u767e\u4fdd\u76fe\u4eba\u5458\u5217\u8868)-EMP-LIST\uff1anull");
        }
        this.log.info("(requestBBD)\u83b7\u53d6\u767e\u4fdd\u76fe\u4eba\u5458\u5217\u8868\uff0c" + ("1".equals(sign) ? "\u589e\u5458" : "\u51cf\u5458") + "\uff1aend-----------------------");
        return iprsVoList;
    }

    private List<InsPreservationResultSetVo> getInsPreservationResultSetVos(List<InsPreservationResultSetVo> iprsVoList, String result) {
        AjaxResult r = null;
        try {
            r = (AjaxResult)JSON.parseObject((String)result, AjaxResult.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!r.isSuccessful()) {
            return iprsVoList;
        }
        List lists = (List)r.getData();
        if (lists == null) {
            return iprsVoList;
        }
        RoleSubjectVo initVo = null;
        Map map = null;
        ArrayList<RoleSubjectVo> voList = new ArrayList<RoleSubjectVo>();
        for (Object obj : lists) {
            map = (Map)obj;
            initVo = new RoleSubjectVo();
            try {
                MyConverUtil.map2PO((Map)map, (Object)initVo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            voList.add(initVo);
            initVo = null;
            map = null;
        }
        iprsVoList = new ArrayList<InsPreservationResultSetVo>();
        InsPreservationResultSetVo iprsVo = null;
        for (RoleSubjectVo vo : voList) {
            iprsVo = new InsPreservationResultSetVo();
            iprsVo.setName(vo.getName_cn());
            iprsVo.setId_card(vo.getOrganization_code());
            iprsVo.setId_type(vo.getId_type());
            iprsVo.setBirthday(vo.getBirth_date());
            iprsVo.setSex(vo.getSex());
            iprsVo.setTel(vo.getMobile());
            iprsVoList.add(iprsVo);
        }
        this.log.info("(requestBBD)\u83b7\u53d6\u767e\u4fdd\u76fe\u4eba\u5458\u5217\u8868\uff0cEMP-LIST\uff1a" + iprsVoList.toString());
        return iprsVoList;
    }

    @Override
    public boolean saveOrderInfo(String order_id) {
        AjaxResult r;
        HashMap<String, String> data = new HashMap<String, String>();
        boolean flag = false;
        this.log.info("(saveOrderInfo)\u56e2\u610f\u9669\u627f\u4fdd\u540e\u63a8\u9001\u767e\u4fdd\u76fe\uff1astar!");
        if (StringUtils.isEmpty((CharSequence)order_id)) {
            return flag;
        }
        String userResult = this.getTPUserIDByOrderID(Long.parseLong(order_id));
        OrderFormVo dto = this.accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
        String roleJson = "";
        if (dto.getProduct_code().contains("TYX")) {
            roleJson = this.getRoleJsonByTYX(order_id, roleJson);
        } else if (dto.getProduct_code().contains("GZZRX")) {
            roleJson = this.getRoleJsonByGZZRX(order_id, roleJson);
        }
        ProductVo pd = this.productService.getProduct(Long.parseLong(dto.getProduct_oid()));
        String doAmount = "";
        String doAmount_yy = "";
        doAmount = this.getFcyAmount(pd, doAmount);
        if (StringUtils.isNotEmpty((CharSequence)doAmount)) {
            doAmount_yy = this.productService.api_request_sign(pd.getProduct_code()) == 1 ? String.valueOf(BigDecimal.valueOf(Double.parseDouble(doAmount)).multiply(BigDecimal.valueOf(Double.parseDouble("0.7")))) : doAmount;
        }
        data.put("insuranceEscortAmount", doAmount_yy);
        data.put("insuranceamount", doAmount);
        data.put("user_id", userResult.split(";")[0]);
        data.put("orderNo", order_id);
        data.put("cardList", roleJson);
        String url = this.getArsPath(userResult.split(";")[1]) + "/company/saveOrderInfo.json";
        this.log.info("(saveOrderInfo)\u56e2\u610f\u9669\u627f\u4fdd\u540e\u63a8\u9001\u767e\u4fdd\u76fe\uff0cDATA\uff1a" + ((Object)data).toString());
        this.log.info("(saveOrderInfo)\u56e2\u610f\u9669\u627f\u4fdd\u540e\u63a8\u9001\u767e\u4fdd\u76fe\uff0cURL\uff1a" + url);
        String result = "";
        try {
            result = RestUtil.restful((String)url, data);
            this.log.info("(saveOrderInfo)\u56e2\u610f\u9669\u627f\u4fdd\u540e\u63a8\u9001\u767e\u4fdd\u76fe\uff0cRESULT\uff1a" + result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (StringUtils.isNotEmpty((CharSequence)result) && (r = (AjaxResult)JSON.parseObject((String)result, AjaxResult.class)).isSuccessful()) {
            flag = true;
        }
        this.log.info("(saveOrderInfo)\u56e2\u610f\u9669\u627f\u4fdd\u540e\u63a8\u9001\u767e\u4fdd\u76fe\uff0cRETURN\uff1a" + flag);
        this.log.info("(saveOrderInfo)\u56e2\u610f\u9669\u627f\u4fdd\u540e\u63a8\u9001\u767e\u4fdd\u76fe\uff1aend!");
        return flag;
    }

    private String getFcyAmount(ProductVo pd, String doAmount) {
        if (pd.getResponsibilityVoList().size() <= 0) {
            return doAmount;
        }
        for (ResponsibilityVo rvo : pd.getResponsibilityVoList()) {
            if ("\u610f\u5916\u4f24\u5bb3\u4fdd\u9669\u91d1".equals(rvo.getName())) {
                doAmount = String.valueOf(rvo.getFcy());
                break;
            }
            if (!"\u4fdd\u5b89\u5458\u96c7\u4e3b\u8d23\u4efb".equals(rvo.getName())) continue;
            doAmount = String.valueOf(rvo.getInsurance_amount_max());
            break;
        }
        return doAmount;
    }

    private String getRoleJsonByGZZRX(String order_id, String roleJson) {
        SpecialHirelingVo vo = this.accordingToOrderIDToGetSpecialHirelingVo(Long.parseLong(order_id));
        if (vo.getHirelingVoList() == null) {
            return roleJson;
        }
        JSONObject jsonObject = new JSONObject();
        int count = ConstProp.INT_NUMBER_ZERO;
        jsonObject.put("count", (Object)String.valueOf(vo.getHirelingVoList().size()));
        for (HirelingVo hVo : vo.getHirelingVoList()) {
            jsonObject.put(count + "", (Object)hVo.getId_card());
            ++count;
        }
        return jsonObject.toString();
    }

    private String getRoleJsonByTYX(String order_id, String roleJson) {
        GMRPolicyVo vo = this.accordingToOrderIDToGetGMRPolicyVo(Long.parseLong(order_id));
        if (vo.getRoleSubjectList() == null) {
            return roleJson;
        }
        JSONObject jsonObject = new JSONObject();
        int count = ConstProp.INT_NUMBER_ZERO;
        jsonObject.put("count", (Object)String.valueOf(vo.getRoleSubjectList().size() - 1));
        for (RoleSubjectVo roleVo : vo.getRoleSubjectList()) {
            if (!"2".equals(roleVo.getKind())) continue;
            jsonObject.put(count + "", (Object)roleVo.getOrganization_code());
            ++count;
        }
        return jsonObject.toString();
    }

    @Override
    public boolean saveOrderInfoPush(String order_id) {
        HashMap<String, String> data = new HashMap<String, String>();
        boolean flag = false;
        this.log.info("(saveOrderInfoPush)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff1astar!");
        if (StringUtils.isEmpty((CharSequence)order_id)) {
            return flag;
        }
        String userResult = this.getTPUserIDByOrderID(Long.parseLong(order_id));
        OrderFormVo dto = this.accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
        if (StringUtils.isEmpty((CharSequence)dto.getExternal_reference())) {
            return flag;
        }
        JSONArray jarr = new JSONArray();
        if (dto.getProduct_code().contains("TYX")) {
            this.getJarrByTYX(order_id, data, jarr);
        } else if (dto.getProduct_code().contains("GZZRX")) {
            this.getJarrByGZZRX(order_id, data, jarr);
        } else {
            this.log.info("(saveOrderInfoPush)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0cend\uff1a" + dto.getProduct_code());
            return true;
        }
        data.put("orderId", dto.getOid());
        data.put("comId", userResult.split(";")[0]);
        data.put("productName", dto.getProduct_name());
        data.put("productCode", dto.getProduct_code());
        data.put("insComName", dto.getInsurance_name());
        data.put("buyTime", dto.getStart_time());
        data.put("effectStartDate", dto.getInception_date());
        data.put("effectEndDate", dto.getPlanned_end_date());
        data.put("policyNo", dto.getExternal_reference());
        data.put("perPremiums", dto.getPremium());
        String policyUrl = "";
        if (StringUtils.isNotEmpty((CharSequence)dto.getInsure_path())) {
            policyUrl = dto.getInsure_path().contains("http") ? dto.getInsure_path() : GlobalResources.WEB_URL + dto.getInsure_path();
        }
        data.put("policyUrl", policyUrl);
        data.put("userList", jarr.toJSONString());
        String url = "";
        if (dto.getWeb_type().contains("SAAS")) {
            url = this.getArsPath(dto.getWeb_type()) + "/enterprise/blb-api-controller/save-order-info";
        } else if (dto.getWeb_type().contains("PASP")) {
            url = this.getArsPath(dto.getWeb_type()) + "/enterprise/blb-api-controller/save-order-info";
        }
        this.log.info("(saveOrderInfoPush)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0curl\uff1a" + url);
        String result = "";
        try {
            this.log.info("(saveOrderInfoPush)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0cdata\uff1a" + ((Object)data).toString());
            result = RestUtil.restful((String)url, data);
            this.log.info("(saveOrderInfoPush)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0cresult\uff1a" + result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            return flag;
        }
        Result r = (Result)JSON.parseObject((String)result, Result.class);
        this.log.info("(saveOrderInfoPush)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0cretType\uff1a" + r.getRetType());
        this.log.info("(saveOrderInfoPush)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0cmsg\uff1a" + r.getMsg());
        if ("0".equals(r.getRetType())) {
            flag = true;
        }
        this.log.info("(saveOrderInfoPush)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff1aend!");
        return flag;
    }

    private void getJarrByGZZRX(String order_id, Map<String, String> data, JSONArray jarr) {
        SpecialHirelingVo vo = this.accordingToOrderIDToGetSpecialHirelingVo(Long.parseLong(order_id));
        if (vo.getHirelingVoList() == null) {
            return;
        }
        JSONObject jsonObject = null;
        data.put("perNum", String.valueOf(vo.getHirelingVoList().size()));
        for (HirelingVo hVo : vo.getHirelingVoList()) {
            jsonObject = new JSONObject();
            jsonObject.put("idCardNo", (Object)hVo.getId_card());
            jsonObject.put("name", (Object)hVo.getName());
            jarr.add((Object)jsonObject);
            jsonObject = null;
        }
    }

    private void getJarrByTYX(String order_id, Map<String, String> data, JSONArray jarr) {
        GMRPolicyVo vo = this.accordingToOrderIDToGetGMRPolicyVo(Long.parseLong(order_id));
        if (vo.getRoleSubjectList() == null) {
            return;
        }
        JSONObject jsonObject = null;
        if (vo.getSpecialExhibitionVo() != null && StringUtils.isNotEmpty((CharSequence)vo.getSpecialExhibitionVo().getName())) {
            data.put("projectName", vo.getSpecialExhibitionVo().getName());
        }
        data.put("perNum", String.valueOf(vo.getRoleSubjectList().size() - 1));
        for (RoleSubjectVo roleVo : vo.getRoleSubjectList()) {
            if (!"2".equals(roleVo.getKind())) continue;
            jsonObject = new JSONObject();
            jsonObject.put("idCardNo", (Object)roleVo.getOrganization_code());
            jsonObject.put("name", (Object)roleVo.getName_cn());
            jarr.add((Object)jsonObject);
            jsonObject = null;
        }
    }

    @Override
    public Result pushRepairOrderInfo(String order_id) {
        GMRPolicyVo vo;
        HashMap<String, String> data = new HashMap<String, String>();
        this.log.info("(pushRepairOrderInfo)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff1astar!");
        if (StringUtils.isEmpty((CharSequence)order_id)) {
            return Result.fail((String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String userResult = this.getTPUserIDByOrderID(Long.parseLong(order_id));
        OrderFormVo dto = this.accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
        JSONArray jarr = new JSONArray();
        if (!dto.getProduct_code().contains("TYX") && !dto.getProduct_code().contains("GZZRX")) {
            this.log.info("(pushRepairOrderInfo)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0cend\uff1a" + dto.getProduct_code());
            return Result.fail((String)("product_code\u4e0d\u5339\u914d:" + dto.getProduct_code()));
        }
        List<InsPreservationResultSet> setList = this.insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(null, Long.parseLong(order_id), "", "0", "", "");
        if (setList.size() <= 0) {
            this.log.info("(pushRepairOrderInfo)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0cend\uff1a\u672a\u627e\u5230\u5728\u4fdd\u4eba\u5458\u4fe1\u606f\uff01");
            return Result.fail((String)"\u672a\u627e\u5230\u5728\u4fdd\u4eba\u5458\u4fe1\u606f\uff01");
        }
        if (dto.getProduct_code().contains("TYX") && (vo = this.accordingToOrderIDToGetGMRPolicyVo(Long.parseLong(order_id))).getSpecialExhibitionVo() != null && StringUtils.isNotEmpty((CharSequence)vo.getSpecialExhibitionVo().getName())) {
            data.put("projectName", vo.getSpecialExhibitionVo().getName());
        }
        JSONObject jsonObject = null;
        data.put("perNum", String.valueOf(setList.size()));
        for (InsPreservationResultSet set : setList) {
            jsonObject = new JSONObject();
            jsonObject.put("idCardNo", (Object)set.getId_card());
            jsonObject.put("name", (Object)set.getName());
            jarr.add((Object)jsonObject);
        }
        data.put("orderId", dto.getOid());
        data.put("comId", userResult.split(";")[0]);
        data.put("productName", dto.getProduct_name());
        data.put("productCode", dto.getProduct_code());
        data.put("insComName", dto.getInsurance_name());
        data.put("buyTime", dto.getStart_time());
        data.put("effectStartDate", dto.getInception_date());
        data.put("effectEndDate", dto.getPlanned_end_date());
        data.put("policyNo", dto.getExternal_reference());
        data.put("perPremiums", dto.getPremium());
        String policyUrl = "";
        if (StringUtils.isNotEmpty((CharSequence)dto.getInsure_path())) {
            policyUrl = dto.getInsure_path().contains("http") ? dto.getInsure_path() : GlobalResources.WEB_URL + dto.getInsure_path();
        }
        data.put("policyUrl", policyUrl);
        data.put("userList", jarr.toJSONString());
        String url = "";
        if (dto.getWeb_type().contains("SAAS")) {
            url = this.getArsPath(dto.getWeb_type()) + "/enterprise/blb-api-controller/save-order-info";
        } else if (dto.getWeb_type().contains("PASP")) {
            url = this.getArsPath(dto.getWeb_type()) + "/enterprise/blb-api-controller/save-order-info";
        }
        this.log.info("(pushRepairOrderInfo)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0curl\uff1a" + url);
        try {
            this.log.info("(pushRepairOrderInfo)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0cdata\uff1a" + ((Object)data).toString());
            String result = RestUtil.restful((String)url, data);
            this.log.info("(pushRepairOrderInfo)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0cresult\uff1a" + result);
            if (StringUtils.isNotEmpty((CharSequence)result)) {
                Result r = (Result)JSON.parseObject((String)result, Result.class);
                this.log.info("(pushRepairOrderInfo)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0cretType\uff1a" + r.getRetType());
                this.log.info("(pushRepairOrderInfo)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0cmsg\uff1a" + r.getMsg());
                this.log.info("(pushRepairOrderInfo)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff1aend!");
                return r;
            }
            this.log.info("(pushRepairOrderInfo)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff1aend!");
            return Result.fail((String)"\u63a5\u53e3\u8fd4\u56de\u7a7a\uff01");
        }
        catch (IOException e) {
            this.log.info("(pushRepairOrderInfo)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff1aend!");
            return Result.fail((String)("pushRepairOrderInfo\u4e1a\u52a1\u5f02\u5e38\uff1a" + e.getMessage()));
        }
    }

    @Override
    public boolean pushOfflineOrderPerson(String order_id) {
        HashMap<String, String> data = new HashMap<String, String>();
        this.log.info("(pushOfflineOrderPerson)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff1astar!");
        if (StringUtils.isEmpty((CharSequence)order_id)) {
            return false;
        }
        OrderFormVo dto = this.accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
        JSONArray jarr = new JSONArray();
        if (!dto.getProduct_code().contains("TYX") && !dto.getProduct_code().contains("GZZRX")) {
            this.log.info("(pushOfflineOrderPerson)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0cend\uff1a" + dto.getProduct_code());
            return false;
        }
        List<InsPreservationResultSet> setList = this.insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(null, Long.parseLong(order_id), "", "0", "", "");
        if (setList.size() <= 0) {
            this.log.info("(pushOfflineOrderPerson)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0cend\uff1a\u672a\u627e\u5230\u5728\u4fdd\u4eba\u5458\u4fe1\u606f\uff01");
            return false;
        }
        JSONObject jsonObject = null;
        data.put("perNum", String.valueOf(setList.size()));
        for (InsPreservationResultSet set : setList) {
            jsonObject = new JSONObject();
            jsonObject.put("idCardNo", (Object)set.getId_card());
            jsonObject.put("name", (Object)set.getName());
            jarr.add((Object)jsonObject);
        }
        data.put("policyNo", dto.getExternal_reference());
        data.put("userList", jarr.toJSONString());
        String url = "";
        if (dto.getWeb_type().contains("PASP")) {
            url = this.getArsPath(dto.getWeb_type()) + "/enterprise/blb-api-controller/save-offline-order-person";
        }
        this.log.info("(pushOfflineOrderPerson)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0curl\uff1a" + url);
        try {
            this.log.info("(pushOfflineOrderPerson)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0cdata\uff1a" + ((Object)data).toString());
            String result = RestUtil.restful((String)url, data);
            this.log.info("(pushOfflineOrderPerson)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0cresult\uff1a" + result);
            if (StringUtils.isNotEmpty((CharSequence)result)) {
                Result r = (Result)JSON.parseObject((String)result, Result.class);
                this.log.info("(pushOfflineOrderPerson)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0cretType\uff1a" + r.getRetType());
                this.log.info("(pushOfflineOrderPerson)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff0cmsg\uff1a" + r.getMsg());
                this.log.info("(pushOfflineOrderPerson)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff1aend!");
                return "0".equals(r.getRetType());
            }
            this.log.info("(pushOfflineOrderPerson)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff1a\u63a5\u53e3\u8fd4\u56de\u7a7a end!");
            return false;
        }
        catch (IOException e) {
            this.log.info("(pushOfflineOrderPerson)\u8ba2\u5355\u63a8\u9001\u7b2c\u4e09\u65b9\uff1a" + e.getMessage() + " end!");
            return false;
        }
    }

    @Override
    public boolean savePolicyUrlPush(String order_id) {
        HashMap<String, String> data = new HashMap<String, String>();
        boolean flag = false;
        this.log.info("(savePolicyUrlPush)\u7535\u5b50\u4fdd\u5355\u5730\u5740\u63a8\u9001\u7b2c\u4e09\u65b9\u5e73\u53f0\uff1astar!");
        if (StringUtils.isEmpty((CharSequence)order_id)) {
            return flag;
        }
        OrderFormVo dto = this.accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
        String policyUrl = "";
        if (StringUtils.isNotEmpty((CharSequence)dto.getInsure_path())) {
            String string = policyUrl = dto.getInsure_path().contains("http") ? dto.getInsure_path() : GlobalResources.WEB_URL + dto.getInsure_path();
        }
        if (StringUtils.isNotEmpty((CharSequence)policyUrl)) {
            return flag;
        }
        data.put("orderId", dto.getOid());
        data.put("policyUrl", policyUrl);
        String url = "";
        if (dto.getWeb_type().contains("SAAS")) {
            url = this.getArsPath(dto.getWeb_type()) + "/enterprise/blb-api-controller/save-policy-url";
        } else if (dto.getWeb_type().contains("PASP")) {
            url = this.getArsPath(dto.getWeb_type()) + "/enterprise/blb-api-controller/save-policy-url";
        }
        this.log.info("(savePolicyUrlPush)\u7535\u5b50\u4fdd\u5355\u5730\u5740\u63a8\u9001\u7b2c\u4e09\u65b9\u5e73\u53f0\uff0curl\uff1a" + url);
        String result = "";
        try {
            this.log.info("(savePolicyUrlPush)\u7535\u5b50\u4fdd\u5355\u5730\u5740\u63a8\u9001\u7b2c\u4e09\u65b9\u5e73\u53f0\uff0cdata\uff1a" + ((Object)data).toString());
            result = RestUtil.restful((String)url, data);
            this.log.info("(savePolicyUrlPush)\u7535\u5b50\u4fdd\u5355\u5730\u5740\u63a8\u9001\u7b2c\u4e09\u65b9\u5e73\u53f0\uff0cresult\uff1a" + result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            this.log.info("(savePolicyUrlPush)\u7535\u5b50\u4fdd\u5355\u5730\u5740\u63a8\u9001\u7b2c\u4e09\u65b9\u5e73\u53f0\uff1aend!");
            return flag;
        }
        Result r = (Result)JSON.parseObject((String)result, Result.class);
        this.log.info("(savePolicyUrlPush)\u7535\u5b50\u4fdd\u5355\u5730\u5740\u63a8\u9001\u7b2c\u4e09\u65b9\u5e73\u53f0\uff0cretType\uff1a" + r.getRetType());
        this.log.info("(savePolicyUrlPush)\u7535\u5b50\u4fdd\u5355\u5730\u5740\u63a8\u9001\u7b2c\u4e09\u65b9\u5e73\u53f0\uff0cmsg\uff1a" + r.getMsg());
        if ("0".equals(r.getRetType())) {
            flag = true;
        }
        this.log.info("(savePolicyUrlPush)\u7535\u5b50\u4fdd\u5355\u5730\u5740\u63a8\u9001\u7b2c\u4e09\u65b9\u5e73\u53f0\uff1aend!");
        return flag;
    }

    @Override
    public boolean deletePolicyPush(String order_id) {
        HashMap<String, String> data = new HashMap<String, String>();
        boolean flag = false;
        this.log.info("(deletePolicyPush)\u8bf7\u6c42\u7b2c\u4e09\u65b9\u5e9f\u5f03\u4fdd\u5355\uff1astar!");
        if (StringUtils.isEmpty((CharSequence)order_id)) {
            return flag;
        }
        String userResult = this.getTPUserIDByOrderID(Long.parseLong(order_id));
        OrderFormVo dto = this.accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
        if (dto == null) {
            return flag;
        }
        data.put("orderId", dto.getOid());
        String url = "";
        if (dto.getWeb_type().contains("SAAS")) {
            url = this.getArsPath(dto.getWeb_type()) + "/enterprise/blb-api-controller/delete-policy";
        } else if (dto.getWeb_type().contains("PASP")) {
            url = this.getArsPath(dto.getWeb_type()) + "/enterprise/blb-api-controller/delete-policy";
        }
        this.log.info("(deletePolicyPush)\u8bf7\u6c42\u7b2c\u4e09\u65b9\u5e9f\u5f03\u4fdd\u5355\uff0curl\uff1a" + url);
        String result = "";
        try {
            this.log.info("(deletePolicyPush)\u8bf7\u6c42\u7b2c\u4e09\u65b9\u5e9f\u5f03\u4fdd\u5355\uff0cdata\uff1a" + ((Object)data).toString());
            result = RestUtil.restful((String)url, data);
            this.log.info("(deletePolicyPush)\u8bf7\u6c42\u7b2c\u4e09\u65b9\u5e9f\u5f03\u4fdd\u5355\uff0cresult\uff1a" + result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            this.log.info("(deletePolicyPush)\u8bf7\u6c42\u7b2c\u4e09\u65b9\u5e9f\u5f03\u4fdd\u5355\uff1aend!");
            return flag;
        }
        Result r = (Result)JSON.parseObject((String)result, Result.class);
        this.log.info("(deletePolicyPush)\u8bf7\u6c42\u7b2c\u4e09\u65b9\u5e9f\u5f03\u4fdd\u5355\uff0cretType\uff1a" + r.getRetType());
        this.log.info("(deletePolicyPush)\u8bf7\u6c42\u7b2c\u4e09\u65b9\u5e9f\u5f03\u4fdd\u5355\uff0cmsg\uff1a" + r.getMsg());
        if ("0".equals(r.getRetType())) {
            flag = true;
        }
        this.log.info("(deletePolicyPush)\u8bf7\u6c42\u7b2c\u4e09\u65b9\u5e9f\u5f03\u4fdd\u5355\uff1aend!");
        return flag;
    }

    @Override
    public boolean pushRecordInfo(String record_id) {
        this.log.info("(pushRecordInfo)\u4fdd\u5168\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7\u540e\u63a8\u9001\u7b2c\u4e09\u65b9\uff1astart!");
        this.log.info("(pushRecordInfo)\u4fdd\u5168\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7\u540e\u63a8\u9001\u7b2c\u4e09\u65b9\uff0crecord_id\uff1a" + record_id);
        HashMap<String, String> data = new HashMap<String, String>();
        boolean flag = false;
        String url = "";
        if (StringUtils.isEmpty((CharSequence)record_id)) {
            return flag;
        }
        InsPreservationRecordVo iprVo = this.insPreservationRecordAPIService.findInsPreservationRecordVoById(Long.parseLong(record_id));
        String userResult = this.getTPUserIDByOrderID(Long.parseLong(iprVo.getIns_insurance_slip_id()));
        OrderFormVo orderVo = this.accordingToOrderIDToGetPolicyDto(Long.parseLong(iprVo.getIns_insurance_slip_id()));
        if (StringUtils.isNotEmpty((CharSequence)userResult) && orderVo.getWeb_type().contains("BLB")) {
            return true;
        }
        String sign = userResult.split(";")[1];
        if (sign.contains("ARS")) {
            url = this.getArsPath(sign) + "/company/insurancePreservation.json";
            this.setARSParmes(data, iprVo, userResult.split(";")[0]);
        } else if (sign.contains("SAAS")) {
            url = this.getArsPath(sign) + "/enterprise/blb-api-controller/save-preservation-info";
            this.setSAASParmes(data, iprVo, userResult.split(";")[0]);
        } else if (sign.contains("PASP")) {
            url = this.getArsPath(sign) + "/enterprise/blb-api-controller/save-preservation-info";
            this.setPASPParmes(data, iprVo, userResult.split(";")[0]);
        } else if (StringUtils.isNotEmpty((CharSequence)orderVo.getWeb_type()) && orderVo.getWeb_type().contains("PASP")) {
            url = this.getArsPath(orderVo.getWeb_type()) + "/enterprise/blb-api-controller/save-offline-preservation-info";
            this.setPASPOfflineParmes(data, iprVo);
        } else {
            return true;
        }
        if (data == null) {
            this.log.error("(pushRecordInfo)\u4fdd\u5168\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7\u540e\u63a8\u9001\u7b2c\u4e09\u65b9\uff0c\u4fdd\u5168\u4fe1\u606f\u5f02\u5e38\uff01\uff0crecord_id\uff1a" + record_id);
            return flag;
        }
        this.log.info("(pushRecordInfo)\u4fdd\u5168\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7\u540e\u63a8\u9001\u7b2c\u4e09\u65b9\uff0curl\uff1a" + url);
        this.log.info("(pushRecordInfo)\u4fdd\u5168\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7\u540e\u63a8\u9001\u7b2c\u4e09\u65b9\uff0cdata\uff1a" + ((Object)data).toString());
        String result = "";
        try {
            result = RestUtil.restful((String)url, data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            this.log.info("(pushRecordInfo)\u4fdd\u5168\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7\u540e\u63a8\u9001\u7b2c\u4e09\u65b9\uff0c\u66f4\u65b0\u63a8\u9001\u6210\u529f\u6807\u8bc6\uff01");
            return flag;
        }
        this.log.info("(pushRecordInfo)\u4fdd\u5168\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7\u540e\u63a8\u9001\u7b2c\u4e09\u65b9\uff0cAjaxResult\uff1a" + result);
        AjaxResult r = (AjaxResult)JSON.parseObject((String)result, AjaxResult.class);
        if (r.isSuccessful()) {
            this.insPreservationRecordAPIService.updateRecordByIsPush(iprVo.getOid());
            this.log.info("(pushRecordInfo)\u4fdd\u5168\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7\u540e\u63a8\u9001\u7b2c\u4e09\u65b9\uff1aend!----------");
            flag = true;
        }
        this.log.info("(pushRecordInfo)\u4fdd\u5168\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7\u540e\u63a8\u9001\u7b2c\u4e09\u65b9\uff0c\u66f4\u65b0\u63a8\u9001\u6210\u529f\u6807\u8bc6\uff01");
        return flag;
    }

    private void setARSParmes(Map<String, String> data, InsPreservationRecordVo iprVo, String user_id) {
        String roleJson = "";
        if (iprVo.getInsPreservationDetailVoList() != null) {
            JSONObject jsonObject = new JSONObject();
            int count = ConstProp.INT_NUMBER_ZERO;
            jsonObject.put("count", (Object)String.valueOf(iprVo.getInsPreservationDetailVoList().size() - 1));
            for (InsPreservationDetailVo ipdVo : iprVo.getInsPreservationDetailVoList()) {
                jsonObject.put(count + "", (Object)(ipdVo.getId_card() + "#" + iprVo.getRevise_type()));
                ++count;
            }
            roleJson = jsonObject.toString();
        }
        data.put("user_id", user_id);
        data.put("orderNo", iprVo.getIns_insurance_slip_id());
        data.put("cardList", roleJson);
    }

    private void setSAASParmes(Map<String, String> data, InsPreservationRecordVo iprVo, String user_id) {
        String roleJson = "";
        if (iprVo.getInsPreservationDetailVoList() == null) {
            data.put("user_id", user_id);
            data.put("order_no", iprVo.getIns_insurance_slip_id());
            data.put("cardList", roleJson);
            return;
        }
        JSONObject jsonObject = new JSONObject();
        int count = ConstProp.INT_NUMBER_ZERO;
        for (InsPreservationDetailVo ipdVo : iprVo.getInsPreservationDetailVoList()) {
            if ("3".equals(iprVo.getRevise_type())) {
                if (ipdVo.getBusiness_vo() == null) continue;
                jsonObject.put(count + "", (Object)(ipdVo.getId_card() + "#" + ipdVo.getName() + "#" + "1"));
                jsonObject.put(++count + "", (Object)(ipdVo.getBusiness_vo().getId_card() + "#" + ipdVo.getBusiness_vo().getName() + "#" + "2"));
                ++count;
                continue;
            }
            jsonObject.put(count + "", (Object)(ipdVo.getId_card() + "#" + ipdVo.getName() + "#" + iprVo.getRevise_type()));
            ++count;
        }
        if (count == ConstProp.INT_NUMBER_ZERO) {
            data = null;
            return;
        }
        jsonObject.put("count", (Object)String.valueOf(count - 1));
        data.put("user_id", user_id);
        data.put("order_no", iprVo.getIns_insurance_slip_id());
        data.put("cardList", jsonObject.toString());
    }

    private void setPASPParmes(Map<String, String> data, InsPreservationRecordVo iprVo, String user_id) {
        String roleJson = "";
        if (iprVo.getInsPreservationDetailVoList() == null) {
            data.put("user_id", user_id);
            data.put("order_no", iprVo.getIns_insurance_slip_id());
            data.put("cardList", roleJson);
            return;
        }
        JSONObject jsonObject = new JSONObject();
        int count = ConstProp.INT_NUMBER_ZERO;
        for (InsPreservationDetailVo ipdVo : iprVo.getInsPreservationDetailVoList()) {
            if ("3".equals(iprVo.getRevise_type())) {
                if (ipdVo.getBusiness_vo() == null) continue;
                jsonObject.put(count + "", (Object)(ipdVo.getId_card() + "#" + ipdVo.getName() + "#" + "1"));
                jsonObject.put(++count + "", (Object)(ipdVo.getBusiness_vo().getId_card() + "#" + ipdVo.getBusiness_vo().getName() + "#" + "2"));
                ++count;
                continue;
            }
            jsonObject.put(count + "", (Object)(ipdVo.getId_card() + "#" + ipdVo.getName() + "#" + iprVo.getRevise_type()));
            ++count;
        }
        if (count == ConstProp.INT_NUMBER_ZERO) {
            data = null;
            return;
        }
        jsonObject.put("count", (Object)String.valueOf(count - 1));
        data.put("user_id", user_id);
        data.put("order_no", iprVo.getIns_insurance_slip_id());
        data.put("cardList", jsonObject.toString());
    }

    private void setPASPOfflineParmes(Map<String, String> data, InsPreservationRecordVo iprVo) {
        String roleJson = "";
        if (iprVo.getInsPreservationDetailVoList() == null) {
            data.put("policyNo", iprVo.getExternal_reference());
            data.put("cardList", roleJson);
            return;
        }
        JSONObject jsonObject = new JSONObject();
        int count = ConstProp.INT_NUMBER_ZERO;
        for (InsPreservationDetailVo ipdVo : iprVo.getInsPreservationDetailVoList()) {
            if ("3".equals(iprVo.getRevise_type())) {
                if (ipdVo.getBusiness_vo() == null) continue;
                jsonObject.put(count + "", (Object)(ipdVo.getId_card() + "#" + ipdVo.getName() + "#" + "1"));
                jsonObject.put(++count + "", (Object)(ipdVo.getBusiness_vo().getId_card() + "#" + ipdVo.getBusiness_vo().getName() + "#" + "2"));
                ++count;
                continue;
            }
            jsonObject.put(count + "", (Object)(ipdVo.getId_card() + "#" + ipdVo.getName() + "#" + iprVo.getRevise_type()));
            ++count;
        }
        if (count == ConstProp.INT_NUMBER_ZERO) {
            data = null;
            return;
        }
        jsonObject.put("count", (Object)String.valueOf(count - 1));
        data.put("policyNo", iprVo.getExternal_reference());
        data.put("cardList", jsonObject.toString());
    }

    @Override
    public List<InsPreservationDetailVo> getPreservationDetailVoByApi(String cacheId, String sign) {
        this.log.info("(getPreservationDetailVoByApi)\u4fdd\u5168\u4eba\u5458\u8bf7\u6c42\uff1aStar----------------------");
        HashMap<String, String> data = new HashMap<String, String>();
        ArrayList<InsPreservationDetailVo> voList = null;
        List lists = null;
        data.put("cacheId", cacheId);
        this.log.info("(getPreservationDetailVoByApi)\u4fdd\u5168\u4eba\u5458\u8bf7\u6c42\u53c2\u6570\uff0ccacheId\uff1a" + cacheId);
        String url = "";
        if (sign.contains("SAAS")) {
            url = this.getArsPath(sign) + "/enterprise/blb-api-controller/find-perIds-by-cache-id";
        } else if (sign.contains("PASP")) {
            url = this.getArsPath(sign) + "/enterprise/blb-api-controller/find-perIds-by-cache-id";
        }
        this.log.info("(getPreservationDetailVoByApi)\u4fdd\u5168\u4eba\u5458\u8bf7\u6c42\u5730\u5740\uff0curl\uff1a" + url);
        String result = "";
        try {
            result = RequestUtil.sendGet((String)url, (String)("cacheId=" + cacheId));
        }
        catch (Exception e) {
            this.log.error("(getPreservationDetailVoByApi)\u4fdd\u5168\u4eba\u5458\u8bf7\u6c42\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            return voList;
        }
        AjaxResult r = null;
        try {
            r = (AjaxResult)JSON.parseObject((String)result, AjaxResult.class);
        }
        catch (Exception e) {
            this.log.error("(getPreservationDetailVoByApi)\u4fdd\u5168\u4eba\u5458\u6570\u636e\u89e3\u6790\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            return null;
        }
        this.log.info("(getPreservationDetailVoByApi)\u4fdd\u5168\u4eba\u5458\u6570\u636e\uff0cresult\uff1a" + JSONObject.toJSONString((Object)r));
        if (!r.isSuccessful()) {
            return voList;
        }
        lists = (List)r.getData();
        if (lists == null) {
            return voList;
        }
        InsPreservationDetailVo initVo = null;
        Map map = null;
        voList = new ArrayList<InsPreservationDetailVo>();
        for (Object obj : lists) {
            map = (Map)obj;
            if (map == null) continue;
            initVo = new InsPreservationDetailVo();
            HashMap mapn = Maps.newHashMap();
            for (String key : map.keySet()) {
                if ("null".equals(map.get(key)) || map.get(key) == null) continue;
                mapn.put(key, map.get(key));
            }
            try {
                MyConverUtil.map2PO((Map)mapn, (Object)initVo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if ("0".equals(initVo.getId_type()) && StringUtils.isNotEmpty((CharSequence)initVo.getId_card()) && initVo.getId_card().length() == 18) {
                if (StringUtils.isEmpty((CharSequence)initVo.getSex())) {
                    initVo.setSex(IdNumberValidator.getSexFromCard((String)initVo.getId_card()));
                }
                if (StringUtils.isEmpty((CharSequence)initVo.getBirthday())) {
                    initVo.setBirthday(DateUtil.convertDateToString((Date)IdNumberValidator.idNumber2BirthDate((String)initVo.getId_card()), (String)"yyyy-MM-dd"));
                }
            }
            voList.add(initVo);
            initVo = null;
            map = null;
        }
        this.log.info("(getPreservationDetailVoByApi)\u4fdd\u5168\u4eba\u5458\u6570\u636e\uff0cRoleSubjectVoList\uff1a" + voList);
        this.log.info("(getPreservationDetailVoByApi)\u4fdd\u5168\u4eba\u5458\u6570\u636e\uff1aEnd------------------");
        return voList;
    }

    @Override
    public boolean pushBackOrderID(String order_id) {
        return false;
    }

    @Override
    public boolean pushOrderToPSS(String order_id) {
        SpecialPublicDutyVo vo;
        this.log.info("(pushOrderToPSS)\u516c\u8d23\u9669\u627f\u4fdd\u63a8\u9001PSS\u5e73\u53f0\uff0c\u5f00\u59cb-----------");
        this.log.info("(pushOrderToPSS)\u516c\u8d23\u9669\u627f\u4fdd\u63a8\u9001PSS\u5e73\u53f0\uff0corder_id\uff1a" + order_id);
        HashMap<String, String> data = new HashMap<String, String>();
        boolean flag = false;
        if (StringUtils.isEmpty((CharSequence)order_id)) {
            return flag;
        }
        String userResult = this.getTPUserIDByOrderID(Long.parseLong(order_id));
        OrderFormVo dto = this.accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
        if (StringUtils.isEmpty((CharSequence)dto.getExternal_reference())) {
            return flag;
        }
        String invoiceURL = "";
        String insuranceObject = "";
        if (dto.getProduct_code().contains("GZX-HT")) {
            vo = this.accordingToOrderIDToGetSpecialPublicDutyVo(Long.parseLong(order_id));
            invoiceURL = vo.getMailPolicyVo().getE_invoice_url();
            insuranceObject = vo.getReport_name();
        } else if (dto.getProduct_code().contains("ZZX-HT")) {
            vo = this.accordingToOrderIDToGetLOTEPolicyVo(Long.parseLong(order_id));
            invoiceURL = vo.getMailPolicyVo().getE_invoice_url();
            insuranceObject = vo.getSpecialExhibitionVo().getName();
        } else if (dto.getProduct_code().contains("TYX-QH-DQ") || dto.getProduct_code().contains("TYX-HT-DQ")) {
            vo = this.accordingToOrderIDToGetGMRPolicyVo(Long.parseLong(order_id));
            invoiceURL = vo.getMailPolicyVo().getE_invoice_url();
            insuranceObject = vo.getSpecialExhibitionVo().getName();
        }
        data.put("userId", userResult.split(";")[0]);
        data.put("externalReference", dto.getExternal_reference());
        data.put("policyURL", dto.getInsure_path());
        data.put("invoiceURL", invoiceURL);
        data.put("blbOrderId", dto.getOid());
        data.put("orderNo", dto.getTrade_serial_number());
        data.put("applicantName", dto.getApplicant_name());
        data.put("productName", dto.getProduct_name());
        data.put("insuranceName", dto.getInsurance_name());
        data.put("insuranceObject", insuranceObject);
        data.put("inceptionDate", dto.getInception_date());
        data.put("plannedEndDate", dto.getPlanned_end_date());
        data.put("signedDate", dto.getStart_time());
        data.put("policyStatus", "6".equals(dto.getPolicy_status()) ? dto.getPolicy_status() : "12");
        data.put("amount", dto.getGross_premium());
        this.log.info("(pushOrderToPSS)\u516c\u8d23\u9669\u627f\u4fdd\u63a8\u9001PSS\u5e73\u53f0\uff0cdata\uff1a" + JSON.toJSONString(data));
        String url = this.getArsPath(userResult.split(";")[1]) + "/communicate/blb/policy/feedback";
        this.log.info("(pushOrderToPSS)\u516c\u8d23\u9669\u627f\u4fdd\u63a8\u9001PSS\u5e73\u53f0\uff0curl\uff1a" + url);
        String result = "";
        try {
            result = RestUtil.restful((String)url, data);
            this.log.info("(pushOrderToPSS)\u516c\u8d23\u9669\u627f\u4fdd\u63a8\u9001PSS\u5e73\u53f0\uff0cresult\uff1a" + result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            this.log.info("(pushOrderToPSS)\u516c\u8d23\u9669\u627f\u4fdd\u63a8\u9001PSS\u5e73\u53f0\uff0c\u7ed3\u675f-----------------");
            return flag;
        }
        AjaxResult r = (AjaxResult)JSON.parseObject((String)result, AjaxResult.class);
        if (r.isSuccessful()) {
            this.log.info("(pushOrderToPSS)\u516c\u8d23\u9669\u627f\u4fdd\u63a8\u9001PSS\u5e73\u53f0\uff0cisSuccessful\uff1a" + r.isSuccessful());
            flag = true;
        }
        this.log.info("(pushOrderToPSS)\u516c\u8d23\u9669\u627f\u4fdd\u63a8\u9001PSS\u5e73\u53f0\uff0c\u7ed3\u675f-----------------");
        return flag;
    }

    public static void main(String[] args) throws IOException {
        String data = "{\"amount\":\"135.00\",\"orderNo\":\"1749247337408098304\",\"insuranceObject\":\"\u4f19\u98df4\",\"blbOrderId\":\"1749247337563164673\",\"applicantName\":\"\u4f73\u5f18\u5b89\u9632\u670d\u52a1\u516c\u53f8\",\"policyStatus\":\"6\",\"userId\":\"12\",\"productName\":\"\u534e\u6cf0\u4fdd\u5b89\u4eba\u5458\u77ed\u671f\u610f\u5916\u9669\u8ba1\u5212\u56db\",\"plannedEndDate\":\"2024-02-07\",\"externalReference\":\"PB251649722402178487\",\"policyURL\":\"https://test.pc.ehuatai.com:9003/inco-gateway/printPdf?key=E112625FC319387FF7723A39E69B542E\",\"inceptionDate\":\"2024-01-23\",\"insuranceName\":\"\u534e\u6cf0\u4fdd\u9669\u96c6\u56e2\u80a1\u4efd\u6709\u9650\u516c\u53f8\",\"signedDate\":\"2024-01-22 09:47:19\"}";
        Map map = (Map)JSONObject.parseObject((String)data, Map.class);
        String url = "http://localhost:8080/communicate/blb/policy/feedback";
        System.out.println(RestUtil.restful((String)url, (Map)map));
    }

    @Override
    public boolean pushZZXOrderToYWZC(String order_id) {
        this.log.info("(pushZZXOrderToYWZC)\u5c55\u8d23\u9669\u6d3b\u52a8\u63a8\u9001\u4e1a\u52a1\u652f\u6491\uff0c\u5f00\u59cb-----------");
        this.log.info("(pushZZXOrderToYWZC)\u5c55\u8d23\u9669\u6d3b\u52a8\u63a8\u9001\u4e1a\u52a1\u652f\u6491\uff0corder_id\uff1a" + order_id);
        HashMap<String, String> data = new HashMap<String, String>();
        boolean flag = false;
        if (StringUtils.isEmpty((CharSequence)order_id)) {
            return flag;
        }
        OrderFormVo dto = this.accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
        LOTEPolicyVo loteVo = this.accordingToOrderIDToGetLOTEPolicyVo(Long.parseLong(order_id));
        if (loteVo == null) {
            return flag;
        }
        if (StringUtils.isEmpty((CharSequence)loteVo.getSpecialExhibitionVo().getActivity_id())) {
            return flag;
        }
        data.put("activity_id", loteVo.getSpecialExhibitionVo().getActivity_id());
        data.put("exhibition_hall_pos_string", loteVo.getSpecialExhibitionVo().getEx_no());
        data.put("blb_order_id", order_id);
        data.put("blb_product_code", dto.getProduct_code());
        this.log.info("(pushZZXOrderToYWZC)\u5c55\u8d23\u9669\u6d3b\u52a8\u63a8\u9001\u4e1a\u52a1\u652f\u6491\uff0cdata\uff1a" + ((Object)data).toString());
        String url = String.valueOf(GlobalResources.map.get("YWZC_URL")) + "/api/blb/update-exhibition-ins-info";
        this.log.info("(pushZZXOrderToYWZC)\u5c55\u8d23\u9669\u6d3b\u52a8\u63a8\u9001\u4e1a\u52a1\u652f\u6491\uff0curl\uff1a" + url);
        String result = "";
        try {
            result = RestUtil.restful((String)url, data);
            this.log.info("(pushZZXOrderToYWZC)\u5c55\u8d23\u9669\u6d3b\u52a8\u63a8\u9001\u4e1a\u52a1\u652f\u6491\uff0cresult\uff1a" + result);
        }
        catch (IOException e) {
            this.log.info("(pushZZXOrderToYWZC)\u5c55\u8d23\u9669\u6d3b\u52a8\u63a8\u9001\u4e1a\u52a1\u652f\u6491\uff0cERROR\uff1a\u65b9\u6cd5\u6267\u884c\u53d1\u751f\u5f02\u5e38-\u8bb0\u5f55\uff0c\u7b49\u5f85\u91cd\u65b0\u6267\u884c-----------------------");
            this.comTaskResidualAPIService.saveComTaskResidual("pushZZXOrderToYWZC", "\u5c55\u8d23\u9669\u627f\u4fdd\u540e\u63a8\u6d3b\u52a8\u4fe1\u606f\u7ed9\u4e1a\u52a1\u652f\u6491", "com.bcxin.ins.service.order.PolicyService", 1, "String", order_id);
            this.log.info("(pushZZXOrderToYWZC)\u5c55\u8d23\u9669\u6d3b\u52a8\u63a8\u9001\u4e1a\u52a1\u652f\u6491\uff0cERROR\uff1a" + e.getMessage());
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            this.log.info("(pushZZXOrderToYWZC)\u5c55\u8d23\u9669\u6d3b\u52a8\u63a8\u9001\u4e1a\u52a1\u652f\u6491\uff0c\u7ed3\u675f-----------------");
            return flag;
        }
        AjaxResult r = (AjaxResult)JSON.parseObject((String)result, AjaxResult.class);
        if (r.isSuccess()) {
            this.log.info("(pushZZXOrderToYWZC)\u5c55\u8d23\u9669\u6d3b\u52a8\u63a8\u9001\u4e1a\u52a1\u652f\u6491\uff0cisSuccessful\uff1a" + r.isSuccess());
            flag = true;
        } else {
            this.log.info("(pushZZXOrderToYWZC)\u5c55\u8d23\u9669\u6d3b\u52a8\u63a8\u9001\u4e1a\u52a1\u652f\u6491\uff0cERROR\uff1a\u65b9\u6cd5\u6267\u884c\u672a\u8fd4\u56de\u9884\u671f\u7ed3\u679c-\u8bb0\u5f55\uff0c\u7b49\u5f85\u91cd\u65b0\u6267\u884c-----------------------");
            this.comTaskResidualAPIService.saveComTaskResidual("pushZZXOrderToYWZC", "\u5c55\u8d23\u9669\u627f\u4fdd\u540e\u63a8\u6d3b\u52a8\u4fe1\u606f\u7ed9\u4e1a\u52a1\u652f\u6491", "com.bcxin.ins.service.order.PolicyService", 1, "String", order_id);
        }
        this.log.info("(pushZZXOrderToYWZC)\u5c55\u8d23\u9669\u6d3b\u52a8\u63a8\u9001\u4e1a\u52a1\u652f\u6491\uff0c\u7ed3\u675f-----------------");
        return flag;
    }

    @Override
    public List<BLBCommunicationDto> getBLBCommunicationDtoByUserID_PSSAPI(String user_id, String activity_type, String sign, String exclude_id) {
        String result;
        HashMap<String, String> data = new HashMap<String, String>();
        ArrayList<BLBCommunicationDto> voList = null;
        data.put("activity_type", activity_type);
        data.put("user_id", user_id);
        this.log.info("(getBLBCommunicationDtoByUserID_PSSAPI)\uff0cdata:" + ((Object)data).toString());
        String url = this.getArsPath(sign) + "/communicate/blb/activity/list";
        this.log.info("(getBLBCommunicationDtoByUserID_PSSAPI)\uff0curl:" + url);
        try {
            result = RestUtil.restful((String)url, data);
            this.log.info("(getBLBCommunicationDtoByUserID_PSSAPI)\uff0cresult:" + result);
        }
        catch (IOException e) {
            return voList;
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            return voList;
        }
        AjaxResult r = null;
        try {
            r = (AjaxResult)JSON.parseObject((String)result, AjaxResult.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!r.isSuccessful()) {
            return voList;
        }
        List lists = (List)r.getData();
        if (lists == null) {
            return voList;
        }
        BLBCommunicationDto initVo = null;
        Map map = null;
        voList = new ArrayList<BLBCommunicationDto>();
        for (Object obj : lists) {
            map = (Map)obj;
            if (map == null) continue;
            initVo = new BLBCommunicationDto();
            HashMap mapn = Maps.newHashMap();
            for (String key : map.keySet()) {
                if ("null".equals(map.get(key)) || map.get(key) == null) continue;
                mapn.put(key, map.get(key));
            }
            try {
                MyConverUtil.map2PO((Map)mapn, (Object)initVo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (StringUtils.isEmpty((CharSequence)initVo.getActivity_id())) {
                initVo = null;
                map = null;
            }
            if (StringUtils.isNotEmpty((CharSequence)exclude_id) && exclude_id.equals(initVo.getActivity_id())) {
                voList.add(initVo);
            }
            if (!this.specialPublicDutyAPIService.getSpecialPublicDutyVoByThrOrderId(initVo.getActivity_id())) {
                voList.add(initVo);
            }
            initVo = null;
            map = null;
        }
        return voList;
    }

    @Override
    public BLBCommunicationDto getBLBCommunicationDtoByOrderID_PSSAPI(String order_id, String sign) {
        HashMap<String, String> data = new HashMap<String, String>();
        BLBCommunicationDto dto = null;
        data.put("activity_id", order_id);
        String url = this.getArsPath(sign) + "/communicate/blb/activity/detail";
        this.log.info("(getBLBCommunicationDtoByOrderID_PSSAPI)\uff0cdata:" + ((Object)data).toString());
        this.log.info("(getBLBCommunicationDtoByOrderID_PSSAPI)\uff0cpath:" + url);
        String result = "";
        try {
            result = RestUtil.restful((String)url, data);
            this.log.info("(getBLBCommunicationDtoByOrderID_PSSAPI)\uff0cresult:" + result);
        }
        catch (IOException e) {
            return dto;
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            return dto;
        }
        AjaxResult r = null;
        try {
            r = (AjaxResult)JSON.parseObject((String)result, AjaxResult.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!r.isSuccessful()) {
            return dto;
        }
        Object obj = r.getData();
        if (obj == null) {
            return dto;
        }
        Map map = (Map)obj;
        dto = new BLBCommunicationDto();
        HashMap mapn = Maps.newHashMap();
        for (String key : map.keySet()) {
            if ("null".equals(map.get(key)) || map.get(key) == null) continue;
            mapn.put(key, map.get(key));
        }
        try {
            MyConverUtil.map2PO((Map)mapn, (Object)dto);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dto;
    }

    @Override
    public List<RoleSubjectVo> getRoleSubjectVoByUserID_PSSAPI(String user_id, String sign) {
        HashMap<String, String> data = new HashMap<String, String>();
        ArrayList<RoleSubjectVo> voList = null;
        Object list = null;
        List lists = null;
        data.put("user_id", user_id);
        String url = this.getArsPath(sign) + "/communicate/blb/activity/findCompnayAndPersonByUserid";
        String result = "";
        try {
            result = RestUtil.restful((String)url, data);
        }
        catch (IOException e) {
            return voList;
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            return voList;
        }
        AjaxResult r = null;
        try {
            r = (AjaxResult)JSON.parseObject((String)result, AjaxResult.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!r.isSuccessful()) {
            return voList;
        }
        lists = (List)r.getData();
        if (lists == null) {
            return voList;
        }
        RoleSubjectVo initVo = null;
        Map map = null;
        voList = new ArrayList<RoleSubjectVo>();
        for (Object obj : lists) {
            map = (Map)obj;
            if (map == null) continue;
            initVo = new RoleSubjectVo();
            HashMap mapn = Maps.newHashMap();
            for (String key : map.keySet()) {
                if ("null".equals(map.get(key)) || map.get(key) == null) continue;
                mapn.put(key, map.get(key));
            }
            try {
                MyConverUtil.map2PO((Map)mapn, (Object)initVo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            voList.add(initVo);
            initVo = null;
            map = null;
        }
        if (voList.size() <= 0) {
            return voList;
        }
        if ("1".equals(((RoleSubjectVo)voList.get(0)).getKind())) {
            return voList;
        }
        RoleSubjectVo ro = null;
        for (RoleSubjectVo vo : voList) {
            if (!"1".equals(((RoleSubjectVo)voList.get(0)).getKind())) continue;
            ro = vo;
            voList.remove(vo);
        }
        voList.set(0, ro);
        return voList;
    }

    @Override
    public boolean deleteRoleInPolicyByOid(String role_id) {
        boolean flag = false;
        if (StrUtil.isBlank((String)role_id)) {
            return flag;
        }
        try {
            InsRoleInpolicy insRoleInpolicy = (InsRoleInpolicy)this.insRoleInpolicyService.selectById(Long.valueOf(Long.parseLong(role_id)));
            if (insRoleInpolicy != null) {
                this.insRoleInpolicyService.deleteById((Serializable)((Object)role_id));
                flag = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Override
    public boolean delectAllInsRole(String order_id) {
        boolean flag = false;
        if (StrUtil.isNotBlank((CharSequence)order_id)) {
            try {
                flag = this.insRoleInpolicyService.delectAllInsRole(Long.parseLong(order_id));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    @Override
    public boolean deleteHirelingByOid(String hire_id) {
        boolean flag = false;
        if (StrUtil.isNotBlank((CharSequence)hire_id)) {
            flag = this.hirelingAPIService.delectHirelingByOid(Long.parseLong(hire_id));
        }
        return flag;
    }

    @Override
    public boolean delectAllHireling(String order_id) {
        boolean flag = false;
        if (StrUtil.isNotBlank((CharSequence)order_id)) {
            flag = this.hirelingAPIService.delectAllHireling(Long.parseLong(order_id));
        }
        return flag;
    }

    @Override
    public OrderFormVo getPolicyDtoByRcptNo(String rcptno) {
        OrderFormVo vo = null;
        if (StrUtil.isNotBlank((CharSequence)rcptno)) {
            vo = this.insInsuranceSlipService.getOrderFormVoByRcptNo(rcptno);
        }
        return vo;
    }

    @Override
    public void findPolicyListByLapsed() throws ParseException {
        ArrayList<OrderFormVo> doesTimeList = new ArrayList<OrderFormVo>();
        List<OrderFormVo> pdto_1 = this.insInsuranceSlipService.selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(InsOrderSearchVo.build(null, (String)"4", (String)"", (String)"", (String)"", (String)"", (String)"", null));
        List<OrderFormVo> pdto_2 = this.insInsuranceSlipService.selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(InsOrderSearchVo.build(null, (String)"16", (String)"", (String)"", (String)"", (String)"", (String)"", null));
        Date dates = new Date();
        for (OrderFormVo dto : pdto_1) {
            if (StringUtils.isEmpty((CharSequence)dto.getPlanned_end_date()) || !DateUtil.parseDate((String)dto.getPlanned_end_date()).before(dates)) continue;
            doesTimeList.add(dto);
        }
        for (OrderFormVo dto : pdto_2) {
            if (StringUtils.isEmpty((CharSequence)dto.getPlanned_end_date())) {
                dto.setPolicy_status("13");
                this.updateOrderFormStatus(dto);
                continue;
            }
            if (!DateUtil.parseDate((String)dto.getPlanned_end_date()).before(dates)) continue;
            doesTimeList.add(dto);
        }
        List<OrderFormVo> pdto_3 = this.insInsuranceSlipService.selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(InsOrderSearchVo.build(null, (String)"6", (String)"", (String)"", (String)"", (String)"", (String)"", null));
        for (OrderFormVo dto : pdto_3) {
            JedisUtils.del((String)("BLB:CACHE:POLICY-ID-" + dto.getOid()));
            if (StringUtils.isEmpty((CharSequence)dto.getPlanned_end_date())) {
                dto.setPolicy_status("13");
                this.updateOrderFormStatus(dto);
                continue;
            }
            if (!DateUtil.parseDate((String)dto.getPlanned_end_date()).before(dates)) continue;
            doesTimeList.add(dto);
        }
        for (OrderFormVo dto : doesTimeList) {
            dto.setPolicy_status("12");
            this.updateOrderFormStatus(dto);
            if (!StringUtils.isNotEmpty((CharSequence)dto.getProduct_code()) || !"TYX".equals(dto.getProduct_code().split("-")[0])) continue;
            this.pushBackOrderID(dto.getOid());
        }
    }

    @Override
    public void policyPayment_bd_cpic(String policyId, String payType, String userId, HttpServletResponse response) {
        try {
            ComRegion regionPro;
            String val2_;
            List<ComAreaCode> tbpList;
            this.log.info("requestTB(\u6295\u4fdd\u592a\u4fdd\u8bf7\u6c42)\uff1astar-----------------------");
            InsInsuranceSlip policy = this.insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(policyId));
            SpecialBidVo sVo = this.accordingToOrderIDToGetSpecialBidVo(Long.parseLong(policyId));
            OrderFormVo dto = this.accordingToOrderIDToGetPolicyDto(Long.parseLong(policyId));
            PolicyTransactionVo vo = new PolicyTransactionVo();
            IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
            vo.setTrade_serial_number(String.valueOf(idWorker.nextId()));
            String relyCO = "Y";
            String _init = "";
            String msg = "";
            String payforURL = "";
            Communicator communicator = new Communicator();
            vo.setPayment_method("3");
            if (StringUtils.isEmpty((CharSequence)payType)) {
                response.getWriter().print("{\"statusCode\":\"300\",\"message\":\"\u672a\u68c0\u7d22\u5230\u652f\u4ed8\u7c7b\u578b\"}");
                return;
            }
            RegionUtils.getComRegionByCode((String)policy.getCity());
            ComRegion regionCity = RegionUtils.getComRegionByCode((String)policy.getCity());
            String val1_ = regionCity.getNamed().substring(0, regionCity.getNamed().length() - 1);
            List<ComAreaCode> tbsList = this.comAreaCodeAPIService.findComAreaCodeByCode("", "", val1_);
            ComAreaCode tb = null;
            if (tbsList.size() > 0) {
                tb = tbsList.get(0);
            }
            if (tb == null && (tbpList = this.comAreaCodeAPIService.findComAreaCodeByCode("", "", val2_ = (regionPro = RegionUtils.getComRegionByCode((String)policy.getProvince())).getNamed().substring(0, regionPro.getNamed().length() - 1))).size() > 0) {
                tb = tbpList.get(0);
            }
            this.log.info("requestTB(\u6295\u4fdd\u592a\u4fdd\u8bf7\u6c42)/API_CODE\uff1a107001/policyId:" + policyId + ";policyPaymentType:" + payType + ";tb_code:" + tb.getCodes());
            String policyNumber = communicator.sendAndReturn(vo.getTrade_serial_number(), sVo, dto, tb.getCodes(), CommunicateType.TAIBAO, payType, TransType.EPIC_INS, "");
            this.log.info("responseTB(\u8fd4\u56de\u6570\u636e)\uff1a" + policyNumber);
            String[] num = policyNumber.split("#");
            if ("200".equals(num[0])) {
                if (num.length > 2) {
                    policy.setPolicy_serial_number(num[1]);
                    payforURL = num[2];
                }
            } else {
                relyCO = "N";
                if (num.length > 1) {
                    msg = num[1];
                }
            }
            if (!"Y".equals(relyCO)) {
                response.getWriter().print("{\"statusCode\":\"301\",\"message\":\"" + msg + "\"}");
                return;
            }
            vo.setPay_amount(policy.getPremium());
            vo.setOut_of_pocket(policy.getPremium());
            vo.setStart_time(new Date());
            vo.setDeal_url(payforURL);
            vo.setPolicy_id(policyId);
            vo.setPayment_method("1");
            vo.setPath_sign("1");
            vo.setPay_type("3");
            vo.setUser_id(Long.valueOf(Long.parseLong(userId)));
            vo.setPolicy_serial_number(policy.getPolicy_serial_number());
            this.saveTransaction(vo);
            this.insInsuranceSlipService.updateById(policy);
            this.log.info("responseTB(\u652f\u4ed8\u4fe1\u606f\u5f55\u5165\u5b8c\u6210)\uff1aend-------------------------");
            response.getWriter().print("{\"statusCode\":\"200\",\"forwardurl\":\"" + payforURL + "\"}");
        }
        catch (Exception e) {
            this.log.error("\u6295\u6807\u4fdd\u9669\u8ba2\u5355\u6838\u4fdd\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            try {
                response.getWriter().print("{\"statusCode\":\"300\",\"message\":\"\u652f\u4ed8\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\"}");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public String HTTP_DB_BUILD_HB(String oid) {
        this.log.info("HTTP_DB_BUILD_HB(\u90fd\u90a6\u6295\u6807\u4fdd\u9669\u6838\u4fdd\u63a5\u53e3\u8bf7\u6c42)\uff1astar-----------------------");
        try {
            InsInsuranceSlip policy = this.insInsuranceSlipService.selectById(Long.parseLong(oid));
            PolicyTransactionVo vo = new PolicyTransactionVo();
            IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
            vo.setTrade_serial_number(String.valueOf(idWorker.nextId()));
            vo.setPayment_method("3");
            String policyNumber = this.build_DBRequestService.requestDB(Long.parseLong(oid), "1", null);
            this.log.info("HTTP_DB_BUILD_HB(\u6838\u4fdd\u63a5\u53e3\u8fd4\u56de\u6570\u636e)\uff0cpolicyNumber\uff1a" + policyNumber);
            String[] num = policyNumber.split("#");
            if (!"200".equals(num[0])) {
                return "300#" + num[1];
            }
            vo.setPay_amount(policy.getPremium());
            vo.setOut_of_pocket(policy.getPremium());
            vo.setStart_time(new Date());
            vo.setPolicy_id(oid);
            vo.setPayment_method("1");
            vo.setPath_sign("1");
            vo.setPay_type("2");
            vo.setUser_id(policy.getRegister_user_id());
            vo.setPolicy_serial_number(num[1]);
            this.saveTransaction(vo);
            PolicyTransactionVo ptVo = new PolicyTransactionVo();
            ptVo.setPolicy_number(num[2]);
            ptVo.setPolicy_id(oid);
            this.insTransactionService.savePolicyExternalReferenceToDB(ptVo);
            this.log.info("HTTP_DB_BUILD_HB(\u6838\u4fdd\u4fe1\u606f\u5f55\u5165\u5b8c\u6210\uff08\u521d\u59cb\u5316\u652f\u4ed8\u8ba2\u5355\uff09)\uff1aend-------------------------");
            return "200#";
        }
        catch (Exception e) {
            this.log.error("\u90fd\u90a6\u8bf7\u6c42\u6838\u4fdd\u63a5\u53e3\u6570\u636e\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return "300#\u652f\u4ed8\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38";
        }
    }

    @Override
    public String HTTP_YG_BUILD_DZBD(String oid) {
        this.log.info("HTTP_YG_BUILD_DZBD(\u9633\u5149\u7535\u5b50\u4fdd\u5355\u63a5\u53e3\u8bf7\u6c42)\uff1astar-----------------------");
        String downloadUrl = "";
        try {
            OrderFormVo dto = this.accordingToOrderIDToGetPolicyDto(Long.valueOf(oid));
            SpecialBidVo specialBidVo = this.accordingToOrderIDToGetSpecialBidVo(Long.valueOf(oid));
            com.bcxin.ins.third.build.yangguang.yggc.Result result = this.yGGCService.underwritingHttpSend(JSON.toJSONString((Object)BDYGGC.getDemo(dto, specialBidVo)), "2");
            String errorCode = result.getQueryEpolicyDTO().get(0).getErrorCode();
            if ("SUCCESS00000".equals(errorCode)) {
                downloadUrl = result.getQueryEpolicyDTO().get(0).getUrl();
                PolicyTransactionVo vo = new PolicyTransactionVo();
                vo.setPolicy_id(oid);
                vo.setInsure_path(downloadUrl);
                this.insTransactionService.savePolicyOther(vo);
                this.log.info("HTTP_YG_BUILD_DZBD(\u7535\u5b50\u4fdd\u5355\u4e0b\u8f7d\u5730\u5740)\uff1a" + downloadUrl);
            }
        }
        catch (Exception e) {
            this.log.error("\u9633\u5149\u7535\u5b50\u4fdd\u5355\u63a5\u53e3\u8bf7\u6c42\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        this.log.info("HTTP_YG_BUILD_DZBD(\u9633\u5149\u7535\u5b50\u4fdd\u5355\u63a5\u53e3\u8bf7\u6c42)\uff1aend-----------------------");
        return downloadUrl;
    }

    @Override
    public ResultDto uploadPayMentFile_com(String paymentPath, String oid) {
        try {
            JSONObject json = new JSONObject();
            boolean endUpload = false;
            if (StringUtils.isEmpty((CharSequence)oid) && StringUtils.isEmpty((CharSequence)paymentPath)) {
                return new ResultDto("\u8bf7\u91cd\u65b0\u4e0a\u4f20\uff01\uff01", "300", "", "", "");
            }
            InsInsuranceSlip policy = this.insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(oid));
            OrderFormVo dto = this.accordingToOrderIDToGetPolicyDto(policy.getIns_insurance_slip_id());
            InsTransaction transaction = this.insTransactionService.getTranctionByorderIDAndStatus(policy.getIns_insurance_slip_id());
            if (StringUtils.isEmpty((CharSequence)paymentPath)) {
                return new ResultDto("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\uff01\uff01", "300", "", "", "");
            }
            boolean count = false;
            if (transaction == null) {
                PolicyTransactionVo ptVo = new PolicyTransactionVo();
                ptVo.setPolicy_id(String.valueOf(policy.getIns_insurance_slip_id()));
                ptVo.setPay_order_url(paymentPath);
                ptVo.setUser_id(policy.getRegister_user_id());
                ptVo.setPay_amount(policy.getPremium());
                ptVo.setPay_type("6");
                ptVo.setPayment_method(dto.getPay_methods());
                IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
                ptVo.setTrade_serial_number(String.valueOf(idWorker.nextId()));
                this.insTransactionService.saveTransaction(ptVo);
                transaction = this.insTransactionService.getTranctionByorderIDAndStatus(policy.getIns_insurance_slip_id());
                count = true;
            }
            if (!count) {
                transaction.setPay_order_url(paymentPath);
                this.insTransactionService.updateById(transaction);
            }
            if (StringUtils.isNotEmpty((CharSequence)policy.getUser_insure_path()) && StringUtils.isNotEmpty((CharSequence)transaction.getPay_order_url())) {
                endUpload = true;
            }
            if (endUpload) {
                this.saveOrUpdateTransaction_ss(String.valueOf(dto.getOid()), transaction.getPay_order_url(), String.valueOf(policy.getPremium()), transaction.getPath_sign());
            }
            new Thread(() -> this.JFPZ_SendEmail(policy.getIns_insurance_slip_id(), paymentPath)).start();
            return new ResultDto("\u4e0a\u4f20\u6210\u529f\uff01", "200", endUpload + "", "", "");
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u590d\u5370\u4ef6\u4e0a\u4f20\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResultDto("\u4e0a\u4f20\u6587\u4ef6\u66f4\u65b0\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\uff01\uff01", "300", "", "", "");
        }
    }

    @Override
    public void policyToPDF(InsInsuranceSlip policy, String sign) {
        if (StringUtils.isEmpty((CharSequence)policy.getPolicy_serial_number())) {
            return;
        }
        Communicator communicator = new Communicator();
        SpecialBidVo sVo = this.accordingToOrderIDToGetSpecialBidVo(policy.getIns_insurance_slip_id());
        OrderFormVo dto = this.accordingToOrderIDToGetPolicyDto(policy.getIns_insurance_slip_id());
        List<InsTransaction> tList = this.insTransactionService.selectInsTransactionByInsOrderForm(Long.parseLong(dto.getOid()));
        if (tList == null && tList.size() <= 0) {
            return;
        }
        if ("1".equals(sign)) {
            this.sign1Server(policy, sign, communicator, sVo, dto, tList);
        }
        if ("2".equals(sign)) {
            this.sign2Server(policy, sign, communicator, sVo, dto, tList);
        }
    }

    private void sign2Server(InsInsuranceSlip policy, String sign, Communicator communicator, SpecialBidVo sVo, OrderFormVo dto, List<InsTransaction> tList) {
        if (StringUtils.isNotEmpty((CharSequence)policy.getLg_path())) {
            return;
        }
        this.log.debug("b ready to communicator ");
        String policyNumber03 = communicator.sendAndReturn(tList.get(0).getTrade_serial_number(), sVo, dto, "", CommunicateType.TAIBAO, "", TransType.EPIC_EPOLICY, sign);
        this.log.debug("b communicator finish get policyNumber:" + policyNumber03);
        String[] numbers = policyNumber03.split("#");
        if ("200".equals(numbers[0])) {
            policy.setBh_initial(numbers[1]);
            this.insInsuranceSlipService.updateById(policy);
        }
        this.log.debug("b save compelte");
    }

    private void sign1Server(InsInsuranceSlip policy, String sign, Communicator communicator, SpecialBidVo sVo, OrderFormVo dto, List<InsTransaction> tList) {
        if (StringUtils.isNotEmpty((CharSequence)policy.getInsure_path())) {
            return;
        }
        this.log.debug("b ready to communicator ");
        String policyNumber03 = communicator.sendAndReturn(tList.get(0).getTrade_serial_number(), sVo, dto, "", CommunicateType.TAIBAO, "", TransType.EPIC_EPOLICY, sign);
        this.log.debug("b communicator finish get policyNumber:" + policyNumber03);
        String[] numbers = policyNumber03.split("#");
        if ("200".equals(numbers[0])) {
            policy.setInsure_path(numbers[1]);
            this.insInsuranceSlipService.updateById(policy);
        }
        this.log.debug("b save compelte");
    }

    @Override
    public void policyEndStatus(String userId) {
        Long uid = StringUtils.isEmpty((CharSequence)userId) ? null : Long.valueOf(Long.parseLong(userId));
        InsOrderSearchVo search = InsOrderSearchVo.build((Long)uid, (String)"4", (String)"3", (String)"", (String)"", (String)"", (String)"", null);
        List<OrderFormVo> listVo = this.findPolicyForPage(search);
        if (listVo == null) {
            return;
        }
        for (OrderFormVo vo : listVo) {
            if (!StringUtils.isNotEmpty((CharSequence)vo.getProduct_code()) || !"BZX-TB-GCTB".equals(vo.getProduct_code())) continue;
            this.port_107002(vo);
        }
    }

    @Override
    public void port_107002(OrderFormVo dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getPolicy_serial_number()) || StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
            return;
        }
        SpecialBidVo sVo = this.accordingToOrderIDToGetSpecialBidVo(Long.parseLong(dto.getOid()));
        List<InsTransaction> tList = this.insTransactionService.selectInsTransactionByInsOrderForm(Long.parseLong(dto.getOid()));
        if (tList == null || tList.size() <= 0) {
            return;
        }
        Communicator communicator = new Communicator();
        String policyNumber = communicator.sendAndReturn(tList.get(0).getTrade_serial_number(), sVo, dto, "", CommunicateType.TAIBAO, "", TransType.EPIC_QUERY, "");
        String sign = policyNumber.split("#")[0];
        String num = "";
        if (policyNumber.split("#").length > 1) {
            num = policyNumber.split("#")[1];
        }
        if (!"200".equals(sign)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)num)) {
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(num);
            vo.setPolicy_id(dto.getOid());
            this.saveExternalReference(vo);
        }
    }

    @Override
    public boolean HTTP_PAC_ZZX_CB(Long oid, Map<String, String> map) {
        boolean flag = true;
        try {
            this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_ZZX_CB\uff09\uff1astar-----------");
            String result = this.zZX_PACRequestService.requestPAC(oid, "2", map);
            this.log.info("----------PA-ZZX-PolicyDto-request(oid:" + oid + "\uff0c" + result + ")-----------");
            this.log.info("------------" + result);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                flag = false;
                this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_PAC_ZZX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_ZZX_CB\uff09\uff1aend-----------");
                return flag;
            }
            this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_PAC_ZZX_CB\uff09\uff1aSUCCESS!!-----------");
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                flag = false;
                this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fdd\u5355\u53f7\uff08HTTP_PAC_ZZX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_ZZX_CB\uff09\uff1aend-----------");
                return flag;
            }
            this.log.info("----------PA-ZZX-PolicyDto-request(oid:" + oid + "\uff0cSUCCESS!!)-----------");
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(strs[1]);
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference(vo);
            this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u66f4\u65b0\u6570\u636e\u5e93\uff08HTTP_PAC_ZZX_CB\uff09\uff1aSUCCESS!!-----------");
            this.pushZZXOrderToYWZC(String.valueOf(oid));
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u627f\u4fdd\u63a5\u53e3\u8bf7\u6c42\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_ZZX_CB\uff09\uff1aend-----------");
        return flag;
    }

    @Override
    public boolean PAC_ZZX_SAVE_PAY_MSG(Map<String, String> map) {
        boolean flag;
        try {
            OrderFormVo dto = this.insInsuranceSlipService.getOrderFormVoByNoticeNo(map.get("businessNo"));
            if (dto == null && StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
                return true;
            }
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
            pvo.setTrade_serial_number(String.valueOf(idWorker.nextId()));
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setOut_of_pocket(new BigDecimal(map.get("paymentSum")));
            pvo.setStart_time(DateUtil.convertString2Date((String)map.get("paymentDate")));
            pvo.setEnd_time(new Date());
            pvo.setPayment_method("1");
            pvo.setPay_type("7");
            pvo.setPolicy_id(dto.getOid());
            pvo.setTransaction_status("1");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            this.insTransactionService.saveTransaction(pvo);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u652f\u4ed8\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            flag = this.HTTP_PAC_ZZX_CB(Long.parseLong(dto.getOid()), map);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u7ed3\u679c--------" + flag);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
        }
        catch (Exception e) {
            this.log.error("\u5e73\u5b89\u56e2\u610f\u9669\u652f\u4ed8\u56de\u8c03\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        return flag;
    }

    @Override
    public String HTTP_PAC_ZZX_DZBD(Long oid) {
        String path = "";
        try {
            String result = this.zZX_PACRequestService.requestPAC(oid, "3", null);
            this.log.info("----------PAC-ZZX-PolicyDto-request(oid:" + oid + "\uff0c" + result + ")-----------");
            this.log.info("------------" + result);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0]) || StringUtils.isEmpty((CharSequence)strs[1])) {
                return path;
            }
            this.log.info("----------PAC-ZZX-PolicyDto-request(oid:" + oid + "\uff0cSUCCESS!!)-----------");
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_id(String.valueOf(oid));
            vo.setInsure_path(strs[1]);
            this.insTransactionService.savePolicyOther(vo);
            path = strs[1];
        }
        catch (Exception e) {
            this.log.error("\u5e73\u5b89\u8d22\u5c55\u8d23\u9669\u83b7\u53d6\u7535\u5b50\u4fdd\u5355\u63a5\u53e3\u8c03\u7528\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return path;
    }

    @Override
    public boolean HTTP_PAC_GZX_CB(Long oid, Map<String, String> map) {
        boolean flag = true;
        try {
            this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_GZX_CB\uff09\uff1astar-----------");
            String result = this.gZX_PACRequestService.requestPAC(oid, "2", map);
            this.log.info("----------PA-GZX-PolicyDto-request(oid:" + oid + "\uff0c" + result + ")-----------");
            this.log.info("------------" + result);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                flag = false;
                this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_PAC_GZX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_GZX_CB\uff09\uff1aend-----------");
                return flag;
            }
            this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_PAC_GZX_CB\uff09\uff1aSUCCESS!!-----------");
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                flag = false;
                this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fdd\u5355\u53f7\uff08HTTP_PAC_GZX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_GZX_CB\uff09\uff1aend-----------");
                return flag;
            }
            this.log.info("----------PA-GZX-PolicyDto-request(oid:" + oid + "\uff0cSUCCESS!!)-----------");
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(strs[1]);
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference(vo);
            this.returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
            this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u66f4\u65b0\u6570\u636e\u5e93\uff08HTTP_PAC_GZX_CB\uff09\uff1aSUCCESS!!-----------");
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u627f\u4fdd\u63a5\u53e3\u8bf7\u6c42\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_GZX_CB\uff09\uff1aend-----------");
        return flag;
    }

    @Override
    public boolean PAC_GZX_SAVE_PAY_MSG(Map<String, String> map) {
        boolean flag;
        try {
            OrderFormVo dto = this.insInsuranceSlipService.getOrderFormVoByNoticeNo(map.get("businessNo"));
            if (StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
                return true;
            }
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
            pvo.setTrade_serial_number(String.valueOf(idWorker.nextId()));
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setOut_of_pocket(new BigDecimal(map.get("paymentSum")));
            pvo.setStart_time(DateUtil.convertString2Date((String)map.get("paymentDate")));
            pvo.setEnd_time(new Date());
            pvo.setPayment_method("1");
            pvo.setPay_type("7");
            pvo.setPolicy_id(dto.getOid());
            pvo.setTransaction_status("1");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            this.insTransactionService.saveTransaction(pvo);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u652f\u4ed8\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            flag = this.HTTP_PAC_GZX_CB(Long.parseLong(dto.getOid()), map);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u7ed3\u679c--------" + flag);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
        }
        catch (Exception e) {
            this.log.error("\u5e73\u5b89\u56e2\u610f\u9669\u652f\u4ed8\u56de\u8c03\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        return flag;
    }

    @Override
    public void HTTP_PAC_GZX_DZBD(Long oid, Map<String, String> map, OrderFormVo ofVo) {
        try {
            String result = this.gZX_PACRequestService.requestPAC(oid, "3", map);
            this.log.info("----------PAC-GZX-PolicyDto-request(oid:" + oid + "\uff0c" + result + ")-----------");
            this.log.info("------------" + result);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                return;
            }
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                return;
            }
            this.log.info("----------PAC-GZX-PolicyDto-request(oid:" + oid + "\uff0cSUCCESS!!)-----------");
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_id(String.valueOf(oid));
            vo.setInsure_path(strs[1]);
            this.insTransactionService.savePolicyOther(vo);
            ofVo.setInsure_path(strs[1]);
            new Thread(() -> {
                try {
                    this.returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
                }
                catch (Exception e) {
                    this.log.error("------------\u96c7\u4e3b\u8d23\u4efb\u9669\u63a8\u9001\u767e\u4fdd\u76fe\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }).start();
        }
        catch (Exception e) {
            this.log.error("\u5e73\u5b89\u8d22\u516c\u8d23\u9669\u83b7\u53d6\u7535\u5b50\u4fdd\u5355\u63a5\u53e3\u8c03\u7528\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
    }

    @Override
    public boolean HTTP_PAC_TYX_CB(Long oid, Map<String, String> map) {
        boolean flag = false;
        try {
            this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_TYX_CB\uff09\uff1astar-----------");
            if (StringUtils.isEmpty((CharSequence)map.get("policyNo"))) {
                return flag;
            }
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(map.get("policyNo"));
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference(vo);
            String result = this.pACRequestService.requestPAC(oid, "8", null);
            this.log.info("----------PA-TYX-PolicyDto-request(oid:" + oid + "\uff0c" + result + ")-----------");
            this.log.info("------------" + result);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                this.log.info("----------\u5e73\u5b89\u8d22\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_PAC_TYX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u5e73\u5b89\u8d22\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_TYX_CB\uff09\uff1aend-----------");
                return flag;
            }
            this.log.info("----------\u5e73\u5b89\u8d22\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_PAC_TYX_CB\uff09\uff1aSUCCESS!!-----------");
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                this.log.info("----------\u5e73\u5b89\u8d22\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fdd\u5355\u53f7\uff08HTTP_PAC_TYX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u5e73\u5b89\u8d22\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_TYX_CB\uff09\uff1aend-----------");
                return flag;
            }
            this.log.info("----------PA-TYX-PolicyDto-request(oid:" + oid + "\uff0cSUCCESS!!)-----------");
            vo.setInsure_path(strs[1]);
            this.insTransactionService.savePolicyOther(vo);
            new Thread(() -> {
                try {
                    this.returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
                }
                catch (Exception e) {
                    this.log.error("------------\u56e2\u610f\u9669\u63a8\u9001\u767e\u4fdd\u76fe\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }).start();
            this.log.info("----------\u5e73\u5b89\u8d22\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u66f4\u65b0\u6570\u636e\u5e93\uff08HTTP_PAC_TYX_CB\uff09\uff1aSUCCESS!!-----------");
            flag = true;
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u627f\u4fdd\u63a5\u53e3\u8bf7\u6c42\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        this.log.info("----------\u5e73\u5b89\u8d22\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_TYX_CB\uff09\uff1aend-----------");
        return flag;
    }

    @Override
    public boolean HTTP_PAC_GZZRX_CB(Long oid, String policyNo) {
        boolean flag = false;
        try {
            this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_GZZRX_CB\uff09\uff1astar-----------");
            if (StringUtils.isEmpty((CharSequence)policyNo)) {
                return flag;
            }
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(policyNo);
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference_16(vo);
            String result = this.gZZRX_PACRequestService.requestPAC(oid, "8", null);
            this.log.info("----------PAC-GZZRX-PolicyDto-request(oid:" + oid + "\uff0c" + result + ")-----------");
            this.log.info("------------" + result);
            String[] strs = result.split("#");
            if ("200".equals(strs[0]) && StringUtils.isNotEmpty((CharSequence)strs[1])) {
                vo.setInsure_path(strs[1]);
                this.insTransactionService.savePolicyOther(vo);
            }
            new Thread(() -> {
                try {
                    this.returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
                }
                catch (Exception e) {
                    this.log.error("------------\u56e2\u610f\u9669\u63a8\u9001\u767e\u4fdd\u76fe\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }).start();
            this.log.info("----------\u5e73\u5b89\u8d22\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u66f4\u65b0\u6570\u636e\u5e93\uff08HTTP_PAC_GZZRX_CB\uff09\uff1aSUCCESS!!-----------");
            flag = true;
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u627f\u4fdd\u63a5\u53e3\u8bf7\u6c42\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        this.log.info("----------\u5e73\u5b89\u8d22\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_GZZRX_CB\uff09\uff1aend-----------");
        return flag;
    }

    @Override
    public boolean HTTP_PAC_GZZRX_XS_CB(Long oid, Map<String, String> map) {
        boolean flag = false;
        try {
            this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_GZZRX_XS_CB\uff09\uff1astar-----------");
            if (StringUtils.isEmpty((CharSequence)map.get("policyNo"))) {
                return flag;
            }
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(map.get("policyNo"));
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference(vo);
            String result = this.gZZRX_PACRequestService.requestPAC(oid, "8", null);
            this.log.info("----------PAC-GZZRX-PolicyDto-request(oid:" + oid + "\uff0c" + result + ")-----------");
            this.log.info("------------" + result);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                this.log.info("----------\u5e73\u5b89\u8d22\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_PAC_GZZRX_XS_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u5e73\u5b89\u8d22\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_GZZRX_XS_CB\uff09\uff1aend-----------");
                return flag;
            }
            this.log.info("----------\u5e73\u5b89\u8d22\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_PAC_GZZRX_XS_CB\uff09\uff1aSUCCESS!!-----------");
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                this.log.info("----------\u5e73\u5b89\u8d22\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fdd\u5355\u53f7\uff08HTTP_PAC_GZZRX_XS_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u5e73\u5b89\u8d22\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_GZZRX_XS_CB\uff09\uff1aend-----------");
                return flag;
            }
            this.log.info("----------PAC-GZZRX-PolicyDto-request(oid:" + oid + "\uff0cSUCCESS!!)-----------");
            vo.setInsure_path(strs[1]);
            this.insTransactionService.savePolicyOther(vo);
            new Thread(() -> {
                try {
                    this.returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
                }
                catch (Exception e) {
                    this.log.error("------------\u56e2\u610f\u9669\u63a8\u9001\u767e\u4fdd\u76fe\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }).start();
            this.log.info("----------\u5e73\u5b89\u8d22\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u66f4\u65b0\u6570\u636e\u5e93\uff08HTTP_PAC_GZZRX_XS_CB\uff09\uff1aSUCCESS!!-----------");
            flag = true;
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u627f\u4fdd\u63a5\u53e3\u8bf7\u6c42\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        this.log.info("----------\u5e73\u5b89\u8d22\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_GZZRX_XS_CB\uff09\uff1aend-----------");
        return flag;
    }

    @Override
    public void HTTP_PAC_GZZRX_DZBD(OrderFormVo dto) {
        try {
            this.log.info("----------\u5e73\u5b89\u7535\u5b50\u4fdd\u5355\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_GZZRX_DZBD\uff09\uff1astar-----------");
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_id(dto.getOid());
            String result = this.gZZRX_PACRequestService.requestPAC(Long.parseLong(dto.getOid()), "8", null);
            this.log.info("----------PA-GZZRX-PolicyDto-request(oid:" + dto.getOid() + "\uff0c" + result + ")-----------");
            this.log.info("------------" + result);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                this.log.info("----------\u5e73\u5b89\u8d22\u7535\u5b50\u4fdd\u5355\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_PAC_GZZRX_DZBD\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u5e73\u5b89\u8d22\u7535\u5b50\u4fdd\u5355\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_GZZRX_DZBD\uff09\uff1aend-----------");
                return;
            }
            this.log.info("----------\u5e73\u5b89\u8d22\u7535\u5b50\u4fdd\u5355\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_PAC_GZZRX_DZBD\uff09\uff1aSUCCESS!!-----------");
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                this.log.info("----------\u5e73\u5b89\u8d22\u7535\u5b50\u4fdd\u5355\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u5730\u5740\uff08HTTP_PAC_GZZRX_DZBD\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u5e73\u5b89\u8d22\u7535\u5b50\u4fdd\u5355\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_GZZRX_DZBD\uff09\uff1aend-----------");
                return;
            }
            this.log.info("----------PA-GZZRX-PolicyDto-request(oid:" + dto.getOid() + "\uff0cSUCCESS!!)-----------");
            vo.setInsure_path(strs[1]);
            dto.setInsure_path(strs[1]);
            this.insTransactionService.savePolicyOther(vo);
            new Thread(() -> {
                try {
                    this.returnsAnOrderToTheSpecifiedPlatform(dto.getOid());
                }
                catch (Exception e) {
                    this.log.error("------------\u56e2\u610f\u9669\u63a8\u9001\u767e\u4fdd\u76fe\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }).start();
            this.log.info("----------\u5e73\u5b89\u8d22\u7535\u5b50\u4fdd\u5355\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u66f4\u65b0\u6570\u636e\u5e93\uff08HTTP_PAC_GZZRX_DZBD\uff09\uff1aSUCCESS!!-----------");
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u627f\u4fdd\u63a5\u53e3\u8bf7\u6c42\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        this.log.info("----------\u5e73\u5b89\u8d22\u7535\u5b50\u4fdd\u5355\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAC_GZZRX_DZBD\uff09\uff1aend-----------");
    }

    @Override
    public boolean HTTP_CA_GZZRX_CB(Long oid) {
        boolean flag = false;
        try {
            this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_GZZRX_CB\uff09\uff1astar-----------");
            if (oid == null) {
                return flag;
            }
            String result = this.gZZRX_CARequestService.request_ca_gzzrx(oid, TransTypeEnum.CBQR.getValue(), null);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_CA_GZZRX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_GZZRX_CB\uff09\uff1aend-----------");
                return flag;
            }
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fdd\u5355\u53f7\uff08HTTP_CA_GZZRX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_GZZRX_CB\uff09\uff1aend-----------");
                return flag;
            }
            this.log.info("----------CA-GZZRX-PolicyDto-request(oid:" + oid + "\uff0cSUCCESS!!)-----------");
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(strs[1]);
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference(vo);
            if (StringUtils.isNotEmpty((CharSequence)strs[4])) {
                vo.setInsure_path(strs[4]);
                this.insTransactionService.savePolicyOther(vo);
            }
            new Thread(() -> {
                try {
                    this.returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
                }
                catch (Exception e) {
                    this.log.error("------------\u96c7\u4e3b\u9669\u63a8\u9001\u767e\u4fdd\u76fe\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }).start();
            this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u66f4\u65b0\u6570\u636e\u5e93\uff08HTTP_CA_GZZRX_CB\uff09\uff1aSUCCESS!!-----------");
            flag = true;
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u627f\u4fdd\u63a5\u53e3\u8bf7\u6c42\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_GZZRX_CB\uff09\uff1aend-----------");
        return flag;
    }

    @Override
    public boolean BU_HTTP_CA_GZZRX_CB(Long oid, String policyNo, String eUrl) {
        boolean flag = false;
        try {
            if (oid == null) {
                return flag;
            }
            if (StringUtils.isEmpty((CharSequence)policyNo)) {
                return flag;
            }
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(policyNo);
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference(vo);
            if (StringUtils.isNotEmpty((CharSequence)eUrl)) {
                vo.setInsure_path(eUrl);
                this.insTransactionService.savePolicyOther(vo);
            }
            new Thread(() -> {
                try {
                    this.returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
            flag = true;
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return flag;
    }

    @Override
    public boolean CA_GZZRX_SAVE_PAY_MSG(Map<String, String> map) {
        boolean flag;
        try {
            OrderFormVo dto = this.getPolicyDtoByRcptNo(map.get("orderNo"));
            if (StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
                return true;
            }
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setTrade_serial_number(map.get("tradeNo"));
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
            pvo.setEnd_time(DateUtil.convertStringToDate((String)map.get("payTime")));
            pvo.setPayment_method("1");
            pvo.setPay_type(this.payTypeConV(map.get("payType")));
            pvo.setPolicy_id(dto.getOid());
            pvo.setTransaction_status("1");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            this.insTransactionService.saveTransaction(pvo);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u652f\u4ed8\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            flag = this.HTTP_CA_GZZRX_CB(Long.parseLong(dto.getOid()));
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u7ed3\u679c--------" + flag);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            if (!flag) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        }
        catch (Exception e) {
            this.log.error("\u5e73\u5b89\u8d22\u56e2\u610f\u9669\u652f\u4ed8\u56de\u8c03\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean BU_CA_GZZRX_SAVE_PAY_MSG(Map<String, String> map) {
        boolean flag;
        try {
            OrderFormVo dto = this.getPolicyDtoByRcptNo(map.get("orderNo"));
            if (dto == null || StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
                return true;
            }
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setTrade_serial_number(map.get("tradeNo"));
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
            pvo.setEnd_time(DateUtil.convertStringToDate((String)map.get("payTime")));
            pvo.setPayment_method("1");
            pvo.setPay_type(this.payTypeConV(map.get("payType")));
            pvo.setPolicy_id(dto.getOid());
            pvo.setTransaction_status("1");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            this.insTransactionService.saveTransaction(pvo);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u652f\u4ed8\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            flag = this.BU_HTTP_CA_GZZRX_CB(Long.parseLong(dto.getOid()), map.get("policyNo"), map.get("eUrl"));
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u7ed3\u679c--------" + flag);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            if (!flag) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        }
        catch (Exception e) {
            this.log.error("\u5e73\u5b89\u8d22\u56e2\u610f\u9669\u652f\u4ed8\u56de\u8c03\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        return flag;
    }

    private String payTypeConV(String payType) {
        if ("Alipay".equals(payType)) {
            return "1";
        }
        if ("wechat".equals(payType)) {
            return "2";
        }
        if ("unionPay".equals(payType)) {
            return "3";
        }
        if ("netSilver".equals(payType)) {
            return "4";
        }
        if ("yeepay".equals(payType)) {
            return "7";
        }
        if ("offlinepay".equals(payType)) {
            return "6";
        }
        return "";
    }

    @Override
    public boolean HTTP_CA_TYX_CB(Long oid) {
        boolean flag = false;
        try {
            this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_TYX_CB\uff09\uff1astar-----------");
            if (oid == null) {
                return flag;
            }
            String result = this.tYX_CARequestService.request_ca_tyx(oid, TransTypeEnum.CBQR.getValue(), null);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_CA_TYX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_TYX_CB\uff09\uff1aend-----------");
                return flag;
            }
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fdd\u5355\u53f7\uff08HTTP_CA_TYX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_TYX_CB\uff09\uff1aend-----------");
                return flag;
            }
            this.log.info("----------CA-TYX-PolicyDto-request(oid:" + oid + "\uff0cSUCCESS!!)-----------");
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(strs[1]);
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference(vo);
            if (StringUtils.isNotEmpty((CharSequence)strs[4])) {
                vo.setInsure_path(strs[4]);
                this.insTransactionService.savePolicyOther(vo);
            }
            new Thread(() -> {
                try {
                    this.returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
                }
                catch (Exception e) {
                    this.log.error("------------\u96c7\u4e3b\u9669\u63a8\u9001\u767e\u4fdd\u76fe\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }).start();
            this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u66f4\u65b0\u6570\u636e\u5e93\uff08HTTP_CA_TYX_CB\uff09\uff1aSUCCESS!!-----------");
            flag = true;
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u627f\u4fdd\u63a5\u53e3\u8bf7\u6c42\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_TYX_CB\uff09\uff1aend-----------");
        return flag;
    }

    @Override
    public boolean BU_HTTP_CA_TYX_CB(Long oid, String policyNo, String eUrl) {
        boolean flag = false;
        try {
            if (oid == null) {
                return flag;
            }
            if (StringUtils.isEmpty((CharSequence)policyNo)) {
                return flag;
            }
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(policyNo);
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference(vo);
            if (StringUtils.isNotEmpty((CharSequence)eUrl)) {
                vo.setInsure_path(eUrl);
                this.insTransactionService.savePolicyOther(vo);
            }
            new Thread(() -> {
                try {
                    this.returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
            flag = true;
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return flag;
    }

    @Override
    public boolean CA_TYX_SAVE_PAY_MSG(Map<String, String> map) {
        boolean flag;
        try {
            OrderFormVo dto = this.getPolicyDtoByRcptNo(map.get("orderNo"));
            if (StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
                return true;
            }
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setTrade_serial_number(map.get("tradeNo"));
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
            pvo.setEnd_time(DateUtil.convertStringToDate((String)map.get("payTime")));
            pvo.setPayment_method("1");
            pvo.setPay_type(this.payTypeConV(map.get("payType")));
            pvo.setPolicy_id(dto.getOid());
            pvo.setTransaction_status("1");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            this.insTransactionService.saveTransaction(pvo);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u652f\u4ed8\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            flag = this.HTTP_CA_TYX_CB(Long.parseLong(dto.getOid()));
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u7ed3\u679c--------" + flag);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            if (!flag) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        }
        catch (Exception e) {
            this.log.error("\u5e73\u5b89\u8d22\u56e2\u610f\u9669\u652f\u4ed8\u56de\u8c03\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean BU_CA_TYX_SAVE_PAY_MSG(Map<String, String> map) {
        boolean flag;
        try {
            OrderFormVo dto = this.getPolicyDtoByRcptNo(map.get("orderNo"));
            if (dto == null || StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
                return true;
            }
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setTrade_serial_number(map.get("tradeNo"));
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
            pvo.setEnd_time(DateUtil.convertStringToDate((String)map.get("payTime")));
            pvo.setPayment_method("1");
            pvo.setPay_type(this.payTypeConV(map.get("payType")));
            pvo.setPolicy_id(dto.getOid());
            pvo.setTransaction_status("1");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            this.insTransactionService.saveTransaction(pvo);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u652f\u4ed8\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            flag = this.BU_HTTP_CA_TYX_CB(Long.parseLong(dto.getOid()), map.get("policyNo"), map.get("eUrl"));
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u7ed3\u679c--------" + flag);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            if (!flag) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        }
        catch (Exception e) {
            this.log.error("\u5e73\u5b89\u8d22\u56e2\u610f\u9669\u652f\u4ed8\u56de\u8c03\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean HTTP_CA_GYX_CB(Long oid) {
        boolean flag = false;
        try {
            this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_GYX_CB\uff09\uff1astar-----------");
            if (oid == null) {
                return flag;
            }
            String result = this.gYX_CARequestService.request_ca_gyx(oid, TransTypeEnum.CBQR.getValue());
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_CA_GYX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_GYX_CB\uff09\uff1aend-----------");
                return flag;
            }
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fdd\u5355\u53f7\uff08HTTP_CA_GYX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_GYX_CB\uff09\uff1aend-----------");
                return flag;
            }
            this.log.info("----------CA-GYX-PolicyDto-request(oid:" + oid + "\uff0cSUCCESS!!)-----------");
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(strs[1]);
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference(vo);
            if (StringUtils.isNotEmpty((CharSequence)strs[4])) {
                vo.setInsure_path(strs[4]);
                this.insTransactionService.savePolicyOther(vo);
            }
            new Thread(() -> {
                try {
                    this.returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
                }
                catch (Exception e) {
                    this.log.error("------------\u4e2a\u610f\u9669\u63a8\u9001\u767e\u4fdd\u76fe\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }).start();
            this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u66f4\u65b0\u6570\u636e\u5e93\uff08HTTP_CA_GYX_CB\uff09\uff1aSUCCESS!!-----------");
            flag = true;
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u627f\u4fdd\u63a5\u53e3\u8bf7\u6c42\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_GYX_CB\uff09\uff1aend-----------");
        return flag;
    }

    @Override
    public boolean BU_HTTP_CA_GYX_CB(Long oid, String policyNo, String eUrl) {
        boolean flag = false;
        try {
            if (oid == null) {
                return flag;
            }
            if (StringUtils.isEmpty((CharSequence)policyNo)) {
                return flag;
            }
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(policyNo);
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference(vo);
            if (StringUtils.isNotEmpty((CharSequence)eUrl)) {
                vo.setInsure_path(eUrl);
                this.insTransactionService.savePolicyOther(vo);
            }
            new Thread(() -> {
                try {
                    this.returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
            flag = true;
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return flag;
    }

    @Override
    public boolean CA_GYX_SAVE_PAY_MSG(Map<String, String> map) {
        boolean flag;
        try {
            OrderFormVo dto = this.getPolicyDtoByRcptNo(map.get("orderNo"));
            if (StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
                return true;
            }
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setTrade_serial_number(map.get("tradeNo"));
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
            pvo.setEnd_time(DateUtil.convertStringToDate((String)map.get("payTime")));
            pvo.setPayment_method("1");
            pvo.setPay_type(this.payTypeConV(map.get("payType")));
            pvo.setPolicy_id(dto.getOid());
            pvo.setTransaction_status("1");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            this.insTransactionService.saveTransaction(pvo);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u652f\u4ed8\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            flag = this.HTTP_CA_GYX_CB(Long.parseLong(dto.getOid()));
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u7ed3\u679c--------" + flag);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            if (!flag) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        }
        catch (Exception e) {
            this.log.error("\u957f\u5b89\u4e2a\u4eba\u610f\u5916\u9669\u652f\u4ed8\u56de\u8c03\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean BU_CA_GYX_SAVE_PAY_MSG(Map<String, String> map) {
        boolean flag;
        try {
            OrderFormVo dto = this.getPolicyDtoByRcptNo(map.get("orderNo"));
            if (dto == null || StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
                return true;
            }
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setTrade_serial_number(map.get("tradeNo"));
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
            pvo.setEnd_time(DateUtil.convertStringToDate((String)map.get("payTime")));
            pvo.setPayment_method("1");
            pvo.setPay_type(this.payTypeConV(map.get("payType")));
            pvo.setPolicy_id(dto.getOid());
            pvo.setTransaction_status("1");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            this.insTransactionService.saveTransaction(pvo);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u652f\u4ed8\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            flag = this.BU_HTTP_CA_GYX_CB(Long.parseLong(dto.getOid()), map.get("policyNo"), map.get("eUrl"));
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u7ed3\u679c--------" + flag);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            if (!flag) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        }
        catch (Exception e) {
            this.log.error("\u957f\u5b89\u4e2a\u4eba\u610f\u5916\u9669\u652f\u4ed8\u56de\u8c03\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean HTTP_CA_GZX_CB(Long oid) {
        boolean flag = false;
        try {
            this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_GZX_CB\uff09\uff1astar-----------");
            if (oid == null) {
                return flag;
            }
            String result = this.gZX_CARequestService.request_ca_gzx(oid, TransTypeEnum.CBQR.getValue());
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_CA_GZX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_GZX_CB\uff09\uff1aend-----------");
                return flag;
            }
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fdd\u5355\u53f7\uff08HTTP_CA_GZX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_GZX_CB\uff09\uff1aend-----------");
                return flag;
            }
            this.log.info("----------CA-GZZRX-PolicyDto-request(oid:" + oid + "\uff0cSUCCESS!!)-----------");
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(strs[1]);
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference(vo);
            if (StringUtils.isNotEmpty((CharSequence)strs[4])) {
                vo.setInsure_path(strs[4]);
                this.insTransactionService.savePolicyOther(vo);
            }
            new Thread(() -> {
                try {
                    this.returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
                }
                catch (Exception e) {
                    this.log.error("------------\u63a8\u9001\u767e\u4fdd\u76fe\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }).start();
            this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u66f4\u65b0\u6570\u636e\u5e93\uff08HTTP_CA_GZZRX_CB\uff09\uff1aSUCCESS!!-----------");
            flag = true;
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u627f\u4fdd\u63a5\u53e3\u8bf7\u6c42\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_GZZRX_CB\uff09\uff1aend-----------");
        return flag;
    }

    @Override
    public boolean BU_HTTP_CA_GZX_CB(Long oid, String policyNo, String eUrl) {
        boolean flag = false;
        try {
            if (oid == null) {
                return flag;
            }
            if (StringUtils.isEmpty((CharSequence)policyNo)) {
                return flag;
            }
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(policyNo);
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference(vo);
            if (StringUtils.isNotEmpty((CharSequence)eUrl)) {
                vo.setInsure_path(eUrl);
                this.insTransactionService.savePolicyOther(vo);
            }
            new Thread(() -> {
                try {
                    this.returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
            flag = true;
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return flag;
    }

    @Override
    public boolean CA_GZX_SAVE_PAY_MSG(Map<String, String> map) {
        boolean flag;
        try {
            OrderFormVo dto = this.getPolicyDtoByRcptNo(map.get("orderNo"));
            if (StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
                return true;
            }
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setTrade_serial_number(map.get("tradeNo"));
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
            pvo.setEnd_time(DateUtil.convertStringToDate((String)map.get("payTime")));
            pvo.setPayment_method("1");
            pvo.setPay_type(this.payTypeConV(map.get("payType")));
            pvo.setPolicy_id(dto.getOid());
            pvo.setTransaction_status("1");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            this.insTransactionService.saveTransaction(pvo);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u652f\u4ed8\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            flag = this.HTTP_CA_GZX_CB(Long.parseLong(dto.getOid()));
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u7ed3\u679c--------" + flag);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            if (!flag) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        }
        catch (Exception e) {
            this.log.error("\u957f\u5b89\u516c\u4f17\u8d23\u4efb\u9669\u652f\u4ed8\u56de\u8c03\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean BU_CA_GZX_SAVE_PAY_MSG(Map<String, String> map) {
        boolean flag;
        try {
            OrderFormVo dto = this.getPolicyDtoByRcptNo(map.get("orderNo"));
            if (dto == null || StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
                return true;
            }
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setTrade_serial_number(map.get("tradeNo"));
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
            pvo.setEnd_time(DateUtil.convertStringToDate((String)map.get("payTime")));
            pvo.setPayment_method("1");
            pvo.setPay_type(this.payTypeConV(map.get("payType")));
            pvo.setPolicy_id(dto.getOid());
            pvo.setTransaction_status("1");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            this.insTransactionService.saveTransaction(pvo);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u652f\u4ed8\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            flag = this.BU_HTTP_CA_GZX_CB(Long.parseLong(dto.getOid()), map.get("policyNo"), map.get("eUrl"));
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u7ed3\u679c--------" + flag);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            if (!flag) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        }
        catch (Exception e) {
            this.log.error("\u957f\u5b89\u516c\u4f17\u8d23\u4efb\u9669\u652f\u4ed8\u56de\u8c03\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean HTTP_CA_ZZX_CB(Long oid) {
        boolean flag = false;
        try {
            this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_ZZX_CB\uff09\uff1astar-----------");
            if (oid == null) {
                return flag;
            }
            String result = this.zZX_CARequestService.request_ca_zzx(oid, TransTypeEnum.CBQR.getValue());
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_CA_ZZX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_ZZX_CB\uff09\uff1aend-----------");
                return flag;
            }
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fdd\u5355\u53f7\uff08HTTP_CA_ZZX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_ZZX_CB\uff09\uff1aend-----------");
                return flag;
            }
            this.log.info("----------CA-ZZX-PolicyDto-request(oid:" + oid + "\uff0cSUCCESS!!)-----------");
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(strs[1]);
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference(vo);
            if (StringUtils.isNotEmpty((CharSequence)strs[4])) {
                vo.setInsure_path(strs[4]);
                this.insTransactionService.savePolicyOther(vo);
            }
            new Thread(() -> {
                try {
                    this.returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
                }
                catch (Exception e) {
                    this.log.error("------------\u63a8\u9001\u767e\u4fdd\u76fe\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }).start();
            this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u66f4\u65b0\u6570\u636e\u5e93\uff08HTTP_CA_ZZX_CB\uff09\uff1aSUCCESS!!-----------");
            flag = true;
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u627f\u4fdd\u63a5\u53e3\u8bf7\u6c42\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        this.log.info("----------\u957f\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_CA_ZZX_CB\uff09\uff1aend-----------");
        return flag;
    }

    @Override
    public boolean BU_HTTP_CA_ZZX_CB(Long oid, String policyNo, String eUrl) {
        boolean flag = false;
        try {
            if (oid == null) {
                return flag;
            }
            if (StringUtils.isEmpty((CharSequence)policyNo)) {
                return flag;
            }
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(policyNo);
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference(vo);
            if (StringUtils.isNotEmpty((CharSequence)eUrl)) {
                vo.setInsure_path(eUrl);
                this.insTransactionService.savePolicyOther(vo);
            }
            new Thread(() -> {
                try {
                    this.returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
            flag = true;
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return flag;
    }

    @Override
    public boolean CA_ZZX_SAVE_PAY_MSG(Map<String, String> map) {
        boolean flag;
        try {
            OrderFormVo dto = this.getPolicyDtoByRcptNo(map.get("orderNo"));
            if (StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
                return true;
            }
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setTrade_serial_number(map.get("tradeNo"));
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
            pvo.setEnd_time(DateUtil.convertStringToDate((String)map.get("payTime")));
            pvo.setPayment_method("1");
            pvo.setPay_type(this.payTypeConV(map.get("payType")));
            pvo.setPolicy_id(dto.getOid());
            pvo.setTransaction_status("1");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            this.insTransactionService.saveTransaction(pvo);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u652f\u4ed8\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            flag = this.HTTP_CA_ZZX_CB(Long.parseLong(dto.getOid()));
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u7ed3\u679c--------" + flag);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            if (!flag) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        }
        catch (Exception e) {
            this.log.error("\u957f\u5b89\u5c55\u4f1a\u8d23\u4efb\u9669\u652f\u4ed8\u56de\u8c03\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean BU_CA_ZZX_SAVE_PAY_MSG(Map<String, String> map) {
        boolean flag;
        try {
            OrderFormVo dto = this.getPolicyDtoByRcptNo(map.get("orderNo"));
            if (dto == null || StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
                return true;
            }
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setTrade_serial_number(map.get("tradeNo"));
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setOut_of_pocket(new BigDecimal(dto.getGross_premium()));
            pvo.setEnd_time(DateUtil.convertStringToDate((String)map.get("payTime")));
            pvo.setPayment_method("1");
            pvo.setPay_type(this.payTypeConV(map.get("payType")));
            pvo.setPolicy_id(dto.getOid());
            pvo.setTransaction_status("1");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            this.insTransactionService.saveTransaction(pvo);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u652f\u4ed8\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            flag = this.BU_HTTP_CA_ZZX_CB(Long.parseLong(dto.getOid()), map.get("policyNo"), map.get("eUrl"));
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u7ed3\u679c--------" + flag);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            if (!flag) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        }
        catch (Exception e) {
            this.log.error("\u957f\u5b89\u5c55\u4f1a\u8d23\u4efb\u9669\u652f\u4ed8\u56de\u8c03\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean PAC_GZZRX_SAVE_PAY_MSG(Map<String, String> map) {
        boolean flag;
        try {
            OrderFormVo dto = this.insInsuranceSlipService.getOrderFormVoByNoticeNo(map.get("noticeNo"));
            if (StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
                return true;
            }
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setTrade_serial_number(map.get("tradeNo"));
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setOut_of_pocket(new BigDecimal(map.get("paymentSum")));
            pvo.setStart_time(new Date());
            pvo.setEnd_time(new Date());
            pvo.setPayment_method("1");
            pvo.setPay_type("7");
            pvo.setPolicy_id(dto.getOid());
            pvo.setTransaction_status("1");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            this.insTransactionService.saveTransaction(pvo);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u652f\u4ed8\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            flag = this.HTTP_PAC_GZZRX_XS_CB(Long.parseLong(dto.getOid()), map);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u7ed3\u679c--------" + flag);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
        }
        catch (Exception e) {
            this.log.error("\u5e73\u5b89\u8d22\u56e2\u610f\u9669\u652f\u4ed8\u56de\u8c03\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean PAC_TYX_SAVE_PAY_MSG(Map<String, String> map) {
        boolean flag;
        try {
            OrderFormVo dto = this.insInsuranceSlipService.getOrderFormVoByNoticeNo(map.get("noticeNo"));
            if (StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
                return true;
            }
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setTrade_serial_number(map.get("tradeNo"));
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setOut_of_pocket(new BigDecimal(map.get("paymentSum")));
            pvo.setStart_time(new Date());
            pvo.setEnd_time(new Date());
            pvo.setPayment_method("1");
            pvo.setPay_type("7");
            pvo.setPolicy_id(dto.getOid());
            pvo.setTransaction_status("1");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            this.insTransactionService.saveTransaction(pvo);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u652f\u4ed8\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            flag = this.HTTP_PAC_TYX_CB(Long.parseLong(dto.getOid()), map);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u7ed3\u679c--------" + flag);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
        }
        catch (Exception e) {
            this.log.error("\u5e73\u5b89\u8d22\u56e2\u610f\u9669\u652f\u4ed8\u56de\u8c03\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean HTTP_PAS_TYX_CB(Long oid, Map<String, String> map) {
        boolean flag = true;
        try {
            this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAS_TYX_CB\uff09\uff1astar-----------");
            String result = this.pARequestService.requestPA(oid, "5", map);
            this.log.info("----------PAS-TYX-PolicyDto-request(oid:" + oid + "\uff0c" + result + ")-----------");
            this.log.info("------------" + result);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                flag = false;
                this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_PAS_TYX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAS_TYX_CB\uff09\uff1aend-----------");
                return flag;
            }
            this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_PAS_TYX_CB\uff09\uff1aSUCCESS!!-----------");
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                flag = false;
                this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fdd\u5355\u53f7\uff08HTTP_PAS_TYX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAS_TYX_CB\uff09\uff1aend-----------");
                return flag;
            }
            this.log.info("----------PAS-TYX-PolicyDto-request(oid:" + oid + "\uff0cSUCCESS!!)-----------");
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(strs[1]);
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference(vo);
            if (strs.length == 3) {
                vo.setInsure_path(strs[2]);
                this.insTransactionService.savePolicyOther(vo);
            }
            new Thread(() -> {
                try {
                    this.returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
                }
                catch (Exception e) {
                    this.log.error("------------\u96c7\u4e3b\u8d23\u4efb\u9669\u63a8\u9001\u767e\u4fdd\u76fe\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }).start();
            this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u66f4\u65b0\u6570\u636e\u5e93\uff08HTTP_PAS_TYX_CB\uff09\uff1aSUCCESS!!-----------");
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u627f\u4fdd\u63a5\u53e3\u8bf7\u6c42\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAS_TYX_CB\uff09\uff1aend-----------");
        return flag;
    }

    @Override
    public boolean HTTP_PAS_TYX_CB_TEMPORARY(Long oid, Map<String, String> map) {
        boolean flag = true;
        try {
            this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAS_TYX_CB\uff09\uff1astar-----------");
            String result = "200#" + map.get("policy");
            this.log.info("----------PAS-TYX-PolicyDto-request(oid:" + oid + "\uff0c" + result + ")-----------");
            this.log.info("------------" + result);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                flag = false;
                this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_PAS_TYX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAS_TYX_CB\uff09\uff1aend-----------");
                return flag;
            }
            this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_PAS_TYX_CB\uff09\uff1aSUCCESS!!-----------");
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                flag = false;
                this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fdd\u5355\u53f7\uff08HTTP_PAS_TYX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAS_TYX_CB\uff09\uff1aend-----------");
                return flag;
            }
            this.log.info("----------PAS-TYX-PolicyDto-request(oid:" + oid + "\uff0cSUCCESS!!)-----------");
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(strs[1]);
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference(vo);
            if (strs.length == 3) {
                vo.setInsure_path(strs[2]);
                this.insTransactionService.savePolicyOther(vo);
            }
            new Thread(() -> {
                try {
                    this.returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
                }
                catch (Exception e) {
                    this.log.error("------------\u96c7\u4e3b\u8d23\u4efb\u9669\u63a8\u9001\u767e\u4fdd\u76fe\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }).start();
            this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u66f4\u65b0\u6570\u636e\u5e93\uff08HTTP_PAS_TYX_CB\uff09\uff1aSUCCESS!!-----------");
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u627f\u4fdd\u63a5\u53e3\u8bf7\u6c42\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        this.log.info("----------\u5e73\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_PAS_TYX_CB\uff09\uff1aend-----------");
        return flag;
    }

    @Override
    public boolean PAS_TYX_SAVE_PAY_MSG(PingAnPayVo paVo) {
        boolean flag;
        try {
            Map map = MyConverUtil.PO2Map((Object)paVo);
            OrderFormVo dto = this.getPolicyDtoByRcptNo(paVo.getRcptno());
            if (StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
                return true;
            }
            String _dts = paVo.getBankTranDate() + " " + paVo.getBankTranTime();
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setTrade_serial_number(paVo.getBankTradeNo());
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setStart_time(DateUtil.convertString2Date((String)_dts));
            pvo.setEnd_time(new Date());
            pvo.setPayment_method("1");
            pvo.setPay_type("2");
            pvo.setPolicy_id(dto.getOid());
            pvo.setTransaction_status("1");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            this.insTransactionService.saveTransaction(pvo);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u652f\u4ed8\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            flag = this.HTTP_PAS_TYX_CB(Long.parseLong(dto.getOid()), map);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u7ed3\u679c--------" + flag);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            this.log.info("\u652f\u4ed8\u8bf7\u6c42\uff1a" + paVo.toString());
        }
        catch (Exception e) {
            this.log.error("\u5e73\u5b89\u56e2\u610f\u9669\u652f\u4ed8\u56de\u8c03\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean PAS_TYX_SAVE_PAY_MSG_TEMPORARY(PingAnPayVo paVo) {
        boolean flag;
        try {
            Map map = MyConverUtil.PO2Map((Object)paVo);
            OrderFormVo dto = this.getPolicyDtoByRcptNo(paVo.getRcptno());
            if (StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
                return true;
            }
            String _dts = paVo.getBankTranDate() + " " + paVo.getBankTranTime();
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setTrade_serial_number(paVo.getBankTradeNo());
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setStart_time(DateUtil.convertString2Date((String)_dts));
            pvo.setEnd_time(new Date());
            pvo.setPayment_method("1");
            pvo.setPay_type("2");
            pvo.setPolicy_id(dto.getOid());
            pvo.setTransaction_status("1");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            this.insTransactionService.saveTransaction(pvo);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u652f\u4ed8\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            flag = this.HTTP_PAS_TYX_CB_TEMPORARY(Long.parseLong(dto.getOid()), map);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u7ed3\u679c--------" + flag);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            this.log.info("\u652f\u4ed8\u8bf7\u6c42\uff1a" + paVo.toString());
        }
        catch (Exception e) {
            this.log.error("\u5e73\u5b89\u56e2\u610f\u9669\u652f\u4ed8\u56de\u8c03\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        return flag;
    }

    @Override
    public void HTTP_PAS_TYX_DZBD(Long oid, Map<String, String> map, OrderFormVo ofVo) {
        try {
            String result = this.pARequestService.requestPA(oid, "6", map);
            this.log.info("----------PA-TYX-PolicyDto-request(oid:" + oid + "\uff0c" + result + ")-----------");
            this.log.info("------------" + result);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                return;
            }
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                return;
            }
            this.log.info("----------PA-TYX-PolicyDto-request(oid:" + oid + "\uff0cSUCCESS!!)-----------");
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_id(String.valueOf(oid));
            vo.setInsure_path(strs[1]);
            this.insTransactionService.savePolicyOther(vo);
            ofVo.setInsure_path(strs[1]);
            new Thread(() -> {
                try {
                    this.savePolicyUrlPush(String.valueOf(oid));
                }
                catch (Exception e) {
                    this.log.error("------------\u7535\u5b50\u4fdd\u5355\u5730\u5740\u63a8\u9001SAAS\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }).start();
        }
        catch (Exception e) {
            this.log.error("\u5e73\u5b89\u56e2\u610f\u9669\u83b7\u53d6\u7535\u5b50\u4fdd\u5355\u63a5\u53e3\u8c03\u7528\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
    }

    @Override
    public void pa_reconciliation_underwrite(String rcptno, String p_policy_no) {
        try {
            if (StringUtils.isEmpty((CharSequence)rcptno) || StringUtils.isEmpty((CharSequence)p_policy_no)) {
                return;
            }
            OrderFormVo dto = this.getPolicyDtoByRcptNo(rcptno);
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(p_policy_no);
            vo.setPolicy_id(dto.getOid());
            this.insTransactionService.savePolicyExternalReference(vo);
            new Thread(() -> {
                try {
                    this.returnsAnOrderToTheSpecifiedPlatform(dto.getOid());
                }
                catch (Exception e) {
                    this.log.error("------------\u96c7\u4e3b\u8d23\u4efb\u9669\u63a8\u9001\u767e\u4fdd\u76fe\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }).start();
        }
        catch (Exception e) {
            this.log.error("\u5e73\u5b89\u56e2\u610f\u9669\u5bf9\u8d26\u63a5\u53e3\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
    }

    @Override
    public void HTTP_TK_TYX_CB(Long oid) throws Exception {
        try {
            String result = this.tKRequestService.requestTK(oid, "02");
            this.log.info("----------TK-TYX-PolicyDto-request(oid:" + oid + "\uff0c" + result + ")-----------");
            this.log.info("------------" + result);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0]) || strs.length != 3) {
                return;
            }
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                return;
            }
            this.log.info("----------TK-TYX-PolicyDto-request(oid:" + oid + "\uff0cSUCCESS!!)-----------");
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(strs[1]);
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference(vo);
            vo.setInsure_path(strs[2]);
            this.insTransactionService.savePolicyOther(vo);
            new Thread(() -> {
                try {
                    this.returnsAnOrderToTheSpecifiedPlatform(String.valueOf(oid));
                }
                catch (Exception e) {
                    this.log.error("------------\u96c7\u4e3b\u8d23\u4efb\u9669\u63a8\u9001\u767e\u4fdd\u76fe\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }).start();
        }
        catch (Exception e) {
            this.log.error("\u6cf0\u5eb7\u627f\u4fdd\u63a5\u53e3\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
    }

    @Override
    public boolean HTTP_TPC_XYX_YX(Long oid) throws Exception {
        boolean flag = false;
        try {
            String result = this.xYX_TBRequestService.requestTB(oid, TransType.EPIC_YX_XW.getValue(), null);
            this.log.info("----------HTTP_TPC_XYX_YX-request(oid:" + oid + "\uff0c" + result + ")-----------");
            this.log.info("------------" + result);
            String[] strs = result.split("#");
            if ("200".equals(strs[0])) {
                flag = true;
                this.log.info("----------HTTP_TPC_XYX_YX-request(oid:" + oid + "\uff0cSUCCESS!!)-----------");
            } else {
                this.log.info("----------HTTP_TPC_XYX_YX-request(oid:" + oid + "\uff0cFAIL!!)-----------");
            }
        }
        catch (Exception e) {
            this.log.error("\u592a\u5e73\u8d22\u5c0f\u5fae\u4fe1\u7528\u9669\u5f71\u50cf\u63a5\u53e3\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
        }
        return flag;
    }

    @Override
    public boolean HTTP_TPC_XYX_CB(Long oid) throws Exception {
        boolean flag = false;
        try {
            String result = this.xYX_TBRequestService.requestTB(oid, TransType.EPIC_CB_XW.getValue(), null);
            this.log.info("----------HTTP_TPC_XYX_CB-request(oid:" + oid + "\uff0c" + result + ")-----------");
            this.log.info("------------" + result);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0]) || strs.length <= 1) {
                return flag;
            }
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                return true;
            }
            this.log.info("----------HTTP_TPC_XYX_CB-request(oid:" + oid + "\uff0cSUCCESS!!)-----------");
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(strs[1]);
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference(vo);
            flag = true;
        }
        catch (Exception e) {
            this.log.error("\u592a\u5e73\u8d22\u627f\u4fdd\u63a5\u53e3\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return flag;
    }

    @Override
    public String HTTP_TPC_XYX_DZBD(Long oid) {
        String path = "";
        try {
            String result = this.xYX_TBRequestService.requestTB(oid, TransType.EPIC_DZBD_XW.getValue(), null);
            this.log.info("----------HTTP_TPC_XYX_DZBD-request(oid:" + oid + "\uff0c" + result + ")-----------");
            this.log.info("------------" + result);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0]) || strs.length <= 1) {
                return path;
            }
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                return path;
            }
            this.log.info("----------HTTP_TPC_XYX_DZBD-request(oid:" + oid + "\uff0cSUCCESS!!)-----------");
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_id(String.valueOf(oid));
            vo.setInsure_path(strs[1]);
            this.insTransactionService.savePolicyOther(vo);
            path = strs[1];
        }
        catch (Exception e) {
            this.log.error("\u592a\u5e73\u8d22\u5c0f\u5fae\u4fe1\u7528\u9669\u7535\u5b50\u4fdd\u5355\u67e5\u8be2\u63a5\u53e3\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return path;
    }

    @Override
    public void returnsAnOrderToTheSpecifiedPlatform(String orderId) {
        String userResult = this.getTPUserIDByOrderID(Long.parseLong(orderId));
        if (StringUtils.isEmpty((CharSequence)userResult)) {
            return;
        }
        String[] ur = userResult.split(";");
        if (ur.length <= 1) {
            return;
        }
        if (ur[1].contains("ARS")) {
            if (!this.saveOrderInfo(orderId)) {
                this.comTaskResidualAPIService.saveComTaskResidual("saveOrderInfo", "\u56e2\u610f\u9669\u627f\u4fdd\u540e\u63a8\u7ed9\u767e\u4fdd\u76fe", "com.bcxin.ins.service.order.PolicyService", 1, "String", orderId);
            }
            this.log.info("----------\u56e2\u610f\u9669\u63a8\u9001\u767e\u4fdd\u76fe\uff08HTTP_TYX_CB\uff09\uff1aSUCCESS!!-----------");
        } else if (ur[1].contains("SAAS") || ur[1].contains("PASP")) {
            if (!this.saveOrderInfoPush(orderId)) {
                this.comTaskResidualAPIService.saveComTaskResidual("saveOrderInfoPush", "\u56e2\u610f\u9669/\u96c7\u4e3b\u8d23\u4efb\u9669\u627f\u4fdd\u540e\u63a8\u7ed9SAAS\u3001PASP\u5e73\u53f0", "com.bcxin.ins.service.order.PolicyService", 1, "String", orderId);
            }
            this.log.info("----------\u56e2\u610f\u9669/\u96c7\u4e3b\u8d23\u4efb\u9669\u63a8\u9001SAAS\uff08HTTP_TYX_CB\uff09\uff1aSUCCESS!!-----------");
        } else if (ur[1].contains("PSS")) {
            if (!this.pushOrderToPSS(orderId)) {
                this.comTaskResidualAPIService.saveComTaskResidual("pushOrderToPSS", "\u516c\u8d23\u9669\u627f\u4fdd\u540e\u63a8\u7ed9PSS\u5e73\u53f0", "com.bcxin.ins.service.order.PolicyService", 1, "String", orderId);
            }
            this.log.info("----------\u516c\u8d23\u9669\u63a8\u9001PSS\uff08HTTP_GZX_CB\uff09\uff1aSUCCESS!!-----------");
        }
    }

    @Override
    public void TYX_TK_02() {
        List<OrderFormVo> dtoList = this.selectInsOrderFormByStatusAndProductCode("4", "TYX-TK");
        this.log.info("----------TK-TYX-PolicyDto-select(" + (dtoList != null ? Integer.valueOf(dtoList.size()) : "null") + ")-----------");
        for (OrderFormVo dto : dtoList) {
            if (!StringUtils.isNotEmpty((CharSequence)dto.getProduct_code()) || !"TYX".equals(dto.getProduct_code().split("-")[0])) continue;
            try {
                this.log.info("----------TK-TYX-PolicyDto-oid(" + dto.getOid() + ")-star-----------");
                this.HTTP_TK_TYX_CB(Long.parseLong(dto.getOid()));
                this.log.info("----------TK-TYX-PolicyDto-oid(" + dto.getOid() + ")-end-----------");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void XYX_TB_CB() {
        List<OrderFormVo> dtoList = this.selectInsOrderFormByStatusAndProductCode("5", "XYX-XWCK");
        this.log.info("----------XYX_TB_CB-OrderFormVo-dtoList(" + (dtoList != null ? Integer.valueOf(dtoList.size()) : "null") + ")-----------");
        for (OrderFormVo dto : dtoList) {
            if (!"1".equals(dto.getIs_send_yx())) continue;
            try {
                this.log.info("----------XYX_TB_CB-PolicyDto-oid(" + dto.getOid() + ")-star-----------");
                this.HTTP_TPC_XYX_CB(Long.parseLong(dto.getOid()));
                this.log.info("----------XYX_TB_CB-PolicyDto-oid(" + dto.getOid() + ")-end-----------");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean ZA_ZZX_SAVE_PAY_MSG(Map<String, String> map) {
        boolean flag;
        try {
            OrderFormVo dto = this.insInsuranceSlipService.getOrderFormVoByTradeSerialNumber(map.get("out_trade_no"));
            if (StringUtils.isNotEmpty((CharSequence)dto.getExternal_reference())) {
                return true;
            }
            PolicyTransactionVo pvo = new PolicyTransactionVo();
            pvo.setTrade_serial_number(map.get("pay_trade_no"));
            pvo.setPay_amount(new BigDecimal(dto.getGross_premium()));
            pvo.setOut_of_pocket(new BigDecimal(map.get("amt")));
            pvo.setStart_time(DateUtil.convertString2Date((String)map.get("pay_time")));
            pvo.setEnd_time(new Date());
            pvo.setPayment_method("1");
            pvo.setPay_type(this.getPayType(map.get("pay_channel")));
            pvo.setPolicy_id(dto.getOid());
            pvo.setTransaction_status("1");
            pvo.setPath_sign("1");
            pvo.setUser_id(Long.valueOf(Long.parseLong(dto.getUser_oid())));
            this.insTransactionService.saveTransaction(pvo);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u652f\u4ed8\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
            flag = this.HTTP_ZA_ZZX_CB(Long.parseLong(dto.getOid()), map);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u7ed3\u679c--------" + flag);
            this.log.info("\u652f\u4ed8\u63a5\u53e3\u56de\u8c03-callbackPay\uff1a\u63a5\u6536\u6210\u529f-\u627f\u4fdd\u4fe1\u606f\u5904\u7406\u5b8c\u6210");
        }
        catch (Exception e) {
            this.log.error("\u4f17\u5b89\u5c55\u8d23\u9669\u652f\u4ed8\u56de\u8c03\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        return flag;
    }

    private String getPayType(String str) {
        if ("alipay".equals(str)) {
            return "1";
        }
        if ("wxpay".equals(str)) {
            return "2";
        }
        if ("unionpay".equals(str) || "unionpayB2B".equals(str)) {
            return "3";
        }
        return "";
    }

    @Override
    public boolean HTTP_ZA_ZZX_CB(Long oid, Map<String, String> map) {
        boolean flag = true;
        try {
            this.log.info("----------\u4f17\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_ZA_ZZX_CB\uff09\uff1astar-----------");
            String result = this.zARequestService.requestZA(oid, "2", map);
            this.log.info("----------ZA-ZZX-request(oid:" + oid + "\uff0c" + result + ")-----------");
            this.log.info("------------" + result);
            String[] strs = result.split("#");
            if (!"200".equals(strs[0])) {
                flag = false;
                this.log.info("----------\u4f17\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_ZA_ZZX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u4f17\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_ZA_ZZX_CB\uff09\uff1aend-----------");
                return flag;
            }
            this.log.info("----------\u4f17\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff08HTTP_ZA_ZZX_CB\uff09\uff1aSUCCESS!!-----------");
            if (StringUtils.isEmpty((CharSequence)strs[1])) {
                flag = false;
                this.log.info("----------\u4f17\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u4fdd\u5355\u53f7\uff08HTTP_ZA_ZZX_CB\uff09\uff1aFAIL!!-----------");
                this.log.info("----------\u4f17\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_ZA_ZZX_CB\uff09\uff1aend-----------");
                return flag;
            }
            this.log.info("----------ZA-ZZX-request(oid:" + oid + "\uff0cSUCCESS!!)-----------");
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(strs[1]);
            vo.setPolicy_id(String.valueOf(oid));
            this.insTransactionService.savePolicyExternalReference(vo);
            if (strs.length == 3) {
                vo.setInsure_path(strs[2]);
                this.insTransactionService.savePolicyOther(vo);
            }
            this.pushZZXOrderToYWZC(String.valueOf(oid));
            this.log.info("----------\u4f17\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u66f4\u65b0\u6570\u636e\u5e93\uff08HTTP_ZA_ZZX_CB\uff09\uff1aSUCCESS!!-----------");
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u627f\u4fdd\u63a5\u53e3\u8bf7\u6c42\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            flag = false;
        }
        this.log.info("----------\u4f17\u5b89\u627f\u4fdd\u63a5\u53e3\u8c03\u7528\uff08HTTP_ZA_ZZX_CB\uff09\uff1aend-----------");
        return flag;
    }

    @Override
    public void HTTP_HT_GZX_HBCB(String orderNo, String transactionNo) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.getInsOrderForm(orderNo);
        List list = insInsuranceSlip.getInsTransaction();
        InsTransaction transaction = null;
        if (list != null && list.size() > 0) {
            transaction = (InsTransaction)list.get(0);
        }
        this.log.info("\u534e\u6cf0\u5bf9\u63a5\u8ba2\u5355\u53f7orderNo" + orderNo);
        if (!"2".equals(transaction.getTransaction_status())) {
            return;
        }
        try {
            transaction.setPay_order_number(transactionNo);
            transaction.setPay_type("1");
            transaction.setTransaction_status("1");
            transaction.setOut_of_pocket(transaction.getPay_amount());
            transaction.setTrade_serial_number(IdWorker.getId() + "");
            transaction.setPath_sign("1");
            this.insTransactionService.updateById(transaction);
            this.log.info("\u4e0e\u534e\u6cf0\u6295\u4fdd\u5bf9\u63a5\u5f00\u59cb-----------");
            insInsuranceSlip.setOrder_status("6");
            insInsuranceSlip.setUpdate_time(new Date());
            insInsuranceSlip.setEnd_time(new Date());
            SpecialPublicDutyVo policyExtra = this.accordingToOrderIDToGetSpecialPublicDutyVo(insInsuranceSlip.getIns_insurance_slip_id());
            String result = this.htPolicyService.insureInvoke(insInsuranceSlip, policyExtra, transaction);
            if (StringUtils.isEmpty((CharSequence)result)) {
                this.log.info("\u4e0e\u534e\u6cf0\u6295\u4fdd\u5bf9\u63a5\u5931\u8d25\uff1a\u6295\u4fdd\u5931\u8d25\uff1a\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                return;
            }
            Map<String, String> map = com.bcxin.ins.third.gzx.huatai.HttpUtil.getMapValue(result);
            PolicyTransactionVo vo = new PolicyTransactionVo();
            vo.setPolicy_number(map.get("policyNO"));
            vo.setPolicy_id(insInsuranceSlip.getIns_insurance_slip_id() + "");
            this.insTransactionService.savePolicyExternalReference(vo);
            this.insInsuranceSlipService.accordingToOrderIDCreatePolicySerialNumber(insInsuranceSlip);
            if (!"".equals(map.get("policyURL"))) {
                vo.setInsure_path(map.get("policyURL"));
                this.insTransactionService.savePolicyOther(vo);
            }
            new Thread(() -> {
                try {
                    this.log.info("\u534e\u6cf0\u627f\u4fdd\u5b8c\u6210\uff0c\u63a8\u9001PSS---------STAR--------");
                    this.returnsAnOrderToTheSpecifiedPlatform(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
                }
                catch (Exception e) {
                    this.log.error("------------\u534e\u6cf0\u627f\u4fdd\u5b8c\u6210\uff0c\u63a8\u9001PSS\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }).start();
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            e.printStackTrace();
        }
    }

    @Override
    public List<OrderFormVo> selectInsOrderFormByStatusAndProductCode(String status, String productCode) {
        return this.insInsuranceSlipService.selectInsOrderFormByStatusAndProductCode(status, productCode);
    }

    @Override
    public void saveTransaction(PolicyTransactionVo vo) {
        try {
            this.insTransactionService.saveTransaction(vo);
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u4ea4\u6613\u8bb0\u5f55\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
    }

    @Override
    public void saveExternalReference(PolicyTransactionVo vo) {
        try {
            this.insTransactionService.savePolicyExternalReference(vo);
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u4fdd\u5355\u4fdd\u5b58\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
    }

    @Override
    public void savePolicyOther(PolicyTransactionVo vo) {
        try {
            this.insTransactionService.savePolicyOther(vo);
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u5176\u5b83\u51ed\u8bc1\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
    }

    @Override
    public boolean saveOrUpdateTransaction_ss(String policyID, String payOrderUrl, String payAmount, String path_sign) {
        try {
            String orderID;
            if (StrUtil.isBlank((String)policyID) || StrUtil.isBlank((String)payOrderUrl)) {
                return false;
            }
            if (StrUtil.isBlank((String)payAmount)) {
                payAmount = "0";
            }
            if (StrUtil.isNotBlank((CharSequence)(orderID = this.uploadPayMentFileToTranction(payOrderUrl, policyID, path_sign, payAmount)))) {
                OrderFormVo vo = new OrderFormVo();
                vo.setOid(orderID);
                vo.setPolicy_status("5");
                this.updateOrderFormStatus(vo);
                return true;
            }
        }
        catch (Exception e) {
            this.log.error("\u8bc9\u8bbc\u8ba2\u5355\u66f4\u65b0\u4ea4\u6613\u4fe1\u606f\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return false;
    }

    @Override
    public void downloadAttachment(String path, String name, HttpServletResponse response) {
        try {
            response.reset();
            response.setHeader("Content-Disposition", "attachment; filename=" + new String(name.getBytes("gbk"), "iso-8859-1") + ".pdf");
            response.setContentType("application/octet-stream; charset=utf-8");
            long fileLength = new File(path).length();
            response.setHeader("Content-Length", String.valueOf(fileLength));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(path));
             BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            int bytesRead;
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String createOrderAndGetOrderIDByProductID(Long product_id, Long user_id, String recommendCode, String trade_serial_number) {
        Map<String, Object> map = this.createOrderFormByProductOid(product_id, user_id, recommendCode, trade_serial_number);
        if (map.get("order_id") != null) {
            return (String)map.get("order_id");
        }
        return "";
    }

    @Override
    public Map<String, Object> obtainSpecialBidVoSetUp(SpecialBidVo vo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isBlank((String)vo.getOid())) {
            return null;
        }
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
        String tsn = insInsuranceSlip.getTrade_serial_number();
        if (StringUtils.isNotEmpty((CharSequence)vo.getRecommend_code())) {
            insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
            vo.setInception_date(vo.getInception_date() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date())) {
            vo.setPlanned_end_date(vo.getPlanned_end_date() + " 23:59:59");
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insInsuranceSlip);
            insInsuranceSlip.setTrade_serial_number(tsn);
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
        if (StringUtils.isEmpty((CharSequence)vo.getAptitude_level())) {
            vo.setAptitude_level(" ");
        }
        this.insSpecialBidService.accordingToTheSpecialBidVoSetUpInsSpecialBid(vo, insInsuranceSlip.getSpecial_id());
        this.insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        if (StrUtil.isNotBlank((CharSequence)vo.getInsured_amount())) {
            this.insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(new BigDecimal(vo.getInsured_amount()), insInsuranceSlip);
        }
        map.put("order_id", String.valueOf(vo.getOid()));
        return map;
    }

    @Override
    public ResultDto pendingSpecialBidPolicy(SpecialBidVo vo, String recommendCode) {
        try {
            ClientUserVo userdetail = UserSupportUtil.getSessionUser();
            if (userdetail == null) {
                return new ResultDto("\u8d26\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c", "/");
            }
            if (StringUtils.isEmpty((CharSequence)vo.getOid())) {
                String orderId = this.getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode, vo.getSigId());
                if (StringUtils.isNotEmpty((CharSequence)orderId)) {
                    vo.setOid(orderId);
                    if (StringUtils.isNotEmpty((CharSequence)vo.getSigId())) {
                        this.insInsuranceSlipService.updateOrderIdBySigId(orderId, vo.getSigId());
                    }
                } else {
                    return new ResultDto("\u8ba2\u5355\u521d\u59cb\u5316\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
                }
            }
            Map<String, Object> map = null;
            try {
                map = this.obtainSpecialBidVoSetUp(vo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (map != null) {
                return new ResultDto("\u5f53\u524d\u586b\u5199\u5185\u5bb9\u5df2\u7ecf\u6682\u5b58\uff0c\u7a0d\u540e\u60a8\u53ef\u5728\u3010\u6211\u7684\u8d26\u6237-\u6211\u7684\u8ba2\u5355-\u6295\u4fdd\u4e2d\u3011 \u7ee7\u7eed\u5b8c\u6210\u586b\u5199\u5185\u5bb9\u3002", "200", String.valueOf(map.get("order_id")), "", "");
            }
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        catch (Exception e) {
            this.log.error("\u6295\u6807\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResultDto("\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff01", "300", "", "", "");
        }
    }

    @Override
    public SpecialBidVo accordingToOrderIDToGetSpecialBidVo(Long order_id) {
        SpecialBidVo vo = null;
        if (StrUtil.isBlank((String)String.valueOf(order_id))) {
            return vo;
        }
        vo = new SpecialBidVo();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(order_id);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        vo.setResponsibilityVoList(this.findResponsibilityVoList(vo.getProduct_id(), order_id));
        this.insSpecialBidService.getSpecialBidVoByPolicyID(vo, insInsuranceSlip.getSpecial_id());
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        if (StringUtils.isNotEmpty((CharSequence)vo.getBid_time())) {
            vo.setBid_time(vo.getBid_time().replace(" 00:00:00", ""));
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
            vo.setInception_date(vo.getInception_date().replace(" 23:59:59", ""));
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date())) {
            vo.setPlanned_end_date(vo.getPlanned_end_date().replace(" 23:59:59", ""));
        }
        return vo;
    }

    @Override
    public Map<String, Object> obtainSpecialPerformanceVo_1SetUp(SpecialPerformanceVo_1 vo) {
        HashMap<String, Object> map = null;
        if (StrUtil.isBlank((String)vo.getOid())) {
            return map;
        }
        map = new HashMap<String, Object>();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
        String tsn = insInsuranceSlip.getTrade_serial_number();
        if (StringUtils.isNotEmpty((CharSequence)vo.getRecommend_code())) {
            insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insInsuranceSlip);
            insInsuranceSlip.setTrade_serial_number(tsn);
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insSpecialPerformanceService.accordingToTheSpecialPerformanceVo_1SetUpInsSpecialPerformance(vo, insInsuranceSlip.getSpecial_id());
        map.put("order_id", String.valueOf(vo.getOid()));
        return map;
    }

    @Override
    public ResultDto pendingSpecialPerformance_1VoPolicy(SpecialPerformanceVo_1 vo, String recommendCode) {
        try {
            ClientUserVo userdetail = UserSupportUtil.getSessionUser();
            if (userdetail == null) {
                return new ResultDto("\u8d26\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c", "/");
            }
            if (StringUtils.isEmpty((CharSequence)vo.getOid())) {
                String orderId = this.getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode, vo.getSigId());
                if (StringUtils.isNotEmpty((CharSequence)orderId)) {
                    vo.setOid(orderId);
                    if (StringUtils.isNotEmpty((CharSequence)vo.getSigId())) {
                        this.insInsuranceSlipService.updateOrderIdBySigId(orderId, vo.getSigId());
                    }
                } else {
                    return new ResultDto("\u8ba2\u5355\u521d\u59cb\u5316\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
                }
            }
            Map<String, Object> map = null;
            try {
                map = this.obtainSpecialPerformanceVo_1SetUp(vo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (map != null) {
                return new ResultDto("\u5f53\u524d\u586b\u5199\u5185\u5bb9\u5df2\u7ecf\u6682\u5b58\uff0c\u7a0d\u540e\u60a8\u53ef\u5728\u3010\u6211\u7684\u8d26\u6237-\u6211\u7684\u8ba2\u5355-\u6295\u4fdd\u4e2d\u3011 \u7ee7\u7eed\u5b8c\u6210\u586b\u5199\u5185\u5bb9\u3002", "200", String.valueOf(map.get("order_id")), "", "");
            }
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        catch (Exception e) {
            this.log.error("\u5c65\u7ea6\u9875\u4e00\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResultDto("\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff01", "300", "", "", "");
        }
    }

    @Override
    public Map<String, Object> obtainSpecialPerformanceVo_2SetUp(SpecialPerformanceVo_2 vo) {
        HashMap<String, Object> map = null;
        if (StrUtil.isBlank((String)vo.getOid())) {
            return map;
        }
        map = new HashMap<String, Object>();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
        String tsn = insInsuranceSlip.getTrade_serial_number();
        if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
            vo.setInception_date(vo.getInception_date() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date())) {
            vo.setPlanned_end_date(vo.getPlanned_end_date() + " 23:59:59");
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insInsuranceSlip);
            insInsuranceSlip.setTrade_serial_number(tsn);
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
        this.insSpecialPerformanceService.accordingToTheSpecialPerformanceVo_2SetUpInsSpecialPerformance(vo, insInsuranceSlip.getSpecial_id());
        if (vo.getRoleSubjectList().size() > 0 && StrUtil.isNotBlank((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getTurnover_export())) {
            this.insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(new BigDecimal(((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getTurnover_export()), insInsuranceSlip);
        }
        this.insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        map.put("order_id", String.valueOf(vo.getOid()));
        return map;
    }

    @Override
    public ResultDto pendingSpecialPerformance_2VoPolicy(SpecialPerformanceVo_2 vo) {
        try {
            ClientUserVo userdetail = UserSupportUtil.getSessionUser();
            if (userdetail == null) {
                return new ResultDto("\u8d26\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c", "/");
            }
            Map<String, Object> map = this.obtainSpecialPerformanceVo_2SetUp(vo);
            if (map != null) {
                return new ResultDto("\u5f53\u524d\u586b\u5199\u5185\u5bb9\u5df2\u7ecf\u6682\u5b58\uff0c\u7a0d\u540e\u60a8\u53ef\u5728\u3010\u6211\u7684\u8d26\u6237-\u6211\u7684\u8ba2\u5355-\u6295\u4fdd\u4e2d\u3011 \u7ee7\u7eed\u5b8c\u6210\u586b\u5199\u5185\u5bb9\u3002", "200", String.valueOf(map.get("order_id")), "", "");
            }
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        catch (Exception e) {
            this.log.error("\u5c65\u7ea6\u9875\u4e8c\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResultDto("\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff01", "300", "", "", "");
        }
    }

    @Override
    public Map<String, Object> obtainSpecialPerformanceVo_3SetUp(SpecialPerformanceVo_3 vo) {
        HashMap<String, String> map = null;
        if (StrUtil.isNotBlank((CharSequence)vo.getOid())) {
            map = new HashMap<String, String>();
            InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
            this.insSpecialPerformanceService.accordingToTheSpecialPerformanceVo_3SetUpInsSpecialPerformance(vo, insInsuranceSlip.getSpecial_id());
            map.put("order_id", String.valueOf(vo.getOid()));
        }
        return map;
    }

    @Override
    public ResultDto pendingSpecialPerformance_3VoPolicy(SpecialPerformanceVo_3 vo) {
        try {
            ClientUserVo userdetail = UserSupportUtil.getSessionUser();
            if (userdetail == null) {
                return new ResultDto("\u8d26\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c", "/");
            }
            Map<String, Object> map = this.obtainSpecialPerformanceVo_3SetUp(vo);
            if (map != null) {
                return new ResultDto("\u5f53\u524d\u586b\u5199\u5185\u5bb9\u5df2\u7ecf\u6682\u5b58\uff0c\u7a0d\u540e\u60a8\u53ef\u5728\u3010\u6211\u7684\u8d26\u6237-\u6211\u7684\u8ba2\u5355-\u6295\u4fdd\u4e2d\u3011 \u7ee7\u7eed\u5b8c\u6210\u586b\u5199\u5185\u5bb9\u3002", "200", String.valueOf(map.get("order_id")), "", "");
            }
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        catch (Exception e) {
            this.log.error("\u5c65\u7ea6\u9875\u4e09\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResultDto("\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff01", "300", "", "", "");
        }
    }

    @Override
    public SpecialPerformanceVo_1 accordingToOrderIDToGetSpecialPerformanceVo_1(Long order_id) {
        SpecialPerformanceVo_1 vo = null;
        if (StrUtil.isBlank((String)String.valueOf(order_id))) {
            return vo;
        }
        vo = new SpecialPerformanceVo_1();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(order_id);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        vo.setResponsibilityVoList(this.findResponsibilityVoList(vo.getProduct_id(), order_id));
        this.insSpecialPerformanceService.getSpecialPerformanceVo_1BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        return vo;
    }

    @Override
    public SpecialPerformanceVo_2 accordingToOrderIDToGetSpecialPerformanceVo_2(Long order_id) {
        SpecialPerformanceVo_2 vo = null;
        if (StrUtil.isBlank((String)String.valueOf(order_id))) {
            return vo;
        }
        vo = new SpecialPerformanceVo_2();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(order_id);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insSpecialPerformanceService.getSpecialPerformanceVo_2BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
            vo.setInception_date(vo.getInception_date().replace(" 00:00:00", ""));
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date())) {
            vo.setPlanned_end_date(vo.getPlanned_end_date().replace(" 23:59:59", ""));
        }
        return vo;
    }

    @Override
    public SpecialPerformanceVo_3 accordingToOrderIDToGetSpecialPerformanceVo_3(Long order_id) {
        SpecialPerformanceVo_3 vo = null;
        if (StrUtil.isNotBlank((CharSequence)String.valueOf(order_id))) {
            vo = new SpecialPerformanceVo_3();
            MailPolicyVo voMP = new MailPolicyVo();
            InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(order_id);
            vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
            this.insSpecialPerformanceService.getSpecialPerformanceVo_3BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        }
        return vo;
    }

    @Override
    public Map<String, Object> obtainSpecialLitigationVo_1SetUp(SpecialLitigationVo_1 vo) {
        HashMap<String, Object> map = null;
        if (StrUtil.isBlank((String)vo.getOid())) {
            return map;
        }
        map = new HashMap<String, Object>();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(vo.getOid()));
        String tsn = insInsuranceSlip.getTrade_serial_number();
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insInsuranceSlip);
            insInsuranceSlip.setTrade_serial_number(tsn);
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
        this.specialLitigationService.accordingToTheSpecialLitigationVo_1SetUpSpecialLitigation(vo, insInsuranceSlip.getSpecial_id());
        if (vo.getRoleSubjectList().size() > 0 && StrUtil.isNotBlank((CharSequence)((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getTurnover_export())) {
            this.insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(new BigDecimal(((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getTurnover_export()), insInsuranceSlip);
        }
        map.put("order_id", String.valueOf(vo.getOid()));
        return map;
    }

    @Override
    public ResultDto pendingSpecialLitigation_1VoPolicy(SpecialLitigationVo_1 vo, String recommendCode) {
        try {
            Map<String, Object> map;
            ClientUserVo userdetail = UserSupportUtil.getSessionUser();
            if (userdetail == null) {
                return new ResultDto("\u8d26\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c", "/");
            }
            if (StringUtils.isEmpty((CharSequence)vo.getOid())) {
                String orderId = this.getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode, vo.getSigId());
                if (StringUtils.isNotEmpty((CharSequence)orderId)) {
                    vo.setOid(orderId);
                    if (StringUtils.isNotEmpty((CharSequence)vo.getSigId())) {
                        this.insInsuranceSlipService.updateOrderIdBySigId(orderId, vo.getSigId());
                    }
                } else {
                    return new ResultDto("\u8ba2\u5355\u521d\u59cb\u5316\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
                }
            }
            if ((map = this.obtainSpecialLitigationVo_1SetUp(vo)) != null) {
                return new ResultDto("\u5f53\u524d\u586b\u5199\u5185\u5bb9\u5df2\u7ecf\u6682\u5b58\uff0c\u7a0d\u540e\u60a8\u53ef\u5728\u3010\u6211\u7684\u8d26\u6237-\u6211\u7684\u8ba2\u5355-\u6295\u4fdd\u4e2d\u3011 \u7ee7\u7eed\u5b8c\u6210\u586b\u5199\u5185\u5bb9\u3002", "200", String.valueOf(map.get("order_id")), "", "");
            }
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        catch (Exception e) {
            this.log.error("\u8bc9\u8bbc\u9875\u4e00\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResultDto("\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff01", "300", "", "", "");
        }
    }

    @Override
    public Map<String, Object> obtainSpecialLitigationVo_2SetUp(SpecialLitigationVo_2 vo) {
        HashMap<String, Object> map = null;
        if (StrUtil.isBlank((String)vo.getOid())) {
            return map;
        }
        map = new HashMap<String, Object>();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
        String tsn = insInsuranceSlip.getTrade_serial_number();
        if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
            vo.setInception_date(vo.getInception_date() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date())) {
            vo.setPlanned_end_date(vo.getPlanned_end_date() + " 23:59:59");
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insInsuranceSlip);
            insInsuranceSlip.setTrade_serial_number(tsn);
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.specialLitigationService.accordingToTheSpecialLitigationVo_2SetUpSpecialLitigation(vo, insInsuranceSlip.getSpecial_id());
        this.insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        map.put("order_id", String.valueOf(vo.getOid()));
        return map;
    }

    @Override
    public ResultDto pendingSpecialLitigation_2VoPolicy(SpecialLitigationVo_2 vo) {
        try {
            ClientUserVo userdetail = UserSupportUtil.getSessionUser();
            if (userdetail == null) {
                return new ResultDto("\u8d26\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c", "/");
            }
            Map<String, Object> map = this.obtainSpecialLitigationVo_2SetUp(vo);
            if (map != null) {
                return new ResultDto("\u5f53\u524d\u586b\u5199\u5185\u5bb9\u5df2\u7ecf\u6682\u5b58\uff0c\u7a0d\u540e\u60a8\u53ef\u5728\u3010\u6211\u7684\u8d26\u6237-\u6211\u7684\u8ba2\u5355-\u6295\u4fdd\u4e2d\u3011 \u7ee7\u7eed\u5b8c\u6210\u586b\u5199\u5185\u5bb9\u3002", "200", String.valueOf(map.get("order_id")), "", "");
            }
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        catch (Exception e) {
            this.log.error("\u8bc9\u8bbc\u9875\u4e8c\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResultDto("\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff01", "300", "", "", "");
        }
    }

    @Override
    public Map<String, Object> obtainSpecialLitigationVo_3SetUp(SpecialLitigationVo_3 vo) {
        HashMap<String, String> map = null;
        if (StrUtil.isNotBlank((CharSequence)vo.getOid())) {
            map = new HashMap<String, String>();
            InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
            this.specialLitigationService.accordingToTheSpecialLitigationVo_3SetUpSpecialLitigation(vo, insInsuranceSlip.getSpecial_id());
            map.put("order_id", String.valueOf(vo.getOid()));
        }
        return map;
    }

    @Override
    public ResultDto pendingSpecialLitigation_3VoPolicy(SpecialLitigationVo_3 vo) {
        try {
            ClientUserVo userdetail = UserSupportUtil.getSessionUser();
            if (userdetail == null) {
                return new ResultDto("\u8d26\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c", "/");
            }
            Map<String, Object> map = this.obtainSpecialLitigationVo_3SetUp(vo);
            if (map != null) {
                return new ResultDto("\u5f53\u524d\u586b\u5199\u5185\u5bb9\u5df2\u7ecf\u6682\u5b58\uff0c\u7a0d\u540e\u60a8\u53ef\u5728\u3010\u6211\u7684\u8d26\u6237-\u6211\u7684\u8ba2\u5355-\u6295\u4fdd\u4e2d\u3011 \u7ee7\u7eed\u5b8c\u6210\u586b\u5199\u5185\u5bb9\u3002", "200", String.valueOf(map.get("order_id")), "", "");
            }
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        catch (Exception e) {
            this.log.error("\u8bc9\u8bbc\u9875\u4e09\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResultDto("\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff01", "300", "", "", "");
        }
    }

    @Override
    public SpecialLitigationVo_1 accordingToOrderIDToGetSpecialLitigationVo_1(Long order_id) {
        SpecialLitigationVo_1 vo = null;
        if (StrUtil.isBlank((String)String.valueOf(order_id))) {
            return vo;
        }
        vo = new SpecialLitigationVo_1();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(order_id);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        vo.setResponsibilityVoList(this.findResponsibilityVoList(vo.getProduct_id(), order_id));
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        this.specialLitigationService.getSpecialLitigationVo_1BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        return vo;
    }

    @Override
    public SpecialLitigationVo_2 accordingToOrderIDToGetSpecialLitigationVo_2(Long order_id) {
        SpecialLitigationVo_2 vo = null;
        if (StrUtil.isBlank((String)String.valueOf(order_id))) {
            return vo;
        }
        vo = new SpecialLitigationVo_2();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(order_id);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.specialLitigationService.getSpecialLitigationVo_2BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        MailPolicyVo voMP = new MailPolicyVo();
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
            vo.setInception_date(vo.getInception_date().replace(" 00:00:00", ""));
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date())) {
            vo.setPlanned_end_date(vo.getPlanned_end_date().replace(" 23:59:59", ""));
        }
        return vo;
    }

    @Override
    public SpecialLitigationVo_3 accordingToOrderIDToGetSpecialLitigationVo_3(Long order_id) {
        SpecialLitigationVo_3 vo = null;
        if (StrUtil.isNotBlank((CharSequence)String.valueOf(order_id))) {
            vo = new SpecialLitigationVo_3();
            InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(order_id);
            vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
            this.specialLitigationService.getSpecialLitigationVo_3BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        }
        return vo;
    }

    @Override
    public boolean deleteLnAccusedByOid(String lna_id) {
        boolean flag = false;
        if (StrUtil.isNotBlank((CharSequence)lna_id)) {
            try {
                LnAccused lnAccused = (LnAccused)this.lnAccusedAPIService.selectById(Long.valueOf(Long.parseLong(lna_id)));
                if (lnAccused != null) {
                    this.lnAccusedAPIService.deleteById(lnAccused.getLn_accused_id());
                    flag = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    @Override
    public Map<String, Object> obtainGMRPolicyVoSetUp(GMRPolicyVo vo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isBlank((String)vo.getOid())) {
            return null;
        }
        try {
            this.log.info("\u56e2\u610f\u9669\u8ba2\u5355\u6570\u636e\u5904\u7406\u5f00\u59cb---------------------");
            InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
            if (StringUtils.isNotEmpty((CharSequence)vo.getRecommend_code())) {
                insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
                insInsuranceSlip.setInception_date(DateUtil.convertString2Date((String)(vo.getInception_date() + " 00:00:00")));
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date())) {
                insInsuranceSlip.setPlanned_end_date(DateUtil.convertString2Date((String)(vo.getPlanned_end_date() + " 23:59:59")));
            }
            insInsuranceSlip.setIs_contain_repo(vo.getIs_contain_repo());
            insInsuranceSlip.setAccredit_path(vo.getAccredit_path());
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
            vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
            this.log.info("\u56e2\u610f\u9669\u8ba2\u5355\u4eba\u5458\u8fc7\u6ee4\u5f00\u59cb---------------------");
            this.log.info("\u56e2\u610f\u9669\u8ba2\u5355\u4eba\u5458\u521d\u59cb\u6570\u636e,vo.getRoleSubjectList():" + vo.getRoleSubjectList().size());
            ArrayList voList = Lists.newArrayList();
            for (RoleSubjectVo rvo : vo.getRoleSubjectList()) {
                if ("1".equals(rvo.getKind())) {
                    voList.add(rvo);
                    continue;
                }
                if (!StringUtils.isNotEmpty((CharSequence)rvo.getOrganization_code()) && !StringUtils.isNotEmpty((CharSequence)rvo.getName_cn()) && !StringUtils.isNotEmpty((CharSequence)rvo.getMobile()) && !StringUtils.isNotEmpty((CharSequence)rvo.getBirth_date())) continue;
                voList.add(rvo);
            }
            this.log.info("\u56e2\u610f\u9669\u8ba2\u5355\u4eba\u5458\u8fc7\u6ee4\u540e\u6570\u636e,voList:" + voList);
            this.log.info("\u56e2\u610f\u9669\u8ba2\u5355\u4eba\u5458\u8fc7\u6ee4\u7ed3\u675f---------------------");
            this.log.info("\u56e2\u610f\u9669\u8ba2\u5355\u4eba\u5458\u66f4\u65b0\u6570\u636e\u5e93\u5f00\u59cb---------------------");
            if (insInsuranceSlip.getSpecial_id() != null) {
                this.specialExhibitionAPIService.accordingToTheSpecialExhibitionVoSetUpSpecialExhibition(vo.getSpecialExhibitionVo(), insInsuranceSlip.getSpecial_id());
            }
            this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(voList, insInsuranceSlip.getIns_insurance_slip_id());
            this.log.info("\u56e2\u610f\u9669\u8ba2\u5355\u4eba\u5458\u66f4\u65b0\u6570\u636e\u5e93\u7ed3\u675f---------------------");
            this.insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
            this.insInsuranceSlipService.setPremiumAndCoverageByOrderID(insInsuranceSlip);
        }
        catch (Exception e) {
            this.log.error("\u56e2\u610f\u9669\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        map.put("order_id", String.valueOf(vo.getOid()));
        return map;
    }

    @Override
    public ResultDto pendingGMRPolicyVoPolicy(GMRPolicyVo vo, String recommendCode) {
        try {
            Map<String, Object> map;
            ClientUserVo userdetail = UserSupportUtil.getSessionUser();
            if (userdetail == null) {
                return new ResultDto("\u8d26\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c", "/");
            }
            ResultDto r = this.isDuplicateIdCardNoToRoleSubject(((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getName_cn(), vo.getRoleSubjectList());
            if (r != null) {
                return r;
            }
            if (StringUtils.isEmpty((CharSequence)vo.getOid())) {
                String orderId = this.getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode, vo.getSigId());
                if (StringUtils.isNotEmpty((CharSequence)orderId)) {
                    vo.setOid(orderId);
                    if (StringUtils.isNotEmpty((CharSequence)vo.getSigId())) {
                        this.insInsuranceSlipService.updateOrderIdBySigId(orderId, vo.getSigId());
                    }
                } else {
                    return new ResultDto("\u8ba2\u5355\u521d\u59cb\u5316\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
                }
            }
            if ((map = this.obtainGMRPolicyVoSetUp(vo)) != null) {
                return new ResultDto("\u5f53\u524d\u586b\u5199\u5185\u5bb9\u5df2\u7ecf\u6682\u5b58\uff0c\u7a0d\u540e\u60a8\u53ef\u5728\u3010\u6211\u7684\u8d26\u6237-\u6211\u7684\u8ba2\u5355-\u6295\u4fdd\u4e2d\u3011 \u7ee7\u7eed\u5b8c\u6210\u586b\u5199\u5185\u5bb9\u3002", "200", String.valueOf(map.get("order_id")), "", "");
            }
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        catch (Exception e) {
            this.log.error("\u56e2\u610f\u9669\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResultDto("\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff01", "300", "", "", "");
        }
    }

    private ResultDto isDuplicateIdCardNoToRoleSubject(String appName, List<RoleSubjectVo> list) {
        String[] idcards = new String[list.size()];
        int count = 0;
        for (RoleSubjectVo rvo : list) {
            if ("1".equals(rvo.getKind()) || !StringUtils.isNotEmpty((CharSequence)rvo.getOrganization_code())) continue;
            idcards[count] = rvo.getOrganization_code();
            ++count;
        }
        String str = this.insPreservationResultSetAPIService.findDuplicateIdCardNo(appName, "TYX", idcards);
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            return new ResultDto("\u90e8\u5206\u8bc1\u4ef6\u53f7\u5df2\u5728\u4fdd\uff0c\u65e0\u6cd5\u91cd\u590d\u6295\u4fdd\uff1a" + str, "300", "", "", "");
        }
        return null;
    }

    @Override
    public GMRPolicyVo accordingToOrderIDToGetGMRPolicyVo(Long order_id) {
        GMRPolicyVo vo = null;
        if (StrUtil.isBlank((String)String.valueOf(order_id))) {
            return vo;
        }
        vo = new GMRPolicyVo();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(order_id);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        if (insInsuranceSlip.getInception_date() != null) {
            vo.setInception_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getInception_date(), (String)"yyyy-MM-dd"));
        }
        if (insInsuranceSlip.getPlanned_end_date() != null) {
            vo.setPlanned_end_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getPlanned_end_date(), (String)"yyyy-MM-dd"));
        }
        vo.setAccredit_path(insInsuranceSlip.getAccredit_path());
        vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
        vo.setIs_contain_repo(insInsuranceSlip.getIs_contain_repo());
        List<RoleSubjectVo> list = this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id());
        if (list.size() < 4) {
            int v = 4 - list.size();
            RoleSubjectVo rvo = new RoleSubjectVo();
            rvo.setKind("2");
            rvo.setMajor_group("1");
            for (int i = 0; i < v; ++i) {
                list.add(rvo);
            }
        }
        vo.setRoleSubjectList(list);
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        if (insInsuranceSlip.getSpecial_id() != null) {
            SpecialExhibitionVo seVo = new SpecialExhibitionVo();
            this.specialExhibitionAPIService.getSpecialExhibitionVoByPolicyID2(seVo, insInsuranceSlip.getSpecial_id());
            vo.setSpecialExhibitionVo(seVo);
        }
        vo.setResponsibilityVoList(this.findResponsibilityVoList(vo.getProduct_id(), order_id));
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        return vo;
    }

    private List<ResponsibilityVo> findResponsibilityVoList(String product_id, Long order_id) {
        InsAgreement insAgreement = this.insAgreementAPIService.selectInsAgreementByInsInsuranceSlip(order_id);
        String responsibility_ids = "";
        if (insAgreement != null) {
            responsibility_ids = insAgreement.getResponsibility_ids();
        }
        return this.insProductResponsibilityAPIService.findResponsibilityVoListByResponsibilityIds(product_id, responsibility_ids);
    }

    @Override
    public Map<String, Object> obtainSpecialHirelingVoSetUp(SpecialHirelingVo vo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isBlank((String)vo.getOid())) {
            return null;
        }
        try {
            this.log.info("\u96c7\u4e3b\u8d23\u4efb\u9669\u8ba2\u5355\u6570\u636e\u5904\u7406\u5f00\u59cb---------------------");
            InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
            if (StringUtils.isNotEmpty((CharSequence)vo.getRecommend_code())) {
                insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
            }
            OrderFormVo order = this.accordingToOrderIDToGetPolicyDto(insInsuranceSlip.getIns_insurance_slip_id());
            String inception_long = "";
            if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
                if (order.getProduct_code().contains("GZZRX-CA-DQ")) {
                    insInsuranceSlip.setInception_date(DateUtil.convertString2Date((String)(vo.getInception_date() + " 00:00:00")));
                    insInsuranceSlip.setPlanned_end_date(DateUtil.convertString2Date((String)(DateUtil.dateAdd((int)3, (String)DateUtil.dateAdd((int)2, (String)vo.getInception_date(), (int)1), (int)-1) + " 23:59:59")));
                } else if (StringUtils.isNotEmpty((CharSequence)vo.getInception_type()) && vo.getInception_type().contains("2")) {
                    inception_long = vo.getInception_long();
                    insInsuranceSlip.setInception_date(DateUtil.convertString2Date((String)(vo.getInception_date() + " 00:00:00")));
                    insInsuranceSlip.setPlanned_end_date(DateUtil.convertString2Date((String)(DateUtil.dateAdd((int)3, (String)DateUtil.dateAdd((int)2, (String)vo.getInception_date(), (int)Integer.parseInt(vo.getInception_long())), (int)-1) + " 23:59:59")));
                } else {
                    insInsuranceSlip.setInception_date(DateUtil.convertString2Date((String)(vo.getInception_date() + " 00:00:00")));
                    insInsuranceSlip.setPlanned_end_date(DateUtil.convertString2Date((String)(DateUtil.dateAdd((int)3, (String)DateUtil.dateAdd((int)1, (String)vo.getInception_date(), (int)1), (int)-1) + " 23:59:59")));
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getInception_type())) {
                insInsuranceSlip.setInception_type(vo.getInception_type());
            }
            insInsuranceSlip.setInception_long(inception_long);
            insInsuranceSlip.setDispute(vo.getDispute());
            insInsuranceSlip.setArbitral_institution(vo.getArbitral_institution());
            insInsuranceSlip.setIs_contain_repo(vo.getIs_contain_repo());
            if (StringUtils.isNotEmpty((CharSequence)vo.getPremium())) {
                insInsuranceSlip.setPremium(new BigDecimal(vo.getPremium()));
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getInsured_amount())) {
                insInsuranceSlip.setInsured_amount(new BigDecimal(vo.getInsured_amount()));
            }
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
            this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
            this.hirelingAPIService.accordingToTheHirelingVoSetUpHireling(vo, insInsuranceSlip.getIns_insurance_slip_id());
            this.insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        }
        catch (Exception e) {
            this.log.error("\u96c7\u4e3b\u8d23\u4efb\u9669\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        map.put("order_id", String.valueOf(vo.getOid()));
        return map;
    }

    @Override
    public ResultDto pendingSpecialHirelingVoPolicy(SpecialHirelingVo vo, String recommendCode) {
        try {
            Map<String, Object> map;
            ClientUserVo userdetail = UserSupportUtil.getSessionUser();
            if (userdetail == null) {
                return new ResultDto("\u8d26\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c", "/");
            }
            ResultDto r = this.isDuplicateIdCardNoToHireling(((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getName_cn(), vo.getHirelingVoList());
            if (r != null) {
                return r;
            }
            if (StringUtils.isEmpty((CharSequence)vo.getOid())) {
                String orderId = this.getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode, vo.getSigId());
                if (StringUtils.isNotEmpty((CharSequence)orderId)) {
                    vo.setOid(orderId);
                    if (StringUtils.isNotEmpty((CharSequence)vo.getSigId())) {
                        this.insInsuranceSlipService.updateOrderIdBySigId(orderId, vo.getSigId());
                    }
                } else {
                    return new ResultDto("\u8ba2\u5355\u521d\u59cb\u5316\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
                }
            }
            if ((map = this.obtainSpecialHirelingVoSetUp(vo)) != null) {
                return new ResultDto("\u5f53\u524d\u586b\u5199\u5185\u5bb9\u5df2\u7ecf\u6682\u5b58\uff0c\u7a0d\u540e\u60a8\u53ef\u5728\u3010\u6211\u7684\u8d26\u6237-\u6211\u7684\u8ba2\u5355-\u6295\u4fdd\u4e2d\u3011 \u7ee7\u7eed\u5b8c\u6210\u586b\u5199\u5185\u5bb9\u3002", "200", String.valueOf(map.get("order_id")), "", "");
            }
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        catch (Exception e) {
            this.log.error("\u96c7\u4e3b\u8d23\u4efb\u9669\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResultDto("\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff01", "300", "", "", "");
        }
    }

    private ResultDto isDuplicateIdCardNoToHireling(String appName, List<HirelingVo> list) {
        String[] idcards = new String[list.size()];
        int count = 0;
        for (HirelingVo hvo : list) {
            if (!StringUtils.isNotEmpty((CharSequence)hvo.getId_card())) continue;
            idcards[count] = hvo.getId_card();
            ++count;
        }
        String str = this.insPreservationResultSetAPIService.findDuplicateIdCardNo(appName, "GZZRX", idcards);
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            return new ResultDto("\u90e8\u5206\u8bc1\u4ef6\u53f7\u5df2\u5728\u4fdd\uff0c\u65e0\u6cd5\u91cd\u590d\u6295\u4fdd\uff1a" + str, "300", "", "", "");
        }
        return null;
    }

    @Override
    public SpecialHirelingVo accordingToOrderIDToGetSpecialHirelingVo(Long order_id) {
        SpecialHirelingVo vo = null;
        if (StrUtil.isBlank((String)String.valueOf(order_id))) {
            return vo;
        }
        vo = new SpecialHirelingVo();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(order_id);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        if (insInsuranceSlip.getInception_date() != null) {
            vo.setInception_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getInception_date(), (String)"yyyy-MM-dd"));
        }
        vo.setInception_type(insInsuranceSlip.getInception_type());
        vo.setInception_long(insInsuranceSlip.getInception_long());
        vo.setDispute(insInsuranceSlip.getDispute());
        vo.setArbitral_institution(insInsuranceSlip.getArbitral_institution());
        vo.setPremium(String.valueOf(insInsuranceSlip.getPremium()));
        vo.setInsured_amount(String.valueOf(insInsuranceSlip.getInsured_amount()));
        vo.setIs_contain_repo(insInsuranceSlip.getIs_contain_repo());
        vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        vo.setResponsibilityVoList(this.findResponsibilityVoList(vo.getProduct_id(), order_id));
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        this.hirelingAPIService.getSpecialHirelingVoByOrderID(vo, insInsuranceSlip.getIns_insurance_slip_id());
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        return vo;
    }

    @Override
    public Map<String, Object> obtainSpecialPublicDutyVoSetUp(SpecialPublicDutyVo vo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isBlank((String)vo.getOid())) {
            return null;
        }
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
        String tsn = insInsuranceSlip.getTrade_serial_number();
        if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date()) && !vo.getInception_date().contains(" 00:00:00")) {
            vo.setInception_date(vo.getInception_date() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date()) && !vo.getPlanned_end_date().contains(" 23:59:59")) {
            vo.setPlanned_end_date(vo.getPlanned_end_date() + " 23:59:59");
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)vo.getInsured_amount())) {
                vo.setInsured_amount(Integer.parseInt(vo.getInsured_amount()) * 10000 + "");
            }
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insInsuranceSlip);
            insInsuranceSlip.setTrade_serial_number(tsn);
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
        this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
        this.specialPublicDutyService.accordingToTheSpecialPublicDutyVoSetUpSpecialPublicDuty(vo, insInsuranceSlip.getSpecial_id());
        this.insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        map.put("order_id", String.valueOf(vo.getOid()));
        return map;
    }

    @Override
    public ResultDto pendingSpecialPublicDutyVoPolicy(SpecialPublicDutyVo vo, String recommendCode) {
        try {
            Map<String, Object> map;
            ClientUserVo userdetail = UserSupportUtil.getSessionUser();
            if (userdetail == null) {
                return new ResultDto("\u8d26\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c", "/");
            }
            if (StringUtils.isEmpty((CharSequence)vo.getOid())) {
                String orderId = this.getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode, vo.getSigId());
                if (StringUtils.isNotEmpty((CharSequence)orderId)) {
                    vo.setOid(orderId);
                    if (StringUtils.isNotEmpty((CharSequence)vo.getSigId())) {
                        this.insInsuranceSlipService.updateOrderIdBySigId(orderId, vo.getSigId());
                    }
                } else {
                    return new ResultDto("\u8ba2\u5355\u521d\u59cb\u5316\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
                }
            }
            if ((map = this.obtainSpecialPublicDutyVoSetUp(vo)) != null) {
                return new ResultDto("\u5f53\u524d\u586b\u5199\u5185\u5bb9\u5df2\u7ecf\u6682\u5b58\uff0c\u7a0d\u540e\u60a8\u53ef\u5728\u3010\u6211\u7684\u8d26\u6237-\u6211\u7684\u8ba2\u5355-\u6295\u4fdd\u4e2d\u3011 \u7ee7\u7eed\u5b8c\u6210\u586b\u5199\u5185\u5bb9\u3002", "200", String.valueOf(map.get("order_id")), "", "");
            }
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        catch (Exception e) {
            this.log.error("\u516c\u8d23\u9669\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResultDto("\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff01", "300", "", "", "");
        }
    }

    @Override
    public SpecialPublicDutyVo accordingToOrderIDToGetSpecialPublicDutyVo(Long order_id) {
        SpecialPublicDutyVo vo = null;
        if (StrUtil.isBlank((String)String.valueOf(order_id))) {
            return vo;
        }
        vo = new SpecialPublicDutyVo();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(order_id);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (insInsuranceSlip.getInception_date() != null) {
            vo.setInception_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getInception_date(), (String)"yyyy-MM-dd"));
        }
        if (insInsuranceSlip.getPlanned_end_date() != null) {
            vo.setPlanned_end_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getPlanned_end_date(), (String)"yyyy-MM-dd"));
        }
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        vo.setResponsibilityVoList(this.findResponsibilityVoList(vo.getProduct_id(), order_id));
        this.specialPublicDutyService.getSpecialPublicDutyVoByPolicyID(vo, insInsuranceSlip.getSpecial_id());
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        return vo;
    }

    @Override
    public Map<String, Object> obtainLOTEPolicyVoSetUp(LOTEPolicyVo vo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isBlank((String)vo.getOid())) {
            return null;
        }
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
        if (StringUtils.isNotEmpty((CharSequence)vo.getRecommend_code())) {
            insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insInsuranceSlip);
            insInsuranceSlip.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
            if (insInsuranceSlip.getInsured_amount() == null || insInsuranceSlip.getInsured_amount().compareTo(BigDecimal.ONE) < 0) {
                insInsuranceSlip.setInsured_amount(this.setInsuredAmountByProductId(insInsuranceSlip.getPro_primary().getPro_primary_id()));
            }
            if (vo.getSpecialExhibitionVo() != null) {
                if (StringUtils.isNotEmpty((CharSequence)vo.getSpecialExhibitionVo().getStar_time())) {
                    insInsuranceSlip.setInception_date(DateUtil.convertString2Date((String)(vo.getSpecialExhibitionVo().getStar_time() + " 00:00:00")));
                }
                if (StringUtils.isNotEmpty((CharSequence)vo.getSpecialExhibitionVo().getEnd_time())) {
                    insInsuranceSlip.setPlanned_end_date(DateUtil.convertString2Date((String)(vo.getSpecialExhibitionVo().getEnd_time() + " 23:59:59")));
                }
            }
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
        if (insInsuranceSlip.getSpecial_id() != null) {
            this.specialExhibitionAPIService.accordingToTheSpecialExhibitionVoSetUpSpecialExhibition(vo.getSpecialExhibitionVo(), insInsuranceSlip.getSpecial_id());
        }
        if (insInsuranceSlip.getMailPolicy() != null) {
            this.insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        }
        map.put("order_id", String.valueOf(vo.getOid()));
        return map;
    }

    @Override
    public BigDecimal setInsuredAmountByProductId(Long pId) {
        BigDecimal result = BigDecimal.ZERO;
        List<ResponsibilityVo> irpVoList = this.insProductResponsibilityAPIService.findResponsibilityVoList(String.valueOf(pId));
        if (irpVoList.size() <= 0) {
            return result;
        }
        for (ResponsibilityVo vo : irpVoList) {
            if ("1".equals(vo.getType())) {
                if (StringUtils.isEmpty((CharSequence)vo.getFcy())) continue;
                if (StringUtils.isNotEmpty((CharSequence)vo.getCompensation_days())) {
                    result = result.add(BigDecimal.valueOf(Double.parseDouble(vo.getFcy())).multiply(BigDecimal.valueOf(Double.parseDouble("180"))));
                    continue;
                }
                result = result.add(BigDecimal.valueOf(Double.parseDouble(vo.getFcy())));
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)vo.getInsurance_amount_max())) continue;
            result = result.add(BigDecimal.valueOf(Double.parseDouble(vo.getInsurance_amount_max())));
        }
        return result;
    }

    @Override
    public ResultDto pendingLOTEPolicyVoPolicy(LOTEPolicyVo vo, String recommendCode) {
        try {
            Map<String, Object> map;
            ClientUserVo userdetail = UserSupportUtil.getSessionUser();
            if (userdetail == null) {
                return new ResultDto("\u8d26\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c", "/");
            }
            if (StringUtils.isEmpty((CharSequence)vo.getOid())) {
                String orderId = this.getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode, vo.getSigId());
                if (StringUtils.isNotEmpty((CharSequence)orderId)) {
                    vo.setOid(orderId);
                    if (StringUtils.isNotEmpty((CharSequence)vo.getSigId())) {
                        this.insInsuranceSlipService.updateOrderIdBySigId(orderId, vo.getSigId());
                    }
                } else {
                    return new ResultDto("\u8ba2\u5355\u521d\u59cb\u5316\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
                }
            }
            if ((map = this.obtainLOTEPolicyVoSetUp(vo)) != null) {
                return new ResultDto("\u5f53\u524d\u586b\u5199\u5185\u5bb9\u5df2\u7ecf\u6682\u5b58\uff0c\u7a0d\u540e\u60a8\u53ef\u5728\u3010\u6211\u7684\u8d26\u6237-\u6211\u7684\u8ba2\u5355-\u6295\u4fdd\u4e2d\u3011 \u7ee7\u7eed\u5b8c\u6210\u586b\u5199\u5185\u5bb9\u3002", "200", String.valueOf(map.get("order_id")), "", "");
            }
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        catch (Exception e) {
            this.log.error("\u96c7\u4e3b\u8d23\u4efb\u9669\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResultDto("\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff01", "300", "", "", "");
        }
    }

    @Override
    public LOTEPolicyVo accordingToOrderIDToGetLOTEPolicyVo(Long order_id) {
        LOTEPolicyVo vo = null;
        if (StrUtil.isBlank((String)String.valueOf(order_id))) {
            return vo;
        }
        vo = new LOTEPolicyVo();
        MailPolicyVo mpVo = new MailPolicyVo();
        SpecialExhibitionVo seVo = new SpecialExhibitionVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(order_id);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        if (insInsuranceSlip.getInception_date() != null) {
            vo.setInception_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getInception_date(), (String)"yyyy-MM-dd"));
        }
        if (insInsuranceSlip.getPlanned_end_date() != null) {
            vo.setPlanned_end_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getPlanned_end_date(), (String)"yyyy-MM-dd"));
        }
        vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        vo.setResponsibilityVoList(this.findResponsibilityVoList(vo.getProduct_id(), order_id));
        if (insInsuranceSlip.getSpecial_id() != null) {
            this.specialExhibitionAPIService.getSpecialExhibitionVoByPolicyID(seVo, insInsuranceSlip.getSpecial_id());
        }
        vo.setSpecialExhibitionVo(seVo);
        if (insInsuranceSlip.getMailPolicy() != null) {
            InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
            this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(mpVo, insMailPolicy);
        }
        vo.setMailPolicyVo(mpVo);
        return vo;
    }

    @Override
    public Map<String, Object> obtainGYXPolicyVoSetUp(GYXPolicyVo vo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isBlank((String)vo.getOid())) {
            return map;
        }
        try {
            this.log.info("\u4e2a\u610f\u9669\u8ba2\u5355\u6570\u636e\u5904\u7406\u5f00\u59cb---------------------");
            InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
            if (StringUtils.isNotEmpty((CharSequence)vo.getRecommend_code())) {
                insInsuranceSlip.setRecommend_code(vo.getRecommend_code());
            }
            insInsuranceSlip.setDispute(vo.getDispute());
            insInsuranceSlip.setArbitral_institution(vo.getArbitral_institution());
            if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
                insInsuranceSlip.setInception_date(DateUtil.convertString2Date((String)(vo.getInception_date() + " 00:00:00")));
                insInsuranceSlip.setPlanned_end_date(DateUtil.convertString2Date((String)(vo.getPlanned_end_date() + " 23:59:59")));
            }
            vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
            insInsuranceSlip.setInsured_amount(this.setInsuredAmountByProductId(insInsuranceSlip.getPro_primary().getPro_primary_id()));
            int days = DateUtil.getDistDates((Date)insInsuranceSlip.getInception_date(), (Date)insInsuranceSlip.getPlanned_end_date()) + 1;
            if (days > 0) {
                insInsuranceSlip.setPremium(this.getPremiumByGYX(days));
            }
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
            this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
            this.log.info("\u4e2a\u610f\u9669\u8ba2\u5355\u4eba\u5458\u66f4\u65b0\u6570\u636e\u5e93\u7ed3\u675f---------------------");
        }
        catch (Exception e) {
            this.log.error("\u4e2a\u610f\u9669\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        map.put("order_id", String.valueOf(vo.getOid()));
        return map;
    }

    private BigDecimal getPremiumByGYX(int day) {
        BigDecimal allPr = BigDecimal.ZERO;
        if (day == 1) {
            allPr = BigDecimal.valueOf(Double.parseDouble("10"));
        } else if (day > 1 && day < 8) {
            allPr = BigDecimal.valueOf(Double.parseDouble("20"));
        } else if (day > 7 && day < 16) {
            allPr = BigDecimal.valueOf(Double.parseDouble("30"));
        } else if (day > 15 && day < 31) {
            allPr = BigDecimal.valueOf(Double.parseDouble("50"));
        }
        return allPr;
    }

    @Override
    public ResultDto pendingGYXPolicyVoPolicy(GYXPolicyVo vo, String recommendCode) {
        try {
            Map<String, Object> map;
            ClientUserVo userdetail = UserSupportUtil.getSessionUser();
            if (userdetail == null) {
                return new ResultDto("\u8d26\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c", "/");
            }
            if (StringUtils.isEmpty((CharSequence)vo.getOid())) {
                String orderId = this.getOidByCreatePolicy(vo.getProduct_id(), userdetail.getOid(), recommendCode, vo.getSigId());
                if (StringUtils.isNotEmpty((CharSequence)orderId)) {
                    vo.setOid(orderId);
                    if (StringUtils.isNotEmpty((CharSequence)vo.getSigId())) {
                        this.insInsuranceSlipService.updateOrderIdBySigId(orderId, vo.getSigId());
                    }
                } else {
                    return new ResultDto("\u8ba2\u5355\u521d\u59cb\u5316\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
                }
            }
            if ((map = this.obtainGYXPolicyVoSetUp(vo)) != null) {
                return new ResultDto("\u5f53\u524d\u586b\u5199\u5185\u5bb9\u5df2\u7ecf\u6682\u5b58\uff0c\u7a0d\u540e\u60a8\u53ef\u5728\u3010\u6211\u7684\u8d26\u6237-\u6211\u7684\u8ba2\u5355-\u6295\u4fdd\u4e2d\u3011 \u7ee7\u7eed\u5b8c\u6210\u586b\u5199\u5185\u5bb9\u3002", "200", String.valueOf(map.get("order_id")), "", "");
            }
            return new ResultDto("\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01", "300", "", "", "");
        }
        catch (Exception e) {
            this.log.error("\u4e2a\u610f\u9669\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new ResultDto("\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff01", "300", "", "", "");
        }
    }

    @Override
    public GYXPolicyVo accordingToOrderIDToGetGYXPolicyVo(Long order_id) {
        GYXPolicyVo vo = null;
        if (StrUtil.isBlank((String)String.valueOf(order_id))) {
            return vo;
        }
        vo = new GYXPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(order_id);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        if (insInsuranceSlip.getInception_date() != null) {
            vo.setInception_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getInception_date(), (String)"yyyy-MM-dd"));
            vo.setPlanned_end_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getPlanned_end_date(), (String)"yyyy-MM-dd"));
        }
        vo.setDispute(insInsuranceSlip.getDispute());
        vo.setArbitral_institution(insInsuranceSlip.getArbitral_institution());
        vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        vo.setResponsibilityVoList(this.findResponsibilityVoList(vo.getProduct_id(), order_id));
        return vo;
    }

    @Override
    public String getArsPath(String sign) {
        String result = "";
        if (StringUtils.isNotEmpty((CharSequence)sign)) {
            result = this.comDeployConfigService.getValueByKey("PATH-" + sign);
        }
        return result;
    }

    @Override
    public String getArsPathWeb(String sign) {
        String result = "";
        if (StringUtils.isNotEmpty((CharSequence)sign)) {
            result = this.comDeployConfigService.getValueByKey("PATH-WEB-" + sign);
        }
        return result;
    }

    @Override
    public String pns_access_token() {
        String url = GlobalResources.PNS_GET_ACCESS_TOKEN_URL;
        this.log.info("===========================PNS_GET_ACCESS_TOKEN_URL-START======================");
        String result = "";
        try {
            this.log.info("token\u83b7\u53d6\u5730\u5740\uff1a" + url);
            result = RequestUtil.sendGet((String)url, null);
            this.log.info("token\u8fd4\u56de\u62a5\u6587\uff1a" + result);
            if (StringUtils.isEmpty((CharSequence)result)) {
                return result;
            }
            JSONObject json = JSON.parseObject((String)result);
            String status = json.get((Object)"ret").toString();
            if ("0".equals(status)) {
                String data = json.getString("data");
                this.log.info("\u5e73\u5b89\u8fd4\u56de\u503c\uff1a" + data);
                JSONObject resultJson = JSONObject.parseObject((String)data);
                result = resultJson.getString("access_token");
                this.log.info("\u5e73\u5b89token\u503c\uff1a" + result);
                this.log.info("===========================PNS_GET_ACCESS_TOKEN_URL-END======================");
            }
        }
        catch (Exception ex) {
            this.log.error("ACCESS_TOKEN", (Throwable)ex);
        }
        return result;
    }

    @Override
    public String pnc_access_token() {
        String url = GlobalResources.PNC_GET_ACCESS_TOKEN_URL;
        this.log.info("===========================PNC_GET_ACCESS_TOKEN_URL-START======================");
        String result = "";
        try {
            this.log.info("token\u83b7\u53d6\u5730\u5740\uff1a" + url);
            result = RequestUtil.sendGet((String)url, null);
            this.log.info("token\u8fd4\u56de\u62a5\u6587\uff1a" + result);
            if (StringUtils.isEmpty((CharSequence)result)) {
                return result;
            }
            JSONObject json = JSON.parseObject((String)result);
            String status = json.get((Object)"ret").toString();
            if (!"0".equals(status)) {
                return result;
            }
            String data = json.getString("data");
            this.log.info("\u5e73\u5b89\u8fd4\u56de\u503c\uff1a" + data);
            JSONObject resultJson = JSONObject.parseObject((String)data);
            result = resultJson.getString("access_token");
            this.log.info("\u5e73\u5b89token\u503c\uff1a" + result);
            this.log.info("===========================PNC_GET_ACCESS_TOKEN_URL-END======================");
        }
        catch (Exception ex) {
            this.log.error("ACCESS_TOKEN", (Throwable)ex);
        }
        return result;
    }

    @Override
    public void gainDZBDByTiming() {
        this.log.info("\u67e5\u8be2\u5df2\u627f\u4fdd\u4f46\u672a\u83b7\u53d6\u7535\u5b50\u4fdd\u5355\u7684\u8ba2\u5355\uff1astart");
        ArrayList list = new ArrayList();
        List<OrderFormVo> o1List = this.insInsuranceSlipService.listOrderFormVoByDzbdIsNot("TYX-PAS");
        this.log.info("\u67e5\u8be2\u5df2\u627f\u4fdd\u4f46\u672a\u83b7\u53d6\u7535\u5b50\u4fdd\u5355\u7684\u8ba2\u5355\uff1aTYX-PAS(" + o1List.size() + ")");
        for (OrderFormVo orderFormVo : o1List) {
            this.HTTP_PAS_TYX_DZBD(Long.parseLong(orderFormVo.getOid()), null, orderFormVo);
        }
        List<OrderFormVo> o2List = this.insInsuranceSlipService.listOrderFormVoByDzbdIsNot("ZZX-PAC");
        this.log.info("\u67e5\u8be2\u5df2\u627f\u4fdd\u4f46\u672a\u83b7\u53d6\u7535\u5b50\u4fdd\u5355\u7684\u8ba2\u5355\uff1aZZX-PAC(" + o2List.size() + ")");
        for (OrderFormVo orderFormVo : o2List) {
            this.HTTP_PAC_ZZX_DZBD(Long.parseLong(orderFormVo.getOid()));
        }
        List<OrderFormVo> list2 = this.insInsuranceSlipService.listOrderFormVoByDzbdIsNot("GZX-PAC");
        this.log.info("\u67e5\u8be2\u5df2\u627f\u4fdd\u4f46\u672a\u83b7\u53d6\u7535\u5b50\u4fdd\u5355\u7684\u8ba2\u5355\uff1aGZX-PAC(" + list2.size() + ")");
        for (OrderFormVo orderFormVo : list2) {
            this.HTTP_PAC_GZX_DZBD(Long.parseLong(orderFormVo.getOid()), null, orderFormVo);
        }
        List<OrderFormVo> list3 = this.insInsuranceSlipService.listOrderFormVoByDzbdIsNot("XYX-XWCK");
        this.log.info("\u67e5\u8be2\u5df2\u627f\u4fdd\u4f46\u672a\u83b7\u53d6\u7535\u5b50\u4fdd\u5355\u7684\u8ba2\u5355\uff1aXYX-XWCK(" + list3.size() + ")");
        for (OrderFormVo vo : list3) {
            this.HTTP_TPC_XYX_DZBD(Long.parseLong(vo.getOid()));
        }
        List<OrderFormVo> list4 = this.insInsuranceSlipService.listOrderFormVoByDzbdIsNot("BZX-YG-GCTB");
        this.log.info("\u67e5\u8be2\u5df2\u627f\u4fdd\u4f46\u672a\u83b7\u53d6\u7535\u5b50\u4fdd\u5355\u7684\u8ba2\u5355\uff1aBZX-YG-GCTB(" + list4.size() + ")");
        for (OrderFormVo vo : list4) {
            this.HTTP_YG_BUILD_DZBD(vo.getOid());
        }
        this.log.info("\u67e5\u8be2\u5df2\u627f\u4fdd\u4f46\u672a\u83b7\u53d6\u7535\u5b50\u4fdd\u5355\u7684\u8ba2\u5355\uff1aend");
    }

    @Override
    public void yxTimer(Long order_id) {
        long endTime;
        long syTime;
        long thrMM = 180000L;
        long allTime = 3600000L;
        long bgTime = System.currentTimeMillis();
        boolean flag = false;
        boolean i = false;
        while ((syTime = (endTime = System.currentTimeMillis()) - bgTime) < allTime) {
            try {
                if (this.HTTP_TPC_XYX_YX(order_id)) {
                    flag = true;
                    this.insInsuranceSlipService.updateIsSendYX(order_id);
                    i = true;
                    break;
                }
                Thread.sleep(thrMM);
            }
            catch (Exception e) {
                if (!flag) continue;
                break;
            }
        }
        if (!i) {
            return;
        }
        try {
            boolean doF = false;
            for (int x = 0; x < 3; ++x) {
                if (doF) continue;
                Thread.sleep(240000L);
                doF = this.HTTP_TPC_XYX_CB(order_id);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void payUrlChange(Long order_id) throws Exception {
        InsInsuranceSlip order = this.insInsuranceSlipService.selectById(order_id);
        List<InsTransaction> tList = this.insTransactionService.selectInsTransactionByInsOrderForm(order_id);
        if (tList.size() <= 0) {
            return;
        }
        InsTransaction it = tList.get(0);
        String result = this.gZZRX_RBRequestService.request_rb_gzzrx(order_id, "5", null);
        String[] strs = result.split("#");
        if (!"200".equals(strs[0]) || strs.length != 3) {
            return;
        }
        it.setDeal_url(strs[2]);
        it.setStart_time(new Date());
        order.setNotice_no(strs[1]);
        this.insInsuranceSlipService.updateById(order);
        this.insTransactionService.updateById(it);
    }

    @Override
    public void payUrlChangeZHGZ(Long order_id, String payNo, String payUrl) throws Exception {
        if (order_id == null || StringUtils.isEmpty((CharSequence)payNo) || StringUtils.isEmpty((CharSequence)payUrl)) {
            return;
        }
        InsInsuranceSlip order = this.insInsuranceSlipService.selectById(order_id);
        InsTransaction insTransaction = null;
        List<InsTransaction> insTransactionList = this.insTransactionService.selectInsTransactionByInsOrderForm(order_id);
        if (insTransactionList.size() > 0) {
            insTransaction = insTransactionList.get(0);
        } else {
            insTransaction = this.insTransactionService.initInsTransaction();
            insTransaction.setInsurance_slip(order);
        }
        insTransaction.setDeal_url(payUrl);
        insTransaction.setStart_time(new Date());
        order.setNotice_no(payNo);
        this.insInsuranceSlipService.updateById(order);
        this.insTransactionService.updateById(insTransaction);
    }

    @Override
    public void payUrlChangeCA(Long order_id, String payNo, String payUrl) throws Exception {
        if (order_id == null || StringUtils.isEmpty((CharSequence)payNo) || StringUtils.isEmpty((CharSequence)payUrl)) {
            return;
        }
        InsInsuranceSlip order = this.insInsuranceSlipService.selectById(order_id);
        InsTransaction insTransaction = null;
        List<InsTransaction> insTransactionList = this.insTransactionService.selectInsTransactionByInsOrderForm(order_id);
        if (insTransactionList.size() > 0) {
            insTransaction = insTransactionList.get(0);
        } else {
            insTransaction = this.insTransactionService.initInsTransaction();
            insTransaction.setInsurance_slip(order);
        }
        insTransaction.setPay_order_number(payNo);
        insTransaction.setDeal_url(payUrl);
        insTransaction.setStart_time(new Date());
        this.insTransactionService.updateById(insTransaction);
    }

    @Override
    public void payUrlChangeHT(Long order_id, String payNo, String payUrl) throws Exception {
        if (order_id == null || StringUtils.isEmpty((CharSequence)payNo) || StringUtils.isEmpty((CharSequence)payUrl)) {
            return;
        }
        InsInsuranceSlip order = this.insInsuranceSlipService.selectById(order_id);
        InsTransaction insTransaction = null;
        List<InsTransaction> insTransactionList = this.insTransactionService.selectInsTransactionByInsOrderForm(order_id);
        if (insTransactionList.size() > 0) {
            insTransaction = insTransactionList.get(0);
        } else {
            insTransaction = this.insTransactionService.initInsTransaction();
            insTransaction.setInsurance_slip(order);
        }
        insTransaction.setPay_order_number(payNo);
        insTransaction.setDeal_url(payUrl);
        insTransaction.setStart_time(new Date());
        this.insTransactionService.updateById(insTransaction);
    }

    @Override
    public void payUrlChangePAC(Long order_id, String tranNo, String payUrl) throws Exception {
        if (order_id == null || StringUtils.isEmpty((CharSequence)tranNo) || StringUtils.isEmpty((CharSequence)payUrl)) {
            return;
        }
        InsInsuranceSlip order = this.insInsuranceSlipService.selectById(order_id);
        InsTransaction insTransaction = null;
        List<InsTransaction> insTransactionList = this.insTransactionService.selectInsTransactionByInsOrderForm(order_id);
        if (insTransactionList.size() > 0) {
            insTransaction = insTransactionList.get(0);
        } else {
            insTransaction = this.insTransactionService.initInsTransaction();
            insTransaction.setInsurance_slip(order);
        }
        insTransaction.setTrade_serial_number(tranNo);
        insTransaction.setDeal_url(payUrl);
        insTransaction.setStart_time(new Date());
        this.insTransactionService.updateById(insTransaction);
    }

    @Override
    public String zzx_amount_count(String productCode, String exAcreage) {
        String result = "";
        if (StringUtils.isEmpty((CharSequence)productCode) || StringUtils.isEmpty((CharSequence)exAcreage)) {
            return "300#\u5fc5\u8981\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        Double ead = Double.valueOf(exAcreage);
        if ("ZZX-PAC-1".equals(productCode)) {
            result = 0.0 < ead && ead < 37.0 ? "200#180.00" : "300#\u8be5\u65b9\u6848\u5c55\u4f4d\u603b\u9762\u79ef\u57281~36\u5e73\u7c73\u4e4b\u95f4\uff01";
        } else if ("ZZX-PAC-2".equals(productCode)) {
            result = 0.0 < ead && ead < 37.0 ? "200#240.00" : (36.0 < ead && ead < 101.0 ? "200#340.00" : "300#\u8be5\u65b9\u6848\u5c55\u4f4d\u603b\u9762\u79ef\u57281~100\u5e73\u7c73\u4e4b\u95f4\uff01");
        } else if ("ZZX-PAC-3".equals(productCode)) {
            result = 0.0 < ead && ead < 37.0 ? "200#300.00" : (36.0 < ead && ead < 101.0 ? "200#400.00" : (ead > 100.0 ? "200#490.00" : "300#\u5c55\u4f4d\u603b\u9762\u79ef\u57281\u5e73\u7c73\u4ee5\u4e0a\uff01"));
        } else if ("ZZX-YA-1".equals(productCode)) {
            if (0.0 < ead && ead < 37.0) {
                result = "200#200.00";
            } else if (36.0 < ead && ead < 109.0) {
                result = "200#280.00";
            } else if (108.0 < ead && ead < 217.0) {
                result = "200#380.00";
            } else if (ead > 216.0) {
                int _y = (Integer.parseInt(exAcreage) - 216) % 108 > 0 ? 1 : 0;
                result = "200#" + String.valueOf(380 + ((Integer.parseInt(exAcreage) - 216) / 108 + _y) * 30) + ".00";
            } else {
                result = "300#\u5c55\u4f4d\u603b\u9762\u79ef\u57281\u5e73\u7c73\u4ee5\u4e0a\uff01";
            }
        } else if ("ZZX-YA-2".equals(productCode)) {
            if (0.0 < ead && ead < 37.0) {
                result = "200#260.00";
            } else if (36.0 < ead && ead < 109.0) {
                result = "200#360.00";
            } else if (108.0 < ead && ead < 217.0) {
                result = "200#470.00";
            } else if (ead > 216.0) {
                int _y = (Integer.parseInt(exAcreage) - 216) % 108 > 0 ? 1 : 0;
                result = "200#" + String.valueOf(470 + ((Integer.parseInt(exAcreage) - 216) / 108 + _y) * 30) + ".00";
            } else {
                result = "300#\u5c55\u4f4d\u603b\u9762\u79ef\u57281\u5e73\u7c73\u4ee5\u4e0a\uff01";
            }
        } else if ("ZZX-YA-3".equals(productCode)) {
            if (0.0 < ead && ead < 37.0) {
                result = "200#330.00";
            } else if (36.0 < ead && ead < 109.0) {
                result = "200#430.00";
            } else if (108.0 < ead && ead < 217.0) {
                result = "200#520.00";
            } else if (ead > 216.0) {
                int _y = (Integer.parseInt(exAcreage) - 216) % 108 > 0 ? 1 : 0;
                result = "200#" + String.valueOf(520 + ((Integer.parseInt(exAcreage) - 216) / 108 + _y) * 30) + ".00";
            } else {
                result = "300#\u5c55\u4f4d\u603b\u9762\u79ef\u57281\u5e73\u7c73\u4ee5\u4e0a\uff01";
            }
        } else if ("ZZX-HT-1".equals(productCode)) {
            result = 0.0 < ead && ead < 37.0 ? "200#200.00" : (36.0 < ead && ead < 101.0 ? "200#300.00" : (ead > 100.0 ? "200#400.00" : "300#\u5c55\u4f4d\u603b\u9762\u79ef\u57281\u5e73\u7c73\u4ee5\u4e0a\uff01"));
        } else if ("ZZX-HT-2".equals(productCode)) {
            result = 0.0 < ead && ead < 37.0 ? "200#260.00" : (36.0 < ead && ead < 101.0 ? "200#360.00" : (ead > 100.0 ? "200#460.00" : "300#\u5c55\u4f4d\u603b\u9762\u79ef\u57281\u5e73\u7c73\u4ee5\u4e0a\uff01"));
        } else if ("ZZX-HT-3".equals(productCode)) {
            result = 0.0 < ead && ead < 37.0 ? "200#330.00" : (36.0 < ead && ead < 101.0 ? "200#430.00" : (ead > 100.0 ? "200#530.00" : "300#\u5c55\u4f4d\u603b\u9762\u79ef\u57281\u5e73\u7c73\u4ee5\u4e0a\uff01"));
        } else if ("ZZX-CA-1".equals(productCode)) {
            result = 0.0 < ead && ead < 100.0 ? "200#180.00" : "300#\u8be5\u65b9\u6848\u5c55\u4f4d\u603b\u9762\u79ef\u57281~100\u5e73\u7c73\u4e4b\u95f4\uff01";
        } else {
            if (!productCode.contains("ZZX-ZA")) {
                return "300#\u672a\u5339\u914d\u5230\u5bf9\u5e94\u4ea7\u54c1\uff01";
            }
            if (0.0 >= ead || ead >= 109.0) {
                return "300#\u5c55\u4f4d\u603b\u9762\u79ef\u57281~108\u5e73\u7c73\u4e4b\u95f4\uff01";
            }
            result = "ZZX-ZA-1".equals(productCode) ? "200#450.00" : ("ZZX-ZA-2".equals(productCode) ? "200#500.00" : ("ZZX-ZA-3".equals(productCode) ? "200#600.00" : "300#\u672a\u5339\u914d\u5230\u5bf9\u5e94\u4ea7\u54c1\uff01"));
        }
        return result;
    }

    @Override
    public void updateUrlByExternalreference(String url, String externalreference) {
        this.insMailPolicyService.updateUrlByExternalreference(url, externalreference);
    }

    @Override
    public void downSecurityPersonnel(Long oid, HttpServletResponse resp) {
        OrderFormVo orderVo = this.accordingToOrderIDToGetPolicyDto(oid);
        if (orderVo == null || StringUtils.isEmpty((CharSequence)orderVo.getPolicy_serial_number())) {
            return;
        }
        String fileName = orderVo.getTrade_serial_number() + "-\u4fdd\u969c\u4eba\u5458.xls";
        try {
            fileName = new String(fileName.getBytes("gb2312"), "ISO8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ExcelUtil util = new ExcelUtil(ResultSetExcelVo.class);
        resp.setContentType("application/vnd.ms-excel");
        resp.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
        try (ServletOutputStream os = resp.getOutputStream();){
            List<ResultSetExcelVo> voList = null;
            if (orderVo.getProduct_code().contains("GZZRX")) {
                voList = this.hirelingAPIService.selectHirelingListByOrderID(oid);
            } else if (orderVo.getProduct_code().contains("TYX")) {
                voList = this.insRoleInpolicyService.selectRoleInPolicyListByOrderID(oid);
            }
            if (voList != null && voList.size() > 0) {
                util.exportExcel(voList, orderVo.getTrade_serial_number() + "\u4fdd\u969c\u4eba\u5458", 65535, (OutputStream)os);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void policyExpireInform() {
        EmailModel em;
        String aDay = DateUtil.formatDate((Date)DateUtils.addMonths((Date)new Date(), (int)1), (Object[])new Object[]{"yyyy-MM-dd"});
        String bDay = DateUtil.formatDate((Date)DateUtils.addDays((Date)new Date(), (int)15), (Object[])new Object[]{"yyyy-MM-dd"});
        String cDay = DateUtil.formatDate((Date)DateUtils.addDays((Date)new Date(), (int)3), (Object[])new Object[]{"yyyy-MM-dd"});
        List<Map<String, Object>> bList = this.insInsuranceSlipService.findMaturingPolicy(aDay, bDay, cDay);
        String dDay = DateUtil.formatDate((Date)new Date(), (Object[])new Object[]{"yyyy-MM-dd"});
        List<Map<String, Object>> tList = this.insInsuranceSlipService.findMaturingPolicy(dDay, "", "");
        for (Map<String, Object> map : bList) {
            if (!StringUtils.isNotEmpty((CharSequence)String.valueOf(map.get("email")))) continue;
            em = new EmailModel(EmailMsgType.BD_JJ_DQ, String.valueOf(map.get("productName")), String.valueOf(map.get("perNum")), String.valueOf(map.get("external_reference")), String.valueOf(map.get("planned_end_date")));
            em.addTo(String.valueOf(map.get("email")));
            this.log.info("\u4fdd\u9669\u5230\u671f\u90ae\u4ef6\u53d1\u9001\uff0cPARAM\uff1a" + JSON.toJSONString((Object)em));
            SendEmailAndMsgUtil.sendEmail((EmailModel)em);
        }
        for (Map<String, Object> map : tList) {
            if (!StringUtils.isNotEmpty((CharSequence)String.valueOf(map.get("email")))) continue;
            em = new EmailModel(EmailMsgType.BD_DQ, String.valueOf(map.get("productName")), String.valueOf(map.get("perNum")), String.valueOf(map.get("external_reference")), String.valueOf(map.get("planned_end_date")));
            em.addTo(String.valueOf(map.get("email")));
            this.log.info("\u4fdd\u9669\u5230\u671f\u90ae\u4ef6\u53d1\u9001\uff0cPARAM\uff1a" + JSON.toJSONString((Object)em));
            SendEmailAndMsgUtil.sendEmail((EmailModel)em);
        }
    }

    @Override
    public List<Map<String, Object>> orderList(String idCardNo) {
        return this.insInsuranceSlipService.orderList(idCardNo);
    }

    @Override
    public int isDueToByPolicy(Long orderId, String inception_date) {
        if (orderId == null || StringUtils.isEmpty((CharSequence)inception_date)) {
            return 1;
        }
        return this.insInsuranceSlipService.isDueToByPolicy(orderId, inception_date);
    }

    @Override
    public void JFPZ_SendEmail(Long orderId, String payUrl) {
        String[] arrs = this.comDeployConfigService.getValueByKey("JFPZ_EMAIL").split(";");
        OrderFormVo dto = this.accordingToOrderIDToGetPolicyDto(orderId);
        EmailModel emailModel = new EmailModel(EmailMsgType.BD_JFPZ, dto.getProduct_name(), dto.getApplicant_name(), payUrl, dto.getTrade_serial_number(), dto.getPolicy_serial_number(), dto.getInception_date() + "~" + dto.getPlanned_end_date(), dto.getGross_premium());
        ArrayList<String> emailList = new ArrayList<String>();
        for (int i = 0; i < arrs.length; ++i) {
            String[] eArr = arrs[i].split(":");
            if (!StringUtils.isNotEmpty((CharSequence)arrs[i])) continue;
            if (eArr.length == 1) {
                emailList.add(eArr[0].trim());
                continue;
            }
            if (eArr.length != 2 || !StringUtils.isNotEmpty((CharSequence)eArr[1]) || !StringUtils.isNotEmpty((CharSequence)dto.getProduct_code()) || !dto.getProduct_code().contains(eArr[1])) continue;
            emailList.add(eArr[0].trim());
        }
        if (emailList.size() > 0) {
            emailModel.setTo(emailList);
            SendEmailAndMsgUtil.sendEmail((EmailModel)emailModel);
        }
    }

    @Override
    public ResultDto copyPolicy(Long orderID) {
        OrderFormVo orderVo = this.accordingToOrderIDToGetPolicyDto(orderID);
        if (orderVo == null || StringUtils.isEmpty((CharSequence)orderVo.getProduct_code())) {
            return new ResultDto("\u8ba2\u5355\u4e0d\u5b58\u5728\uff01", "300", "", "", "");
        }
        if ("XYX-DQCK".equals(orderVo.getProduct_code())) {
            return new ResultDto("\u77ed\u671f\u51fa\u53e3\u9669\u4e0d\u652f\u6301\u590d\u5236\u529f\u80fd\uff01", "300", "", "", "");
        }
        IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
        Long tNumber = idWorker.nextId();
        Long pId = idWorker.nextId();
        Long sId = idWorker.nextId();
        Long mId = idWorker.nextId();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        Long oldSpecial_id = insInsuranceSlip.getSpecial_id();
        insMailPolicy.setIns_mail_policy_id(mId);
        insInsuranceSlip.setIns_insurance_slip_id(pId);
        insInsuranceSlip.setTrade_serial_number(String.valueOf(tNumber));
        insInsuranceSlip.setMailPolicy(insMailPolicy);
        insInsuranceSlip.setUnderwrite(null);
        insInsuranceSlip.setPolicy_serial_number("");
        insInsuranceSlip.setSigned_date(new Date());
        insInsuranceSlip.setCreate_time(new Date());
        insInsuranceSlip.setStart_time(new Date());
        insInsuranceSlip.setEnd_time(null);
        insInsuranceSlip.setNotice_no(null);
        insInsuranceSlip.setInsure_path(null);
        insInsuranceSlip.setOrder_status("1");
        HashMap columnMap = Maps.newHashMap();
        columnMap.put("insurance_slip_id", orderID);
        List roleList = this.insRoleInpolicyService.selectByMap(columnMap);
        for (Object role : roleList) {
            role.setIns_role_inpolicy_id(Long.valueOf(idWorker.nextId()));
            role.setInsurance_slip(insInsuranceSlip);
        }
        this.insMailPolicyService.insert(insMailPolicy);
        this.insRoleInpolicyService.insertBatch(roleList);
        if (orderVo.getProduct_code().contains("GZZRX")) {
            columnMap = Maps.newHashMap();
            columnMap.put("ins_insurance_slip_id", orderID);
            List hirelingList = this.hirelingAPIService.selectByMap(columnMap);
            for (Hireling hireling : hirelingList) {
                hireling.setHireling_id(Long.valueOf(idWorker.nextId()));
                hireling.setIns_insurance_slip_id(pId);
            }
            this.hirelingAPIService.insertBatch(hirelingList);
        } else if (orderVo.getProduct_code().contains("ZZX")) {
            insInsuranceSlip.setSpecial_id(sId);
            SpecialExhibition specialExhibition = (SpecialExhibition)this.specialExhibitionAPIService.selectById(oldSpecial_id);
            specialExhibition.setSpecial_exhibition_id(sId);
            this.specialExhibitionAPIService.insert(specialExhibition);
        } else if (orderVo.getProduct_code().contains("GZX")) {
            insInsuranceSlip.setSpecial_id(sId);
            SpecialPublicDuty specialPublicDuty = (SpecialPublicDuty)this.specialPublicDutyService.selectById(oldSpecial_id);
            specialPublicDuty.setSpecial_public_duty_id(sId);
            this.specialPublicDutyService.insert(specialPublicDuty);
        } else if (orderVo.getProduct_code().contains("GCLY")) {
            insInsuranceSlip.setSpecial_id(sId);
            SpecialPerformance insSpecialPerformance = (SpecialPerformance)this.insSpecialPerformanceService.selectById(oldSpecial_id);
            insSpecialPerformance.setSpecial_performance_id(sId);
            this.insSpecialPerformanceService.insert(insSpecialPerformance);
        } else if (orderVo.getProduct_code().contains("GCTB")) {
            insInsuranceSlip.setSpecial_id(sId);
            SpecialBid insSpecialBid = (SpecialBid)this.insSpecialBidService.selectById(oldSpecial_id);
            insSpecialBid.setSpecial_bid_id(sId);
            this.insSpecialBidService.insert(insSpecialBid);
        } else if (orderVo.getProduct_code().contains("XYX-XWCK")) {
            insInsuranceSlip.setSpecial_id(sId);
            SpecialCreditMicro insMicroExport = (SpecialCreditMicro)this.insMicroExportService.selectById(oldSpecial_id);
            insMicroExport.setSpecial_credit_micro_id(sId);
            this.insMicroExportService.insert(insMicroExport);
        } else if (orderVo.getProduct_code().contains("BZX-SSBQ")) {
            insInsuranceSlip.setSpecial_id(sId);
            SpecialLitigation specialLitigation = (SpecialLitigation)this.specialLitigationService.selectById(oldSpecial_id);
            columnMap = Maps.newHashMap();
            columnMap.put("special_litigation_id", specialLitigation.getSpecial_litigation_id());
            List lnAccusedList = this.lnAccusedAPIService.selectByMap(columnMap);
            specialLitigation.setSpecial_litigation_id(sId);
            for (LnAccused lnAccused : lnAccusedList) {
                lnAccused.setLn_accused_id(Long.valueOf(idWorker.nextId()));
                lnAccused.setSpecial_litigation(specialLitigation);
            }
            this.specialLitigationService.insert(specialLitigation);
            this.lnAccusedAPIService.insertBatch(lnAccusedList);
        }
        this.insInsuranceSlipService.insert(insInsuranceSlip);
        return new ResultDto("\u8ba2\u5355\u590d\u5236\u6210\u529f!\u8ba2\u5355\u7f16\u53f7\uff1a" + tNumber, "200", "", "", "");
    }

    @Override
    public boolean createSendOrderTask(Long orderId, int type, String inceptionDate) {
        if (type == 1) {
            InsPreservationRecordVo iprVo = this.insPreservationRecordAPIService.findInsPreservationRecordVoById(orderId);
            OrderFormVo vo = this.accordingToOrderIDToGetPolicyDto(Long.parseLong(iprVo.getIns_insurance_slip_id()));
            InsRoleInpolicy role = this.insRoleInpolicyService.getInsRoleInpolicyListByIDAndKind(Long.parseLong(iprVo.getIns_insurance_slip_id()), "1").get(0);
            List dList = iprVo.getInsPreservationDetailVoList();
            String spercs = vo.getProduct_code() + "-" + (Integer.parseInt(vo.getIs_contain_repo()) + 1);
            String mrPremium = iprVo.getTotal_premium();
            if ("13".equals(iprVo.getRevise_type())) {
                mrPremium = "0";
            }
            this.createParem(iprVo.getRevise_serial_num_ins(), spercs, mrPremium, String.valueOf(dList.size()), role.getReg_district(), role.getOrganization_code(), "1");
        } else {
            OrderFormVo vo = this.accordingToOrderIDToGetPolicyDto(orderId);
            InsRoleInpolicy role = this.insRoleInpolicyService.getInsRoleInpolicyListByIDAndKind(Long.parseLong(vo.getOid()), "1").get(0);
            List<InsPreservationResultSet> list = this.insPreservationResultSetAPIService.initFindInsPreservationResultSetByKeyword(null, orderId, "", "0", "", "");
            String spercs = vo.getProduct_code() + "-" + (Integer.parseInt(vo.getIs_contain_repo()) + 1);
            if (type == 2) {
                this.createParem(vo.getExternal_reference(), spercs, vo.getGross_premium(), String.valueOf(list.size()), role.getReg_district(), role.getOrganization_code(), "0");
            } else {
                if (StringUtils.isEmpty((CharSequence)inceptionDate)) {
                    throw new RuntimeException("\u9000\u4fdd\u4e1a\u52a1\u9700\u8981\u5f55\u5165\u751f\u6548\u65e5\u671f");
                }
                int syDay = DateUtil.getDistDates((Date)DateUtil.convertStringToDate((String)inceptionDate), (Date)DateUtil.convertStringToDate((String)vo.getPlanned_end_date())) + 1;
                int tolDay = DateUtil.getDistDates((Date)DateUtil.convertStringToDate((String)vo.getInception_date()), (Date)DateUtil.convertStringToDate((String)vo.getPlanned_end_date())) + 1;
                BigDecimal liDay = BigDecimal.valueOf(1L).subtract(BigDecimal.valueOf(syDay).divide(BigDecimal.valueOf(tolDay), 10, 4).setScale(6, 4));
                String mrPremium = BigDecimal.valueOf(Double.parseDouble(vo.getPremium())).multiply(BigDecimal.valueOf(list.size())).multiply(liDay).setScale(2, 4).toString();
                this.createParem(vo.getExternal_reference() + "T", spercs, "-" + mrPremium, String.valueOf(list.size()), role.getReg_district(), role.getOrganization_code(), "1");
            }
        }
        return true;
    }

    private void createParem(String orderNo, String spercs, String premium, String num, String district, String identityCardNo, String insuranceType) {
        ImportInsuranceOrderRequest oRequest = new ImportInsuranceOrderRequest(orderNo, "", district, num, premium, spercs, identityCardNo, insuranceType);
        this.comTaskResidualAPIService.saveComTaskResidual("sendOrderToShop", "\u4fdd\u9669\u8ba2\u5355\u63a8\u9001\u5546\u57ce", "com.bcxin.ins.service.order.PolicyService", 1, "com.bcxin.ins.vo.shop.ImportInsuranceOrderRequest", JSON.toJSONString((Object)oRequest));
    }

    @Override
    public boolean sendOrderToShop(ImportInsuranceOrderRequest oRequest) {
        String token = "";
        try {
            token = TokenUtils.generateToken((String)"sourceId", (String)oRequest.getSourceId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        oRequest.setVerify(token);
        String url = (String)GlobalResources.map.get("SHOP_URL") + "/api/front/order/import/insurance";
        this.log.info("=========> sendOrderToShop \u8ba2\u5355\u63a8\u9001\u5546\u57ce URL\uff1a" + url);
        String reqStr = JSON.toJSONString((Object)oRequest);
        this.log.info("=========> sendOrderToShop \u8ba2\u5355\u63a8\u9001\u5546\u57ce param\uff1a" + reqStr);
        String ret = HttpUtil.post((String)url, (String)reqStr);
        this.log.info("=========> sendOrderToShop \u8ba2\u5355\u63a8\u9001\u5546\u57ce ret\uff1a" + ret);
        ShopResult r = (ShopResult)JSON.parseObject((String)ret, ShopResult.class);
        if ("200".equals(r.getCode()) && StringUtils.isNotEmpty((CharSequence)r.getData())) {
            return true;
        }
        this.log.error("=========> sendOrderToShop \u8ba2\u5355\u63a8\u9001\u5546\u57ce\u5f02\u5e38\uff1a" + r.getMessage());
        return r.getMessage().contains("\u8ba2\u5355\u5df2\u5b58\u5728");
    }
}

