/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.repkg.org.apache.http.impl.execchain;

import com.pingan.iobs.sdk.repkg.org.apache.http.HttpEntityEnclosingRequest;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpException;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpHost;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpRequest;
import com.pingan.iobs.sdk.repkg.org.apache.http.ProtocolException;
import com.pingan.iobs.sdk.repkg.org.apache.http.annotation.ThreadSafe;
import com.pingan.iobs.sdk.repkg.org.apache.http.auth.AuthScheme;
import com.pingan.iobs.sdk.repkg.org.apache.http.auth.AuthState;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.RedirectException;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.RedirectStrategy;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.config.RequestConfig;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.methods.CloseableHttpResponse;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.methods.HttpExecutionAware;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.methods.HttpRequestWrapper;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.methods.HttpUriRequest;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.protocol.HttpClientContext;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.utils.URIUtils;
import com.pingan.iobs.sdk.repkg.org.apache.http.conn.routing.HttpRoute;
import com.pingan.iobs.sdk.repkg.org.apache.http.conn.routing.HttpRoutePlanner;
import com.pingan.iobs.sdk.repkg.org.apache.http.impl.execchain.ClientExecChain;
import com.pingan.iobs.sdk.repkg.org.apache.http.impl.execchain.RequestEntityProxy;
import com.pingan.iobs.sdk.repkg.org.apache.http.util.Args;
import com.pingan.iobs.sdk.repkg.org.apache.http.util.EntityUtils;
import java.io.IOException;
import java.net.URI;
import java.util.List;

@ThreadSafe
public class RedirectExec
implements ClientExecChain {
    private final ClientExecChain requestExecutor;
    private final RedirectStrategy redirectStrategy;
    private final HttpRoutePlanner routePlanner;

    public RedirectExec(ClientExecChain requestExecutor, HttpRoutePlanner routePlanner, RedirectStrategy redirectStrategy) {
        Args.notNull(requestExecutor, "HTTP client request executor");
        Args.notNull(routePlanner, "HTTP route planner");
        Args.notNull(redirectStrategy, "HTTP redirect strategy");
        this.requestExecutor = requestExecutor;
        this.routePlanner = routePlanner;
        this.redirectStrategy = redirectStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        RequestConfig config;
        Args.notNull(route, "HTTP route");
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        List<URI> redirectLocations = context.getRedirectLocations();
        if (redirectLocations != null) {
            redirectLocations.clear();
        }
        int maxRedirects = (config = context.getRequestConfig()).getMaxRedirects() > 0 ? config.getMaxRedirects() : 50;
        HttpRoute currentRoute = route;
        HttpRequestWrapper currentRequest = request;
        int redirectCount = 0;
        while (true) {
            CloseableHttpResponse response = this.requestExecutor.execute(currentRoute, currentRequest, context, execAware);
            try {
                URI uri;
                HttpHost newTarget;
                if (!config.isRedirectsEnabled()) return response;
                if (!this.redirectStrategy.isRedirected(currentRequest, response, context)) return response;
                if (redirectCount >= maxRedirects) {
                    throw new RedirectException("Maximum redirects (" + maxRedirects + ") exceeded");
                }
                ++redirectCount;
                HttpUriRequest redirect = this.redirectStrategy.getRedirect(currentRequest, response, context);
                if (!redirect.headerIterator().hasNext()) {
                    HttpRequest original = request.getOriginal();
                    redirect.setHeaders(original.getAllHeaders());
                }
                if ((currentRequest = HttpRequestWrapper.wrap(redirect)) instanceof HttpEntityEnclosingRequest) {
                    RequestEntityProxy.enhance((HttpEntityEnclosingRequest)((Object)currentRequest));
                }
                if ((newTarget = URIUtils.extractHost(uri = currentRequest.getURI())) == null) {
                    throw new ProtocolException("Redirect URI does not specify a valid host name: " + uri);
                }
                if (!currentRoute.getTargetHost().equals(newTarget)) {
                    AuthScheme authScheme;
                    AuthState proxyAuthState;
                    AuthState targetAuthState = context.getTargetAuthState();
                    if (targetAuthState != null) {
                        targetAuthState.reset();
                    }
                    if ((proxyAuthState = context.getProxyAuthState()) != null && (authScheme = proxyAuthState.getAuthScheme()) != null && authScheme.isConnectionBased()) {
                        proxyAuthState.reset();
                    }
                }
                currentRoute = this.routePlanner.determineRoute(newTarget, currentRequest, context);
                EntityUtils.consume(response.getEntity());
                response.close();
            }
            catch (RuntimeException ex) {
                response.close();
                throw ex;
            }
            catch (IOException ex) {
                response.close();
                throw ex;
            }
            catch (HttpException ex) {
                try {
                    EntityUtils.consume(response.getEntity());
                    throw ex;
                }
                catch (IOException ioex) {
                    throw ex;
                }
                finally {
                    response.close();
                }
            }
        }
    }
}

