package com.bcxin.wps.entity;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.io.Serializable;

@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class FileId implements Serializable {
    private String id;
    private int version = 1;

    public FileId copyForNewVersion() {
        return new FileId(id, version + 1);
    }

    public String getFinalId() {
        return String.format("%s_%s",this.getId(), this.getVersion());
    }
}
