package com.bcxin.web.controller;

import com.bcxin.service.impl.ScheduleService;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 *  定时任务
 */
@Service
@EnableScheduling
public class ScheduleController {

    @Resource
    private ScheduleService scheduleService;

    /**
     * <b>定时任务，定时清理下载文件夹 </b>
     */
    @Scheduled(cron="0 0 23 * * ?")//每天23点触发
    public void clear() {
        scheduleService.clearDownloadDir();
    }
}
