package com.bcxin.service.impl;

import com.bcxin.model.FileAttribute;
import com.bcxin.model.ReturnResponse;
import com.bcxin.service.IFilePreview;
import com.bcxin.utils.FileUtils;
import com.bcxin.utils.SimTextUtil;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

import javax.annotation.Resource;

@Service
public class SimTextIFilePreviewImpl implements IFilePreview {

    @Resource
    private SimTextUtil simTextUtil;

    @Resource
    private FileUtils fileUtils;

    @Override
    public String filePreviewHandle(String url, Model model){
        FileAttribute fileAttribute=fileUtils.getFileAttribute(url);
        String decodedUrl=fileAttribute.getDecodedUrl();
        String fileName=fileAttribute.getName();
        ReturnResponse<String> response = simTextUtil.readSimText(decodedUrl, fileName);
        if (0 != response.getCode()) {
            model.addAttribute("msg", response.getMsg());
            model.addAttribute("fileType",fileAttribute.getSuffix());
            return "fileNotSupported";
        }
        model.addAttribute("ordinaryUrl", response.getMsg());
        return "txt";
    }

}
