package com.bcxin.service;

import com.bcxin.model.FileAttribute;
import com.bcxin.utils.FileUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

@Service
public class FilePreviewFactory {

    @Resource
    private FileUtils fileUtils;

    @Resource
    private ApplicationContext context;

    public IFilePreview get(String url) {
        Map<String, IFilePreview> filePreviewMap = context.getBeansOfType(IFilePreview.class);
        FileAttribute fileAttribute = fileUtils.getFileAttribute(url);
        IFilePreview iFilePreview = filePreviewMap.get(fileAttribute.getType().getInstanceName());
        return iFilePreview;
    }
}
