package com.bcxin.health;

import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix = "spring.redisson")
@Component
public class RedisHealthIndicator implements HealthIndicator {

    private String address;

    /**
     * user监控 访问: http://localhost:8088/health
     *
     * @return 自定义Health监控
     */
    @Override
    public Health health() {
        return new Health.Builder().withDetail("redis address ",address) //自定义监控内容
               .up().build();
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
}
