/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.framework.shiro.session;

import com.bcxin.auth.common.enums.OnlineStatus;
import com.bcxin.auth.framework.manager.AsyncManager;
import com.bcxin.auth.framework.manager.factory.AsyncFactory;
import com.bcxin.auth.framework.shiro.service.SysShiroService;
import com.bcxin.auth.framework.shiro.session.OnlineSession;
import java.io.Serializable;
import java.util.Date;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.EnterpriseCacheSessionDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class OnlineSessionDAO
extends EnterpriseCacheSessionDAO {
    @Value(value="${shiro.session.dbSyncPeriod}")
    private int dbSyncPeriod;
    private static final String LAST_SYNC_DB_TIMESTAMP = OnlineSessionDAO.class.getName() + "LAST_SYNC_DB_TIMESTAMP";
    @Autowired
    private SysShiroService sysShiroService;

    public OnlineSessionDAO() {
    }

    public OnlineSessionDAO(long expireTime) {
    }

    protected Session doReadSession(Serializable sessionId) {
        return this.sysShiroService.getSession(sessionId);
    }

    public void update(Session session) throws UnknownSessionException {
        super.update(session);
    }

    public void syncToDb(OnlineSession onlineSession) {
        Date lastSyncTimestamp = (Date)onlineSession.getAttribute(LAST_SYNC_DB_TIMESTAMP);
        if (lastSyncTimestamp != null) {
            boolean isGuest;
            boolean needSync = true;
            long deltaTime = onlineSession.getLastAccessTime().getTime() - lastSyncTimestamp.getTime();
            if (deltaTime < (long)(this.dbSyncPeriod * 60 * 1000)) {
                needSync = false;
            }
            boolean bl = isGuest = onlineSession.getUserId() == null || onlineSession.getUserId() == 0L;
            if (!isGuest && onlineSession.isAttributeChanged()) {
                needSync = true;
            }
            if (!needSync) {
                return;
            }
        }
        onlineSession.setAttribute(LAST_SYNC_DB_TIMESTAMP, onlineSession.getLastAccessTime());
        if (onlineSession.isAttributeChanged()) {
            onlineSession.resetAttributeChanged();
        }
        AsyncManager.me().execute(AsyncFactory.syncSessionToDb(onlineSession));
    }

    protected void doDelete(Session session) {
        OnlineSession onlineSession = (OnlineSession)session;
        if (null == onlineSession) {
            return;
        }
        onlineSession.setStatus(OnlineStatus.off_line);
        this.sysShiroService.deleteSession(onlineSession);
    }
}

