package com.bcxin.obpm.util;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.auth.common.constant.Constants;
import com.bcxin.auth.common.core.domain.AjaxResult;
import com.bcxin.auth.common.exception.V5BusinessException;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.obpm.dto.beijing.ProblemResult;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author linqinglin
 * @date 2021/03/09 0009 15:40
 */
@Service
public class BJProblemDetailUtil {

    private static Logger logger = LoggerFactory.getLogger(BJProblemDetailUtil.class);

    /**
     * 核查违法犯罪接口地址
     */
    private final String BEIJING_CHECK_PERSON_WFFZ_INFO_URL = "http://14.62.1.210:9006/zzxt/jk/helu/checkPersonWffzInfo";
    /**
     * 核查详情
     * 核查违法犯罪接口地址：http://14.62.1.210:9006/zzxt/jk/helu/checkPersonWffzInfo
     * 接口参数:
     * deviceid=60:EB:69:8F:82:9C
     * policesfzh=110101197002285038
     * policename=李京海
     * sfzh=被查询人的身份证号
     * 接口请求头:
     * uid=1100002200000700
     * username=baxt
     * userpwd=Bzxt*bzxt
     * 返回值:
     * {
     * "uuid": "bca0d07e-c5ad-4be6-92de-867e650474f7",
     * "msg": "ok",
     * "status": 0,
     * "results": [
     * {
     * "value": "违法犯罪(其他)",
     * "disposalWay": "",
     * "color": "yellow",
     * "resourceName": "违法犯罪",
     * "order": "2",
     * "key": "criminalType"
     * }
     * ]
     * }
     *
     * @param idNumber
     */
    public AjaxResult checkPersonInfo(String idNumber) {
        if (StringUtils.isEmpty(idNumber)) {
            return AjaxResult.error("参数不正确");
        }
        try {

            //请求参数
            Map<String, Object> paramMap = Maps.newHashMapWithExpectedSize(8);
            //mac地址 固定值
            paramMap.put(Constants.BEIJING_PARAM_DEVICE_ID, Constants.BEIJING_DEVICE_ID);
            //查询民警身份证号 固定值
            paramMap.put(Constants.BEIJING_PARAM_POLICE_IDENTITY_NUMBER, Constants.POLICESFZH);
            //查询民警姓名 固定值
            paramMap.put(Constants.BEIJING_PARAM_POLICE_NAME, Constants.POLICENAME);
            //被查询人员的身份证号
            paramMap.put(Constants.BEIJING_PARAM_BE_QUERIED_IDENTITY_NUMBER, idNumber);

            //构建请求
            HttpResponse response = HttpUtil
                    .createRequest(Method.GET, BEIJING_CHECK_PERSON_WFFZ_INFO_URL)
                    .form(paramMap)
                    //设置三十秒超时时间
                    .timeout(Constants.TIMEOUT)
                    //需携带请求头uid 固定值
                    .header(Constants.BEIJING_HEADER_UID, Constants.BEIJING_HEADER_UID_VALUE)
                    //请求头username 固定值
                    .header(Constants.BEIJING_HEADER_USERNAME, Constants.BEIJING_HEADER_USERNAME_VALUE)
                    //请求头user pwd 固定值
                    .header(Constants.BEIJING_HEADER_USER_PWD, Constants.BEIJING_HEADER_USER_PWD_VALUE)
                    .execute();
            String result = response.body();
            logger.error("身份证号:{},北京核查违法犯罪库返回数据:{}", idNumber, result);
            Map<String,Object> objectMap=new HashMap<>();
            if (StringUtil.isNotEmpty(result)) {
                result = result.replaceAll("RESOURCE_TYPE","资源类型");
                ProblemResult censorResult = JSONObject.parseObject(result, ProblemResult.class);
                if (censorResult.getResults() != null && !censorResult.getResults().isEmpty()) {
                    objectMap.put("problemDetails", JSON.toJSONString(censorResult.getResults()));
                }
            }
            return AjaxResult.success("请求成功", objectMap);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new V5BusinessException("北京核查库调用异常！！");

        }
    }
}
