package com.bcxin.obpm.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.auth.common.core.domain.AjaxResult;
import com.bcxin.auth.common.exception.V5BusinessException;
import com.bcxin.auth.common.utils.CacheUtils;
import com.bcxin.auth.common.utils.DateUtils;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.AuthLog;
import com.bcxin.obpm.dto.AuthenticationResult;
import com.bcxin.obpm.dto.BackgroundInfo;
import com.bcxin.obpm.dto.BackgroundResult;
import com.bcxin.obpm.service.BackgroundService;
import com.bcxin.obpm.util.AuthConstants;
import com.bcxin.obpm.util.FaceUtil;
import com.bcxin.obpm.util.HttpUtils;
import com.bcxin.obpm.util.RSACoder;
import com.github.pagehelper.util.StringUtil;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 南宁
 * @author linqinglin
 * @date 2021/08/19 0019 10:25
 */

@Service("backgroundService_450100")
public class NNBackgroundServiceImpl implements BackgroundService {

    private static Logger logger = LoggerFactory.getLogger(NNBackgroundServiceImpl.class);

    @Autowired
    private FaceUtil faceUtil;

    @Autowired
    private ConfigUtil configUtil;

    private static final String TOKEN_KEY = "gx_censor_token";

    private static final String url = "http://10.151.151.83:8080/dataexchangeserver/innetApiPayload";

    /**
     * 广西人口信息管理系统-常住人口信息查询服务
     *
     */
    public static final String GX_APINAME_CZ = "gxtqdsj_R-450000230000-00002892";

    public static final String GX_AUTHCODE = "YzBkNzRiOWQtMWRiOC00MjkzLTlhYjUtNzdkMDBlNDVjOTZh";


    @Override
    public AjaxResult personnelReview(String idNumber,String realName) {
        if (StringUtils.isEmpty(idNumber)) {
            return AjaxResult.error("参数不正确");
        }

        List<BackgroundInfo> backgroundInfoList = new ArrayList<>();

        this.isKeyPerson(backgroundInfoList,idNumber);

        BackgroundResult backgroundResult = new BackgroundResult();
        backgroundResult.setIdNumber(idNumber);
        backgroundResult.setCensorResult(backgroundInfoList);
        logger.info("身份证{}筛查结果:{}", idNumber, backgroundResult);
        // 请求
        return AjaxResult.success("请求成功", backgroundResult);
    }

    /**
     * 广西【重点人员】
     * <p>
     * 成功:
     * {
     *     "requestId": "a3b7d1f5-af03-44d8-9e22-1e85b9cb072d",
     *     "success": true,
     *     "code": "200",
     *     "message": "OK",
     *     "data": "05"   //重点人员类型,多种类型有逗号分隔 例如: 04,05,06
     * }
     * 失败:
     * {
     *     "code": "401",   //401表示凭证过期,需要重新调用获取新的凭证
     *     "message": "用户身份过期,请重新登录!",
     *     "requestId": "f3b8e5a8-139b-40d4-971d-f7975d131627",
     *     "success": false
     * }
     * {
     * "code": "500",   //500表示接口异常,请联系接口负责人
     * "message": "系统异常!",
     *     "requestId": "f3b8e5a8-139b-40d4-971d-f7975d131627",
     *     "success": false
     * }
     * <p>
     * 字典	报警类型名称
     * 00	正常
     * 01	涉恐人员
     * 02	涉稳人员
     * 03	在逃人员
     * 04	涉毒人员
     * 05	刑事犯罪前科人员报警
     * 06	肇事肇祸精神病人
     * 07	重点上访人员
     *
     * @param list
     * @param idnum
     */
    private void isKeyPerson(List<BackgroundInfo> list, String idnum) {
        try {
            String url = AuthConstants.GUANGXI_URL_COMPARISON + idnum;
            String token = getToken(false);
            logger.error("广西重点人比对，请求地址:{}", url);
            //构建请求
            HttpResponse response = HttpUtil
                    .createRequest(Method.POST, url)
                    //设置三十秒超时时间
                    .timeout(30000)
                    .header("Authorization", token)
                    .execute();
            String result = response.body();
            logger.error("广西重点人比对，返回结果:{}", result);

            if (StringUtil.isNotEmpty(result)) {
                JSONObject resultObj = JSON.parseObject(result);
                if (resultObj.get("code") != null) {
                    if ("200".equals(resultObj.get("code").toString())) {
                        StringBuilder content = new StringBuilder();
                        if (resultObj.get("data") != null) {
                            boolean fz = false;
                            String data = resultObj.get("data").toString();
                            if (!"00".equals(data)) {
                                String[] datas = data.split(",");
                                for (String s : datas) {
                                    if ("03".equals(s)) {
                                        fz = true;
                                        content.append("在逃人员、");
                                    } else if ("04".equals(s)) {
                                        fz = true;
                                        content.append("吸毒人员、");
                                    } else if ("05".equals(s)) {
                                        fz = true;
                                        content.append("刑事犯罪前科人员报警、");
                                    } else if ("06".equals(s)) {
                                        fz = true;
                                        content.append("肇事肇祸精神病人、");
                                    } else if ("07".equals(s)) {
                                        fz = true;
                                        content.append("重点上访人员、");
                                    } else if ("01".equals(s)) {
                                        fz = true;
                                        content.append("涉恐人员、");
                                    } else if ("02".equals(s)) {
                                        fz = true;
                                        content.append("涉稳人员、");
                                    }
                                }
                            }
                            if (fz) {
                                BackgroundInfo backgroundInfo = new BackgroundInfo();
                                List<Map<String, Object>> wffzry = new ArrayList<>();
                                Map<String, Object> wfMap = new HashMap<>();
                                wfMap.put("detail",content.substring(0, content.length() - 1));
                                backgroundInfo.setCode(200);
                                backgroundInfo.setWffzry(wffzry);
                                backgroundInfo.setResult(1);
                                backgroundInfo.setCxxt("重点人比对接口");
                                list.add(backgroundInfo);
                            }

                        }

                    } else if ("401".equals(resultObj.get("code").toString())) {
                        getToken(true);
                        isKeyPerson(list, idnum);
                    } else {
                        try {
                            throw new V5BusinessException("广西重点人比对接口异常,请联系接口负责人:" + resultObj.get("message").toString());
                        } catch (Exception e) {
                            e.printStackTrace();
                            logger.error(e.getMessage());
                            throw new V5BusinessException("广西重点人比对获取token失败");
                        }
                    }
                }

            }


        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), e);
            throw new V5BusinessException("广西【广西重点人比对】调用异常！！");
        }
    }


    /**
     * @return
     */
    private String getToken(boolean refresh) {
        Object token = CacheUtils.get(TOKEN_KEY);
        if (refresh || token == null) {
            try {
                Map<String, Object> paramMap = new HashMap<>();
                paramMap.put("username", "bcxzdr");
                paramMap.put("password", RSACoder.encrypt("bcxzdr123", AuthConstants.GUANGXI_PWD_PUBLIC_KEY));
                paramMap.put("grant_type", "password");

                logger.error("广西重点人比对获取token，请求地址:{}", AuthConstants.GUANGXI_URL_TOKEN);
                logger.error("广西重点人比对获取token，请求参数:{}", JSON.toJSONString(paramMap));
                //构建请求
                HttpResponse response = HttpUtil
                        .createRequest(Method.POST, AuthConstants.GUANGXI_URL_TOKEN)
                        .form(paramMap)
                        //设置三十秒超时时间
                        .timeout(30000)
                        .header("Content-Type", "application/x-www-form-urlencoded")
                        .header("Authorization", "Basic YWRtaW46UklmZmY3WFpYTEZDR2hHM0lOZm5KRis0NjN2WTFnd25PTHgrSWlQYUtQK0lnV0k5aUR5c0VTS0JERDJGNkVxWVZXVS9GVTA2cnNDeE1IWFgvMWJCazN4dk9TR0NtWEJ3d0dsSUNJclg4VFEvdHBmRkU5M2NjZmkrakdEQ2lLOHFWbmRhUG5TaU1yYk00cUZud25TeGF5amp6SDVrSlZkcVZ2YnJSWVZLL3NVPQ==")
                        .execute();
                String result = response.body();
                logger.error("广西重点人比对获取token，返回结果:{}", result);
                if (StringUtil.isNotEmpty(result)) {
                    JSONObject data = JSON.parseObject(result);
                    token = data.get("access_token").toString();
                    CacheUtils.put(TOKEN_KEY, token);
                } else {
                    throw new V5BusinessException("广西重点人比对获取token失败:" + result);
                }
            } catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage());
                throw new V5BusinessException("广西重点人比对获取token失败");
            }
        }
        logger.error("请求token:{}", token);
        return token.toString();
    }

    @Override
    public AjaxResult getPersonnelInformation(String idNumber) {
        if (com.bcxin.auth.common.utils.StringUtils.isEmpty(idNumber)) {
            return AjaxResult.error("参数不正确");
        }
        AuthenticationResult authenticationResult = new AuthenticationResult();
        // 设置身份证号
        try {
            Map<String, Object> paramMap = new HashMap<>();
            Map<String, Object> params = new HashMap<>();

            List<String> parafs = new ArrayList<>();
            parafs.add("NAME");//姓名
            parafs.add("PHOTO");//照片
            parafs.add("CERT_NO");//证号

            params.put("areaCode", "450100000000");
            params.put("qqdwdm", "南宁市公安局");
            params.put("qqdwmc", "450100000000");
            params.put("qqr", "450100210000");
            params.put("qqrsfzh", "450100210000");
            params.put("messageSequence", UUID.randomUUID());
            params.put("condition", " CERT_NO ='" + idNumber + "' and PERSON_STAT_NAME='有效'");
            params.put("parafs", parafs);
            params.put("maxReturnNum", "1");


            paramMap.put("authCode", GX_AUTHCODE);
            paramMap.put("apiName", GX_APINAME_CZ);
            paramMap.put("params", JSON.toJSONString(params));
            logger.error("请求参数：{}",JSON.toJSONString(paramMap));
            //获取结果
            String resultStr = HttpUtils.postWithJson(url, paramMap);
            logger.error("返回结果：{}",resultStr);

            if (com.bcxin.auth.common.utils.StringUtils.isNotEmpty(resultStr)) {
                JSONObject result = JSON.parseObject(resultStr);
                if ("0".equals(result.get("code"))) {
                    result = JSON.parseObject(result.get("result").toString());
                    if ("200".equals(result.get("status").toString())) {
                        if (result.get("data") != null) {
                            result = JSON.parseObject(result.get("data").toString());
                            String totalRows = result.get("totalRows").toString();
                            if (Long.parseLong(totalRows) > 0) {
                                JSONArray results = JSONArray.parseArray(result.get("results").toString());
                                result = (JSONObject)results.get(0);
                                authenticationResult.setRealName(result.get("NAME").toString());
                                authenticationResult.setPhoto(result.get("PHOTO").toString());
                            }
                        }
                    }
                }
            }
        }catch (Exception e){
            throw new V5BusinessException("调用公安部接口异常！！");
        }

        logger.info("{}人员信息服务返回:{}", idNumber, authenticationResult);
        return AjaxResult.success("请求成功", authenticationResult);
    }

    /**
     * 实名认证比对
     * @param list
     * @return
     */
    @Override
    public List<AuthLog> validateResult(List<AuthLog> list) {
        for (AuthLog authLog : list) {
            try {
                this.matchResult(authLog);
                if(StrUtil.isNotEmpty(authLog.getAuthStatus())) {
                    //更新时间
                    authLog.setUpdateTime(new Date());
                }
                authLog.setAuthDate(DateUtils.getNowDate());
            } catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage(), e);
            } finally {
            }
        }
        return list.stream().filter(((authLog)-> StrUtil.isNotEmpty(authLog.getAuthStatus()))).collect(Collectors.toList());
    }

    @Override
    public void getPersonnelAddress(String idNumber) {

    }

    /**
     * 实名认证比对
     * @param authLog
     * @throws IOException
     */
    public void matchResult(AuthLog authLog) throws IOException {
        logger.error("广西照片比对，开始");
        CloseableHttpClient httpClient = HttpClients.createDefault();
        ResponseHandler<String> responseHandler = new BasicResponseHandler();
        try {
            Map<String, Object> paramMap = new HashMap();
            paramMap.put("sh_name", authLog.getSecurityName());
            paramMap.put("sh_sfz", authLog.getIdNumber());
            paramMap.put("qiyebianma", "baoanbcx");
            paramMap.put("shid", "baoanbcx");

            Map<String, Object> requestParamMap = new HashMap();
            requestParamMap.put("param",paramMap);
            logger.error("广西照片比对，请求参数:{}", JSON.toJSONString(requestParamMap));
            paramMap.put("sh_zhaopian", faceUtil.ImageToBase64(authLog.getImgPath()));

            logger.error("广西照片比对，请求地址:{}", AuthConstants.GUANGXI_URL_VALIDATE);

            //第一步：创建HttpClient对象
            httpClient = HttpClients.createDefault();
            //第二步：创建httpPost对象
            HttpPost httpPost = new HttpPost(AuthConstants.GUANGXI_URL_VALIDATE);

            RequestConfig.Builder requestConfig = RequestConfig.custom();
            requestConfig.setConnectTimeout(30000);
            requestConfig.setConnectionRequestTimeout(30000);
            requestConfig.setSocketTimeout(30000);
            //第三步：给httpPost设置JSON格式的参数
            StringEntity requestEntity = new StringEntity(JSON.toJSONString(requestParamMap),"utf-8");
            requestEntity.setContentEncoding("UTF-8");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setConfig(requestConfig.build());

            httpPost.setEntity(requestEntity);

            //第四步：发送HttpPost请求，获取返回值
            String result = httpClient.execute(httpPost,responseHandler); //调接口获取返回值时，必须用此方法


            logger.error("广西照片比对，返回结果:{}", result);

            if (StrUtil.isNotEmpty(result)) {
                JSONObject resultObj = JSON.parseObject(result);
                if (resultObj.get("shjg") != null) {
                    //JSONObject resData = JSON.parseObject(resultObj.get("resData").toString());
                    String comparisonResult = resultObj.get("shjg").toString();
                    //0比对不通过，1比对通过 11是错误 （身份证号码和姓名不符） 20身份证号码不存在
                    switch (comparisonResult) {
                        case "0":
                            authLog.setAuthStatus(AuthConstants.AUTHRESULT_NO);
                            authLog.setAuthResult(AuthConstants.AUTHRESULT_NO_NOIMGMSG);
                            break;
                        case "1":
                            authLog.setAuthStatus(AuthConstants.AUTHRESULT_YES);
                            authLog.setAuthResult(AuthConstants.AUTHRESULT_YES_MESSAGE);
                            break;
                        case "11":
                            if(resultObj.get("msg") == null || resultObj.get("msg").toString().contains("姓名与证件号码不匹配")){
                                authLog.setAuthStatus(AuthConstants.AUTHRESULT_NO);
                                authLog.setAuthResult(AuthConstants.AUTHRESULT_NO_NAME_IDEMSG);
                            }else{
                                authLog.setAuthStatus(AuthConstants.AUTHRESULT_NO);
                                authLog.setAuthResult(AuthConstants.AUTHRESULT_NO_NOIMGMSG);
                            }
                            break;
                        case "20":
                            authLog.setAuthStatus(AuthConstants.AUTHRESULT_NO);
                            authLog.setAuthResult(AuthConstants.AUTHRESULT_NO_CARD_IDEMSG);
                            break;
                        default:
                            break;
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage());
            throw e;
        }finally {
            try {
                httpClient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

    }
}
