package com.bcxin.obpm.ministerial;

import com.bcxin.obpm.annotation.MinisterialAttr;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

/**
 * 保安服务公司经济类型转换
 * @author linqinglin
 * @date 2021/03/09 0009 16:51
 */
public class EconomicTypeFormatStrategy implements MinDataFormatStrategy {
    @Override
    public String format(Field columnField, Object data) {
        if(data == null){
            MinisterialAttr resource = columnField.getAnnotation(MinisterialAttr.class);
            return resource.defaultValue();
        }
        Map<String,String> scopeTypeMap = new HashMap<>();
        scopeTypeMap.put("1","11");//国有经济
        scopeTypeMap.put("2","12");//集体经济
        scopeTypeMap.put("3","17");//私营经济
        scopeTypeMap.put("4","19");//个体经济
        scopeTypeMap.put("5","14");//联营经济
        scopeTypeMap.put("6","16");//股份制
        scopeTypeMap.put("7","30");//外商投资
        scopeTypeMap.put("8","20");//港澳台投资与其他经济
        scopeTypeMap.put("9","90");//其他经济


        String result = "";

        String[] scopeTypes = data.toString().split(",");
        for (String scopeType : scopeTypes) {
            if(scopeTypeMap.get(scopeType) != null){
                result =scopeTypeMap.get(scopeType)+ " ";
            }
        }

        if(result.length() > 0){
            result = result.substring(0,result.length()-1);
        }
        return result;
    }
}
