/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.attend.impl;

import cn.hutool.core.util.StrUtil;
import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.BusinessException;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.AttendChangeShift;
import com.bcxin.platform.domain.attend.AttendSchedulDetail;
import com.bcxin.platform.mapper.attend.AttendChangeShiftMapper;
import com.bcxin.platform.mapper.attend.AttendSchedulDetailMapper;
import com.bcxin.platform.service.attend.AttendChangeShiftService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AttendChangeShiftServiceImpl
implements AttendChangeShiftService {
    @Autowired
    private AttendChangeShiftMapper attendChangeShiftMapper;
    @Autowired
    private AttendSchedulDetailMapper attendSchedulDetailMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public AttendChangeShift findById(Long id) {
        return this.attendChangeShiftMapper.findById(id);
    }

    @Override
    public List<AttendChangeShift> selectList(AttendChangeShift attendChangeShift) {
        return this.attendChangeShiftMapper.selectList(attendChangeShift);
    }

    @Override
    public int update(AttendChangeShift attendChangeShift) {
        if (attendChangeShift.getId() == null) {
            attendChangeShift.setCreateTime(DateUtils.getNowDate());
            attendChangeShift.setId(this.idWorker.nextId());
        } else {
            AttendChangeShift dbAttendChangeShift = this.attendChangeShiftMapper.findById(attendChangeShift.getId());
            BeanUtils.copyPropertiesIgnore((Object)((Object)attendChangeShift), (Object)((Object)dbAttendChangeShift), (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)((Object)dbAttendChangeShift), (Object)((Object)attendChangeShift), (Boolean)false);
        }
        String schedulDetailIds = "";
        ArrayList<AttendSchedulDetail> updateScheduls = new ArrayList<AttendSchedulDetail>();
        List<AttendSchedulDetail> schedulDetails = this.attendSchedulDetailMapper.selectListForPer(attendChangeShift.getPerId(), attendChangeShift.getSchedulDate());
        if (schedulDetails.size() == 0) {
            throw new BusinessException("\u7533\u8bf7\u4eba\u5f53\u65e5\u65e0\u6392\u73ed\uff0c\u65e0\u9700\u6362\u73ed\uff01");
        }
        for (AttendSchedulDetail schedulDetail : schedulDetails) {
            schedulDetail.setPerId(attendChangeShift.getChangePerId());
            schedulDetail.setUpdateBy(attendChangeShift.getUpdateBy());
            schedulDetail.setUpdateTime(DateUtils.getNowDate());
            schedulDetailIds = StrUtil.isEmpty((CharSequence)schedulDetailIds) ? schedulDetail.getId() + "" : schedulDetailIds + "," + schedulDetail.getId();
            updateScheduls.add(schedulDetail);
        }
        String changeSchedulDetailIds = "";
        schedulDetails = this.attendSchedulDetailMapper.selectListForPer(attendChangeShift.getPerId(), attendChangeShift.getChangeDate());
        List<AttendSchedulDetail> changeSchedulDetails = this.attendSchedulDetailMapper.selectListForPer(attendChangeShift.getChangePerId(), attendChangeShift.getChangeDate());
        if (schedulDetails.size() > 0 && changeSchedulDetails.size() > 0) {
            for (AttendSchedulDetail schedulDetail : schedulDetails) {
                if ("0".equals(schedulDetail.getSchedulType())) continue;
                Date startTime = DateUtils.parseDate((Object)schedulDetail.getStartTime());
                Date endTime = DateUtils.parseDate((Object)schedulDetail.getEndTime());
                for (AttendSchedulDetail changeSchedulDetail : changeSchedulDetails) {
                    if ("0".equals(changeSchedulDetail.getSchedulType())) continue;
                    Date changeStartTime = DateUtils.parseDate((Object)changeSchedulDetail.getStartTime());
                    Date changeEndTime = DateUtils.parseDate((Object)changeSchedulDetail.getEndTime());
                    if (startTime.getTime() > changeStartTime.getTime() && startTime.getTime() < changeEndTime.getTime()) {
                        throw new BusinessException("\u65f6\u95f4\u51b2\u7a81");
                    }
                    if (endTime.getTime() > changeStartTime.getTime() && endTime.getTime() < changeEndTime.getTime()) {
                        throw new BusinessException("\u65f6\u95f4\u51b2\u7a81");
                    }
                    if (changeStartTime.getTime() > startTime.getTime() && changeStartTime.getTime() < endTime.getTime()) {
                        throw new BusinessException("\u65f6\u95f4\u51b2\u7a81");
                    }
                    if (changeEndTime.getTime() <= startTime.getTime() || changeEndTime.getTime() >= endTime.getTime()) continue;
                    throw new BusinessException("\u65f6\u95f4\u51b2\u7a81");
                }
            }
        }
        for (AttendSchedulDetail schedulDetail : changeSchedulDetails) {
            schedulDetail.setPerId(attendChangeShift.getPerId());
            schedulDetail.setUpdateBy(attendChangeShift.getUpdateBy());
            schedulDetail.setUpdateTime(DateUtils.getNowDate());
            changeSchedulDetailIds = StrUtil.isEmpty((CharSequence)changeSchedulDetailIds) ? schedulDetail.getId() + "" : changeSchedulDetailIds + "," + schedulDetail.getId();
            updateScheduls.add(schedulDetail);
        }
        this.attendSchedulDetailMapper.saveBatch(updateScheduls);
        attendChangeShift.setSchedulDetailIds(schedulDetailIds);
        attendChangeShift.setChangeSchedulDetailIds(changeSchedulDetailIds);
        attendChangeShift.setIsDelete("0");
        attendChangeShift.setUpdateTime(DateUtils.getNowDate());
        return this.attendChangeShiftMapper.save(attendChangeShift);
    }

    @Override
    public int deleteByIds(String ids) {
        return this.attendChangeShiftMapper.deleteByIds(Convert.toStrArray((String)ids));
    }

    @Override
    public int deleteById(Long id) {
        return this.attendChangeShiftMapper.deleteById(id);
    }
}

