ALTER TABLE `tb_attend_schedul`
  ADD COLUMN `weeks` varchar(255) NULL COMMENT '星期' AFTER `perIds`;


CREATE TABLE `tb_attend_schedul_conflict` (
                                            `id` bigint(20) NOT NULL COMMENT '排班冲突ID',
                                            `schedulId` bigint(20) NOT NULL COMMENT '排班ID',
                                            `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
                                            `createTime` datetime DEFAULT NULL COMMENT '创建时间',
                                            `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
                                            `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
                                            `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
                                            `needCalendar` char(1) DEFAULT '1' COMMENT '是否使用休息日套 1是0否',
                                            `calendarId` bigint(20) DEFAULT NULL COMMENT '日历套ID',
                                            `shiftId` bigint(20) DEFAULT NULL COMMENT '班次ID',
                                            `perId` bigint(20) DEFAULT NULL COMMENT '人员ID',
                                            `deptId` bigint(20) DEFAULT NULL COMMENT '部门ID',
                                            `attendId` bigint(20) DEFAULT NULL COMMENT '考勤套ID',
                                            `schedulDate` varchar(20) DEFAULT NULL COMMENT '上班日期',
                                            `startTime` varchar(20) DEFAULT NULL COMMENT '上班时间',
                                            `endTime` varchar(20) DEFAULT NULL COMMENT '下班时间',
                                            `needRest` char(1) DEFAULT '1' COMMENT '是否休息 1是0否',
                                            `restStart` varchar(20) DEFAULT NULL COMMENT '休息开始时间',
                                            `restEnd` varchar(20) DEFAULT NULL COMMENT '休息结束时间',
                                            `schedulType` char(2) DEFAULT NULL COMMENT '类型 0休息 1上班',
                                            `conflictState` char(2) DEFAULT NULL COMMENT '冲突状态 0待覆盖1已覆盖',
                                            PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤排班冲突';

CREATE TABLE `tb_attend_schedul_conflict_detail` (
                                                   `id` bigint(20) NOT NULL COMMENT '排班冲突关联关系ID',
                                                   `conflictId` bigint(20) NOT NULL COMMENT '冲突ID',
                                                   `schedulDetailId` bigint(20) NOT NULL COMMENT '排班ID',
                                                   `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
                                                   `createTime` datetime DEFAULT NULL COMMENT '创建时间',
                                                   `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
                                                   `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
                                                   `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
                                                   PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤排班冲突关联关系';


CREATE TABLE `tb_attend_address` (
  `id` bigint(20) NOT NULL COMMENT '考勤地点ID',
  `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
  `createTime` datetime DEFAULT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `longitude` double DEFAULT NULL COMMENT '定位经度',
  `latitude` double DEFAULT NULL COMMENT '定位纬度',
  `address` varchar(500) DEFAULT NULL COMMENT '定位地址',
  `validRange` int(8) DEFAULT NULL COMMENT '定位有效范围',
  `attendId` bigint(20) DEFAULT NULL COMMENT '考勤套ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤地点定位';

CREATE TABLE `tb_attend_wifi` (
  `id` bigint(20) NOT NULL COMMENT '考勤wifi ID',
  `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
  `createTime` datetime DEFAULT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `wifiName` varchar(200) DEFAULT NULL COMMENT 'wifi名称',
  `wifiMac` varchar(50) DEFAULT NULL COMMENT 'wifi设备mac地址',
  `attendId` bigint(20) DEFAULT NULL COMMENT '考勤套ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤wifi';


INSERT INTO `tb_attend_address` (`id`, `isDelete`, `createTime`, `createBy`, `updateTime`, `updateBy`, `longitude`, `latitude`, `address`, `validRange`, `attendId`)
select `id`, `isDelete`, `createTime`, `createBy`, `updateTime`, `updateBy`, `longitude`, `latitude`, `address`, `validRange`, `id` from tb_attend where position='1';


INSERT INTO `tb_attend_wifi` (`id`, `isDelete`, `createTime`, `createBy`, `updateTime`, `updateBy`, `wifiName`, `wifiMac`, `attendId`)
select `id`, `isDelete`, `createTime`, `createBy`, `updateTime`, `updateBy`, `wifiName`, `wifiMac`, `id` from tb_attend where wifi = '1';

ALTER TABLE `tb_attend`
DROP COLUMN `position`,
DROP COLUMN `longitude`,
DROP COLUMN `latitude`,
DROP COLUMN `address`,
DROP COLUMN `validRange`,
DROP COLUMN `wifi`,
DROP COLUMN `wifiName`,
DROP COLUMN `wifiMac`;


