package com.bcxin.platform.common.utils.validator;



import javax.validation.Constraint;
import javax.validation.Payload;
import javax.validation.ReportAsSingleViolation;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;


/**
 * 日期格式验证,可以在{@code format}中添加有效的日期格式
 * @author Canaan
 * @date 2017年3月8日
 */
@Documented
@Constraint(validatedBy = { DateValueValidator.class })
@Target({ METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER })
@Retention(RUNTIME)
@ReportAsSingleViolation
public @interface DateValue {

    String message() default "日期格式不正确";

    Class<?>[] groups() default { };

    Class<? extends Payload>[] payload() default { };

    /**
     * 有效的日期格式
     */
    String[] format() default {};

    /**
     * Defines several {@link DateValue} annotations on the same element.
     *
     */
    @Target({ METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER })
    @Retention(RUNTIME)
    @Documented
    @interface List {
        DateValue[] value();
    }

}
