/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.common.utils.validator;

import com.bcxin.platform.common.utils.validator.DateValue;
import java.text.SimpleDateFormat;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class DateValueValidator
implements ConstraintValidator<DateValue, String> {
    private String[] formats;

    public void initialize(DateValue constraintAnnotation) {
        this.formats = constraintAnnotation.format();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null || "".equals(value.trim())) {
            return true;
        }
        if (this.formats.length == 0) {
            return true;
        }
        for (String string : this.formats) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat(string);
                formatter.parse(value);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }
}

