/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.common.utils.bean;

import com.bcxin.platform.common.exception.PlatFormBusinessException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.BeanWrapperImpl;

public class BeanUtils
extends org.springframework.beans.BeanUtils {
    private static final int BEAN_METHOD_PROP_INDEX = 3;
    private static final Pattern GET_PATTERN = Pattern.compile("get(\\p{javaUpperCase}\\w*)");
    private static final Pattern SET_PATTERN = Pattern.compile("set(\\p{javaUpperCase}\\w*)");

    public static void copyBeanProp(Object dest, Object src) {
        try {
            BeanUtils.copyProperties((Object)src, (Object)dest);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<Method> getSetterMethods(Object obj) {
        Method[] methods;
        ArrayList<Method> setterMethods = new ArrayList<Method>();
        for (Method method : methods = obj.getClass().getMethods()) {
            Matcher m = SET_PATTERN.matcher(method.getName());
            if (!m.matches() || method.getParameterTypes().length != 1) continue;
            setterMethods.add(method);
        }
        return setterMethods;
    }

    public static List<Method> getGetterMethods(Object obj) {
        Method[] methods;
        ArrayList<Method> getterMethods = new ArrayList<Method>();
        for (Method method : methods = obj.getClass().getMethods()) {
            Matcher m = GET_PATTERN.matcher(method.getName());
            if (!m.matches() || method.getParameterTypes().length != 0) continue;
            getterMethods.add(method);
        }
        return getterMethods;
    }

    public static boolean isMethodPropEquals(String m1, String m2) {
        return m1.substring(3).equals(m2.substring(3));
    }

    public static void copyPropertiesIgnore(Object src, Object target, Boolean ignoreNull) {
        Object ignoreObject = src;
        if (!ignoreNull.booleanValue()) {
            ignoreObject = target;
        }
        org.springframework.beans.BeanUtils.copyProperties((Object)src, (Object)target, (String[])BeanUtils.getPropertyNames(ignoreObject, src, ignoreNull, new String[0]));
    }

    public static String[] getPropertyNames(Object source, Object validateExist, Boolean needNull, String[] needCopyArr) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        BeanWrapperImpl validate = new BeanWrapperImpl(validateExist);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        PropertyDescriptor[] pdValidate = validate.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        HashSet<String> notEmptyNames = new HashSet<String>();
        HashSet<String> ignorePropertiesNames = new HashSet<String>();
        int length = needCopyArr.length;
        if (length > 0) {
            int pdLength = length;
            int validateLength = length;
            block0: for (String needCopyStr : needCopyArr) {
                PropertyDescriptor pd;
                int n;
                PropertyDescriptor[] propertyDescriptorArray = pdValidate;
                int n2 = propertyDescriptorArray.length;
                for (n = 0; n < n2; ++n) {
                    pd = propertyDescriptorArray[n];
                    if (!needCopyStr.equals(pd.getName())) continue;
                    --validateLength;
                    break;
                }
                if (needNull.booleanValue()) continue;
                propertyDescriptorArray = pds;
                n2 = propertyDescriptorArray.length;
                for (n = 0; n < n2; ++n) {
                    pd = propertyDescriptorArray[n];
                    if (!needCopyStr.equals(pd.getName())) continue;
                    --pdLength;
                    continue block0;
                }
            }
            if (!needNull.booleanValue() && pdLength > 0) {
                throw new PlatFormBusinessException("\u76ee\u6807\u7684\u5bf9\u8c61\u6709\u4e0d\u5b58\u5728\u7684\u5c5e\u6027\uff0c\u8bf7\u6821\u9a8c\u540d\u79f0\u662f\u5426\u5199\u9519\uff01");
            }
            if (validateLength > 0) {
                throw new PlatFormBusinessException("\u590d\u5236\u7684\u5bf9\u8c61\u6709\u4e0d\u5b58\u5728\u7684\u5c5e\u6027\uff0c\u8bf7\u6821\u9a8c\u540d\u79f0\u662f\u5426\u5199\u9519\uff01");
            }
        }
        for (PropertyDescriptor pd : pds) {
            if (length <= 0) {
                Object srcValue = src.getPropertyValue(pd.getName());
                if (srcValue == null || "".equals(srcValue)) {
                    emptyNames.add(pd.getName());
                    continue;
                }
                notEmptyNames.add(pd.getName());
                continue;
            }
            boolean flag = false;
            for (String needCopyStr : needCopyArr) {
                if (!needCopyStr.equals(pd.getName())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            ignorePropertiesNames.add(pd.getName());
        }
        String[] resultEmpty = new String[emptyNames.size()];
        String[] resultNotEmpty = new String[notEmptyNames.size()];
        String[] resultIgnoreProperties = new String[ignorePropertiesNames.size()];
        if (length <= 0) {
            if (needNull.booleanValue()) {
                return emptyNames.toArray(resultEmpty);
            }
            return notEmptyNames.toArray(resultNotEmpty);
        }
        if (needNull.booleanValue()) {
            return needCopyArr;
        }
        return ignorePropertiesNames.toArray(resultIgnoreProperties);
    }
}

