/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.common.utils;

import com.bcxin.platform.common.utils.spring.SpringUtils;
import java.util.Iterator;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.ehcache.EhCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheUtils {
    private static Logger logger = LoggerFactory.getLogger(CacheUtils.class);
    private static CacheManager cacheManager = SpringUtils.getBean(CacheManager.class);
    private static final String SYS_CACHE = "sys-cache";

    public static Object get(String key) {
        return CacheUtils.get(SYS_CACHE, key);
    }

    public static Object get(String key, Object defaultValue) {
        Object value = CacheUtils.get(key);
        return value != null ? value : defaultValue;
    }

    public static void put(String key, Object value) {
        CacheUtils.put(SYS_CACHE, key, value);
    }

    public static void remove(String key) {
        CacheUtils.remove(SYS_CACHE, key);
    }

    public static Object get(String cacheName, String key) {
        return CacheUtils.getCache(cacheName).get((Object)CacheUtils.getKey(key));
    }

    public static Object get(String cacheName, String key, Object defaultValue) {
        Object value = CacheUtils.get(cacheName, CacheUtils.getKey(key));
        return value != null ? value : defaultValue;
    }

    public static void put(String cacheName, String key, Object value) {
        CacheUtils.getCache(cacheName).put((Object)CacheUtils.getKey(key), value);
    }

    public static void remove(String cacheName, String key) {
        CacheUtils.getCache(cacheName).remove((Object)CacheUtils.getKey(key));
    }

    public static void removeAll(String cacheName) {
        Cache<String, Object> cache = CacheUtils.getCache(cacheName);
        Set keys = cache.keys();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            cache.remove(it.next());
        }
        logger.info("\u6e05\u7406\u7f13\u5b58\uff1a {} => {}", (Object)cacheName, (Object)keys);
    }

    public static void removeByKeys(Set<String> keys) {
        CacheUtils.removeByKeys(SYS_CACHE, keys);
    }

    public static void removeByKeys(String cacheName, Set<String> keys) {
        Iterator<String> it = keys.iterator();
        while (it.hasNext()) {
            CacheUtils.remove(it.next());
        }
        logger.info("\u6e05\u7406\u7f13\u5b58\uff1a {} => {}", (Object)cacheName, keys);
    }

    private static String getKey(String key) {
        return key;
    }

    public static Cache<String, Object> getCache(String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            throw new RuntimeException("\u5f53\u524d\u7cfb\u7edf\u4e2d\u6ca1\u6709\u5b9a\u4e49\u201c" + cacheName + "\u201d\u8fd9\u4e2a\u7f13\u5b58\u3002");
        }
        return cache;
    }

    public static String[] getCacheNames() {
        return ((EhCacheManager)cacheManager).getCacheManager().getCacheNames();
    }
}

