/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.common.utils.operator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public abstract class Operator {
    private char operator;
    private int priority;
    private static Map<Character, Operator> operators = new HashMap<Character, Operator>();
    public static final Operator ADITION = new Operator('+', 100){

        @Override
        public BigDecimal eval(BigDecimal left, BigDecimal right) {
            return left.add(right);
        }
    };
    public static final Operator SUBTRATION = new Operator('-', 100){

        @Override
        public BigDecimal eval(BigDecimal left, BigDecimal right) {
            return left.subtract(right);
        }
    };
    public static final Operator MULTIPLICATION = new Operator('*', 200){

        @Override
        public BigDecimal eval(BigDecimal left, BigDecimal right) {
            return left.multiply(right);
        }
    };
    public static final Operator DIVITION = new Operator('/', 200){

        @Override
        public BigDecimal eval(BigDecimal left, BigDecimal right) {
            return left.divide(right, 2, 4);
        }
    };
    public static final Operator EXPONENT = new Operator('^', 300){

        @Override
        public BigDecimal eval(BigDecimal left, BigDecimal right) {
            return left.pow(right.intValue());
        }
    };

    private Operator(char operator, int priority) {
        this.setOperator(operator);
        this.setPriority(priority);
        this.register(this);
    }

    private void register(Operator operator) {
        operators.put(Character.valueOf(operator.getOperator()), operator);
    }

    public char getOperator() {
        return this.operator;
    }

    private void setOperator(char operator) {
        this.operator = operator;
    }

    public int getPriority() {
        return this.priority;
    }

    private void setPriority(int priority) {
        this.priority = priority;
    }

    public static int getPrority(char c) {
        Operator op = operators.get(Character.valueOf(c));
        return op != null ? op.getPriority() : 0;
    }

    public static boolean isOperator(char c) {
        return Operator.getInstance(c) != null;
    }

    public static boolean isOperator(String str) {
        return str.length() > 1 ? false : Operator.isOperator(str.charAt(0));
    }

    public static Operator getInstance(char c) {
        return operators.get(Character.valueOf(c));
    }

    public static Operator getInstance(String str) {
        return str.length() > 1 ? null : Operator.getInstance(str.charAt(0));
    }

    public abstract BigDecimal eval(BigDecimal var1, BigDecimal var2);
}

