/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.common.utils.operator;

import com.bcxin.platform.common.exception.PlatFormBusinessException;
import com.bcxin.platform.common.utils.operator.Operator;
import java.math.BigDecimal;
import java.util.Stack;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class Calculator {
    private static Log logger = LogFactory.getLog(Calculator.class);
    public static final char LEFT_BRACKET = '(';
    public static final char RIGHT_BRACKET = ')';
    public static final char BLANK = ' ';
    public static final char DECIMAL_POINT = '.';
    public static final char NEGATIVE_SIGN = '-';
    public static final char POSITIVE_SIGN = '+';
    public static final char SEPARATOR = ' ';

    public BigDecimal eval(String expression) {
        String str = this.infix2Suffix(expression);
        logger.debug("Infix Expression: " + expression);
        logger.debug("Suffix Expression: " + str);
        if (str == null) {
            throw new IllegalArgumentException("Infix Expression is null!");
        }
        return this.evalInfix(str);
    }

    private BigDecimal evalInfix(String expression) {
        String[] strs = expression.split("\\s+");
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < strs.length; ++i) {
            if (!Operator.isOperator(strs[i])) {
                stack.push(strs[i]);
                continue;
            }
            Operator op = Operator.getInstance(strs[i]);
            BigDecimal right = new BigDecimal((String)stack.pop());
            BigDecimal left = new BigDecimal((String)stack.pop());
            BigDecimal result = op.eval(left, right);
            stack.push(String.valueOf(result));
        }
        return new BigDecimal((String)stack.pop());
    }

    public String infix2Suffix(String expression) {
        if (expression == null) {
            return null;
        }
        Stack<Character> stack = new Stack<Character>();
        char[] chs = expression.toCharArray();
        StringBuilder sb = new StringBuilder(chs.length);
        boolean appendSeparator = false;
        boolean sign = true;
        for (int i = 0; i < chs.length; ++i) {
            char c = chs[i];
            if (c == ' ') continue;
            if (appendSeparator) {
                sb.append(' ');
                appendSeparator = false;
            }
            if (this.isSign(c) && sign) {
                sb.append(c);
                continue;
            }
            if (this.isNumber(c)) {
                sign = false;
                sb.append(c);
                continue;
            }
            if (this.isLeftBracket(c)) {
                stack.push(Character.valueOf(c));
                continue;
            }
            if (this.isRightBracket(c)) {
                sign = false;
                while (((Character)stack.peek()).charValue() != '(') {
                    sb.append(' ').append(stack.pop());
                }
                stack.pop();
                continue;
            }
            appendSeparator = true;
            if (Operator.isOperator(c)) {
                sign = true;
                if (stack.isEmpty() || ((Character)stack.peek()).charValue() == '(') {
                    stack.push(Character.valueOf(c));
                    continue;
                }
                int precedence = Operator.getPrority(c);
                while (!stack.isEmpty() && Operator.getPrority(((Character)stack.peek()).charValue()) >= precedence) {
                    sb.append(' ').append(stack.pop());
                }
                stack.push(Character.valueOf(c));
                continue;
            }
            throw new PlatFormBusinessException("\u8ba1\u7b97\u516c\u5f0f\u6821\u9a8c\u5931\u8d25");
        }
        while (!stack.isEmpty()) {
            sb.append(' ').append(stack.pop());
        }
        return sb.toString();
    }

    private boolean isSign(char c) {
        return c == '-' || c == '+';
    }

    private boolean isNumber(char c) {
        return c >= '0' && c <= '9' || c == '.';
    }

    private boolean isLeftBracket(char c) {
        return c == '(';
    }

    private boolean isRightBracket(char c) {
        return c == ')';
    }
}

