/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.util.huawei;

import com.bcxin.platform.util.huawei.RestRequest;
import com.bcxin.platform.util.huawei.RestResponse;
import com.github.pagehelper.util.StringUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final HttpUtil httpUtil = new HttpUtil();
    private static CloseableHttpClient httpClient;
    private static PoolingHttpClientConnectionManager connectionManager;
    private static HttpParams params;
    private static final int MAX_CONNECTION = 15000;
    private static final int MAX_SOCKET_CONNECTION = 15000;
    private static final long MAX_MANAGER_CONNECTION = 15000L;
    private static final String CONTENT_TYPE_TEXT_JSON = "text/json";
    private static final String APPLICATION_JSON = "application/json";

    private HttpUtil() {
    }

    /*
     * Exception decompiling
     */
    public static RestResponse post(String url, String json, String token) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String postGetToken(String url, String json) {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httppost = new HttpPost(url);
            httppost.addHeader("Content-Type", APPLICATION_JSON);
            if (StringUtil.isNotEmpty((String)json)) {
                StringEntity se = new StringEntity(json, StandardCharsets.UTF_8);
                se.setContentType(CONTENT_TYPE_TEXT_JSON);
                se.setContentEncoding((Header)new BasicHeader("Content-Type", APPLICATION_JSON));
                httppost.setEntity((HttpEntity)se);
            }
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                int code = response.getStatusLine().getStatusCode();
                if (code != 201) return "";
                Header[] contentTypeHeader = response.getHeaders("X-Subject-Token");
                if (contentTypeHeader == null) return "";
                if (contentTypeHeader.length <= 0) return "";
                String string = contentTypeHeader[0].getValue();
                return string;
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public static HttpUtil getInstance() {
        return httpUtil;
    }

    public RestResponse sendMessage(HttpHost target, String resourceUri, RestRequest message) throws ClientProtocolException, URISyntaxException, IOException {
        if (null == target) {
            throw new NullPointerException("HttpHost target can not be null.");
        }
        RestResponse restResponse = new RestResponse();
        HttpRequestBase request = this.buildRequestMessage(message, resourceUri);
        request.setParams(params);
        HttpContext basicHttpContext = null;
        CloseableHttpResponse response = null;
        try {
            log.debug(Thread.currentThread().getName() + " before execute " + System.currentTimeMillis());
            response = httpClient.execute(target, (HttpRequest)request, basicHttpContext);
            log.debug(Thread.currentThread().getName() + " after execute " + System.currentTimeMillis());
            if (response != null) {
                Header[] headers;
                restResponse.setHttpCode(response.getStatusLine().getStatusCode());
                HttpEntity entity = response.getEntity();
                if (null != entity) {
                    ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
                    Charset charset = contentType.getCharset();
                    String body = EntityUtils.toString((HttpEntity)entity, (Charset)(charset == null ? Charset.forName("utf-8") : charset));
                    restResponse.setEntity(body);
                }
                if (null != (headers = response.getAllHeaders())) {
                    Map<String, List<String>> headerMap = restResponse.getHeaders();
                    for (Header header : headers) {
                        if (headerMap.containsKey(header.getName())) {
                            headerMap.get(header.getName()).add(header.getValue());
                            continue;
                        }
                        ArrayList<String> headerVals = new ArrayList<String>();
                        headerVals.add(header.getValue());
                        headerMap.put(header.getName(), headerVals);
                    }
                }
                log.debug(Thread.currentThread().getName() + " out execute " + System.currentTimeMillis());
                return restResponse;
            }
            return null;
        }
        catch (RuntimeException e) {
            log.error("httpclient error:" + e.getMessage());
        }
        catch (Exception e) {
            log.error("httpclient error:" + e.getMessage());
        }
        return null;
    }

    private HttpRequestBase buildRequestMessage(RestRequest message, String resourceUri) throws URISyntaxException, UnsupportedEncodingException {
        HttpGet request;
        if ("GET".equalsIgnoreCase(message.getHttpMethod())) {
            HttpGet httpGet = new HttpGet(resourceUri);
            this.setParameters((HttpRequestBase)httpGet, message.getParameters());
            request = httpGet;
        } else if ("POST".equalsIgnoreCase(message.getHttpMethod())) {
            HttpPost httpPost = new HttpPost(resourceUri);
            this.setParameters((HttpRequestBase)httpPost, message.getParameters());
            if (null == message.getEntity()) {
                message.setEntity("");
            }
            httpPost.setEntity((HttpEntity)new StringEntity(message.getEntity(), "UTF-8"));
            request = httpPost;
        } else if ("PUT".equalsIgnoreCase(message.getHttpMethod())) {
            HttpPut httpPut = new HttpPut(resourceUri);
            if (null == message.getEntity()) {
                message.setEntity("");
            }
            httpPut.setEntity((HttpEntity)new StringEntity(message.getEntity(), "UTF-8"));
            request = httpPut;
        } else if ("DELETE".equalsIgnoreCase(message.getHttpMethod())) {
            HttpDelete httpDelete = new HttpDelete(resourceUri);
            this.setParameters((HttpRequestBase)httpDelete, message.getParameters());
            request = httpDelete;
        } else {
            String msg = message.getHttpMethod() + " is not a valid HTTP method";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        this.setHttpHeaders((HttpRequestBase)request, message.getHttpHeaders());
        return request;
    }

    private void setParameters(HttpRequestBase httpRequest, Map<String, String> parameters) throws URISyntaxException {
        if (null != parameters && !parameters.isEmpty()) {
            URIBuilder uriBuilder = new URIBuilder(httpRequest.getURI());
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                uriBuilder.addParameter(entry.getKey(), entry.getValue());
            }
            httpRequest.setURI(uriBuilder.build());
        }
    }

    private void setHttpHeaders(HttpRequestBase request, Map<String, String> httpHeaders) {
        if (null != httpHeaders) {
            for (Map.Entry<String, String> entry : httpHeaders.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    static {
        params = new BasicHttpParams();
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            };
            sslContext.init(null, new TrustManager[]{tm}, null);
            sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error("SSL connect error");
        }
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
        connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connectionManager.setMaxTotal(2000);
        connectionManager.setDefaultMaxPerRoute(connectionManager.getMaxTotal());
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        params.setIntParameter("http.connection.timeout", 15000);
        params.setIntParameter("http.socket.timeout", 15000);
        params.setLongParameter("http.conn-manager.timeout", 15000L);
    }
}

