/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.attend.impl;

import cn.hutool.core.util.StrUtil;
import com.bcxin.oaflow.domain.MakeUpCard;
import com.bcxin.oaflow.domain.OaBusinessBaseEntity;
import com.bcxin.oaflow.dto.OaBusinessDto;
import com.bcxin.oaflow.mapper.BusinessTravelMapper;
import com.bcxin.oaflow.mapper.LeaveApplicationMapper;
import com.bcxin.oaflow.mapper.MakeUpCardMapper;
import com.bcxin.oaflow.mapper.PublicReleaseMapper;
import com.bcxin.oaflow.mapper.WorkOvertimeMapper;
import com.bcxin.platform.common.exception.BusinessException;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.Attend;
import com.bcxin.platform.domain.attend.AttendLeave;
import com.bcxin.platform.domain.attend.AttendReport;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.dto.app.AppAttendReportDto;
import com.bcxin.platform.dto.app.AppAttendSchedulClockDto;
import com.bcxin.platform.dto.app.AppAttendSearchDto;
import com.bcxin.platform.dto.attend.AttendClockDto;
import com.bcxin.platform.dto.attend.AttendReportDto;
import com.bcxin.platform.mapper.attend.AttendClockMapper;
import com.bcxin.platform.mapper.attend.AttendLeaveMapper;
import com.bcxin.platform.mapper.attend.AttendMapper;
import com.bcxin.platform.mapper.attend.AttendReportMapper;
import com.bcxin.platform.mapper.company.PerBaseInfoMapper;
import com.bcxin.platform.service.attend.AttendReportService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class AttendReportServiceImpl
implements AttendReportService {
    @Autowired
    private AttendReportMapper attendReportMapper;
    @Autowired
    private AttendClockMapper attendClockMapper;
    @Autowired
    private AttendLeaveMapper attendLeaveMapper;
    @Autowired
    private AttendMapper attendMapper;
    @Autowired
    private BusinessTravelMapper businessTravelMapper;
    @Autowired
    private LeaveApplicationMapper leaveApplicationMapper;
    @Autowired
    private PublicReleaseMapper publicReleaseMapper;
    @Autowired
    private WorkOvertimeMapper workOvertimeMapper;
    @Autowired
    private MakeUpCardMapper makeUpCardMapper;
    @Autowired
    private PerBaseInfoMapper perBaseInfoMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public AttendReportDto findById(Long id) {
        AttendReportDto reportDto = this.attendReportMapper.findDetail(id);
        AttendClockDto attendClock = new AttendClockDto();
        attendClock.setSchedulDate(reportDto.getReportDate());
        attendClock.setPerId(reportDto.getPerId());
        List<AttendClockDto> clockList = this.attendClockMapper.selectList(attendClock);
        reportDto.setClockList(clockList);
        return reportDto;
    }

    @Override
    public List<AttendReportDto> selectList(AttendReportDto searchDto) {
        if (!(searchDto.isDomainAdmin() || searchDto.getAdminDepartIds() != null && searchDto.getAdminDepartIds().size() != 0)) {
            return new ArrayList<AttendReportDto>();
        }
        return this.attendReportMapper.selectList(searchDto);
    }

    @Override
    public int update(AttendReport attendReport) {
        if (attendReport.getId() == null) {
            attendReport.setCreateTime(DateUtils.getNowDate());
            attendReport.setId(this.idWorker.nextId());
        } else {
            AttendReport dbAttendReport = this.attendReportMapper.findById(attendReport.getId());
            BeanUtils.copyPropertiesIgnore((Object)((Object)attendReport), (Object)((Object)dbAttendReport), (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)((Object)dbAttendReport), (Object)((Object)attendReport), (Boolean)false);
        }
        attendReport.setUpdateTime(DateUtils.getNowDate());
        return this.attendReportMapper.save(attendReport);
    }

    @Override
    public AttendReportDto findDetail(Long id) {
        AttendReportDto reportDto = this.attendReportMapper.findDetail(id);
        AttendClockDto attendClock = new AttendClockDto();
        attendClock.setSchedulDate(reportDto.getReportDate());
        attendClock.setPerId(reportDto.getPerId());
        attendClock.setDomainAdmin(true);
        List<AttendClockDto> clockList = this.attendClockMapper.selectList(attendClock);
        reportDto.setClockList(clockList);
        AttendLeave attendLeave = new AttendLeave();
        attendLeave.setPerId(reportDto.getPerId());
        attendLeave.setLeaveDate(reportDto.getReportDate());
        List<AttendLeave> leaveList = this.attendLeaveMapper.selectListGroupDate(attendLeave);
        reportDto.setLeaveList(leaveList);
        return reportDto;
    }

    @Override
    public AppAttendReportDto findMonthStatistics(AppAttendSearchDto searchDto) {
        Attend attend = this.attendMapper.findByPerId(searchDto.getPerId());
        if (attend == null) {
            throw new BusinessException("\u65e0\u76f8\u5173\u8003\u52e4\u5957");
        }
        AppAttendReportDto reportDto = this.attendReportMapper.findMonthStatistics(searchDto);
        if (reportDto == null) {
            reportDto = this.attendReportMapper.findMonthReport(searchDto);
        }
        ArrayList<AppAttendReportDto> dayReportList = new ArrayList();
        Map<Object, Object> perMap = new HashMap();
        List<AppAttendSchedulClockDto> schedulClockList = this.attendClockMapper.selectListForApp(searchDto);
        if (reportDto == null) {
            if (schedulClockList.size() == 0) {
                throw new BusinessException("\u65e0\u76f8\u5173\u7edf\u8ba1\u4fe1\u606f");
            }
            reportDto = new AppAttendReportDto();
            reportDto.setReportDate(DateUtils.dateTimeNow((String)DateUtils.YYYY_MM));
            PerBaseInfo perBaseInfo = this.perBaseInfoMapper.selectPerBaseInfoById(searchDto.getPerId());
            reportDto.setTlkPerId(perBaseInfo.getTlkPerId());
        }
        List<MakeUpCard> cardList = this.makeUpCardMapper.selectList(Arrays.asList(reportDto.getTlkPerId().split(",")), reportDto.getReportDate());
        Map<Date, List<MakeUpCard>> cardsMap = cardList.stream().collect(Collectors.groupingBy(OaBusinessBaseEntity::getStartTime));
        block0: for (Object schedulClockDto : schedulClockList) {
            if ((StrUtil.isEmpty((CharSequence)schedulClockDto.getClockStart()) || schedulClockDto.getLateMin() != null && schedulClockDto.getLateMin() > 0) && cardsMap.get(DateUtils.parseDate((Object)schedulClockDto.getStartTime())) != null) {
                List<MakeUpCard> list = cardsMap.get(DateUtils.parseDate((Object)schedulClockDto.getStartTime()));
                for (MakeUpCard subCard : list) {
                    if (!"1".equals(subCard.getCardType())) continue;
                    schedulClockDto.setStartStatus("6");
                    if (!"\u5ba1\u6279\u901a\u8fc7".equals(subCard.getState())) break;
                    schedulClockDto.setStartStatus("61");
                    break;
                }
            }
            if ("2".equals(schedulClockDto.getShiftType()) || !StrUtil.isEmpty((CharSequence)schedulClockDto.getClockEnd()) && (schedulClockDto.getLeaveEarly() == null || schedulClockDto.getLeaveEarly() <= 0) || cardsMap.get(DateUtils.parseDate((Object)schedulClockDto.getEndTime())) == null) continue;
            List<MakeUpCard> list = cardsMap.get(DateUtils.parseDate((Object)schedulClockDto.getEndTime()));
            for (MakeUpCard subCard : list) {
                if (!"2".equals(subCard.getCardType())) continue;
                schedulClockDto.setEndStatus("6");
                if (!"\u5ba1\u6279\u901a\u8fc7".equals(subCard.getState())) continue block0;
                schedulClockDto.setEndStatus("61");
                continue block0;
            }
        }
        Map<String, List<AppAttendSchedulClockDto>> schedulClockMap = schedulClockList.stream().collect(Collectors.groupingBy(AppAttendSchedulClockDto::getSchedulDate));
        if (reportDto != null) {
            dayReportList = this.attendReportMapper.findDayStatistics(searchDto);
            perMap = dayReportList.stream().collect(Collectors.toMap(AttendReport::getReportDate, Function.identity()));
            for (AppAttendReportDto appAttendReportDto : dayReportList) {
                appAttendReportDto.setSchedulClockList(schedulClockMap.get(appAttendReportDto.getReportDate()));
            }
        }
        if (attend.getCountLimit() != null) {
            reportDto.setCountLimit(attend.getCountLimit() - cardList.size());
        }
        AppAttendReportDto attendReportDto = null;
        for (String key : schedulClockMap.keySet()) {
            if (perMap.get(key) != null) continue;
            attendReportDto = new AppAttendReportDto();
            attendReportDto.setReportDate(key);
            attendReportDto.setAttendReportType("1");
            List<AppAttendSchedulClockDto> dayClockList = schedulClockMap.get(key);
            for (AppAttendSchedulClockDto schedulClockDto : dayClockList) {
                if ("2".equals(schedulClockDto.getShiftType())) continue;
                if ("3".equals(schedulClockDto.getClockStatus())) {
                    if (!StrUtil.isEmpty((CharSequence)schedulClockDto.getClockEnd()) || DateUtils.parseDate((Object)schedulClockDto.getEndTime()).getTime() >= DateUtils.addMinutes((Date)DateUtils.getNowDate(), (int)-30).getTime()) continue;
                    schedulClockDto.setClockStatus("23");
                    continue;
                }
                if (!StrUtil.isEmpty((CharSequence)schedulClockDto.getClockStatus()) || DateUtils.parseDate((Object)schedulClockDto.getEndTime()).getTime() >= DateUtils.getNowDate().getTime()) continue;
                if (StrUtil.isEmpty((CharSequence)schedulClockDto.getClockStart())) {
                    if (DateUtils.parseDate((Object)schedulClockDto.getEndTime()).getTime() < DateUtils.addMinutes((Date)DateUtils.getNowDate(), (int)-30).getTime()) {
                        schedulClockDto.setClockStatus("5");
                        continue;
                    }
                    schedulClockDto.setClockStatus("21");
                    continue;
                }
                if (DateUtils.parseDate((Object)schedulClockDto.getEndTime()).getTime() >= DateUtils.addMinutes((Date)DateUtils.getNowDate(), (int)-30).getTime()) continue;
                schedulClockDto.setClockStatus("22");
            }
            attendReportDto.setSchedulClockList(dayClockList);
            dayReportList.add((AppAttendReportDto)((Object)((Object)((Object)attendReportDto))));
        }
        ArrayList<OaBusinessDto> arrayList = new ArrayList<OaBusinessDto>();
        arrayList.addAll(this.leaveApplicationMapper.findByUserId(reportDto.getTlkPerId(), searchDto.getSchedulDate()));
        arrayList.addAll(this.publicReleaseMapper.findByUserId(reportDto.getTlkPerId(), searchDto.getSchedulDate()));
        arrayList.addAll(this.businessTravelMapper.findByUserId(reportDto.getTlkPerId(), searchDto.getSchedulDate()));
        arrayList.addAll(this.workOvertimeMapper.findByUserId(reportDto.getTlkPerId(), searchDto.getSchedulDate()));
        dayReportList = dayReportList.stream().sorted(Comparator.comparing(AttendReport::getReportDate)).collect(Collectors.toList());
        if (arrayList.size() > 0) {
            Date startTime = ((OaBusinessDto)((Object)arrayList.stream().min((a, b) -> a.getStartTime().getTime() > b.getStartTime().getTime() ? 1 : -1).get())).getStartTime();
            Date endTime = ((OaBusinessDto)((Object)arrayList.stream().max((a, b) -> a.getStopTime().getTime() > b.getStopTime().getTime() ? 1 : -1).get())).getStopTime();
            for (OaBusinessDto oaBusinessDto : arrayList) {
                for (AppAttendReportDto appAttendReportDto : dayReportList) {
                    List<OaBusinessDto> dayOaList = appAttendReportDto.getOaList();
                    if (dayOaList == null) {
                        dayOaList = new ArrayList<OaBusinessDto>();
                    }
                    if ("1".equals(oaBusinessDto.getDictType())) {
                        if (!DateUtils.formatDate((Date)oaBusinessDto.getStartTime(), (Object[])new Object[]{DateUtils.YYYY_MM_DD}).equals(appAttendReportDto.getReportDate())) continue;
                        dayOaList.add(oaBusinessDto);
                        continue;
                    }
                    if (appAttendReportDto.getSchedulClockList() == null || appAttendReportDto.getSchedulClockList().size() < 1) continue;
                    for (AppAttendSchedulClockDto appAttendSchedulClockDto : appAttendReportDto.getSchedulClockList()) {
                        OaBusinessDto newOaBusiness;
                        if ("2".equals(appAttendSchedulClockDto.getShiftType())) continue;
                        if (DateUtils.parseDate((Object)appAttendSchedulClockDto.getStartTime()).getTime() > oaBusinessDto.getStartTime().getTime() && DateUtils.parseDate((Object)appAttendSchedulClockDto.getEndTime()).getTime() < oaBusinessDto.getStopTime().getTime()) {
                            newOaBusiness = new OaBusinessDto();
                            newOaBusiness.setStartTime(DateUtils.parseDate((Object)appAttendSchedulClockDto.getStartTime()));
                            newOaBusiness.setStopTime(DateUtils.parseDate((Object)appAttendSchedulClockDto.getEndTime()));
                            newOaBusiness.setDictType(oaBusinessDto.getDictType());
                            appAttendSchedulClockDto.setStartStatus("11");
                            appAttendSchedulClockDto.setEndStatus("11");
                            dayOaList.add(newOaBusiness);
                            continue;
                        }
                        if (DateUtils.parseDate((Object)appAttendSchedulClockDto.getStartTime()).getTime() < oaBusinessDto.getStartTime().getTime() && DateUtils.parseDate((Object)appAttendSchedulClockDto.getEndTime()).getTime() > oaBusinessDto.getStopTime().getTime()) {
                            dayOaList.add(oaBusinessDto);
                            continue;
                        }
                        if (DateUtils.parseDate((Object)appAttendSchedulClockDto.getStartTime()).getTime() < oaBusinessDto.getStartTime().getTime() && DateUtils.parseDate((Object)appAttendSchedulClockDto.getEndTime()).getTime() > oaBusinessDto.getStartTime().getTime() && DateUtils.parseDate((Object)appAttendSchedulClockDto.getEndTime()).getTime() < oaBusinessDto.getStopTime().getTime()) {
                            newOaBusiness = new OaBusinessDto();
                            newOaBusiness.setStartTime(oaBusinessDto.getStartTime());
                            newOaBusiness.setStopTime(DateUtils.parseDate((Object)appAttendSchedulClockDto.getEndTime()));
                            newOaBusiness.setDictType(oaBusinessDto.getDictType());
                            appAttendSchedulClockDto.setEndStatus("11");
                            dayOaList.add(newOaBusiness);
                            continue;
                        }
                        if (DateUtils.parseDate((Object)appAttendSchedulClockDto.getStartTime()).getTime() <= oaBusinessDto.getStartTime().getTime() || DateUtils.parseDate((Object)appAttendSchedulClockDto.getStartTime()).getTime() >= oaBusinessDto.getStopTime().getTime() || DateUtils.parseDate((Object)appAttendSchedulClockDto.getEndTime()).getTime() <= oaBusinessDto.getStopTime().getTime()) continue;
                        newOaBusiness = new OaBusinessDto();
                        newOaBusiness.setStartTime(DateUtils.parseDate((Object)appAttendSchedulClockDto.getStartTime()));
                        newOaBusiness.setStopTime(oaBusinessDto.getStopTime());
                        newOaBusiness.setDictType(oaBusinessDto.getDictType());
                        appAttendSchedulClockDto.setStartStatus("11");
                        dayOaList.add(newOaBusiness);
                    }
                    appAttendReportDto.setOaList(dayOaList);
                }
            }
        }
        reportDto.setDayReportList(dayReportList);
        return reportDto;
    }
}

