/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.temporary;

import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.company.ComBaseInfo;
import com.bcxin.platform.domain.temporary.ComProject;
import com.bcxin.platform.domain.temporary.ComProjectPer;
import com.bcxin.platform.mapper.company.ComBaseInfoMapper;
import com.bcxin.platform.mapper.temporary.ComProjectMapper;
import com.bcxin.platform.mapper.temporary.ComProjectPerMapper;
import com.bcxin.platform.service.temporary.ComProjectService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class ComProjectServiceImpl
implements ComProjectService {
    @Resource
    private ComProjectMapper comProjectMapper;
    @Resource
    private ComProjectPerMapper comProjectPerMapper;
    @Resource
    private ComBaseInfoMapper comBaseInfoMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public Result save(ComProject comProject) {
        ComBaseInfo comBaseInfo = this.comBaseInfoMapper.selectComBaseInfoByTlkId(comProject.getTlkComId());
        if (comBaseInfo != null) {
            comProject.setComId(comBaseInfo.getComId());
        }
        this.comProjectMapper.insert(comProject);
        return Result.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @Override
    public Result update(ComProject comProject) {
        ComProject cp = this.comProjectMapper.getItemsBytlkProjectId(comProject.getTlkProjectId());
        cp.setProjectName(comProject.getProjectName());
        cp.setProjectType(comProject.getProjectType());
        cp.setAddress(comProject.getAddress());
        cp.setCoordinate(comProject.getCoordinate());
        cp.setStartTime(comProject.getStartTime());
        cp.setEndTime(comProject.getEndTime());
        cp.setUpdateTime(new Date());
        this.comProjectMapper.update(comProject);
        return Result.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @Override
    public Result delete(String tlkProjectId) {
        this.comProjectMapper.delete(tlkProjectId);
        return Result.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public Result batchDelete(String[] tlkProjectPerIds) {
        this.comProjectPerMapper.batchDelete(tlkProjectPerIds);
        return Result.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public Result getProjectListByComId(Long comId) {
        List<ComProject> list = this.comProjectMapper.findComProjectByComId(comId);
        return Result.success((String)"", list);
    }

    @Override
    public Result savePer(Collection<ComProjectPer> comProjectPerList) {
        for (ComProjectPer per : comProjectPerList) {
            this.comProjectPerMapper.insert(per);
        }
        return Result.success((String)"\u6dfb\u52a0\u6210\u529f");
    }
}

