/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.system.impl;

import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.PlatFormBusinessException;
import com.bcxin.platform.common.utils.CacheUtils;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.system.SysConfig;
import com.bcxin.platform.mapper.system.SysConfigMapper;
import com.bcxin.platform.service.system.ISysConfigService;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class SysConfigServiceImpl
implements ISysConfigService {
    @Autowired
    private SysConfigMapper configMapper;

    @PostConstruct
    public void init() {
        List<SysConfig> configsList = this.configMapper.selectConfigList(new SysConfig());
        for (SysConfig config : configsList) {
            CacheUtils.put((String)this.getCacheName(), (String)this.getCacheKey(config.getConfigKey()), (Object)config.getConfigValue());
        }
    }

    @Override
    public SysConfig selectConfigById(Long configId) {
        SysConfig config = new SysConfig();
        config.setConfigId(configId);
        return this.configMapper.selectConfig(config);
    }

    @Override
    public String selectConfigByKey(String configKey) {
        String configValue = Convert.toStr((Object)CacheUtils.get((String)this.getCacheName(), (String)this.getCacheKey(configKey)));
        if (StringUtils.isNotEmpty((String)configValue)) {
            return configValue;
        }
        SysConfig config = new SysConfig();
        config.setConfigKey(configKey);
        SysConfig retConfig = this.configMapper.selectConfig(config);
        if (StringUtils.isNotNull((Object)((Object)retConfig))) {
            CacheUtils.put((String)this.getCacheName(), (String)this.getCacheKey(configKey), (Object)retConfig.getConfigValue());
            return retConfig.getConfigValue();
        }
        return "";
    }

    @Override
    public List<SysConfig> selectConfigList(SysConfig config) {
        return this.configMapper.selectConfigList(config);
    }

    @Override
    public int insertConfig(SysConfig config) {
        int row = this.configMapper.insertConfig(config);
        if (row > 0) {
            CacheUtils.put((String)this.getCacheName(), (String)this.getCacheKey(config.getConfigKey()), (Object)config.getConfigValue());
        }
        return row;
    }

    @Override
    public int updateConfig(SysConfig config) {
        int row = this.configMapper.updateConfig(config);
        if (row > 0) {
            CacheUtils.put((String)this.getCacheName(), (String)this.getCacheKey(config.getConfigKey()), (Object)config.getConfigValue());
        }
        return row;
    }

    @Override
    public int deleteConfigByIds(String ids) {
        Long[] configIds;
        for (Long configId : configIds = Convert.toLongArray((String)ids)) {
            SysConfig config = this.selectConfigById(configId);
            if (!StringUtils.equals((CharSequence)"Y", (CharSequence)config.getConfigType())) continue;
            throw new PlatFormBusinessException(String.format("\u5185\u7f6e\u53c2\u6570\u3010%1$s\u3011\u4e0d\u80fd\u5220\u9664 ", config.getConfigKey()));
        }
        int count = this.configMapper.deleteConfigByIds(Convert.toStrArray((String)ids));
        if (count > 0) {
            CacheUtils.removeAll((String)this.getCacheName());
        }
        return count;
    }

    @Override
    public void clearCache() {
        CacheUtils.removeAll((String)this.getCacheName());
    }

    @Override
    public String checkConfigKeyUnique(SysConfig config) {
        Long configId = StringUtils.isNull((Object)config.getConfigId()) ? -1L : config.getConfigId();
        SysConfig info = this.configMapper.checkConfigKeyUnique(config.getConfigKey());
        if (StringUtils.isNotNull((Object)((Object)info)) && info.getConfigId().longValue() != configId.longValue()) {
            return "1";
        }
        return "0";
    }

    private String getCacheName() {
        return "sys-config";
    }

    private String getCacheKey(String configKey) {
        return "sys_config:" + configKey;
    }
}

