/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.insurance.manage;

import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.insurance.ComInsGuaProject;
import com.bcxin.platform.dto.excel.InsExcelVo;
import com.bcxin.platform.dto.insurance.ComInsDTO;
import com.bcxin.platform.dto.insurance.ComInsPrincipalDTO;
import com.bcxin.platform.mapper.ins.ComInsGuaProjectManageMapper;
import com.bcxin.platform.mapper.ins.ComInsManageMapper;
import com.bcxin.platform.mapper.ins.ComInsPrincipalManageMapper;
import com.bcxin.platform.service.insurance.manage.ComInsManageService;
import com.bcxin.platform.util.excel.ExcelUtil;
import com.google.common.collect.Maps;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ComInsManageServiceImpl
implements ComInsManageService {
    @Autowired
    private ComInsManageMapper comInsMapper;
    @Autowired
    private ComInsGuaProjectManageMapper comInsGuaProjectMapper;
    @Autowired
    private ComInsPrincipalManageMapper comInsPrincipalMapper;

    @Override
    public List<Map<String, Object>> pageComInsList(ComInsDTO dto) {
        List<Map<String, Object>> list = this.comInsMapper.getComInsPage(dto);
        return list;
    }

    @Override
    public Result getComInsInfo(ComInsDTO dto) throws V5BusinessException {
        if (dto.getComInsId() == null) {
            throw new V5BusinessException("-1", "\u53c2\u6570comInsId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<String, Object> rec = this.comInsMapper.selectById(dto.getComInsId());
        List<ComInsGuaProject> list = this.comInsGuaProjectMapper.selectItemsById(dto.getComInsId());
        HashMap m = Maps.newHashMap();
        m.put("comIns", rec);
        m.put("comInsGuaProjectList", list);
        return Result.success((String)"", (Object)m);
    }

    @Override
    public Map<String, Object> getComInsInfo(String comInsId) throws V5BusinessException {
        if (StringUtils.isEmpty((String)comInsId)) {
            throw new V5BusinessException("-1", "\u53c2\u6570comInsId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<String, Object> rec = this.comInsMapper.selectById(Long.parseLong(comInsId));
        return rec;
    }

    @Override
    public List<Map> selectPrincipalByComId(ComInsPrincipalDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "\u53c2\u6570comId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Map> list = this.comInsPrincipalMapper.selectPrincipalByComId(dto);
        return list;
    }

    @Override
    public Result updatePerNum(ComInsDTO dto) {
        this.comInsMapper.updatePerNum(dto);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public void downInsSchedule(HttpServletResponse response) {
        try {
            ServletOutputStream os = null;
            ExcelUtil<InsExcelVo> util = new ExcelUtil<InsExcelVo>(InsExcelVo.class);
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String("\u4fdd\u9669\u63a8\u8350\u62a5\u8868.xls".getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            List<InsExcelVo> listMap = this.comInsMapper.downInsSchedule();
            util.exportExcel(listMap, "\u4fdd\u9669\u63a8\u8350\u62a5\u8868", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

