/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.company.impl;

import cn.hutool.core.util.StrUtil;
import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.company.ComBaseInfo;
import com.bcxin.platform.domain.company.ComDepart;
import com.bcxin.platform.dto.company.ComDepartDto;
import com.bcxin.platform.dto.company.ComDepartTreeDto;
import com.bcxin.platform.dto.company.OrgTreeDto;
import com.bcxin.platform.mapper.company.ComBaseInfoMapper;
import com.bcxin.platform.mapper.company.ComDepartMapper;
import com.bcxin.platform.mapper.company.PerOrgRelationMapper;
import com.bcxin.platform.service.company.ComDepartService;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ComDepartServiceImpl
implements ComDepartService {
    @Resource
    private ComDepartMapper comDepartMapper;
    @Resource
    private ComBaseInfoMapper comBaseInfoMapper;
    @Resource
    private PerOrgRelationMapper perOrgRelationMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public ComDepart selectComDepartById(Long departId) {
        return this.comDepartMapper.selectComDepartById(departId);
    }

    @Override
    public List<ComDepart> selectComDepartList(ComDepart comDepart) {
        return this.comDepartMapper.selectComDepartList(comDepart);
    }

    @Override
    public int insertComDepart(ComDepart comDepart) {
        comDepart.setDepartId(this.idWorker.nextId());
        comDepart.setCreateTime(DateUtils.getNowDate());
        return this.comDepartMapper.save(comDepart);
    }

    @Override
    public int updateComDepart(ComDepart comDepart) {
        ComDepart dbComDepart = this.comDepartMapper.selectComDepartByTlkId(comDepart.getTlkDepartId());
        if (dbComDepart == null) {
            comDepart.setDepartId(this.idWorker.nextId());
            comDepart.setCreateTime(DateUtils.getNowDate());
            return this.comDepartMapper.save(comDepart);
        }
        comDepart.setUpdateTime(DateUtils.getNowDate());
        return this.comDepartMapper.updateSelective(comDepart);
    }

    @Override
    public int editBatch(String tklComId, List<ComDepart> list) {
        ComBaseInfo comBaseInfo = this.comBaseInfoMapper.selectComBaseInfoByTlkId(tklComId);
        if (comBaseInfo == null) {
            throw new V5BusinessException("-1", "\u516c\u53f8\u4e0d\u5b58\u5728");
        }
        List<ComDepart> dbList = this.comDepartMapper.findByBatchTlkId(list);
        List<ComDepart> dbParentList = this.comDepartMapper.findByBatchTlkParentId(list);
        Map<String, ComDepart> comDepartMap = dbList.stream().collect(Collectors.toMap(ComDepart::getTlkDepartId, Function.identity()));
        Map comParentDepartMap = dbParentList.stream().collect(Collectors.toMap(ComDepart::getTlkDepartId, Function.identity()));
        Map<String, List<ComDepart>> tlkParentMap = list.stream().filter(departData -> StringUtils.isNotEmpty((String)departData.getTlkParentDepartId())).collect(Collectors.groupingBy(ComDepart::getTlkParentDepartId));
        ComDepart depart = null;
        ArrayList<ComDepart> saveList = new ArrayList<ComDepart>();
        List<ComDepart> departList = null;
        for (ComDepart comDepart : list) {
            if (!StringUtil.isEmpty((String)comDepart.getTlkParentDepartId())) continue;
            depart = (ComDepart)comDepartMap.get(comDepart.getTlkDepartId());
            if (depart != null) {
                if ("1".equals(depart.getIsDelete())) {
                    depart.setIsDelete("0");
                }
                BeanUtils.copyPropertiesIgnore((Object)depart, (Object)comDepart, (Boolean)true);
            } else {
                comDepart.setDepartId(this.idWorker.nextId());
                comDepart.setCreateTime(DateUtils.getNowDate());
                comDepart.setComId(comBaseInfo.getComId());
            }
            comDepart.setDepartTreeCode(comDepart.getDepartId() + "-");
            comDepart.setParentDepartId(-1L);
            comDepart.setUpdateTime(DateUtils.getNowDate());
            saveList.add(comDepart);
            departList = tlkParentMap.get(comDepart.getTlkDepartId());
            if (departList == null) continue;
            this.setSubDepart(comDepart, departList, saveList, comDepartMap, tlkParentMap);
        }
        if (saveList.size() > 0) {
            this.comDepartMapper.saveBatch(saveList);
        }
        return saveList.size();
    }

    @Override
    public void saveBatch(List<ComDepart> list) {
        this.comDepartMapper.saveBatch(list);
    }

    private void setSubDepart(ComDepart parentDepart, List<ComDepart> list, List<ComDepart> saveList, Map<String, ComDepart> comDepartMap, Map<String, List<ComDepart>> tlkParentMap) {
        ComDepart depart = null;
        List<ComDepart> departList = null;
        for (ComDepart comDepart : list) {
            depart = comDepartMap.get(comDepart.getTlkDepartId());
            if (depart != null) {
                if ("1".equals(depart.getIsDelete())) {
                    depart.setIsDelete("0");
                }
                BeanUtils.copyPropertiesIgnore((Object)depart, (Object)comDepart, (Boolean)true);
            } else {
                comDepart.setDepartId(this.idWorker.nextId());
                comDepart.setCreateTime(DateUtils.getNowDate());
                comDepart.setComId(parentDepart.getComId());
            }
            comDepart.setDepartTreeCode(parentDepart.getDepartTreeCode() + comDepart.getDepartId() + "-");
            comDepart.setParentDepartId(parentDepart.getDepartId());
            comDepart.setUpdateTime(DateUtils.getNowDate());
            saveList.add(comDepart);
            departList = tlkParentMap.get(comDepart.getTlkDepartId());
            if (departList == null) continue;
            this.setSubDepart(comDepart, departList, saveList, comDepartMap, tlkParentMap);
        }
    }

    @Override
    public int deleteComDepartByIds(String ids) {
        return this.comDepartMapper.deleteComDepartByIds(Convert.toStrArray((String)ids));
    }

    @Override
    public int deleteComDepartById(Long departId) {
        return this.comDepartMapper.deleteComDepartById(departId);
    }

    @Override
    public Result getDepartTree(ComDepartDto comDepartDto) {
        String parentDepartId = "-1";
        if (comDepartDto.getComId() == null) {
            return Result.success((String)"");
        }
        Long comId = comDepartDto.getComId();
        ArrayList<OrgTreeDto> list = new ArrayList<OrgTreeDto>();
        Map<String, Object> m = this.perOrgRelationMapper.getComPerCount(comId);
        OrgTreeDto root = new OrgTreeDto();
        root.setDepartName(m.get("comName") != null ? m.get("comName").toString() : "");
        root.setPersonCount(Integer.parseInt(m.get("personCount").toString()));
        root.setDepartId("-1");
        root.setIsExistsDataAuth("1");
        List<OrgTreeDto> departList = this.comDepartMapper.getDepartList(comId);
        List<OrgTreeDto> childlist = this.getDepartChild(parentDepartId, departList);
        if (childlist != null && childlist.size() > 0) {
            root.setChildDepart(childlist);
        }
        list.add(root);
        return Result.success((String)"", list);
    }

    @Override
    public Result getTreeDepartNotDataAuth(ComDepartDto comDepartDto) {
        Long parentDepartId = -1L;
        Long comId = comDepartDto.getComId();
        ArrayList<ComDepartTreeDto> list = new ArrayList<ComDepartTreeDto>();
        ComBaseInfo comBaseInfo = this.comBaseInfoMapper.selectComBaseInfoById(comId);
        ComDepartTreeDto root = new ComDepartTreeDto();
        root.setTitle(comBaseInfo.getComName());
        root.setKey("-1");
        root.setLabel(comBaseInfo.getComName());
        root.setValue("-1");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("parentDepartId", parentDepartId);
        param.put("comId", comId);
        List<Object> childlist = new ArrayList();
        List<Map> allTreeDepart = this.comDepartMapper.getTreeDepartNotDataAuth(comId);
        childlist = this.getAllDepartChild(param, allTreeDepart);
        if (childlist != null && childlist.size() > 0) {
            root.setChildren(childlist);
        }
        list.add(root);
        return Result.success((String)"", list);
    }

    @Override
    public Result getTreeDepart(ComDepartDto comDepartDto) {
        Long parentDepartId = -1L;
        Long comId = comDepartDto.getComId();
        ArrayList<ComDepartTreeDto> list = new ArrayList<ComDepartTreeDto>();
        ComBaseInfo comBaseInfo = this.comBaseInfoMapper.selectComBaseInfoById(comId);
        ComDepartTreeDto root = new ComDepartTreeDto();
        root.setTitle(comBaseInfo.getComName());
        root.setKey("-1");
        root.setLabel(comBaseInfo.getComName());
        root.setValue("-1");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("parentDepartId", parentDepartId);
        param.put("comId", comId);
        List<Object> childlist = new ArrayList();
        List<Map> allTreeDepart = this.comDepartMapper.getTreeDepart(comId);
        childlist = this.getAllDepartChild(param, allTreeDepart);
        if (childlist != null && childlist.size() > 0) {
            root.setChildren(childlist);
        }
        list.add(root);
        return Result.success((String)"", list);
    }

    @Override
    public List<ComDepartTreeDto> getTreeDepartForAttend(ComDepartDto comDepartDto) {
        if (!(comDepartDto.isDomainAdmin() || comDepartDto.getAdminDepartIds() != null && comDepartDto.getAdminDepartIds().size() != 0)) {
            return new ArrayList<ComDepartTreeDto>();
        }
        ArrayList<ComDepartTreeDto> list = new ArrayList<ComDepartTreeDto>();
        List<ComDepartTreeDto> allTreeDepart = this.comDepartMapper.getTreeDepartForAttend(comDepartDto);
        Map<String, List<ComDepartTreeDto>> departMap = allTreeDepart.stream().filter(d -> StrUtil.isNotBlank((CharSequence)d.getParentId())).collect(Collectors.groupingBy(ComDepartTreeDto::getParentId));
        Map comDepartMap = allTreeDepart.stream().collect(Collectors.toMap(ComDepartTreeDto::getKey, Function.identity()));
        for (ComDepartTreeDto treeDto : allTreeDepart) {
            if (departMap.get(treeDto.getKey()) != null) {
                treeDto.setChildren(departMap.get(treeDto.getKey()));
            } else {
                treeDto.setChildren(new ArrayList<ComDepartTreeDto>());
            }
            if (!StringUtil.isEmpty((String)treeDto.getParentId()) && comDepartMap.containsKey(treeDto.getParentId())) continue;
            list.add(treeDto);
        }
        return list;
    }

    @Override
    public ComDepart selectComDepartByTlkId(String tlkDepartId) {
        return this.comDepartMapper.selectComDepartByTlkId(tlkDepartId);
    }

    @Override
    public List<ComDepart> selectListByComId(Long comId) {
        return this.comDepartMapper.selectListByComId(comId);
    }

    @Override
    public List<OrgTreeDto> getDepartChild(String parentDepartId, List<OrgTreeDto> departList) {
        ArrayList<OrgTreeDto> deptVosList = new ArrayList<OrgTreeDto>();
        if (departList != null && departList.size() > 0) {
            for (OrgTreeDto depart : departList) {
                if (!parentDepartId.equals(depart.getParentDepartId())) continue;
                OrgTreeDto orgTreeDto = new OrgTreeDto();
                orgTreeDto.setDepartId(depart.getDepartId());
                orgTreeDto.setPersonCount(depart.getPersonCount());
                orgTreeDto.setDepartName(depart.getDepartName());
                orgTreeDto.setIsExistsDataAuth(depart.getIsExistsDataAuth());
                orgTreeDto.setParentDepartId(depart.getParentDepartId());
                orgTreeDto.setChildDepart(this.getDepartChild(depart.getDepartId(), departList));
                deptVosList.add(orgTreeDto);
            }
        }
        return deptVosList;
    }

    private List<ComDepartTreeDto> getAllDepartChild(Map<String, Object> param, List<Map> allTreeDepart) {
        ArrayList<ComDepartTreeDto> deptVosList = new ArrayList<ComDepartTreeDto>();
        Long parentDepartId = Long.valueOf(param.get("parentDepartId").toString());
        Long comId = Long.valueOf(param.get("comId").toString());
        if (allTreeDepart != null && allTreeDepart.size() > 0) {
            for (Map map : allTreeDepart) {
                if (map.get("parentDepartId") == null) {
                    map.put("parentDepartId", "-1");
                }
                if (!parentDepartId.equals(Long.valueOf(map.get("parentDepartId").toString()))) continue;
                ComDepartTreeDto comDepartTreeDto = new ComDepartTreeDto();
                comDepartTreeDto.setKey(String.valueOf(map.get("departId")));
                comDepartTreeDto.setValue(String.valueOf(map.get("departId")));
                comDepartTreeDto.setTitle(String.valueOf(map.get("departName")));
                comDepartTreeDto.setLabel(String.valueOf(map.get("departName")));
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("parentDepartId", String.valueOf(map.get("departId")));
                paramMap.put("comId", comId);
                comDepartTreeDto.setChildren(this.getAllDepartChild(paramMap, allTreeDepart));
                deptVosList.add(comDepartTreeDto);
            }
        }
        return deptVosList;
    }
}

