/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.blb;

import cn.hutool.http.HttpUtil;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.mapper.company.ComBaseInfoMapper;
import com.bcxin.platform.service.blb.BlbTestService;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.util.HttpUtils;
import com.bcxin.platform.util.JwtUtil;
import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
@Transactional(value="transactionManager")
public class BlbTestServiceImpl
implements BlbTestService {
    private static Logger logger = LoggerFactory.getLogger(BlbTestServiceImpl.class);
    @Resource
    private CommonService commonService;
    @Resource
    private ComBaseInfoMapper comBaseInfoMapper;

    public HttpServletRequest getRequest() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Result blbAddPreservationService(String comId, String orderId, String listStr, String inceptionDate) {
        HashMap postParams = Maps.newHashMap();
        String platformSign = this.commonService.getSystemConfig("PLATFORM_SIGN");
        postParams.put("user_id", comId);
        postParams.put("party", platformSign);
        postParams.put("listStr", listStr);
        postParams.put("order_id", orderId);
        postParams.put("inception_date", inceptionDate);
        return HttpUtils.sendHttpRt(this.commonService.getSystemConfig("BLB_URL").replace("https:", "http:") + "/api/preservation/resultSet/sassAddPreservationService" + "?ACCESS_TOKEN=" + BlbTestServiceImpl.getToken(), postParams);
    }

    @Override
    public Result blbMinusPreservationService(String comId, String orderId, String listStr, String inceptionDate) {
        HashMap postParams = Maps.newHashMap();
        String platformSign = this.commonService.getSystemConfig("PLATFORM_SIGN");
        postParams.put("user_id", comId);
        postParams.put("party", platformSign);
        postParams.put("listStr", listStr);
        postParams.put("order_id", orderId);
        postParams.put("inception_date", inceptionDate);
        return HttpUtils.sendHttpRt(this.commonService.getSystemConfig("BLB_URL").replace("https:", "http:") + "/api/preservation/resultSet/sassMinusPreservationService" + "?ACCESS_TOKEN=" + BlbTestServiceImpl.getToken(), postParams);
    }

    @Override
    public Result blbMinusPreservationByNotIncluded(String comId, String orderId, String listStr, String inceptionDate) {
        HashMap postParams = Maps.newHashMap();
        String platformSign = this.commonService.getSystemConfig("PLATFORM_SIGN");
        postParams.put("user_id", comId);
        postParams.put("party", platformSign);
        postParams.put("listStr", listStr);
        postParams.put("order_id", orderId);
        postParams.put("inception_date", inceptionDate);
        return HttpUtils.sendHttpRt(this.commonService.getSystemConfig("BLB_URL").replace("https:", "http:") + "/api/preservation/resultSet/sassSpecialMinusPreservationService" + "?ACCESS_TOKEN=" + BlbTestServiceImpl.getToken(), postParams);
    }

    @Override
    public String getCompnayAndPersonPutCacheUrl(String reviseType, String cacheId) {
        return this.commonService.getSystemConfig("BLB_URL") + "/api/thr/tposCheckoutAddCache" + "?revise_type=" + reviseType + "&cacheId=" + cacheId + "&ACCESS_TOKEN=" + BlbTestServiceImpl.getToken();
    }

    @Override
    public String getBlbOrderPageLinkUrl(String businessType) {
        return this.commonService.getSystemConfig("BLB_URL") + "/api/thr/tposCheckoutToOrder" + "?businessType=" + businessType + "&ACCESS_TOKEN=" + BlbTestServiceImpl.getToken();
    }

    @Override
    public String getBlbReportPageLinkUrl() {
        return this.commonService.getSystemConfig("BLB_URL") + "/api/thr/tposCheckoutToReport" + "?ACCESS_TOKEN=" + BlbTestServiceImpl.getToken();
    }

    @Override
    public String getBlbPreservationPageLinkUrl() {
        return this.commonService.getSystemConfig("BLB_URL") + "/api/thr/tposPreservation" + "?ACCESS_TOKEN=" + BlbTestServiceImpl.getToken();
    }

    @Override
    public String blbLinkUrl(Long comId, String login_name) {
        String platformSign = this.commonService.getSystemConfig("PLATFORM_SIGN");
        HashMap subject = Maps.newHashMap();
        subject.put("user_id", comId);
        subject.put("province", this.comBaseInfoMapper.getProvinceByID(comId));
        subject.put("login_name", login_name);
        subject.put("party", platformSign);
        String token = JwtUtil.createJWT(subject);
        return this.commonService.getSystemConfig("BLB_URL") + "/api/thr/tposCheckout" + "?party=" + platformSign + "&token=" + token + "&ACCESS_TOKEN=" + BlbTestServiceImpl.getToken();
    }

    @Override
    public String blbActivateUserLinkUrl(Long comId, String login_name) {
        String platformSign = this.commonService.getSystemConfig("PLATFORM_SIGN");
        HashMap subject = Maps.newHashMap();
        subject.put("user_id", comId);
        subject.put("province", this.comBaseInfoMapper.getProvinceByID(comId));
        subject.put("login_name", login_name);
        subject.put("party", platformSign);
        String token = JwtUtil.createJWT(subject);
        return this.commonService.getSystemConfig("BLB_URL") + "/api/thr/initTposUser" + "?party=" + platformSign + "&token=" + token + "&ACCESS_TOKEN=" + BlbTestServiceImpl.getToken();
    }

    @Override
    public String getBlbDetailLinkUrl(String orderId) {
        return this.commonService.getSystemConfig("BLB_URL") + "/api/thr/tposDetail" + "?order_id=" + orderId + "&ACCESS_TOKEN=" + BlbTestServiceImpl.getToken();
    }

    @Override
    public String getBlbPreservationLinkUrl(String reviseType, String orderId, String cacheId) {
        return this.commonService.getSystemConfig("BLB_URL") + "/api/preservation/resultSet/sassPreservationView" + "?revise_type=" + reviseType + "&order_id=" + orderId + "&cacheId=" + cacheId + "&ACCESS_TOKEN=" + BlbTestServiceImpl.getToken();
    }

    @Override
    public String getBlbProList() {
        String url = this.commonService.getSystemConfig("BLB_URL") + "/api/thr/tposProductAndRes" + "?ACCESS_TOKEN=" + BlbTestServiceImpl.getToken();
        return HttpUtil.get((String)url);
    }

    @Override
    public Result blbPerName(String listStr) {
        HashMap postParams = Maps.newHashMap();
        postParams.put("listStr", listStr);
        return HttpUtils.sendHttpRt(this.commonService.getSystemConfig("BLB_URL").replace("https:", "http:") + "/api/preservation/resultSet/sassFindPerNameByIdCard" + "?ACCESS_TOKEN=" + BlbTestServiceImpl.getToken(), postParams);
    }

    @Override
    public Result blbZBNum(String token, String policyNos) {
        HashMap postParams = Maps.newHashMap();
        postParams.put("token", token);
        postParams.put("policyNos", policyNos);
        return HttpUtils.sendHttpRt(this.commonService.getSystemConfig("BLB_URL").replace("https:", "http:") + "/api/thr/tposZBNum" + "?ACCESS_TOKEN=" + BlbTestServiceImpl.getToken(), postParams);
    }

    @Override
    public Result blbSetSign(String token, String policyNo, String webType) {
        HashMap postParams = Maps.newHashMap();
        postParams.put("token", token);
        postParams.put("policyNo", policyNo);
        postParams.put("webType", webType);
        return HttpUtils.sendHttpRt(this.commonService.getSystemConfig("BLB_URL") + "/api/thr/tposSetSign" + "?ACCESS_TOKEN=" + BlbTestServiceImpl.getToken(), postParams);
    }

    @Override
    public String blbLinkUrl(Long comId, String loginName, String urlBody) {
        String platformSign = this.commonService.getSystemConfig("PLATFORM_SIGN");
        HashMap subject = Maps.newHashMap();
        subject.put("user_id", comId);
        subject.put("province", this.comBaseInfoMapper.getProvinceByID(comId));
        subject.put("login_name", loginName);
        subject.put("party", platformSign);
        String token = JwtUtil.createJWT(subject);
        return this.commonService.getSystemConfig("BLB_URL") + urlBody + "?party=" + platformSign + "&token=" + token + "&ACCESS_TOKEN=" + BlbTestServiceImpl.getToken();
    }

    @Override
    public String reportList(String idCardNo, String status, Long comId) {
        return this.blbLinkUrl(comId, "", "/app/report/reportList") + "&saasIdCardNo=" + idCardNo + "&status=" + status;
    }

    @Override
    public String findPolicyByIdCard(String idCardNo, Long comId) {
        return this.blbLinkUrl(comId, "", "/app/report/findPolicyByIdCard") + "&saasIdCardNo=" + idCardNo;
    }

    @Override
    public String getReportById(String reportId, Long comId) {
        return this.blbLinkUrl(comId, "", "/app/report/getReportById/{reportId}").replace("{reportId}", reportId);
    }

    @Override
    public String saveReport(Long comId) {
        return this.blbLinkUrl(comId, "", "/app/report/saveReport");
    }

    @Override
    public String saveUploadFile(Long comId) {
        return this.blbLinkUrl(comId, "", "/app/report/saveUploadFile");
    }

    @Override
    public String getFileIdByPath(String path, Long comId) {
        return this.blbLinkUrl(comId, "", "/app/report/getFileIdByPath") + "&path=" + path;
    }

    private static String getToken() {
        HttpServletRequest request = null;
        if (RequestContextHolder.getRequestAttributes() != null) {
            request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            return request.getHeader("access_token");
        }
        return "";
    }
}

