/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.dto.oauth;

import java.io.Serializable;
import java.util.Date;

public class AccessToken
implements Serializable {
    private static final long serialVersionUID = -3065517831372557033L;
    public static final String BEARER_TYPE = "Bearer";
    public static final int REFRESH_TOKEN_VALIDITY_SECONDS = 7200;
    public static final int ACCESS_TOKEN_WEB_VALIDITY_SECONDS = 86400;
    public static final int ACCESS_TOKEN_MOBILE_VALIDITY_SECONDS = 2592000;
    public static final int REFRESH_TOKEN_SECONDS = 600;
    protected static long THOUSAND = 1000L;
    private String tokenId;
    private String userId;
    private String perId;
    private String name;
    private String refreshToken;
    private String comId;
    private String tokenType = "Bearer";
    private int tokenExpiredSeconds;
    protected Date createTime = new Date();
    private boolean domainAdmin = false;
    private String adminOrgIds;

    public boolean tokenExpired() {
        long time = this.createTime.getTime() + (long)this.tokenExpiredSeconds * THOUSAND;
        return time < System.currentTimeMillis();
    }

    public long currentTokenExpiredSeconds() {
        if (this.tokenExpired()) {
            return -1L;
        }
        long time = this.createTime.getTime() + (long)this.tokenExpiredSeconds * THOUSAND;
        return (time - System.currentTimeMillis()) / THOUSAND;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPerId() {
        return this.perId;
    }

    public String getName() {
        return this.name;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getComId() {
        return this.comId;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public int getTokenExpiredSeconds() {
        return this.tokenExpiredSeconds;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public boolean isDomainAdmin() {
        return this.domainAdmin;
    }

    public String getAdminOrgIds() {
        return this.adminOrgIds;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setPerId(String perId) {
        this.perId = perId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setComId(String comId) {
        this.comId = comId;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public void setTokenExpiredSeconds(int tokenExpiredSeconds) {
        this.tokenExpiredSeconds = tokenExpiredSeconds;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setDomainAdmin(boolean domainAdmin) {
        this.domainAdmin = domainAdmin;
    }

    public void setAdminOrgIds(String adminOrgIds) {
        this.adminOrgIds = adminOrgIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessToken)) {
            return false;
        }
        AccessToken other = (AccessToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tokenId = this.getTokenId();
        String other$tokenId = other.getTokenId();
        if (this$tokenId == null ? other$tokenId != null : !this$tokenId.equals(other$tokenId)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$perId = this.getPerId();
        String other$perId = other.getPerId();
        if (this$perId == null ? other$perId != null : !this$perId.equals(other$perId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
            return false;
        }
        String this$comId = this.getComId();
        String other$comId = other.getComId();
        if (this$comId == null ? other$comId != null : !this$comId.equals(other$comId)) {
            return false;
        }
        String this$tokenType = this.getTokenType();
        String other$tokenType = other.getTokenType();
        if (this$tokenType == null ? other$tokenType != null : !this$tokenType.equals(other$tokenType)) {
            return false;
        }
        if (this.getTokenExpiredSeconds() != other.getTokenExpiredSeconds()) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        if (this.isDomainAdmin() != other.isDomainAdmin()) {
            return false;
        }
        String this$adminOrgIds = this.getAdminOrgIds();
        String other$adminOrgIds = other.getAdminOrgIds();
        return !(this$adminOrgIds == null ? other$adminOrgIds != null : !this$adminOrgIds.equals(other$adminOrgIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccessToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tokenId = this.getTokenId();
        result = result * 59 + ($tokenId == null ? 43 : $tokenId.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $perId = this.getPerId();
        result = result * 59 + ($perId == null ? 43 : $perId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        String $comId = this.getComId();
        result = result * 59 + ($comId == null ? 43 : $comId.hashCode());
        String $tokenType = this.getTokenType();
        result = result * 59 + ($tokenType == null ? 43 : $tokenType.hashCode());
        result = result * 59 + this.getTokenExpiredSeconds();
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        result = result * 59 + (this.isDomainAdmin() ? 79 : 97);
        String $adminOrgIds = this.getAdminOrgIds();
        result = result * 59 + ($adminOrgIds == null ? 43 : $adminOrgIds.hashCode());
        return result;
    }

    public String toString() {
        return "AccessToken(tokenId=" + this.getTokenId() + ", userId=" + this.getUserId() + ", perId=" + this.getPerId() + ", name=" + this.getName() + ", refreshToken=" + this.getRefreshToken() + ", comId=" + this.getComId() + ", tokenType=" + this.getTokenType() + ", tokenExpiredSeconds=" + this.getTokenExpiredSeconds() + ", createTime=" + this.getCreateTime() + ", domainAdmin=" + this.isDomainAdmin() + ", adminOrgIds=" + this.getAdminOrgIds() + ")";
    }
}

